/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.angle3points;

import detectprojv2j.exceptions.BadDataException;
import detectprojv2j.structures.point.Point3DCartesian;

public class Angle3Points {
    public static double getAngle3Points(Point3DCartesian p1, Point3DCartesian p2, Point3DCartesian p3) {
        return Angle3Points.getAngle3Points(p1.getX(), p1.getY(), p2.getX(), p2.getY(), p3.getX(), p3.getY());
    }

    public static double getAngle3Points(double x1, double y1, double x2, double y2, double x3, double y3) {
        double x21 = x2 - x1;
        double y21 = y2 - y1;
        double x13 = x1 - x3;
        double y13 = y1 - y3;
        double x23 = x2 - x3;
        double y23 = y2 - y3;
        if (Math.abs(x21) < 1.0E-37 && Math.abs(y21) < 1.0E-37 || Math.abs(x13) < 1.0E-37 && Math.abs(y13) < 1.0E-37 || Math.abs(x23) < 1.0E-37 && Math.abs(y23) < 1.0E-37) {
            throw new BadDataException("BadDataException: can not compute angle between 3 points, ", " at least two points are indentical.");
        }
        double angle = (Math.atan2(y23, x23) - Math.atan2(y21, x21)) * 180.0 / Math.PI;
        return angle < 0.0 ? angle + 360.0 : angle;
    }
}

