/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.cartanalysis;

import detectprojv2j.algorithms.carttransformation.CartTransformation;
import detectprojv2j.algorithms.geneticalgorithms.DifferentialEvolution;
import detectprojv2j.algorithms.geneticalgorithms.FRM7DE;
import detectprojv2j.algorithms.geneticalgorithms.FRM8DE;
import detectprojv2j.algorithms.nonlinearleastsquares.FRM7;
import detectprojv2j.algorithms.nonlinearleastsquares.FRM8;
import detectprojv2j.algorithms.nonlinearleastsquares.NonLinearLeastSquares;
import detectprojv2j.algorithms.numdifferentiation.FJM7;
import detectprojv2j.algorithms.numdifferentiation.FJM8;
import detectprojv2j.algorithms.simplexmethod.FRM7NM;
import detectprojv2j.algorithms.simplexmethod.FRM8NM;
import detectprojv2j.algorithms.simplexmethod.SimplexMethod;
import detectprojv2j.algorithms.transformation.HelmertTransformation2D;
import detectprojv2j.comparators.SortPointsByLat;
import detectprojv2j.comparators.SortPointsByLon;
import detectprojv2j.structures.matrix.Matrix;
import detectprojv2j.structures.point.Point3DCartesian;
import detectprojv2j.structures.point.Point3DGeographic;
import detectprojv2j.structures.projection.Projection;
import detectprojv2j.types.TAdaptiveControl;
import detectprojv2j.types.TAnalysisMethod;
import detectprojv2j.types.TMutationStrategy;
import detectprojv2j.types.TResult;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class CartAnalysisMT
implements Runnable {
    private final List<Point3DCartesian> test_points;
    private final List<Point3DGeographic> reference_points;
    private final List<Projection> projections;
    private final TreeMap<Double, TResult> results;
    private final TAnalysisMethod method;
    private final boolean analyze_lon0;
    private final PrintStream s;
    private final JToggleButton button;
    private final Runnable f_callback;

    public CartAnalysisMT(List<Point3DCartesian> test_points_, List<Point3DGeographic> reference_points_, List<Projection> projections_, TreeMap<Double, TResult> results_, TAnalysisMethod method_, boolean analyze_lon0_, PrintStream s_, JToggleButton button_, Runnable f_callback_) {
        this.test_points = test_points_;
        this.reference_points = reference_points_;
        this.projections = projections_;
        this.results = results_;
        this.method = method_;
        this.analyze_lon0 = analyze_lon0_;
        this.s = s_;
        this.f_callback = f_callback_;
        this.button = button_;
    }

    @Override
    public void run() {
        this.analyzeProjection();
    }

    public void analyzeProjection() {
        int n_points = this.test_points.size();
        int n_proj = this.projections.size();
        String button_text = this.button.getText();
        double lat_min = Collections.min(this.reference_points, new SortPointsByLat()).getLat();
        double lat_max = Collections.max(this.reference_points, new SortPointsByLat()).getLat();
        double lon_min = Collections.min(this.reference_points, new SortPointsByLon()).getLon();
        double lon_max = Collections.max(this.reference_points, new SortPointsByLon()).getLon();
        double lat_aver = 0.5 * (lat_min + lat_max);
        double lon_aver = 0.5 * (lon_min + lon_max);
        double lat1 = lat_aver == 0.0 ? 10.0 : lat_aver;
        double lat2 = lat1 + 10.0;
        double latp = Math.min(90.0 - Math.abs(lat_aver), 80.0);
        double lonp = lon_aver > 90.0 ? lon_aver - 270.0 : (latp == 90.0 ? 0.0 : lon_aver + 90.0);
        double lon0 = lon_aver;
        int processed = 1;
        for (Projection proj : this.projections) {
            int status;
            if ((status = (int)(1.0 * (double)(++processed) / (double)n_proj * 100.0)) % 2 == 0) {
                this.button.setText("Analyzing map (" + String.valueOf(status) + "%)");
            }
            proj.setCartPole(new Point3DGeographic(latp, lonp, 0.0));
            proj.setLat1(lat1);
            proj.setLat2(lat2);
            proj.setLon0(lon0);
            proj.setC(1.0);
            try {
                ArrayList<Point3DCartesian> reference_points_projected = new ArrayList<Point3DCartesian>();
                for (Point3DGeographic p : this.reference_points) {
                    double lat_trans = CartTransformation.latToLatTrans(p.getLat(), p.getLon(), proj.getCartPole().getLat(), proj.getCartPole().getLon());
                    double lon_trans = CartTransformation.lonToLonTrans(p.getLat(), p.getLon(), proj.getCartPole().getLat(), proj.getCartPole().getLon(), proj.getLonDir());
                    double lon_transr = CartTransformation.redLon0(lon_trans, proj.getLon0());
                    double XR = proj.getX(lat_trans, lon_transr);
                    double YR = proj.getY(lat_trans, lon_transr);
                    reference_points_projected.add(new Point3DCartesian(XR, YR, 0.0));
                }
                ArrayList<Double> weights = new ArrayList<Double>(Collections.nCopies(this.test_points.size(), 1.0));
                HelmertTransformation2D key = new HelmertTransformation2D();
                key.getTransformKey(this.test_points, reference_points_projected, weights);
                double[] R_0 = new double[]{Math.sqrt(key.getC1() * key.getC1() + key.getC2() * key.getC2()) * proj.getR()};
                double R = proj.getR();
                proj.setR(R_0[0]);
                int m = this.method.ordinal() < 3 ? 7 : 6;
                Matrix X = this.method.ordinal() < 3 ? this.X0M7(m, proj, this.method) : this.X0M8(m, proj, this.method);
                Matrix A = this.method.ordinal() < 3 ? this.AM7(m, proj, R_0[0]) : this.AM8(m, proj);
                Matrix B = this.method.ordinal() < 3 ? this.BM7(m, proj, R_0[0]) : this.BM8(m, proj);
                Matrix XT = X.trans();
                Matrix AT = A.trans();
                Matrix BT = B.trans();
                Matrix XAVER = new Matrix(XT.rows(), XT.cols());
                XAVER.copy(XT);
                boolean add_x0 = true;
                int population = 2 * m * A.rows();
                int max_iter_nls = 80;
                int max_gen = 100;
                int max_iter_nm = 700;
                double alpha = 1.0E-4;
                double nu = 1.0E-4;
                double max_error = 1.0E-10;
                double max_diff = 1.0E-12;
                double eps = 1.0E-10;
                double[] CR = new double[]{0.8};
                double min_cost = 1.0E37;
                double[] res_aver = new double[]{0.0};
                double[] res_max = new double[]{0.0};
                int[] iterations = new int[]{0};
                double[] q1 = new double[]{key.getC1()};
                double[] q2 = new double[]{key.getC2()};
                double[] dx = new double[]{0.0};
                double[] dy = new double[]{0.0};
                Matrix W = new Matrix(2 * n_points, 2 * n_points, 0.0, 1.0);
                Matrix Y = new Matrix(2 * n_points, 1);
                Matrix V = new Matrix(2 * n_points, 1);
                Matrix F = new Matrix(1, 1);
                F.items[0][0] = 0.5;
                FRM8 frm8 = null;
                FRM7 frm7 = null;
                if (this.method.ordinal() < 3) {
                    frm7 = new FRM7(this.test_points, this.reference_points, proj.getX(), proj.getY(), proj.getLonDir(), dx, dy);
                } else {
                    frm8 = new FRM8(this.test_points, this.reference_points, proj.getX(), proj.getY(), proj.getLonDir(), R_0, q1, q2, dx, dy);
                }
                if (this.method == TAnalysisMethod.NLSM7) {
                    FJM7 fjm7 = new FJM7(this.test_points, this.reference_points, proj.getX(), proj.getY(), proj.getLonDir());
                    min_cost = NonLinearLeastSquares.BFGSH(fjm7::function, frm7::function, W, X, Y, V, A, B, iterations, 1.0E-4, 1.0E-4, 1.0E-10, max_iter_nls, 1.0E-12);
                } else if (this.method == TAnalysisMethod.NLSM8) {
                    FJM8 fjm8 = new FJM8(this.test_points, this.reference_points, proj.getX(), proj.getY(), proj.getLonDir(), R_0, q1, q2);
                    min_cost = NonLinearLeastSquares.BFGSH(fjm8::function, frm8::function, W, X, Y, V, A, B, iterations, 1.0E-4, 1.0E-4, 1.0E-10, max_iter_nls, 1.0E-12);
                } else if (this.method == TAnalysisMethod.DEM7) {
                    FRM7DE frm7de = new FRM7DE(frm7);
                    min_cost = DifferentialEvolution.diffEvolution(frm7de::function, population, 1.0E-10, max_gen, F, CR, TMutationStrategy.DERand1Strategy, TAdaptiveControl.MFDE, W, XT, Y, V, AT, BT, XAVER, res_aver, res_max, iterations, add_x0, this.s);
                    X = XT.trans();
                } else if (this.method == TAnalysisMethod.DEM8) {
                    FRM8DE frm8de = new FRM8DE(frm8);
                    min_cost = DifferentialEvolution.diffEvolution(frm8de::function, population, 1.0E-10, max_gen, F, CR, TMutationStrategy.DERand1Strategy, TAdaptiveControl.MFDE, W, XT, Y, V, AT, BT, XAVER, res_aver, res_max, iterations, add_x0, this.s);
                    X = XT.trans();
                } else if (this.method == TAnalysisMethod.NMM7) {
                    FRM7NM frm7nm = new FRM7NM(frm7);
                    min_cost = SimplexMethod.NelderMead(frm7nm::function, W, XT, Y, V, AT, BT, iterations, 1.0E-10, max_iter_nm, add_x0, System.out);
                    X = XT.trans();
                } else if (this.method == TAnalysisMethod.NMM8) {
                    FRM8NM frm8nm = new FRM8NM(frm8);
                    min_cost = SimplexMethod.NelderMead(frm8nm::function, W, XT, Y, V, AT, BT, iterations, 1.0E-10, max_iter_nm, add_x0, System.out);
                    X = XT.trans();
                }
                if (this.method.ordinal() < 3) {
                    proj.setR(X.items[0][0]);
                } else {
                    proj.setR(R_0[0]);
                }
                if (this.method.ordinal() < 3) {
                    proj.setCartPole(new Point3DGeographic(X.items[1][0], X.items[2][0], 0.0));
                } else {
                    proj.setCartPole(new Point3DGeographic(X.items[0][0], X.items[1][0], 0.0));
                }
                if (this.method.ordinal() < 3) {
                    proj.setLat1(X.items[3][0]);
                } else {
                    proj.setLat1(X.items[2][0]);
                }
                if (this.method.ordinal() < 3) {
                    proj.setLat2(X.items[4][0]);
                } else {
                    proj.setLat2(X.items[3][0]);
                }
                if (this.method.ordinal() < 3) {
                    proj.setLon0(X.items[5][0]);
                } else {
                    proj.setLon0(X.items[4][0]);
                }
                if (this.method.ordinal() < 3) {
                    proj.setC(X.items[6][0]);
                } else {
                    proj.setC(X.items[5][0]);
                }
                proj.setDx(dx[0]);
                proj.setDy(dy[0]);
                double map_scale = R / proj.getR() * 1000.0;
                double rotation = this.method.ordinal() < 3 ? 0.0 : Math.atan2(q2[0], q1[0]) * 180.0 / Math.PI;
                TResult res = new TResult(proj, map_scale, rotation, q1[0], q2[0], iterations[0]);
                this.results.put(min_cost, res);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.button.setText(button_text);
        SwingUtilities.invokeLater(this.f_callback);
    }

    private Matrix X0M7(int m, Projection proj, TAnalysisMethod method_) {
        Matrix X0 = new Matrix(m, 1);
        X0.items[0][0] = proj.getR();
        X0.items[1][0] = this.method.ordinal() % 3 == 0 ? proj.getCartPole().getLat() : 89.0;
        X0.items[2][0] = this.method.ordinal() % 3 == 0 ? proj.getCartPole().getLon() : 10.0;
        X0.items[3][0] = proj.getLat1();
        X0.items[4][0] = proj.getLat2();
        X0.items[5][0] = proj.getLon0();
        X0.items[6][0] = proj.getC();
        return X0;
    }

    private Matrix X0M8(int m, Projection proj, TAnalysisMethod method_) {
        Matrix X0 = new Matrix(m, 1);
        X0.items[0][0] = this.method.ordinal() % 3 == 0 ? proj.getCartPole().getLat() : 89.0;
        X0.items[1][0] = this.method.ordinal() % 3 == 0 ? proj.getCartPole().getLon() : 10.0;
        X0.items[2][0] = proj.getLat1();
        X0.items[3][0] = proj.getLat2();
        X0.items[4][0] = proj.getLon0();
        X0.items[5][0] = proj.getC();
        return X0;
    }

    private Matrix AM7(int m, Projection proj, double scale) {
        Matrix A = new Matrix(m, 1);
        A.items[0][0] = 0.01 * scale;
        A.items[1][0] = -90.0;
        A.items[2][0] = -180.0;
        A.items[3][0] = proj.getLat1Interval().min_value;
        A.items[4][0] = proj.getLat1Interval().min_value;
        A.items[5][0] = this.analyze_lon0 ? -180.0 : 0.0;
        A.items[6][0] = 0.0;
        return A;
    }

    private Matrix BM7(int m, Projection proj, double scale) {
        Matrix B = new Matrix(m, 1);
        B.items[0][0] = 100.0 * scale;
        B.items[1][0] = 90.0;
        B.items[2][0] = 180.0;
        B.items[3][0] = proj.getLat1Interval().max_value;
        B.items[4][0] = proj.getLat1Interval().max_value;
        B.items[5][0] = this.analyze_lon0 ? 180.0 : 0.0;
        B.items[6][0] = 100.0;
        return B;
    }

    private Matrix AM8(int m, Projection proj) {
        Matrix A = new Matrix(m, 1);
        A.items[0][0] = -90.0;
        A.items[1][0] = -180.0;
        A.items[2][0] = proj.getLat1Interval().min_value;
        A.items[3][0] = proj.getLat1Interval().min_value;
        A.items[4][0] = this.analyze_lon0 ? -180.0 : 0.0;
        A.items[5][0] = 0.0;
        return A;
    }

    private Matrix BM8(int m, Projection proj) {
        Matrix B = new Matrix(m, 1);
        B.items[0][0] = 90.0;
        B.items[1][0] = 180.0;
        B.items[2][0] = proj.getLat1Interval().max_value;
        B.items[3][0] = proj.getLat1Interval().max_value;
        B.items[4][0] = this.analyze_lon0 ? 180.0 : 0.0;
        B.items[5][0] = 100.0;
        return B;
    }

    public void printResults(Map<Double, TResult> results, PrintStream s) {
        s.println();
        s.format("%4s %13s %8s %10s %12s %7s %7s %7s %7s %7s %7s %15s %10s %10s", "#", "Family", "Proj.", "Resid.", "R", "latP", "lonP", "lat1", "lat2", "lon0", "C", "Scale", "Rotation", "Iter.");
        int index = 1;
        for (Map.Entry<Double, TResult> resuls_item : results.entrySet()) {
            double fx = resuls_item.getKey();
            TResult result = resuls_item.getValue();
            Projection proj = result.proj;
            s.format(" %3d %13s %8s %10.3e %12.3f %7.1f %7.1f %7.1f %7.1f %7.1f %7.1f %15.1f %10.2f %10d", index, proj.getFamily(), proj.getName(), fx, proj.getR(), proj.getCartPole().getLat(), proj.getCartPole().getLon(), proj.getLat1(), proj.getLat2(), proj.getLon0(), proj.getC(), result.map_scale, result.map_rotation, result.iterations);
            s.println("");
            ++index;
        }
    }
}

