/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.carttransformation;

import detectprojv2j.exceptions.MathInvalidArgumentException;
import detectprojv2j.structures.point.Point3DCartesian;
import detectprojv2j.structures.point.Point3DGeographic;
import detectprojv2j.structures.projection.Projection;
import detectprojv2j.types.ICoordFunctionProj;
import detectprojv2j.types.TTransformedLongitudeDirection;
import java.util.ArrayList;
import java.util.List;

public class CartTransformation {
    public static double redLon0(double lon, double lon0) {
        return lon - lon0 < -180.0 ? 360.0 + (lon - lon0) : (lon - lon0 > 180.0 ? lon - lon0 - 360.0 : lon - lon0);
    }

    public static double latToLatTrans(Point3DGeographic p, Point3DGeographic pole) {
        return CartTransformation.latToLatTrans(p.getLat(), p.getLon(), pole.getLat(), pole.getLon());
    }

    public static double latTransToLat(Point3DGeographic p, Point3DGeographic pole, TTransformedLongitudeDirection lon_direction) {
        return CartTransformation.latTransToLat(p.getLat(), p.getLon(), pole.getLat(), pole.getLon(), lon_direction);
    }

    public static double lonToLonTrans(Point3DGeographic p, Point3DGeographic pole, TTransformedLongitudeDirection lon_direction) {
        return CartTransformation.lonToLonTrans(p.getLat(), p.getLon(), pole.getLat(), pole.getLon(), lon_direction);
    }

    public static double lonTransToLon(Point3DGeographic p, Point3DGeographic pole, TTransformedLongitudeDirection lon_direction) {
        return CartTransformation.lonTransToLon(p.getLat(), p.getLon(), pole.getLat(), pole.getLon(), lon_direction);
    }

    public static double latToLatTrans(double lat, double lon, double latp, double lonp) {
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: ", "can not convert lat to lat_trans, lat > +- Pi/2", lat);
        }
        if (Math.abs(lon) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: ", "can not convert lat to lat_trans, lon > +- Pi", lon);
        }
        if (Math.abs(90.0 - latp) < 1.0E-8) {
            return lat;
        }
        if (Math.abs(lon - lonp) < 1.0E-8 && Math.abs(lat - latp) < 1.0E-8) {
            return 90.0;
        }
        double lat_trans_asin = Math.sin(lat * Math.PI / 180.0) * Math.sin(latp * Math.PI / 180.0) + Math.cos(lat * Math.PI / 180.0) * Math.cos(latp * Math.PI / 180.0) * Math.cos((lonp - lon) * Math.PI / 180.0);
        if (lat_trans_asin > 1.00001 || lat_trans_asin < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: ", "can not convert lat to lat_trans, asin(arg), arg = ", lat_trans_asin);
        }
        if (lat_trans_asin > 1.0) {
            return 90.0;
        }
        if (lat_trans_asin < -1.0) {
            return -90.0;
        }
        return Math.asin(lat_trans_asin) * 180.0 / Math.PI;
    }

    public static double latTransToLat(double lat_trans, double lon_trans, double latp, double lonp, TTransformedLongitudeDirection lon_direction) {
        if (Math.abs(lat_trans) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: ", "can not convert lat_trans to lat, lat_trans > +- Pi/2", lat_trans);
        }
        if (Math.abs(lon_trans) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: ", "can not convert lat_trans to lat, lon > +- Pi", lon_trans);
        }
        if (Math.abs(90.0 - latp) < 1.0E-8) {
            return lat_trans;
        }
        if (Math.abs(lat_trans - 90.0) < 1.0E-8) {
            return latp;
        }
        double lon_trans2 = lon_trans;
        if (lon_direction == TTransformedLongitudeDirection.NormalDirection2) {
            lon_trans2 = -lon_trans;
        } else if (lon_direction == TTransformedLongitudeDirection.ReversedDirection) {
            lon_trans2 = lon_trans < 0.0 ? lon_trans - 180.0 : lon_trans + 180.0;
        } else if (lon_direction == TTransformedLongitudeDirection.NormalDirection) {
            lon_trans2 = lon_trans < 0.0 ? -180.0 - lon_trans : 180.0 - lon_trans;
        }
        double lat_asin = Math.sin(lat_trans * Math.PI / 180.0) * Math.sin(latp * Math.PI / 180.0) + Math.cos(lat_trans * Math.PI / 180.0) * Math.cos(latp * Math.PI / 180.0) * Math.cos(lon_trans2 * Math.PI / 180.0);
        if (lat_asin > 1.00001 || lat_asin < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: ", "can not convert lat_trans to lat, asin(arg), arg = ", lat_asin);
        }
        if (lat_asin > 1.0) {
            return 90.0;
        }
        if (lat_asin < -1.0) {
            return -90.0;
        }
        return Math.asin(lat_asin) * 180.0 / Math.PI;
    }

    public static double lonToLonTrans(double lat, double lon, double latp, double lonp, TTransformedLongitudeDirection lon_direction) {
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: ", " can not convert lon to lon_trans, lat > +- Pi/2", lat);
        }
        if (Math.abs(lon) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: ", " can not convert lon to lon_trans, lon > +- Pi", lon);
        }
        if (Math.abs(90.0 - latp) < 1.0E-8 && Math.abs(lonp) < 1.0E-8) {
            return lon;
        }
        double lon_trans = Math.atan2(Math.cos(lat * Math.PI / 180.0) * Math.sin((lon - lonp) * Math.PI / 180.0), Math.sin(lat * Math.PI / 180.0) * Math.cos(latp * Math.PI / 180.0) - Math.cos((lon - lonp) * Math.PI / 180.0) * Math.sin(latp * Math.PI / 180.0) * Math.cos(lat * Math.PI / 180.0)) * 180.0 / Math.PI;
        if (lon_direction == TTransformedLongitudeDirection.NormalDirection2) {
            lon_trans = -lon_trans;
        } else if (lon_direction == TTransformedLongitudeDirection.ReversedDirection) {
            lon_trans = lon_trans < 0.0 ? (lon_trans += 180.0) : (lon_trans -= 180.0);
        } else if (lon_direction == TTransformedLongitudeDirection.NormalDirection) {
            lon_trans = lon_trans < 0.0 ? -180.0 - lon_trans : 180.0 - lon_trans;
        }
        return lon_trans;
    }

    public static double lonTransToLon(double lat_trans, double lon_trans, double latp, double lonp, TTransformedLongitudeDirection lon_direction) {
        if (Math.abs(lat_trans) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: ", " can not convert lon_trans to lon, lat_trans > +- Pi/2", lat_trans);
        }
        if (Math.abs(lon_trans) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: ", " can not convert lon_trans to lon, lon_trans > +- Pi", lon_trans);
        }
        if (Math.abs(90.0 - latp) < 1.0E-8 && Math.abs(lonp) < 1.0E-8) {
            double lon = CartTransformation.redLon0(lonp, -lon_trans);
            return lon;
        }
        double lon_trans2 = lon_trans;
        if (lon_direction == TTransformedLongitudeDirection.NormalDirection2) {
            lon_trans2 = -lon_trans;
        } else if (lon_direction == TTransformedLongitudeDirection.ReversedDirection) {
            lon_trans2 = lon_trans < 0.0 ? lon_trans - 180.0 : lon_trans + 180.0;
        } else if (lon_direction == TTransformedLongitudeDirection.NormalDirection) {
            lon_trans2 = lon_trans < 0.0 ? -180.0 - lon_trans : 180.0 - lon_trans;
        }
        double dlon = Math.atan2(Math.cos(lat_trans * Math.PI / 180.0) * Math.sin(lon_trans2 * Math.PI / 180.0), Math.sin(lat_trans * Math.PI / 180.0) * Math.cos(latp * Math.PI / 180.0) - Math.cos(lon_trans2 * Math.PI / 180.0) * Math.sin(latp * Math.PI / 180.0) * Math.cos(lat_trans * Math.PI / 180.0)) * 180.0 / Math.PI;
        double lon = CartTransformation.redLon0(lonp, -dlon);
        return lon;
    }

    public static void latLonToXY(double lat, double lon, Projection proj, double alpha, double[] lat_trans, double[] lon_trans, double[] X, double[] Y) {
        CartTransformation.latLonToXY(lat, lon, proj.getR(), proj.getLat1(), proj.getLat2(), proj.getCartPole().getLat(), proj.getCartPole().getLon(), proj.getLonDir(), proj.getLon0(), proj.getDx(), proj.getDy(), proj.getC(), proj.getX(), proj.getY(), alpha, lat_trans, lon_trans, X, Y);
    }

    public static void latLonToXY(double lat, double lon, double R, double lat1, double lat2, double latp, double lonp, TTransformedLongitudeDirection lon_dir, double lon0, double dx, double dy, double c, ICoordFunctionProj F, ICoordFunctionProj G, double alpha, double[] lat_trans, double[] lon_trans, double[] X, double[] Y) {
        lat_trans[0] = CartTransformation.latToLatTrans(lat, lon, latp, lonp);
        lon_trans[0] = CartTransformation.lonToLonTrans(lat, lon, latp, lonp, lon_dir);
        double Xr = F.f(lat_trans[0], lon_trans[0], R, lat1, lat2, lon0, 0.0, 0.0, c);
        double Yr = G.f(lat_trans[0], lon_trans[0], R, lat1, lat2, lon0, 0.0, 0.0, c);
        double q1 = Math.cos(alpha * Math.PI / 180.0);
        double q2 = Math.sin(alpha * Math.PI / 180.0);
        X[0] = Xr * q1 - Yr * q2 + dx;
        Y[0] = Xr * q2 + Yr * q1 + dy;
    }

    public static void XYToLatLon(double X, double Y, Projection proj, double alpha, double[] lat_trans, double[] lon_trans, double[] lat, double[] lon) {
        CartTransformation.XYToLatLon(X, Y, proj.getR(), proj.getLat1(), proj.getLat2(), proj.getCartPole().getLat(), proj.getCartPole().getLon(), proj.getLonDir(), proj.getLon0(), proj.getDx(), proj.getDy(), proj.getC(), proj.getLat(), proj.getLon(), alpha, lat_trans, lon_trans, lat, lon);
    }

    public static void XYToLatLon(double X, double Y, double R, double lat1, double lat2, double latp, double lonp, TTransformedLongitudeDirection lon_dir, double lon0, double dx, double dy, double c, ICoordFunctionProj FI, ICoordFunctionProj GI, double alpha, double[] lat_trans, double[] lon_trans, double[] lat, double[] lon) {
        double q1 = Math.cos(alpha * Math.PI / 180.0);
        double q2 = Math.sin(alpha * Math.PI / 180.0);
        double Xr = (X - dx) * q1 + (Y - dy) * q2;
        double Yr = -(X - dx) * q2 + (Y - dy) * q1;
        lat_trans[0] = FI.f(Xr, Yr, R, lat1, lat2, lon0, 0.0, 0.0, c);
        lon_trans[0] = GI.f(Xr, Yr, R, lat1, lat2, lon0, 0.0, 0.0, c);
        lat[0] = CartTransformation.latTransToLat(lat_trans[0], lon_trans[0], latp, lonp, lon_dir);
        lon[0] = CartTransformation.lonTransToLon(lat_trans[0], lon_trans[0], latp, lonp, lon_dir);
    }

    public static List<Point3DCartesian> latsLonsToXY(List<Point3DGeographic> reference_points, Projection proj, double alpha) {
        ArrayList<Point3DCartesian> projected_points = new ArrayList<Point3DCartesian>();
        for (Point3DGeographic p : reference_points) {
            double[] X = new double[]{0.0};
            double[] Y = new double[]{0.0};
            double[] lat_trans = new double[]{0.0};
            double[] lon_trans = new double[]{0.0};
            try {
                CartTransformation.latLonToXY(p.getLat(), p.getLon(), proj, alpha, lat_trans, lon_trans, X, Y);
                projected_points.add(new Point3DCartesian(X[0], Y[0], p.getH()));
            }
            catch (Exception exception) {}
        }
        return projected_points;
    }

    public static List<Point3DGeographic> XYToLatsLons(List<Point3DCartesian> reference_points, Projection proj, double alpha) {
        ArrayList<Point3DGeographic> projected_points = new ArrayList<Point3DGeographic>();
        for (Point3DCartesian p : reference_points) {
            double[] lat = new double[]{0.0};
            double[] lon = new double[]{0.0};
            double[] lat_trans = new double[]{0.0};
            double[] lon_trans = new double[]{0.0};
            try {
                CartTransformation.XYToLatLon(p.getX(), p.getY(), proj, alpha, lat_trans, lon_trans, lat, lon);
                projected_points.add(new Point3DGeographic(lat[0], lon[0], p.getZ()));
            }
            catch (Exception exception) {}
        }
        return projected_points;
    }
}

