/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.geneticalgorithms;

import detectprojv2j.algorithms.nonlinearleastsquares.NonLinearLeastSquares;
import detectprojv2j.exceptions.BadDataException;
import detectprojv2j.exceptions.MathMatrixDifferentSizeException;
import detectprojv2j.structures.matrix.Matrix;
import detectprojv2j.types.IResiduals;
import detectprojv2j.types.TAdaptiveControl;
import detectprojv2j.types.TMutationStrategy;
import java.io.PrintStream;

public class DifferentialEvolution {
    public static double diffEvolution(IResiduals function, int population_size, double epsilon, int max_gener, Matrix F, double[] CR, TMutationStrategy mutation_strategy, TAdaptiveControl adaptive_control, Matrix W, Matrix X, Matrix Y, Matrix RES, Matrix XMIN, Matrix XMAX, Matrix XAVER, double[] aver_res, double[] fx_max, int[] gener, boolean add_x0, PrintStream output) {
        double fx_min;
        int dim = XMIN.cols();
        int row_index_min = 0;
        int column_index_min = 0;
        boolean improve = false;
        if (XMIN.cols() != XMAX.cols()) {
            throw new MathMatrixDifferentSizeException("MathMatrixDifferentSizeException: ", " invalid dimension of the matrices, can not perform differential evolution; (rows_count columns_count):  ", XMIN, XMAX);
        }
        if (population_size < dim + 1) {
            throw new BadDataException("BadDataException: too small population (pop < dim + 1).", "Can not find the global minimum in this interval...");
        }
        for (int i = 0; i < dim; ++i) {
            if (!(XMIN.items[0][i] > XMAX.items[0][i])) continue;
            throw new BadDataException("BadDataException: all limits a(i) > b(i), should be a(i) < b(i).", "Can not find the global minimum in this interval...");
        }
        Matrix P_A = new Matrix(population_size, dim);
        Matrix P_V = new Matrix(population_size, 1);
        if (add_x0) {
            P_A.replace(X, 0, 0);
        }
        DifferentialEvolution.createInitialPopulation(function, XMIN, XMAX, W, Y, RES, population_size, dim, P_A, P_V, add_x0);
        double fx_min_old_100 = fx_min = P_V.min();
        double fx_min_old = fx_min;
        Matrix Q_A = new Matrix(P_A);
        Matrix Q_V = new Matrix(P_V);
        gener[0] = 0;
        Matrix FM = new Matrix(population_size, 1);
        Matrix CRM = new Matrix(population_size, 1);
        while (gener[0] < max_gener) {
            if (adaptive_control == TAdaptiveControl.AdaptiveDecreasing) {
                F.items[0][0] = 0.5 * (double)(max_gener - gener[0]) / (double)max_gener;
            }
            double dg = 1.2;
            for (int i = 0; i < population_size; ++i) {
                double function_val_y;
                if (adaptive_control == TAdaptiveControl.AdaptiveRandom) {
                    F.items[0][0] = 0.5 * (1.0 + Math.random());
                } else if (adaptive_control == TAdaptiveControl.Jitter) {
                    for (int j = 0; j < dim; ++j) {
                        double r = Math.random();
                        F.items[0][j] = 0.5 * (1.0 + 0.001 * (r - 0.5));
                    }
                } else if (adaptive_control == TAdaptiveControl.MFDE && gener[0] > 0) {
                    double r = Math.random();
                    F.items[0][0] = fx_min < fx_min_old ? 1.5 * Math.sqrt(r * r * dg) : Math.sqrt(r * r * dg) - 0.2;
                    dg -= 1.0 / (double)population_size;
                } else if (adaptive_control == TAdaptiveControl.SAM) {
                    double TAU1 = 0.1;
                    double r1 = Math.random();
                    if (r1 < 0.1) {
                        double r2 = Math.random();
                        F.items[0][0] = 0.1 + 0.9 * r2;
                        FM.items[i][0] = F.items[0][0];
                    } else {
                        F.items[0][0] = FM.items[i][0];
                    }
                    double r3 = Math.random();
                    if (r3 < 0.1) {
                        double r4;
                        CR[0] = r4 = Math.random();
                        CRM.items[i][0] = CR[0];
                    } else {
                        CR[0] = CRM.items[i][0];
                    }
                }
                Matrix U = new Matrix(1, dim);
                Matrix AS = new Matrix(3, dim);
                if (mutation_strategy == TMutationStrategy.DERand1Strategy) {
                    DifferentialEvolution.mutationStrategyDERand1(P_A, i, population_size, F, U);
                } else if (mutation_strategy == TMutationStrategy.DERand2Strategy) {
                    DifferentialEvolution.mutationStrategyDERand2(P_A, i, population_size, F, U);
                } else if (mutation_strategy == TMutationStrategy.DERandDir1Strategy) {
                    DifferentialEvolution.mutationStrategyDERandDir1(P_A, P_V, i, population_size, F, U);
                } else if (mutation_strategy == TMutationStrategy.DERandDir2Strategy) {
                    DifferentialEvolution.mutationStrategyDERandDir2(P_A, P_V, i, population_size, F, U);
                } else if (mutation_strategy == TMutationStrategy.DERandBest1Strategy) {
                    DifferentialEvolution.mutationStrategyDERandBest1(P_A, P_V, i, population_size, F, U);
                } else if (mutation_strategy == TMutationStrategy.DERandBest2Strategy) {
                    DifferentialEvolution.mutationStrategyDERandBest2(P_A, P_V, i, population_size, F, U);
                } else if (mutation_strategy == TMutationStrategy.DERandBestDir1Strategy) {
                    DifferentialEvolution.mutationStrategyDERandBestDir1(P_A, P_V, i, population_size, F, U);
                } else if (mutation_strategy == TMutationStrategy.DETargetToBest1Strategy) {
                    DifferentialEvolution.mutationStrategyDETargetToBest1(P_A, P_V, i, population_size, F, U);
                } else if (mutation_strategy == TMutationStrategy.SACPStrategy) {
                    DifferentialEvolution.mutationStrategySACP(P_A, P_V, i, population_size, aver_res[0], F, CR, U);
                }
                Matrix V = P_A.row(i);
                DifferentialEvolution.crossover(U, CR[0], dim, V);
                DifferentialEvolution.reflection(V, XMIN, XMAX);
                try {
                    function.f(V, Y, RES, W);
                    function_val_y = RES.trans().mult(W).mult(RES).norm();
                }
                catch (Exception error) {
                    function_val_y = 1.0E37;
                }
                if (!(function_val_y <= P_V.items[i][0])) continue;
                Q_A.row(V, i);
                Q_V.items[i][0] = function_val_y;
            }
            P_A = Q_A;
            P_V = Q_V;
            XAVER = P_A.sumCols().mult(1.0 / (double)population_size);
            int[] position = new int[]{0, 0};
            fx_min_old = fx_min;
            fx_max[0] = P_V.max();
            fx_min = P_V.min(position);
            row_index_min = position[0];
            column_index_min = position[1];
            aver_res[0] = P_V.sumCol(0) / (double)population_size;
            double diff = fx_max[0] - fx_min;
            gener[0] = gener[0] + 1;
            if (diff < epsilon * Math.max(1.0, fx_min) && fx_min < 100.0 || gener[0] % 100 == 0 && Math.abs(fx_min - fx_min_old_100) < epsilon * Math.max(1.0, fx_min) && fx_min < 100.0) break;
            if (gener[0] % 100 != 0) continue;
            fx_min_old_100 = fx_min;
        }
        X.copy(P_A.row(row_index_min));
        function.f(X, Y, RES, W);
        return fx_min;
    }

    public static void createInitialPopulation(IResiduals function, Matrix XMIN, Matrix XMAX, Matrix W, Matrix Y, Matrix RES, int population_size, int dim, Matrix P_A, Matrix P_V, boolean add_x0) {
        for (int i = 0; i < population_size; ++i) {
            if (i != 0 && add_x0 || !add_x0) {
                for (int j = 0; j < dim; ++j) {
                    P_A.items[i][j] = XMIN.items[0][j] + (XMAX.items[0][j] - XMIN.items[0][j]) * Math.random();
                }
            }
            try {
                Matrix P_AR = P_A.row(i);
                function.f(P_AR, Y, RES, W);
                P_V.items[i][0] = RES.trans().mult((Matrix)W).mult((Matrix)RES).items[0][0];
                continue;
            }
            catch (Exception error) {
                P_V.items[i][0] = 0.0;
            }
        }
    }

    public static void mutationStrategyDERand1(Matrix P_A, int i, int population_size, Matrix F, Matrix U) {
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        int m = F.rows();
        while ((i1 = (int)(Math.random() * (double)population_size)) == i) {
        }
        while ((i2 = (int)(Math.random() * (double)population_size)) == i1 || i2 == i) {
        }
        while ((i3 = (int)(Math.random() * (double)population_size)) == i2 || i3 == i1 || i3 == i) {
        }
        Matrix R1 = P_A.row(i1);
        Matrix R2 = P_A.row(i2);
        Matrix R3 = P_A.row(i3);
        if (m == 1) {
            U.copy(R1.plus(R2.minus(R3).mult(F.items[0][0])));
        } else {
            U.copy(R1.plus(F.had(R2.minus(R3))));
        }
    }

    public static void mutationStrategyDERand2(Matrix P_A, int i, int population_size, Matrix F, Matrix U) {
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        int i4 = 0;
        int i5 = 0;
        int m = F.rows();
        while ((i1 = (int)(Math.random() * (double)population_size)) == i) {
        }
        while ((i2 = (int)(Math.random() * (double)population_size)) == i1 || i2 == i) {
        }
        while ((i3 = (int)(Math.random() * (double)population_size)) == i2 || i3 == i1 || i3 == i) {
        }
        while ((i4 = (int)(Math.random() * (double)population_size)) == i3 || i4 == i2 || i4 == i1 || i4 == i) {
        }
        while ((i5 = (int)(Math.random() * (double)population_size)) == i4 || i5 == i3 || i5 == i2 || i5 == i1 || i5 == i) {
        }
        Matrix R1 = P_A.row(i1);
        Matrix R2 = P_A.row(i2);
        Matrix R3 = P_A.row(i3);
        Matrix R4 = P_A.row(i4);
        Matrix R5 = P_A.row(i5);
        if (m == 1) {
            U.copy(R1.plus(R2.plus(R4).minus(R3).minus(R5).mult(F.items[0][0])));
        } else {
            U.copy(R1.plus(F.had(R2.plus(R4).minus(R3).minus(R5))));
        }
    }

    public static void mutationStrategyDERandDir1(Matrix P_A, Matrix P_V, int i, int population_size, Matrix F, Matrix U) {
        int i1 = 0;
        int i2 = 0;
        int m = P_A.rows();
        int n = P_A.cols();
        int nf = F.cols();
        while ((i1 = (int)(Math.random() * (double)population_size)) == i) {
        }
        while ((i2 = (int)(Math.random() * (double)population_size)) == i1 || i2 == i) {
        }
        Matrix R1 = P_A.row(i1);
        Matrix R2 = P_A.row(i2);
        double function_val_y1 = P_V.items[i1][0];
        double function_val_y2 = P_V.items[i2][0];
        if (function_val_y1 <= function_val_y2) {
            if (nf == 1) {
                U.copy(R1.plus(R1.minus(R2).mult(F.items[0][0])));
            } else {
                U.copy(R1.plus(F.had(R1.minus(R2))));
            }
        } else if (nf == 1) {
            U.copy(R2.plus(R2.minus(R1).mult(F.items[0][0])));
        } else {
            U.copy(R2.plus(F.had(R2.minus(R1))));
        }
    }

    public static void mutationStrategyDERandDir2(Matrix P_A, Matrix P_V, int i, int population_size, Matrix F, Matrix U) {
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        int i4 = 0;
        int m = P_A.rows();
        int n = P_A.cols();
        int nf = F.cols();
        while ((i1 = (int)(Math.random() * (double)population_size)) == i) {
        }
        while ((i2 = (int)(Math.random() * (double)population_size)) == i1 || i2 == i) {
        }
        while ((i3 = (int)(Math.random() * (double)population_size)) == i2 || i3 == i1 || i3 == i) {
        }
        while ((i4 = (int)(Math.random() * (double)population_size)) == i3 || i4 == i2 || i4 == i1 || i4 == i) {
        }
        Matrix R1 = P_A.row(i1);
        Matrix R2 = P_A.row(i2);
        Matrix R3 = P_A.row(i3);
        Matrix R4 = P_A.row(i4);
        double function_val_y1 = P_V.items[i1][0];
        double function_val_y2 = P_V.items[i2][0];
        double function_val_y3 = P_V.items[i3][0];
        double function_val_y4 = P_V.items[i4][0];
        Matrix v1 = R1;
        Matrix v2 = R2;
        Matrix v3 = R3;
        Matrix v4 = R4;
        if (function_val_y1 > function_val_y2) {
            v1 = R2;
            v2 = R1;
        }
        if (function_val_y3 > function_val_y4) {
            v3 = R4;
            v4 = R3;
        }
        if (nf == 1) {
            U.copy(v1.plus(v1.minus(v2).plus(v3).minus(v4).mult(F.items[0][0])));
        } else {
            U.copy(v1.plus(F.had(v1.minus(v2).plus(v3)).minus(v4)));
        }
    }

    public static void mutationStrategyDERandBest1(Matrix P_A, Matrix P_V, int i, int population_size, Matrix F, Matrix U) {
        int i1 = 0;
        int i2 = 0;
        int row_index_min = 0;
        int column_index_min = 0;
        int nf = F.cols();
        int[] position = new int[]{0, 0};
        double min_val = P_V.min(position);
        row_index_min = position[0];
        column_index_min = position[1];
        while ((i1 = (int)(Math.random() * (double)population_size)) == i || i1 == row_index_min) {
        }
        while ((i2 = (int)(Math.random() * (double)population_size)) == i1 || i2 == i || i2 == row_index_min) {
        }
        Matrix R1 = P_A.row(i1);
        Matrix R2 = P_A.row(i2);
        if (nf == 1) {
            U.copy(P_A.row(row_index_min).plus(R1.minus(R2).mult(F.items[0][0])));
        } else {
            U.copy(P_A.row(row_index_min).plus(F.had(R1.minus(R2))));
        }
    }

    public static void mutationStrategyDERandBest2(Matrix P_A, Matrix P_V, int i, int population_size, Matrix F, Matrix U) {
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        int i4 = 0;
        int[] position = new int[]{0, 0};
        int row_index_min = 0;
        int column_index_min = 0;
        int nf = F.cols();
        double min_val = P_V.min(position);
        row_index_min = position[0];
        column_index_min = position[1];
        while ((i1 = (int)(Math.random() * (double)population_size)) == i || i1 == row_index_min) {
        }
        while ((i2 = (int)(Math.random() * (double)population_size)) == i1 || i2 == i || i2 == row_index_min) {
        }
        while ((i3 = (int)(Math.random() * (double)population_size)) == i2 || i3 == i1 || i3 == i || i3 == row_index_min) {
        }
        while ((i4 = (int)(Math.random() * (double)population_size)) == i3 || i4 == i2 || i4 == i1 || i4 == i || i4 == row_index_min) {
        }
        Matrix R1 = P_A.row(i1);
        Matrix R2 = P_A.row(i2);
        Matrix R3 = P_A.row(i3);
        Matrix R4 = P_A.row(i4);
        if (nf == 1) {
            U.copy(P_A.row(row_index_min).plus(R1.minus(R2).plus(R3).minus(R4).mult(F.items[0][0])));
        } else {
            U.copy(P_A.row(row_index_min).plus(F.had(R1.minus(R2).plus(R3).minus(R4))));
        }
    }

    public static void mutationStrategyDERandBestDir1(Matrix P_A, Matrix P_V, int i, int population_size, Matrix F, Matrix U) {
        int i1 = 0;
        int i2 = 0;
        int[] position = new int[]{0, 0};
        int row_index_min = 0;
        int column_index_min = 0;
        int nf = F.cols();
        double min_val = P_V.min(position);
        row_index_min = position[0];
        column_index_min = position[1];
        while ((i1 = (int)(Math.random() * (double)population_size)) == i || i1 == row_index_min) {
        }
        while ((i2 = (int)(Math.random() * (double)population_size)) == i1 || i2 == i || i2 == row_index_min) {
        }
        Matrix R1 = P_A.row(i1);
        Matrix R2 = P_A.row(i2);
        Matrix Ri = P_A.row(i);
        if (nf == 1) {
            U.copy(P_A.row(row_index_min).plus(P_A.row(row_index_min).plus(R1).minus(Ri).minus(R2).mult(F.items[0][0])));
        } else {
            U.copy(P_A.row(row_index_min).plus(F.had(P_A.row(row_index_min).plus(R1).minus(Ri).minus(R2))));
        }
    }

    public static void mutationStrategyDETargetToBest1(Matrix P_A, Matrix P_V, int i, int population_size, Matrix F, Matrix U) {
        int i1 = 0;
        int i2 = 0;
        int[] position = new int[]{0, 0};
        int row_index_min = 0;
        int column_index_min = 0;
        int nf = F.cols();
        double min_val = P_V.min(position);
        row_index_min = position[0];
        column_index_min = position[1];
        while ((i1 = (int)(Math.random() * (double)population_size)) == i || i1 == row_index_min) {
        }
        while ((i2 = (int)(Math.random() * (double)population_size)) == i1 || i2 == i || i2 == row_index_min) {
        }
        Matrix R1 = P_A.row(i1);
        Matrix R2 = P_A.row(i2);
        Matrix Ri = P_A.row(i);
        if (nf == 1) {
            U.copy(Ri.plus(P_A.row(row_index_min).minus(Ri).mult(F.items[0][0]).plus(R1.minus(R2).mult(F.items[0][0]))));
        } else {
            U.copy(Ri.plus(F.had(P_A.row(row_index_min).minus(Ri)).plus(F.had(R1.minus(R2)))));
        }
    }

    public static void mutationStrategySACP(Matrix P_A, Matrix P_V, int i, int population_size, double aver_res, Matrix F, double[] CR, Matrix U) {
        int i1 = 0;
        int i2 = 0;
        int i3 = 0;
        int m = P_A.rows();
        int n = P_A.cols();
        while ((i1 = (int)(Math.random() * (double)population_size)) == i) {
        }
        while ((i2 = (int)(Math.random() * (double)population_size)) == i1 || i2 == i) {
        }
        while ((i3 = (int)(Math.random() * (double)population_size)) == i2 || i3 == i1 || i3 == i) {
        }
        Matrix A = new Matrix(3, n);
        Matrix V = new Matrix(3, 1);
        A.replace(P_A.row(i1), 0, 0);
        A.replace(P_A.row(i2), 1, 0);
        A.replace(P_A.row(i3), 2, 0);
        V.items[0][0] = P_V.items[i1][0];
        V.items[1][0] = P_V.items[i2][0];
        V.items[2][0] = P_V.items[i3][0];
        Matrix IX = new Matrix(3, 1);
        V.sortrows(IX, 0);
        Matrix AS = new Matrix(3, n);
        AS.replace(A.row((int)IX.items[0][0]), 0, 0);
        AS.replace(A.row((int)IX.items[1][0]), 1, 0);
        AS.replace(A.row((int)IX.items[2][0]), 2, 0);
        F.items[0][0] = 0.1 + 0.8 * (V.items[1][0] - V.items[0][0]) / (V.items[2][0] - V.items[0][0]);
        double function_val_yi = P_V.items[i][0];
        CR[0] = function_val_yi >= aver_res ? 0.1 + 0.5 * (function_val_yi - V.items[0][0]) / (V.items[2][0] - V.items[0][0]) : 0.1;
        U.copy(AS.row(0).plus(AS.row(1).minus(AS.row(2)).mult(F.items[0][0])));
    }

    public static void crossover(Matrix U, double CR, int dim, Matrix V) {
        int total_swap = 0;
        for (int j = 0; j < dim; ++j) {
            double r_val = Math.random();
            if (!(r_val < CR)) continue;
            V.items[0][j] = U.items[0][j];
            total_swap = (short)(total_swap + 1);
        }
        if (total_swap == 0) {
            int index = (int)(Math.random() * (double)dim);
            V.items[0][index] = U.items[0][index];
        }
    }

    public static void reflection(Matrix X, Matrix XMIN, Matrix XMAX) {
        Matrix XT = X.trans();
        NonLinearLeastSquares.reflection(XT, XMIN.trans(), XMAX.trans());
        X.copy(XT.trans());
    }
}

