/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.graticule;

import detectprojv2j.algorithms.carttransformation.CartTransformation;
import detectprojv2j.algorithms.greatcircleintersection.GreatCircleIntersection;
import detectprojv2j.algorithms.round.Round;
import detectprojv2j.exceptions.MathLatSingularityException;
import detectprojv2j.exceptions.MathLonSingularityException;
import detectprojv2j.exceptions.MathSingularityException;
import detectprojv2j.structures.graticule.Meridian;
import detectprojv2j.structures.graticule.Parallel;
import detectprojv2j.structures.point.Point3DCartesian;
import detectprojv2j.structures.point.Point3DGeographic;
import detectprojv2j.structures.projection.Projection;
import detectprojv2j.types.TGraticuleSampling;
import detectprojv2j.types.TInterval;
import detectprojv2j.types.TInterval2D;
import detectprojv2j.types.TTransformedLongitudeDirection;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class Graticule {
    private final double dlat;
    private final double dlon;
    private final double dff;
    private final int dmin;
    private final int dmax;

    public Graticule(double dlat_, double dlon_, double dff_, int dmin_, int dmax_) {
        this.dlat = dlat_;
        this.dlon = dlon_;
        this.dff = dff_;
        this.dmin = dmin_;
        this.dmax = dmax_;
    }

    public void createGraticule(Projection proj, TInterval lat_extent, TInterval lon_extent, double lat_step, double lon_step, double alpha, List<Meridian> meridians, List<List<Point3DCartesian>> meridians_proj, List<Parallel> parallels, List<List<Point3DCartesian>> parallels_proj, TGraticuleSampling sampling_method, int max_splits, double fmax, double eps) {
        Stack<TInterval2D> S = new Stack<TInterval2D>();
        double latp = proj.getCartPole().getLat();
        double lonp = proj.getCartPole().getLon();
        double lon0 = proj.getLon0();
        double lat_interval_width = lat_extent.max_value - lat_extent.min_value;
        double lon_interval_width = lon_extent.max_value - lon_extent.min_value;
        if (lat_step <= lat_interval_width || lon_step <= lon_interval_width) {
            TInterval lat_interval = new TInterval(lat_extent.min_value, lat_extent.max_value);
            lat_interval.min_value = Math.max(lat_extent.min_value, -90.0 + eps);
            lat_interval.max_value = Math.min(lat_extent.max_value, 90.0 - eps);
            TInterval lon_interval = new TInterval(lon_extent.min_value, lon_extent.max_value);
            lon_interval.min_value = Math.max(lon_extent.min_value, -180.0 + eps);
            lon_interval.max_value = Math.min(lon_extent.max_value, 180.0 - eps);
            TInterval2D lat_lon_interval = new TInterval2D(lat_interval, lon_interval);
            S.push(lat_lon_interval);
            int[] split_amount = new int[]{0};
            while (!S.empty()) {
                TInterval2D interval = (TInterval2D)S.pop();
                ArrayList<Meridian> meridians_temp = new ArrayList<Meridian>();
                ArrayList<Parallel> parallels_temp = new ArrayList<Parallel>();
                ArrayList<List<Point3DCartesian>> meridians_temp_proj = new ArrayList<List<Point3DCartesian>>();
                ArrayList<List<Point3DCartesian>> parallels_temp_proj = new ArrayList<List<Point3DCartesian>>();
                short[] k = new short[]{0};
                TInterval2D int1 = new TInterval2D(interval.i1, interval.i2);
                TInterval2D int2 = new TInterval2D(interval.i1, interval.i2);
                try {
                    try {
                        this.createMeridians(proj, interval.i1, interval.i2, lon_step, alpha, meridians_temp, meridians_temp_proj, sampling_method, fmax, eps);
                        this.createParallels(proj, interval.i1, interval.i2, lat_step, alpha, parallels_temp, parallels_temp_proj, sampling_method, fmax, eps);
                        for (Meridian meridian : meridians_temp) {
                            meridians.add(meridian);
                        }
                        for (Parallel parallel : parallels_temp) {
                            parallels.add(parallel);
                        }
                        for (List list : meridians_temp_proj) {
                            meridians_proj.add(list);
                        }
                        for (List list : parallels_temp_proj) {
                            parallels_proj.add(list);
                        }
                    }
                    catch (MathLatSingularityException error) {
                        double d = error.getArg();
                        if (split_amount[0] < max_splits) {
                            this.processInterval(interval.i1, d, int1.i1, int2.i1, k, split_amount, eps);
                        }
                        throw error;
                    }
                    catch (MathLonSingularityException error) {
                        double d = error.getArg();
                        if (split_amount[0] < max_splits) {
                            this.processInterval(interval.i2, d, int1.i2, int2.i2, k, split_amount, eps);
                        }
                        throw error;
                    }
                    catch (Exception error) {
                        meridians.clear();
                        parallels.clear();
                        return;
                    }
                }
                catch (MathSingularityException error) {
                    if (split_amount[0] > max_splits) {
                        meridians.clear();
                        parallels.clear();
                        meridians_proj.clear();
                        parallels_proj.clear();
                        return;
                    }
                    if (k[0] > 0) {
                        S.add(int1);
                    }
                    if (k[0] <= 1) continue;
                    S.add(int2);
                }
            }
        }
    }

    public void processInterval(TInterval i, double c, TInterval i1, TInterval i2, short[] k, int[] split_amount, double eps) {
        k[0] = 0;
        i1.min_value = i.min_value;
        i1.max_value = i.max_value;
        i2.min_value = i.min_value;
        i2.max_value = i.max_value;
        if (Math.abs(i.max_value - i.min_value) < eps) {
            return;
        }
        if (i.min_value > i.max_value) {
            return;
        }
        if (i.min_value <= c && Math.abs(c - i.min_value) <= eps) {
            i1.min_value += eps;
            k[0] = (short)(k[0] + 1);
        } else if (i.max_value >= c && Math.abs(c - i.max_value) <= eps) {
            i1.max_value -= eps;
            k[0] = (short)(k[0] + 1);
        } else if (i.min_value < c && i.max_value > c && Math.abs(c - i.min_value) > eps && Math.abs(c - i.max_value) > eps) {
            i1.max_value = c - eps;
            i2.min_value = c + eps;
            split_amount[0] = split_amount[0] + 1;
            k[0] = (short)(k[0] + 2);
        }
    }

    public void createMeridians(Projection proj, TInterval lat_interval, TInterval lon_interval, double lon_step, double alpha, List<Meridian> meridians, List<List<Point3DCartesian>> meridians_proj, TGraticuleSampling sampling_method, double fmax, double eps) {
        double lon_start = Round.roundToMultipleFloor(lon_interval.min_value, lon_step) + lon_step;
        double lon_end = Round.roundToMultipleCeil(lon_interval.max_value, lon_step) - lon_step;
        double lon_lb = Math.max(Math.min(lon_interval.min_value, 180.0), -180.0);
        lon_lb = Math.min(lon_lb, lon_interval.max_value);
        this.createMeridianFragment(proj, lon_lb, lat_interval, alpha, meridians, meridians_proj, sampling_method, fmax, eps);
        for (double lon = lon_start; lon <= lon_end; lon += lon_step) {
            this.createMeridianFragment(proj, lon, lat_interval, alpha, meridians, meridians_proj, sampling_method, fmax, eps);
        }
        double lon_ub = Math.min(Math.max(lon_interval.max_value - eps, -180.0), 180.0);
        lon_ub = Math.max(lon_ub, lon_interval.min_value);
        this.createMeridianFragment(proj, lon_ub, lat_interval, alpha, meridians, meridians_proj, sampling_method, fmax, eps);
        double lon = proj.getCartPole().getLon();
        if (lon > lon_interval.min_value && lon < lon_interval.max_value) {
            this.createMeridianFragment(proj, Math.min(Math.max(lon - eps, -180.0), 180.0), lat_interval, alpha, meridians, meridians_proj, sampling_method, fmax, eps);
            this.createMeridianFragment(proj, Math.max(Math.min(lon + eps, 180.0), -180.0), lat_interval, alpha, meridians, meridians_proj, sampling_method, fmax, eps);
        }
        double d = lon = lon > 0.0 ? lon - 180.0 : lon + 180.0;
        if (lon > lon_interval.min_value && lon < lon_interval.max_value) {
            this.createMeridianFragment(proj, Math.min(Math.max(lon - 0.001, -180.0), 180.0), lat_interval, alpha, meridians, meridians_proj, sampling_method, fmax, eps);
            this.createMeridianFragment(proj, Math.max(Math.min(lon + 0.001, 180.0), -180.0), lat_interval, alpha, meridians, meridians_proj, sampling_method, fmax, eps);
        }
    }

    public void createParallels(Projection proj, TInterval lat_interval, TInterval lon_interval, double lat_step, double alpha, List<Parallel> parallels, List<List<Point3DCartesian>> parallels_proj, TGraticuleSampling sampling_method, double fmax, double eps) {
        double lat_start = Round.roundToMultipleFloor(lat_interval.min_value, lat_step) + lat_step;
        double lat_end = Round.roundToMultipleCeil(lat_interval.max_value, lat_step) - lat_step;
        double lat_lb = Math.max(Math.min(lat_interval.min_value, 90.0), -90.0);
        lat_lb = Math.min(lat_lb, lat_interval.max_value);
        this.createParallelFragment(proj, lat_lb, lon_interval, alpha, parallels, parallels_proj, sampling_method, fmax, eps);
        for (double lat = lat_start; lat <= lat_end; lat += lat_step) {
            this.createParallelFragment(proj, lat, lon_interval, alpha, parallels, parallels_proj, sampling_method, fmax, eps);
        }
        double lat_ub = Math.min(Math.max(lat_interval.max_value, -90.0), 90.0);
        lat_ub = Math.max(lat_ub, lat_interval.min_value);
        this.createParallelFragment(proj, lat_ub, lon_interval, alpha, parallels, parallels_proj, sampling_method, fmax, eps);
    }

    public void createMeridianFragment(Projection proj, double lon, TInterval lat_interval, double alpha, List<Meridian> meridians, List<List<Point3DCartesian>> meridians_proj, TGraticuleSampling sampling_method, double fmax, double eps) {
        for (TInterval lat_interval_split : this.splitLatInterval(lat_interval, lon, proj.getCartPole(), proj.getLonDir(), proj.getLon0(), eps)) {
            Meridian mer = null;
            ArrayList<Point3DCartesian> mer_proj = new ArrayList<Point3DCartesian>();
            if (sampling_method == TGraticuleSampling.UniformSampling) {
                Meridian mer_u = new Meridian(lon, lat_interval_split, this.dlat, 0.0, 0.0);
                mer_u.project(proj, alpha, mer_proj);
                mer = mer_u;
            } else {
                Meridian mer_a;
                mer = mer_a = new Meridian(lon, lat_interval_split, this.dff, 0.0, 0.0, proj, alpha, mer_proj, fmax, this.dmin, this.dmax, eps);
            }
            meridians.add(mer);
            meridians_proj.add(mer_proj);
        }
    }

    public void createParallelFragment(Projection proj, double lat, TInterval lon_interval, double alpha, List<Parallel> parallels, List<List<Point3DCartesian>> parallels_proj, TGraticuleSampling sampling_method, double fmax, double eps) {
        for (TInterval lon_interval_split : this.splitLonInterval(lon_interval, lat, proj.getCartPole(), proj.getLonDir(), proj.getLon0(), eps)) {
            Parallel par = null;
            ArrayList<Point3DCartesian> par_proj = new ArrayList<Point3DCartesian>();
            if (sampling_method == TGraticuleSampling.UniformSampling) {
                Parallel par_u = new Parallel(lat, lon_interval_split, this.dlon, 0.0, 0.0);
                par_u.project(proj, alpha, par_proj);
                par = par_u;
            } else {
                Parallel par_a;
                par = par_a = new Parallel(lat, lon_interval_split, this.dff, 0.0, 0.0, proj, alpha, par_proj, fmax, this.dmin, this.dmax, eps);
            }
            parallels.add(par);
            parallels_proj.add(par_proj);
        }
    }

    public List<TInterval> splitLatInterval(TInterval lat_interval, double lon, Point3DGeographic pole, TTransformedLongitudeDirection lon_dir, double lon0, double eps) {
        Point3DGeographic[] i2;
        Point3DGeographic[] i1;
        double lon6;
        double lat6;
        Point3DGeographic p6;
        double lon5;
        double lat5;
        Point3DGeographic p5;
        double lon4;
        ArrayList<TInterval> lats_split = new ArrayList<TInterval>();
        Point3DGeographic p1 = new Point3DGeographic(-89.0, lon);
        Point3DGeographic p2 = new Point3DGeographic(1.0, lon);
        Point3DGeographic p3 = new Point3DGeographic(89.0, lon);
        double lat4 = CartTransformation.latTransToLat(-89.0, lon0, pole.getLat(), pole.getLon(), lon_dir);
        Point3DGeographic p4 = new Point3DGeographic(lat4, lon4 = CartTransformation.lonTransToLon(-89.0, lon0, pole.getLat(), pole.getLon(), lon_dir));
        boolean intersection_exists = GreatCircleIntersection.getGreatCirclePlainIntersection(p1, p2, p3, p4, p5 = new Point3DGeographic(lat5 = CartTransformation.latTransToLat(1.0, lon0, pole.getLat(), pole.getLon(), lon_dir), lon5 = CartTransformation.lonTransToLon(1.0, lon0, pole.getLat(), pole.getLon(), lon_dir)), p6 = new Point3DGeographic(lat6 = CartTransformation.latTransToLat(89.0, lon0, pole.getLat(), pole.getLon(), lon_dir), lon6 = CartTransformation.lonTransToLon(89.0, lon0, pole.getLat(), pole.getLon(), lon_dir)), i1 = new Point3DGeographic[]{new Point3DGeographic(0.0, 0.0)}, i2 = new Point3DGeographic[]{new Point3DGeographic(0.0, 0.0)}, pole, lon_dir);
        if (intersection_exists) {
            double lat_inters1 = i1[0].getLat();
            double lat_inters2 = i2[0].getLat();
            double lon_inters1 = i1[0].getLon();
            double lon_inters2 = i2[0].getLon();
            if (lat_inters1 > lat_interval.min_value && lat_inters1 < lat_interval.max_value && Math.abs(lon_inters1 - lon) < 1.0E-8) {
                lats_split.add(new TInterval(lat_interval.min_value, lat_inters1 - eps));
                lats_split.add(new TInterval(lat_inters1 + eps, lat_interval.max_value));
                return lats_split;
            }
            if (lat_inters2 > lat_interval.min_value && lat_inters2 < lat_interval.max_value && Math.abs(lon - lon_inters2) < 1.0E-8) {
                lats_split.add(new TInterval(lat_interval.min_value, lat_inters2 - eps));
                lats_split.add(new TInterval(lat_inters2 + eps, lat_interval.max_value));
                return lats_split;
            }
        }
        lats_split.add(new TInterval(lat_interval.min_value, lat_interval.max_value));
        return lats_split;
    }

    public List<TInterval> splitLonInterval(TInterval lon_interval, double lat, Point3DGeographic pole, TTransformedLongitudeDirection lon_dir, double lon0, double eps) {
        Point3DGeographic[] i2;
        Point3DGeographic[] i1;
        double lon6;
        double lat6;
        Point3DGeographic p6;
        double lon5;
        double lat5;
        Point3DGeographic p5;
        double lon4;
        ArrayList<TInterval> lons_split = new ArrayList<TInterval>();
        Point3DGeographic p1 = new Point3DGeographic(lat, -179.0);
        Point3DGeographic p2 = new Point3DGeographic(lat, 1.0);
        Point3DGeographic p3 = new Point3DGeographic(lat, 179.0);
        double lat4 = CartTransformation.latTransToLat(-89.0, lon0, pole.getLat(), pole.getLon(), lon_dir);
        Point3DGeographic p4 = new Point3DGeographic(lat4, lon4 = CartTransformation.lonTransToLon(-89.0, lon0, pole.getLat(), pole.getLon(), lon_dir));
        boolean intersection_exists = GreatCircleIntersection.getGreatCirclePlainIntersection(p1, p2, p3, p4, p5 = new Point3DGeographic(lat5 = CartTransformation.latTransToLat(1.0, lon0, pole.getLat(), pole.getLon(), lon_dir), lon5 = CartTransformation.lonTransToLon(1.0, lon0, pole.getLat(), pole.getLon(), lon_dir)), p6 = new Point3DGeographic(lat6 = CartTransformation.latTransToLat(89.0, lon0, pole.getLat(), pole.getLon(), lon_dir), lon6 = CartTransformation.lonTransToLon(89.0, lon0, pole.getLat(), pole.getLon(), lon_dir)), i1 = new Point3DGeographic[]{new Point3DGeographic(0.0, 0.0)}, i2 = new Point3DGeographic[]{new Point3DGeographic(0.0, 0.0)}, pole, lon_dir);
        if (intersection_exists) {
            double lon_inters1 = Math.min(i1[0].getLon(), i2[0].getLon());
            double lon_inters2 = Math.max(i1[0].getLon(), i2[0].getLon());
            if (lon_inters1 > lon_interval.min_value && lon_inters1 < lon_interval.max_value && lon_inters2 > lon_interval.min_value && lon_inters2 < lon_interval.max_value && Math.abs(lon_inters2 - lon_inters1) > 1.0E-8) {
                double lon_inters12_min = Math.min(lon_inters1, lon_inters2);
                double lon_inters12_max = Math.max(lon_inters1, lon_inters2);
                lons_split.add(new TInterval(lon_interval.min_value, lon_inters12_min - eps));
                lons_split.add(new TInterval(lon_inters12_min + eps, lon_inters12_max - eps));
                lons_split.add(new TInterval(lon_inters12_max + eps, lon_interval.max_value));
                return lons_split;
            }
            if (lon_inters1 > lon_interval.min_value && lon_inters1 < lon_interval.max_value) {
                lons_split.add(new TInterval(lon_interval.min_value, lon_inters1 - eps));
                lons_split.add(new TInterval(lon_inters1 + eps, lon_interval.max_value));
                return lons_split;
            }
            if (lon_inters2 > lon_interval.min_value && lon_inters2 < lon_interval.max_value) {
                lons_split.add(new TInterval(lon_interval.min_value, lon_inters2 - eps));
                lons_split.add(new TInterval(lon_inters2 + eps, lon_interval.max_value));
                return lons_split;
            }
        }
        lons_split.add(new TInterval(lon_interval.min_value, lon_interval.max_value));
        return lons_split;
    }
}

