/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.graticuleAS;

import detectprojv2j.algorithms.carttransformation.CartTransformation;
import detectprojv2j.algorithms.greatcircleintersection.GreatCircleIntersection;
import detectprojv2j.algorithms.round.Round;
import detectprojv2j.exceptions.MathLatSingularityException;
import detectprojv2j.exceptions.MathLonSingularityException;
import detectprojv2j.structures.graticule.Meridian;
import detectprojv2j.structures.graticule.Parallel;
import detectprojv2j.structures.point.Point3DCartesian;
import detectprojv2j.structures.point.Point3DGeographic;
import detectprojv2j.structures.projection.Projection;
import detectprojv2j.types.TInterval;
import detectprojv2j.types.TInterval2D;
import detectprojv2j.types.TTransformedLongitudeDirection;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class GraticuleAS {
    public static void createGraticule(Projection proj, TInterval lat_extent, TInterval lon_extent, double lat_step, double lon_step, double d_lat, double d_lon, double alpha, List<Meridian> meridians, List<List<Point3DCartesian>> meridians_proj, List<Parallel> parallels, List<List<Point3DCartesian>> parallels_proj) {
        Stack<TInterval2D> S = new Stack<TInterval2D>();
        double latp = proj.getCartPole().getLat();
        double lonp = proj.getCartPole().getLon();
        double lon0 = proj.getLon0();
        double lat_interval_width = lat_extent.max_value - lat_extent.min_value;
        double lon_interval_width = lon_extent.max_value - lon_extent.min_value;
        if (lat_step <= lat_interval_width || lon_step <= lon_interval_width) {
            TInterval lat_interval = new TInterval(lat_extent.min_value, lat_extent.max_value);
            lat_interval.min_value = Math.max(lat_extent.min_value, -89.999);
            lat_interval.max_value = Math.min(lat_extent.max_value, 89.999);
            TInterval lon_interval = new TInterval(lon_extent.min_value, lon_extent.max_value);
            lon_extent.min_value = Math.max(lon_extent.min_value, -179.999);
            lon_extent.max_value = Math.min(lon_extent.max_value, 179.999);
            TInterval2D lat_lon_interval = new TInterval2D(lat_interval, lon_interval);
            S.push(lat_lon_interval);
            int split_amount = 0;
            while (!S.empty()) {
                TInterval2D interval2;
                TInterval2D interval = (TInterval2D)S.pop();
                ArrayList<Meridian> meridians_temp = new ArrayList<Meridian>();
                ArrayList<Parallel> parallels_temp = new ArrayList<Parallel>();
                ArrayList<List<Point3DCartesian>> meridians_temp_proj = new ArrayList<List<Point3DCartesian>>();
                ArrayList<List<Point3DCartesian>> parallels_temp_proj = new ArrayList<List<Point3DCartesian>>();
                try {
                    GraticuleAS.createMeridians(proj, interval.i1, interval.i2, lon_step, d_lat, alpha, meridians_temp, meridians_temp_proj);
                    GraticuleAS.createParallels(proj, interval.i1, interval.i2, lat_step, d_lon, alpha, parallels_temp, parallels_temp_proj);
                    for (Meridian meridian : meridians_temp) {
                        meridians.add(meridian);
                    }
                    for (Parallel parallel : parallels_temp) {
                        parallels.add(parallel);
                    }
                    for (List list : meridians_temp_proj) {
                        meridians_proj.add(list);
                    }
                    for (List list : parallels_temp_proj) {
                        parallels_proj.add(list);
                    }
                }
                catch (MathLatSingularityException error) {
                    double[] dArray = new double[]{error.getArg()};
                    if ((double)split_amount > 100.0) {
                        meridians.clear();
                        parallels.clear();
                        meridians_proj.clear();
                        parallels_proj.clear();
                        return;
                    }
                    if (Math.abs(interval.i1.max_value - interval.i1.min_value) < 0.01) continue;
                    if (Math.abs(interval.i1.min_value - dArray[0]) < 0.002 && Math.abs(interval.i1.max_value - interval.i1.min_value) > 0.01) {
                        interval.i1.min_value += 0.002;
                    } else if (Math.abs(interval.i1.min_value - dArray[0]) < 0.002 && Math.abs(interval.i1.max_value - interval.i1.min_value) > 0.01) {
                        interval.i1.max_value -= 0.002;
                    } else if (interval.i1.min_value < dArray[0] && interval.i1.max_value > dArray[0]) {
                        interval2 = new TInterval2D(interval.i1, interval.i2);
                        interval2.i1.min_value = dArray[0] + 0.002;
                        S.push(interval2);
                        interval.i1.max_value = dArray[0] - 0.002;
                        ++split_amount;
                    }
                    S.push(interval);
                }
                catch (MathLonSingularityException error) {
                    double[] dArray = new double[]{error.getArg()};
                    if ((double)split_amount > 100.0) {
                        meridians.clear();
                        parallels.clear();
                        meridians_proj.clear();
                        parallels_proj.clear();
                        return;
                    }
                    if (Math.abs(interval.i2.max_value - interval.i2.min_value) < 0.01) continue;
                    if (Math.abs(interval.i2.min_value - dArray[0]) < 0.002 && Math.abs(interval.i2.max_value - interval.i2.min_value) > 0.01) {
                        interval.i2.min_value += 0.002;
                    } else if (Math.abs(interval.i2.max_value - dArray[0]) < 0.002 && Math.abs(interval.i2.max_value - interval.i2.min_value) > 0.01) {
                        interval.i2.max_value -= 0.002;
                    } else if (interval.i2.min_value < dArray[0] && interval.i2.max_value > dArray[0]) {
                        interval2 = new TInterval2D(interval.i1, interval.i2);
                        interval2.i2.min_value = dArray[0] + 0.002;
                        S.push(interval2);
                        interval.i2.max_value = dArray[0] - 0.002;
                        ++split_amount;
                    }
                    S.push(interval);
                }
                catch (Exception exception) {
                    meridians.clear();
                    parallels.clear();
                    return;
                }
            }
        }
    }

    public static void createMeridians(Projection proj, TInterval lat_interval, TInterval lon_interval, double lon_step, double d_lat, double alpha, List<Meridian> meridians, List<List<Point3DCartesian>> meridians_proj) {
        double lon_start = Round.roundToMultipleFloor(lon_interval.min_value, lon_step) + lon_step;
        double lon_end = Round.roundToMultipleCeil(lon_interval.max_value, lon_step) - lon_step;
        double lon_lb = Math.max(Math.min(lon_interval.min_value + 0.001, 180.0), -180.0);
        lon_lb = Math.min(lon_lb, lon_interval.max_value);
        GraticuleAS.createMeridianFragment(proj, lon_lb, lat_interval, d_lat, alpha, meridians, meridians_proj);
        for (double lon = lon_start; lon <= lon_end; lon += lon_step) {
            GraticuleAS.createMeridianFragment(proj, lon, lat_interval, d_lat, alpha, meridians, meridians_proj);
        }
        double lon_ub = Math.min(Math.max(lon_interval.max_value - 0.001, -180.0), 180.0);
        lon_ub = Math.max(lon_ub, lon_interval.min_value);
        GraticuleAS.createMeridianFragment(proj, lon_ub, lat_interval, d_lat, alpha, meridians, meridians_proj);
        double lon = proj.getCartPole().getLon();
        if (lon > lon_interval.min_value && lon < lon_interval.max_value) {
            GraticuleAS.createMeridianFragment(proj, Math.min(Math.max(lon - 0.001, -180.0), 180.0), lat_interval, d_lat, alpha, meridians, meridians_proj);
            GraticuleAS.createMeridianFragment(proj, Math.max(Math.min(lon + 0.001, 180.0), -180.0), lat_interval, d_lat, alpha, meridians, meridians_proj);
        }
        double d = lon = lon > 0.0 ? lon - 180.0 : lon + 180.0;
        if (lon > lon_interval.min_value && lon < lon_interval.max_value) {
            GraticuleAS.createMeridianFragment(proj, Math.min(Math.max(lon - 0.001, -180.0), 180.0), lat_interval, d_lat, alpha, meridians, meridians_proj);
            GraticuleAS.createMeridianFragment(proj, Math.max(Math.min(lon + 0.001, 180.0), -180.0), lat_interval, d_lat, alpha, meridians, meridians_proj);
        }
    }

    public static void createParallels(Projection proj, TInterval lat_interval, TInterval lon_interval, double lat_step, double d_lon, double alpha, List<Parallel> parallels, List<List<Point3DCartesian>> parallels_proj) {
        double lat_start = Round.roundToMultipleFloor(lat_interval.min_value, lat_step) + lat_step;
        double lat_end = Round.roundToMultipleCeil(lat_interval.max_value, lat_step) - lat_step;
        double lat_lb = Math.max(Math.min(lat_interval.min_value + 0.001, 90.0), -90.0);
        lat_lb = Math.min(lat_lb, lat_interval.max_value);
        GraticuleAS.createParallelFragment(proj, lat_lb, lon_interval, d_lon, alpha, parallels, parallels_proj);
        for (double lat = lat_start; lat <= lat_end; lat += lat_step) {
            GraticuleAS.createParallelFragment(proj, lat, lon_interval, d_lon, alpha, parallels, parallels_proj);
        }
        double lat_ub = Math.min(Math.max(lat_interval.max_value - 0.001, -90.0), 90.0);
        lat_ub = Math.max(lat_ub, lat_interval.min_value);
        GraticuleAS.createParallelFragment(proj, lat_ub, lon_interval, d_lon, alpha, parallels, parallels_proj);
    }

    public static void createMeridianFragment(Projection proj, double lon, TInterval lat_interval, double d_lat, double alpha, List<Meridian> meridians, List<List<Point3DCartesian>> meridians_proj) {
        for (TInterval lat_interval_split : GraticuleAS.splitLatInterval(lat_interval, lon, proj.getCartPole(), proj.getLonDir(), proj.getLon0())) {
            Meridian mer = new Meridian(lon, lat_interval_split, d_lat, 0.001, 0.001);
            ArrayList<Point3DCartesian> mer_proj = new ArrayList<Point3DCartesian>();
            mer.project(proj, alpha, mer_proj);
            meridians.add(mer);
            meridians_proj.add(mer_proj);
        }
    }

    public static void createParallelFragment(Projection proj, double lat, TInterval lon_interval, double d_lon, double alpha, List<Parallel> parallels, List<List<Point3DCartesian>> parallels_proj) {
        for (TInterval lon_interval_split : GraticuleAS.splitLonInterval(lon_interval, lat, proj.getCartPole(), proj.getLonDir(), proj.getLon0())) {
            Parallel par = new Parallel(lat, lon_interval_split, d_lon, 0.001, 0.001);
            ArrayList<Point3DCartesian> par_proj = new ArrayList<Point3DCartesian>();
            par.project(proj, alpha, par_proj);
            parallels.add(par);
            parallels_proj.add(par_proj);
        }
    }

    public static List<TInterval> splitLatInterval(TInterval lat_interval, double lon, Point3DGeographic pole, TTransformedLongitudeDirection lon_dir, double lon0) {
        Point3DGeographic[] i2;
        Point3DGeographic[] i1;
        double lon6;
        double lat6;
        Point3DGeographic p6;
        double lon5;
        double lat5;
        Point3DGeographic p5;
        double lon4;
        ArrayList<TInterval> lats_split = new ArrayList<TInterval>();
        Point3DGeographic p1 = new Point3DGeographic(lat_interval.min_value, lon);
        Point3DGeographic p2 = new Point3DGeographic(0.5 * (lat_interval.min_value + lat_interval.max_value), lon);
        Point3DGeographic p3 = new Point3DGeographic(lat_interval.max_value, lon);
        double lat4 = CartTransformation.latTransToLat(-80.0, lon0, pole.getLat(), pole.getLon(), lon_dir);
        Point3DGeographic p4 = new Point3DGeographic(lat4, lon4 = CartTransformation.lonTransToLon(-80.0, lon0, pole.getLat(), pole.getLon(), lon_dir));
        boolean intersection_exists = GreatCircleIntersection.getGreatCirclePlainIntersection(p1, p2, p3, p4, p5 = new Point3DGeographic(lat5 = CartTransformation.latTransToLat(0.0, lon0, pole.getLat(), pole.getLon(), lon_dir), lon5 = CartTransformation.lonTransToLon(0.0, lon0, pole.getLat(), pole.getLon(), lon_dir)), p6 = new Point3DGeographic(lat6 = CartTransformation.latTransToLat(80.0, lon0, pole.getLat(), pole.getLon(), lon_dir), lon6 = CartTransformation.lonTransToLon(80.0, lon0, pole.getLat(), pole.getLon(), lon_dir)), i1 = new Point3DGeographic[]{new Point3DGeographic(0.0, 0.0)}, i2 = new Point3DGeographic[]{new Point3DGeographic(0.0, 0.0)}, pole, lon_dir);
        if (intersection_exists) {
            double lat_inters1 = i1[0].getLat();
            double lat_inters2 = i2[0].getLat();
            double lon_inters1 = i1[0].getLon();
            double lon_inters2 = i2[0].getLon();
            if (lat_inters1 > lat_interval.min_value && lat_inters1 < lat_interval.max_value && Math.abs(lon - lon_inters1) < 1.0E-8) {
                lats_split.add(new TInterval(lat_interval.min_value, Math.max(lat_inters1 - 0.001, lat_interval.min_value)));
                lats_split.add(new TInterval(Math.min(lat_inters1 + 0.001, lat_interval.max_value), lat_interval.max_value));
                return lats_split;
            }
            if (lat_inters2 > lat_interval.min_value && lat_inters2 < lat_interval.max_value && Math.abs(lon - lon_inters2) < 1.0E-8) {
                lats_split.add(new TInterval(lat_interval.min_value, Math.max(lat_inters2 - 0.001, lat_interval.min_value)));
                lats_split.add(new TInterval(Math.min(lat_inters2 + 0.001, lat_interval.max_value), lat_interval.max_value));
                return lats_split;
            }
        }
        lats_split.add(new TInterval(lat_interval.min_value, lat_interval.max_value));
        return lats_split;
    }

    public static List<TInterval> splitLonInterval(TInterval lon_interval, double lat, Point3DGeographic pole, TTransformedLongitudeDirection lon_dir, double lon0) {
        Point3DGeographic[] i2;
        Point3DGeographic[] i1;
        double lon6;
        double lat6;
        Point3DGeographic p6;
        double lon5;
        double lat5;
        Point3DGeographic p5;
        double lon4;
        ArrayList<TInterval> lons_split = new ArrayList<TInterval>();
        Point3DGeographic p1 = new Point3DGeographic(lat, lon_interval.min_value + 1.0);
        Point3DGeographic p2 = new Point3DGeographic(lat, 0.5 * (lon_interval.min_value + lon_interval.max_value));
        Point3DGeographic p3 = new Point3DGeographic(lat, lon_interval.max_value - 1.0);
        double lat4 = CartTransformation.latTransToLat(-80.0, lon0, pole.getLat(), pole.getLon(), lon_dir);
        Point3DGeographic p4 = new Point3DGeographic(lat4, lon4 = CartTransformation.lonTransToLon(-80.0, lon0, pole.getLat(), pole.getLon(), lon_dir));
        boolean intersection_exists = GreatCircleIntersection.getGreatCirclePlainIntersection(p1, p2, p3, p4, p5 = new Point3DGeographic(lat5 = CartTransformation.latTransToLat(0.0, lon0, pole.getLat(), pole.getLon(), lon_dir), lon5 = CartTransformation.lonTransToLon(0.0, lon0, pole.getLat(), pole.getLon(), lon_dir)), p6 = new Point3DGeographic(lat6 = CartTransformation.latTransToLat(80.0, lon0, pole.getLat(), pole.getLon(), lon_dir), lon6 = CartTransformation.lonTransToLon(80.0, lon0, pole.getLat(), pole.getLon(), lon_dir)), i1 = new Point3DGeographic[]{new Point3DGeographic(0.0, 0.0)}, i2 = new Point3DGeographic[]{new Point3DGeographic(0.0, 0.0)}, pole, lon_dir);
        if (intersection_exists) {
            double lon_inters1 = Math.min(i1[0].getLon(), i2[0].getLon());
            double lon_inters2 = Math.max(i1[0].getLon(), i2[0].getLon());
            if (lon_inters1 > lon_interval.min_value && lon_inters1 < lon_interval.max_value && lon_inters2 > lon_interval.min_value && lon_inters2 < lon_interval.max_value && Math.abs(lon_inters2 - lon_inters1) > 1.0E-8) {
                lons_split.add(new TInterval(lon_interval.min_value, Math.max(lon_inters1 - 0.001, lon_interval.min_value)));
                lons_split.add(new TInterval(lon_inters1 + 0.001, lon_inters2 - 0.001));
                lons_split.add(new TInterval(Math.min(lon_inters2 + 0.001, lon_interval.max_value), lon_interval.max_value));
                return lons_split;
            }
            if (lon_inters1 > lon_interval.min_value && lon_inters1 < lon_interval.max_value) {
                lons_split.add(new TInterval(lon_interval.min_value, Math.max(lon_inters1 - 0.001, lon_interval.min_value)));
                lons_split.add(new TInterval(Math.min(lon_inters1 + 0.001, lon_interval.max_value), lon_interval.max_value));
                return lons_split;
            }
            if (lon_inters2 > lon_interval.min_value && lon_inters2 < lon_interval.max_value) {
                lons_split.add(new TInterval(lon_interval.min_value, Math.max(lon_inters2 - 0.001, lon_interval.min_value)));
                lons_split.add(new TInterval(Math.min(lon_inters2 + 0.001, lon_interval.max_value), lon_interval.max_value));
                return lons_split;
            }
        }
        lons_split.add(new TInterval(lon_interval.min_value, lon_interval.max_value));
        return lons_split;
    }
}

