/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.imagedpireader;

import detectprojv2j.structures.tile.DPI;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageDPIReader {
    private static final double inches_per_meter = 39.37007874015748;
    private static final String std_tree = "javax_imageio_1.0";
    private static final String png_tree = "javax_imageio_png_1.0";
    private static final String jpeg_tree = "javax_imageio_jpeg_image_1.0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DPI readDPI(File file) throws IOException {
        if (file == null || !file.isFile()) {
            throw new IOException("File does not exist: " + String.valueOf(file));
        }
        try (ImageInputStream iis = ImageIO.createImageInputStream(file);){
            ImageReader reader;
            block23: {
                DPI dpi;
                IIOMetadata md;
                block22: {
                    block21: {
                        block20: {
                            if (iis == null) {
                                throw new IOException("Could not open image stream: " + file.getAbsolutePath());
                            }
                            reader = ImageDPIReader.firstReaderFor(iis);
                            if (reader == null) {
                                throw new IOException("No ImageReader found for: " + file.getAbsolutePath());
                            }
                            try {
                                reader.setInput(iis, true, false);
                                md = reader.getImageMetadata(0);
                                if (md != null) break block20;
                                DPI dPI = null;
                                reader.dispose();
                                return dPI;
                            }
                            catch (Throwable throwable) {
                                reader.dispose();
                                throw throwable;
                            }
                        }
                        dpi = ImageDPIReader.readDpiFromStandard(md);
                        if (dpi == null) break block21;
                        DPI dPI = dpi;
                        reader.dispose();
                        return dPI;
                    }
                    dpi = ImageDPIReader.readDpiFromPng(md);
                    if (dpi == null) break block22;
                    DPI dPI = dpi;
                    reader.dispose();
                    return dPI;
                }
                dpi = ImageDPIReader.readDpiFromJpeg(md);
                if (dpi == null) break block23;
                DPI dPI = dpi;
                reader.dispose();
                return dPI;
            }
            DPI dPI = null;
            reader.dispose();
            return dPI;
        }
    }

    private static DPI readDpiFromStandard(IIOMetadata md) {
        try {
            Node root = md.getAsTree(std_tree);
            Node dimension = ImageDPIReader.firstChild(root, "Dimension");
            if (dimension == null) {
                return null;
            }
            Double mmPerPixelX = ImageDPIReader.getChildAttributeAsDouble(dimension, "HorizontalPixelSize", "value");
            Double mmPerPixelY = ImageDPIReader.getChildAttributeAsDouble(dimension, "VerticalPixelSize", "value");
            if (mmPerPixelX == null || mmPerPixelX <= 0.0) {
                return null;
            }
            double x_dpi = 25.4 / mmPerPixelX;
            double y_dpi = mmPerPixelY != null && mmPerPixelY > 0.0 ? 25.4 / mmPerPixelY : x_dpi;
            return new DPI(x_dpi, y_dpi);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static DPI readDpiFromPng(IIOMetadata md) {
        try {
            Node root = md.getAsTree(png_tree);
            Node pHYs = ImageDPIReader.findChildNode(root, "pHYs");
            if (pHYs == null) {
                return null;
            }
            String unit = ImageDPIReader.getAttribute(pHYs, "unitSpecifier");
            if (!"meter".equalsIgnoreCase(unit)) {
                return null;
            }
            Double xPpm = ImageDPIReader.getAttributeAsDouble(pHYs, "pixelsPerUnitXAxis");
            Double yPpm = ImageDPIReader.getAttributeAsDouble(pHYs, "pixelsPerUnitYAxis");
            if (xPpm == null || yPpm == null || xPpm <= 0.0 || yPpm <= 0.0) {
                return null;
            }
            double x_dpi = xPpm / 39.37007874015748;
            double y_dpi = yPpm / 39.37007874015748;
            return new DPI(x_dpi, y_dpi);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static DPI readDpiFromJpeg(IIOMetadata md) {
        try {
            Node root = md.getAsTree(jpeg_tree);
            Node app0JFIF = ImageDPIReader.findChildNode(root, "app0JFIF");
            if (app0JFIF == null) {
                return null;
            }
            Integer resUnits = ImageDPIReader.getAttributeAsString(app0JFIF, "resUnits");
            Integer x_den = ImageDPIReader.getAttributeAsString(app0JFIF, "Xdensity");
            Integer y_den = ImageDPIReader.getAttributeAsString(app0JFIF, "Ydensity");
            if (resUnits == null || x_den == null || y_den == null) {
                return null;
            }
            return switch (resUnits) {
                case 1 -> new DPI((double)x_den, (double)y_den);
                case 2 -> new DPI((double)x_den.intValue() * 25.4 / 10.0, (double)y_den.intValue() * 25.4 / 10.0);
                default -> null;
            };
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static ImageReader firstReaderFor(ImageInputStream iis) {
        Iterator<ImageReader> it = ImageIO.getImageReaders(iis);
        return it.hasNext() ? it.next() : null;
    }

    private static Node firstChild(Node parent, String name) {
        if (parent == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (!name.equals(n.getNodeName())) continue;
            return n;
        }
        return null;
    }

    private static Node findChildNode(Node parent, String name) {
        if (parent == null) {
            return null;
        }
        if (name.equals(parent.getNodeName())) {
            return parent;
        }
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node found = ImageDPIReader.findChildNode(children.item(i), name);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private static String getAttribute(Node n, String key) {
        if (n == null) {
            return null;
        }
        NamedNodeMap at = n.getAttributes();
        Node a = at != null ? at.getNamedItem(key) : null;
        return a != null ? a.getNodeValue() : null;
    }

    private static Integer getAttributeAsString(Node n, String key) {
        try {
            String s = ImageDPIReader.getAttribute(n, key);
            return s == null ? null : Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Double getAttributeAsDouble(Node n, String key) {
        try {
            String s = ImageDPIReader.getAttribute(n, key);
            return s == null ? null : Double.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Double getChildAttributeAsDouble(Node parent, String childName, String attrName) {
        Node child = ImageDPIReader.firstChild(parent, childName);
        return child == null ? null : ImageDPIReader.getAttributeAsDouble(child, attrName);
    }

    public static void main(String[] args) throws IOException {
        String file_name = "e:\\Tomas\\Java\\detectprojv2j\\test\\Africa\\12 Delisle_Lotter_Africa_cleaned2.jpg";
        File file = new File(file_name);
        DPI dpi = ImageDPIReader.readDPI(file);
        BufferedImage img = ImageIO.read(file);
        String size = img != null ? img.getWidth() + "x" + img.getHeight() + " px" : "unknown size";
        System.out.println("DPI : " + String.valueOf(dpi != null ? dpi.x_dpi : "not present / unspecified"));
    }
}

