/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.mapreproject;

import detectprojv2j.algorithms.carttransformation.CartTransformation;
import detectprojv2j.comparators.MaxLatPredicate;
import detectprojv2j.comparators.SortPointsByLat;
import detectprojv2j.comparators.SortPointsByLon;
import detectprojv2j.comparators.SortPointsByX;
import detectprojv2j.comparators.SortPointsByY;
import detectprojv2j.forms.OSMMap;
import detectprojv2j.structures.point.Point3DCartesian;
import detectprojv2j.structures.point.Point3DGeographic;
import detectprojv2j.structures.projection.Projection;
import detectprojv2j.structures.tile.MercTile;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class MapReproject
implements Runnable {
    private final BufferedImage img_map;
    private final Projection iproj;
    private final Projection proj;
    private final double rotation;
    private final int tile_size;
    private final JLabel label;
    private final OSMMap map;

    public MapReproject(BufferedImage img_map_, Projection iproj_, Projection proj_, double rotation_, int tile_size_, JLabel label_, OSMMap map_) {
        this.img_map = img_map_;
        this.iproj = iproj_;
        this.proj = proj_;
        this.rotation = rotation_;
        this.tile_size = tile_size_;
        this.label = label_;
        this.map = map_;
    }

    @Override
    public void run() {
        this.warpEarlyMapToProj();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warpEarlyMapToProj() {
        int w = this.img_map.getWidth();
        int h = this.img_map.getHeight();
        ArrayList<MercTile> tiles_reproj_temp = new ArrayList<MercTile>();
        this.map.setReprojectedTiles(tiles_reproj_temp);
        String status_bar_text = "Reprojecting map: " + this.iproj.getFamily() + " " + this.iproj.getName() + " Projection";
        int rows_expected = (int)Math.ceil((double)h / (double)this.tile_size);
        int columns_expected = (int)Math.ceil((double)w / (double)this.tile_size);
        int tiles_expected = rows_expected * columns_expected;
        this.label.setText(status_bar_text);
        double[] ratio = new double[]{-1.0};
        int index = 0;
        for (int i = 0; i < w; i += this.tile_size) {
            for (int j = 0; j < h; j += this.tile_size) {
                int status;
                List<Point3DCartesian> tile_points_proj = this.rasterTileToPointTile(this.img_map, i, j, w, h);
                List<Point3DGeographic> tile_points_sphere = CartTransformation.XYToLatsLons(tile_points_proj, this.iproj, this.rotation);
                tile_points_sphere.removeIf(new MaxLatPredicate(85.0));
                if (tile_points_sphere.size() > 2) {
                    double lat_nw = Collections.max(tile_points_sphere, new SortPointsByLat()).getLat();
                    double lon_nw = Collections.min(tile_points_sphere, new SortPointsByLon()).getLon();
                    double lat_se = Collections.min(tile_points_sphere, new SortPointsByLat()).getLat();
                    double lon_se = Collections.max(tile_points_sphere, new SortPointsByLon()).getLon();
                    double[] sx = new double[]{this.proj.getDx()};
                    double[] sy = new double[]{this.proj.getDy()};
                    List<Point3DCartesian> tile_points_reproj = CartTransformation.latsLonsToXY(tile_points_sphere, this.proj, this.rotation);
                    BufferedImage img_map_proj = this.pointTileToRaster(tile_points_reproj, sx, sy, ratio);
                    if (img_map_proj != null) {
                        try {
                            SwingUtilities.invokeLater(() -> {
                                MercTile tile = new MercTile(img_map_proj, lat_nw, lon_nw, lat_se, lon_se, 0.65);
                                tiles_reproj_temp.add(tile);
                                this.map.repaint();
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if ((status = (int)(1.0 * (double)(++index) / (double)tiles_expected * 100.0)) % 2 != 0) continue;
                this.label.setText(status_bar_text + " (" + String.valueOf(status) + "%)");
                OSMMap oSMMap = this.map;
                synchronized (oSMMap) {
                    this.map.repaint();
                    continue;
                }
            }
        }
        this.label.setText("Completed...");
    }

    public List<Point3DCartesian> rasterTileToPointTile(BufferedImage img_map, int i_start, int j_start, int w, int h) {
        int blue_ne;
        int green_ne;
        int color_ne;
        int red_ne;
        int blue_sw;
        int green_sw;
        double pix_step = 1.0;
        int white_threshold = 13824000;
        ArrayList<Point3DCartesian> tile_points = new ArrayList<Point3DCartesian>();
        int k_max = Math.min(i_start + this.tile_size, w - 1);
        int l_max = Math.min(j_start + this.tile_size, h - 1);
        for (int k = i_start; k <= k_max; ++k) {
            for (int l = j_start; l <= l_max; ++l) {
                int blue;
                int green;
                int color = img_map.getRGB(k, l);
                int red = (color & 0xFF0000) >> 16;
                if (red * (green = (color & 0xFF00) >> 8) * (blue = color & 0xFF) >= 13824000) continue;
                tile_points.add(new Point3DCartesian(k, (double)(-l), (double)color));
            }
        }
        int color_sw = img_map.getRGB(i_start, l_max - 1);
        int red_sw = (color_sw & 0xFF0000) >> 16;
        if (red_sw * (green_sw = (color_sw & 0xFF00) >> 8) * (blue_sw = color_sw & 0xFF) > 13824000) {
            tile_points.add(new Point3DCartesian(i_start, (double)(-(l_max - 1)), (double)color_sw));
        }
        if ((red_ne = ((color_ne = img_map.getRGB(k_max - 1, j_start)) & 0xFF0000) >> 16) * (green_ne = (color_ne & 0xFF00) >> 8) * (blue_ne = color_ne & 0xFF) > 13824000) {
            tile_points.add(new Point3DCartesian(k_max - 1, (double)(-j_start), (double)color_ne));
        }
        return tile_points;
    }

    public BufferedImage pointTileToRaster(List<Point3DCartesian> points, double[] sx, double[] sy, double[] ratio) {
        BufferedImage img_map_proj = null;
        if (points.size() > 2) {
            double xmin = Collections.min(points, new SortPointsByX()).getX();
            double ymin = Collections.min(points, new SortPointsByY()).getY();
            double xmax = Collections.max(points, new SortPointsByX()).getX();
            double ymax = Collections.max(points, new SortPointsByY()).getY();
            sx[0] = sx[0] + -xmin;
            sy[0] = sy[0] + -ymin;
            double dx = xmax - xmin;
            double dy = ymax - ymin;
            double rx = dx / (double)this.tile_size;
            double ry = dy / (double)this.tile_size;
            ratio[0] = 1.0 * (0.5 * (rx + ry));
            double w = Math.max(dx / ratio[0], 100.0);
            double h = Math.max(dy / ratio[0], 100.0);
            img_map_proj = new BufferedImage((int)Math.round(w), (int)Math.round(h), 2);
            Graphics2D g = img_map_proj.createGraphics();
            HashMap<RenderingHints.Key, Object> hm = new HashMap<RenderingHints.Key, Object>();
            hm.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            hm.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            hm.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            RenderingHints renderHints = new RenderingHints(hm);
            g.setRenderingHints(renderHints);
            for (Point3DCartesian p : points) {
                double x_pix = (p.getX() + sx[0]) / ratio[0];
                double y_pix = h - (p.getY() + sy[0]) / ratio[0];
                x_pix = Math.min(Math.max(0.0, x_pix), w - 1.0);
                y_pix = Math.min(Math.max(0.0, y_pix), h - 1.0);
                int col = (int)p.getZ();
                int red = col >> 16 & 0xFF;
                int green = col >> 8 & 0xFF;
                int blue = col >> 0 & 0xFF;
                g.setColor(new Color(red, green, blue));
                double pixel_radius = 3.0;
                g.fillOval((int)(x_pix - 1.5), (int)(y_pix - 1.5), 4, 4);
            }
        }
        return img_map_proj;
    }
}

