/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.mosaicmapexport;

import detectprojv2j.io.IO;
import detectprojv2j.structures.tile.MercTile;
import detectprojv2j.types.TMosaicMap;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;

public class MosaicMapExport
implements Callable<TMosaicMap> {
    private final List<MercTile> tiles_reproj;
    private final double target_res;
    private final int max_size;

    @Override
    public TMosaicMap call() {
        return this.exportTiles();
    }

    public MosaicMapExport(List<MercTile> tiles_reproj_, double target_res_, int max_size_) {
        this.tiles_reproj = tiles_reproj_;
        this.target_res = target_res_;
        this.max_size = max_size_;
    }

    public TMosaicMap exportTiles() {
        int n = this.tiles_reproj.size();
        double[] L = new double[n];
        double[] R = new double[n];
        double[] B = new double[n];
        double[] T = new double[n];
        double x_min = 1.0E37;
        double y_min = 1.0E37;
        double x_max = -1.0E37;
        double y_max = -1.0E37;
        double res_min = 1.0E37;
        for (int i = 0; i < this.tiles_reproj.size(); ++i) {
            if (this.tiles_reproj.get(i) == null || this.tiles_reproj.get((int)i).image == null) continue;
            double lat_nw_b = Math.max(Math.min(this.tiles_reproj.get((int)i).lat_nw, 85.0), -85.0);
            double lat_se_b = Math.max(Math.min(this.tiles_reproj.get((int)i).lat_se, 85.0), -85.0);
            double R_E = 6378137.0;
            double x1 = 6378137.0 * this.tiles_reproj.get((int)i).lon_nw / 57.29577951308232;
            double y1 = 6378137.0 * Math.log(Math.tan(lat_nw_b / 57.29577951308232 / 2.0 + 0.7853981633974483));
            double x2 = 6378137.0 * this.tiles_reproj.get((int)i).lon_se / 57.29577951308232;
            double y2 = 6378137.0 * Math.log(Math.tan(lat_se_b / 57.29577951308232 / 2.0 + 0.7853981633974483));
            double left = Math.min(x1, x2);
            double right = Math.max(x1, x2);
            double top = Math.max(y1, y2);
            double bottom = Math.min(y1, y2);
            L[i] = left;
            R[i] = right;
            B[i] = bottom;
            T[i] = top;
            double res_x = (right - left) / (double)this.tiles_reproj.get((int)i).image.getWidth();
            double res_y = (top - bottom) / (double)this.tiles_reproj.get((int)i).image.getHeight();
            double res_xy = Math.max(res_x, res_y);
            res_min = Math.min(res_min, res_xy);
            x_min = Math.min(x_min, left);
            y_min = Math.min(y_min, bottom);
            x_max = Math.max(x_max, right);
            y_max = Math.max(y_max, top);
        }
        if (res_min == 1.0E37) {
            return null;
        }
        double res = this.target_res > 0.0 ? this.target_res : res_min;
        int w = (int)Math.ceil((x_max - x_min) / res);
        int h = (int)Math.ceil((y_max - y_min) / res);
        if (this.max_size > 0 && (w > this.max_size || h > this.max_size)) {
            double scale = Math.max((double)w / (double)this.max_size, (double)h / (double)this.max_size);
            w = (int)Math.ceil((x_max - x_min) / (res *= scale));
            h = (int)Math.ceil((y_max - y_min) / res);
        }
        if (w <= 0 || h <= 0) {
            return null;
        }
        BufferedImage img_out = new BufferedImage(w, h, 2);
        Graphics2D g = img_out.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        for (int i = 0; i < this.tiles_reproj.size(); ++i) {
            int dx1 = (int)Math.floor((L[i] - x_min) / res);
            int dx2 = (int)Math.ceil((R[i] - x_min) / res);
            int dy1 = (int)Math.floor((y_max - T[i]) / res);
            int dy2 = (int)Math.ceil((y_max - B[i]) / res);
            if (dx2 <= 0 || dy2 <= 0 || dx1 >= w || dy1 >= h) continue;
            g.drawImage(this.tiles_reproj.get((int)i).image, dx1, dy1, dx2, dy2, 0, 0, this.tiles_reproj.get((int)i).image.getWidth(), this.tiles_reproj.get((int)i).image.getHeight(), null);
        }
        g.dispose();
        return new TMosaicMap(img_out, x_min, y_max, res);
    }

    public static void writePGW(double x_min, double y_max, double res, String file_name) {
        String mask = "pgw";
        String wf = String.format(Locale.US, "%.12f%n0.0%n0.0%n%.12f%n%.12f%n%.12f%n", res, -res, x_min + res * 0.5, y_max - res * 0.5);
        IO.saveTextFile(wf, file_name + ".pgw");
    }

    public static void writePRJ(String file_name) {
        String mask = "prj";
        String prj = "PROJCS[\"WGS 84 / Pseudo-Mercator\",GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563]],PRIMEM[\"Greenwich\",0],UNIT[\"degree\",0.0174532925199433]],PROJECTION[\"Mercator_1SP\"],PARAMETER[\"central_meridian\",0],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1],AUTHORITY[\"EPSG\",\"3857\"]]";
        IO.saveTextFile(prj, file_name + ".prj");
    }
}

