/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.nonlinearleastsquares;

import detectprojv2j.algorithms.carttransformation.CartTransformation;
import detectprojv2j.structures.matrix.Matrix;
import detectprojv2j.structures.point.Point3DCartesian;
import detectprojv2j.structures.point.Point3DGeographic;
import detectprojv2j.types.ICoordFunctionProj;
import detectprojv2j.types.TTransformedLongitudeDirection;
import java.util.ArrayList;
import java.util.List;

public class FRM7 {
    private final List<Point3DCartesian> test_points;
    private final List<Point3DGeographic> reference_points;
    private final ICoordFunctionProj F;
    private final ICoordFunctionProj G;
    private final TTransformedLongitudeDirection trans_lon_dir;
    private final double[] dx;
    private final double[] dy;

    public FRM7(List test_points_, List reference_points_, ICoordFunctionProj pF_, ICoordFunctionProj pG_, TTransformedLongitudeDirection trans_lon_dir_, double[] dx_, double[] dy_) {
        this.test_points = test_points_;
        this.reference_points = reference_points_;
        this.F = pF_;
        this.G = pG_;
        this.trans_lon_dir = trans_lon_dir_;
        this.dx = dx_;
        this.dy = dy_;
    }

    public void function(Matrix X, Matrix Y, Matrix V, Matrix W) {
        int m = this.test_points.size();
        int index = 0;
        double x_mass_test = 0.0;
        double y_mass_test = 0.0;
        double x_mass_reference = 0.0;
        double y_mass_reference = 0.0;
        this.dx[0] = 0.0;
        this.dy[0] = 0.0;
        ArrayList<Point3DCartesian> reference_points_projected = new ArrayList<Point3DCartesian>();
        for (Point3DGeographic p : this.reference_points) {
            Point3DGeographic pole = new Point3DGeographic(X.items[1][0], X.items[2][0], 0.0);
            double lat_trans = CartTransformation.latToLatTrans(p.getLat(), p.getLon(), pole.getLat(), pole.getLon());
            double lon_trans = CartTransformation.lonToLonTrans(p.getLat(), p.getLon(), pole.getLat(), pole.getLon(), this.trans_lon_dir);
            double lon_transr = CartTransformation.redLon0(lon_trans, X.items[5][0]);
            double XR = this.F.f(lat_trans, lon_transr, X.items[0][0], X.items[3][0], X.items[4][0], 0.0, 0.0, 0.0, X.items[6][0]);
            double YR = this.G.f(lat_trans, lon_transr, X.items[0][0], X.items[3][0], X.items[4][0], 0.0, 0.0, 0.0, X.items[6][0]);
            Point3DCartesian p_temp = new Point3DCartesian(XR, YR, 0.0);
            reference_points_projected.add(p_temp);
            x_mass_test += this.test_points.get(index).getX();
            y_mass_test += this.test_points.get(index).getY();
            x_mass_reference += XR;
            y_mass_reference += YR;
            ++index;
        }
        x_mass_test /= (double)m;
        y_mass_test /= (double)m;
        x_mass_reference /= (double)m;
        y_mass_reference /= (double)m;
        for (int i = 0; i < m; ++i) {
            V.items[i][0] = ((Point3DCartesian)reference_points_projected.get(i)).getX() - x_mass_reference - (this.test_points.get(i).getX() - x_mass_test);
            V.items[i + m][0] = ((Point3DCartesian)reference_points_projected.get(i)).getY() - y_mass_reference - (this.test_points.get(i).getY() - y_mass_test);
        }
        this.dx[0] = x_mass_test - x_mass_reference;
        this.dy[0] = y_mass_test - y_mass_reference;
    }
}

