/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.nonlinearleastsquares;

import detectprojv2j.structures.matrix.Matrix;
import detectprojv2j.types.IJacobian;
import detectprojv2j.types.IResiduals;

public class NonLinearLeastSquares {
    public static double BFGSH(IJacobian function_j, IResiduals function_v, Matrix W, Matrix X, Matrix Y, Matrix V, Matrix A, Matrix B, int[] iterations, double alpha, double nu, double max_error, int max_iterations, double max_diff) {
        double fx;
        int m = W.rows();
        int n = X.rows();
        Matrix J = new Matrix(m, n);
        Matrix V2 = new Matrix(m, 1);
        Matrix dX = new Matrix(n, 1);
        Matrix E = new Matrix(n, n, 0.0, 1.0);
        Matrix H_new = new Matrix(n, n);
        Matrix G_new = new Matrix(n, 1);
        Matrix Y2 = Y;
        function_v.f(X, Y, V, W);
        function_j.f(X, J);
        Matrix H = J.trans().mult(W).mult(J);
        Matrix G = J.trans().mult(W).mult(V);
        H_new.copy(H);
        G_new.copy(G);
        double fx_new = fx = V.trans().mult(W).mult(V).norm();
        iterations[0] = 0;
        while (iterations[0] < max_iterations) {
            iterations[0] = iterations[0] + 1;
            dX = H.pinv().mult(G).mult(-1.0);
            double ndX = dX.norm();
            if (ndX > 1000.0) {
                dX = dX.mult(100.0 / ndX);
            }
            Matrix X2 = X.plus(dX);
            NonLinearLeastSquares.reflection(X2, A, B);
            function_v.f(X2, Y2, V2, W);
            double t_min = 1.0E-10;
            double t = 1.0;
            while (V2.sum2() > V.sum2() + V.trans().mult(J).mult(dX).sum() * t * alpha * 2.0 && t > 1.0E-10) {
                X2 = X.plus(dX.mult(t /= 2.0));
                NonLinearLeastSquares.reflection(X2, A, B);
                function_v.f(X2, Y2, V2, W);
            }
            X.copy(X.plus(dX.mult(t)));
            NonLinearLeastSquares.reflection(X, A, B);
            function_v.f(X, Y, V, W);
            function_j.f(X, J);
            G_new = J.trans().mult(W).mult(V);
            fx_new = V.trans().mult(W).mult(V).norm();
            if (G.norm() < max_error || fx < max_error || dX.norm() < 1.0E-10) break;
            double df = (fx - fx_new) / fx;
            if (df > nu) {
                H_new = J.trans().mult(W).mult(J);
            } else {
                Matrix s = dX.mult(t);
                Matrix y = G_new.minus(G);
                double ys = y.trans().mult(s).sum();
                double shs = s.trans().mult(H).mult(s).sum();
                if (ys > 0.0) {
                    Matrix dH = new Matrix(n, n);
                    if (Math.abs(ys) > 1.0E-37 && Math.abs(shs) > 1.0E-37) {
                        Matrix dH1 = y.mult(y.trans()).mult(1.0 / ys);
                        Matrix dH2 = H.mult(s).mult(H.mult(s).trans().mult(1.0 / shs));
                        dH = dH.plus(dH1.minus(dH2));
                    }
                    H_new = J.trans().mult(W).mult(J).plus(dH);
                } else {
                    H_new = J.trans().mult(W).mult(J);
                }
            }
            H = H_new;
            G = G_new;
            fx = fx_new;
        }
        function_v.f(X, Y, V, W);
        double fxmin = V.trans().mult(W).mult(V).norm();
        return fxmin;
    }

    public static void reflection(Matrix X, Matrix XMIN, Matrix XMAX) {
        int n = X.rows();
        double max_multiplier = 100.0;
        block0: for (int i = 0; i < n; ++i) {
            while (X.items[i][0] < XMIN.items[i][0] || X.items[i][0] > XMAX.items[i][0]) {
                if (XMAX.items[i][0] - XMIN.items[i][0] < 1.0E-15) {
                    X.items[i][0] = XMIN.items[i][0];
                    continue block0;
                }
                if (X.items[i][0] > XMAX.items[i][0]) {
                    X.items[i][0] = 2.0 * XMAX.items[i][0] - X.items[i][0];
                    continue;
                }
                if (!(X.items[i][0] < XMIN.items[i][0])) continue;
                X.items[i][0] = 2.0 * XMIN.items[i][0] - X.items[i][0];
            }
        }
    }
}

