/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.numdifferentiation;

import detectprojv2j.algorithms.carttransformation.CartTransformation;
import detectprojv2j.structures.matrix.Matrix;
import detectprojv2j.types.ICoordFunctionProj;
import detectprojv2j.types.TTransformedLongitudeDirection;

public class FDiffM8 {
    private final double R;
    private final double lat;
    private final double lon;
    private final ICoordFunctionProj equat;
    private final TTransformedLongitudeDirection trans_lon_dir;

    FDiffM8(double R_, double lat_, double lon_, ICoordFunctionProj equat_, TTransformedLongitudeDirection trans_lon_dir_) {
        this.R = R_;
        this.lat = lat_;
        this.lon = lon_;
        this.equat = equat_;
        this.trans_lon_dir = trans_lon_dir_;
    }

    public double function(Matrix XT) {
        double lat_trans = CartTransformation.latToLatTrans(this.lat, this.lon, XT.items[0][0], XT.items[0][1]);
        double lon_trans = CartTransformation.lonToLonTrans(this.lat, this.lon, XT.items[0][0], XT.items[0][1], this.trans_lon_dir);
        double lon_transr = CartTransformation.redLon0(lon_trans, XT.items[0][4]);
        double res = this.equat.f(lat_trans, lon_transr, this.R, XT.items[0][2], XT.items[0][3], 0.0, 0.0, 0.0, XT.items[0][5]);
        return res;
    }
}

