/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.numdifferentiation;

import detectprojv2j.algorithms.numdifferentiation.FDiffM7;
import detectprojv2j.algorithms.numdifferentiation.NumDifferentiation;
import detectprojv2j.structures.matrix.Matrix;
import detectprojv2j.structures.point.Point3DCartesian;
import detectprojv2j.structures.point.Point3DGeographic;
import detectprojv2j.types.ICoordFunctionProj;
import detectprojv2j.types.TDerivativeType;
import detectprojv2j.types.TDerivativeVariable;
import detectprojv2j.types.TTransformedLongitudeDirection;
import java.util.List;

public class FJM7 {
    private final List<Point3DCartesian> test_points;
    private final List<Point3DGeographic> reference_points;
    private final ICoordFunctionProj F;
    private final ICoordFunctionProj G;
    private final TTransformedLongitudeDirection trans_lon_dir;

    public FJM7(List<Point3DCartesian> test_points_, List<Point3DGeographic> reference_points_, ICoordFunctionProj pF, ICoordFunctionProj pG, TTransformedLongitudeDirection trans_lon_dir_) {
        this.test_points = test_points_;
        this.reference_points = reference_points_;
        this.F = pF;
        this.G = pG;
        this.trans_lon_dir = trans_lon_dir_;
    }

    public void function(Matrix X, Matrix J) {
        Matrix J_T = new Matrix(J);
        Matrix XT = X.trans();
        int i = 0;
        int m = this.test_points.size();
        for (Point3DGeographic p : this.reference_points) {
            double lat = p.getLat();
            double lon = p.getLon();
            FDiffM7 fderx = new FDiffM7(lat, lon, this.F, this.trans_lon_dir);
            FDiffM7 fdery = new FDiffM7(lat, lon, this.G, this.trans_lon_dir);
            J_T.items[i][0] = NumDifferentiation.getDerivative(fderx::function, XT, TDerivativeType.FirstDerivative, TDerivativeVariable.VariableX1, 0.001, false);
            J_T.items[i][1] = NumDifferentiation.getDerivative(fderx::function, XT, TDerivativeType.FirstDerivative, TDerivativeVariable.VariableX2, 0.001, false);
            J_T.items[i][2] = NumDifferentiation.getDerivative(fderx::function, XT, TDerivativeType.FirstDerivative, TDerivativeVariable.VariableX3, 0.001, false);
            J_T.items[i][3] = NumDifferentiation.getDerivative(fderx::function, XT, TDerivativeType.FirstDerivative, TDerivativeVariable.VariableX4, 0.001, false);
            J_T.items[i][4] = NumDifferentiation.getDerivative(fderx::function, XT, TDerivativeType.FirstDerivative, TDerivativeVariable.VariableX5, 0.001, false);
            J_T.items[i][5] = NumDifferentiation.getDerivative(fderx::function, XT, TDerivativeType.FirstDerivative, TDerivativeVariable.VariableX6, 0.001, false);
            J_T.items[i][6] = NumDifferentiation.getDerivative(fderx::function, XT, TDerivativeType.FirstDerivative, TDerivativeVariable.VariableX7, 0.001, false);
            J_T.items[i + m][0] = NumDifferentiation.getDerivative(fdery::function, XT, TDerivativeType.FirstDerivative, TDerivativeVariable.VariableX1, 0.001, false);
            J_T.items[i + m][1] = NumDifferentiation.getDerivative(fdery::function, XT, TDerivativeType.FirstDerivative, TDerivativeVariable.VariableX2, 0.001, false);
            J_T.items[i + m][2] = NumDifferentiation.getDerivative(fdery::function, XT, TDerivativeType.FirstDerivative, TDerivativeVariable.VariableX3, 0.001, false);
            J_T.items[i + m][3] = NumDifferentiation.getDerivative(fdery::function, XT, TDerivativeType.FirstDerivative, TDerivativeVariable.VariableX4, 0.001, false);
            J_T.items[i + m][4] = NumDifferentiation.getDerivative(fdery::function, XT, TDerivativeType.FirstDerivative, TDerivativeVariable.VariableX5, 0.001, false);
            J_T.items[i + m][5] = NumDifferentiation.getDerivative(fdery::function, XT, TDerivativeType.FirstDerivative, TDerivativeVariable.VariableX6, 0.001, false);
            J_T.items[i + m][6] = NumDifferentiation.getDerivative(fdery::function, XT, TDerivativeType.FirstDerivative, TDerivativeVariable.VariableX7, 0.001, false);
            ++i;
        }
        double s0x = 0.0;
        double s1x = 0.0;
        double s2x = 0.0;
        double s3x = 0.0;
        double s4x = 0.0;
        double s5x = 0.0;
        double s6x = 0.0;
        double s0y = 0.0;
        double s1y = 0.0;
        double s2y = 0.0;
        double s3y = 0.0;
        double s4y = 0.0;
        double s5y = 0.0;
        double s6y = 0.0;
        for (i = 0; i < m; ++i) {
            s0x += J_T.items[i][0];
            s1x += J_T.items[i][1];
            s2x += J_T.items[i][2];
            s3x += J_T.items[i][3];
            s4x += J_T.items[i][4];
            s5x += J_T.items[i][5];
            s6x += J_T.items[i][6];
            s0y += J_T.items[i + m][0];
            s1y += J_T.items[i + m][1];
            s2y += J_T.items[i + m][2];
            s3y += J_T.items[i + m][3];
            s4y += J_T.items[i + m][4];
            s5y += J_T.items[i + m][5];
            s6y += J_T.items[i + m][6];
        }
        for (i = 0; i < m; ++i) {
            J.items[i][0] = J_T.items[i][0] - s0x / (double)m;
            J.items[i][1] = J_T.items[i][1] - s1x / (double)m;
            J.items[i][2] = J_T.items[i][2] - s2x / (double)m;
            J.items[i][3] = J_T.items[i][3] - s3x / (double)m;
            J.items[i][4] = J_T.items[i][4] - s4x / (double)m;
            J.items[i][5] = J_T.items[i][5] - s5x / (double)m;
            J.items[i][6] = J_T.items[i][6] - s6x / (double)m;
            J.items[i + m][0] = J_T.items[i + m][0] - s0y / (double)m;
            J.items[i + m][1] = J_T.items[i + m][1] - s1y / (double)m;
            J.items[i + m][2] = J_T.items[i + m][2] - s2y / (double)m;
            J.items[i + m][3] = J_T.items[i + m][3] - s3y / (double)m;
            J.items[i + m][4] = J_T.items[i + m][4] - s4y / (double)m;
            J.items[i + m][5] = J_T.items[i + m][5] - s5y / (double)m;
            J.items[i + m][6] = J_T.items[i + m][6] - s6y / (double)m;
        }
    }
}

