/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.numdifferentiation;

import detectprojv2j.exceptions.BadDataException;
import detectprojv2j.structures.matrix.Matrix;
import detectprojv2j.types.INumDerivative;
import detectprojv2j.types.TDerivativeType;
import detectprojv2j.types.TDerivativeVariable;

public class NumDifferentiation {
    public static double getDerivative(INumDerivative function, Matrix args, TDerivativeType deriv_type, TDerivativeVariable deriv_var, double deriv_step, boolean print_exceptions) {
        double[] values = new double[7];
        double[] fvalues = new double[7];
        NumDifferentiation.computeFunctionValues(function, args, deriv_var, deriv_step, values, fvalues, print_exceptions);
        return NumDifferentiation.computeStirlingFormula(values, fvalues, deriv_type, deriv_step);
    }

    public static void computeFunctionValues(INumDerivative function, Matrix args, TDerivativeVariable deriv_var, double deriv_step, double[] values, double[] fvalues, boolean print_exceptions) {
        if (deriv_var.ordinal() > args.cols() - 1) {
            throw new BadDataException("BadDataException: not enough arguments (deriv_index > arg.size() - 1).", "Can not compute the partial derivative...");
        }
        for (int i = 0; i < 7; i = (int)((short)(i + 1))) {
            values[i] = args.items[0][deriv_var.ordinal()] + (double)(i - 2) * deriv_step;
            Matrix args_temp = new Matrix(args);
            args_temp.items[0][deriv_var.ordinal()] = values[i];
            fvalues[i] = function.f(args_temp);
        }
    }

    public static double computeStirlingFormula(double[] values, double[] fvalues, TDerivativeType deriv_type, double deriv_step) {
        double[] dif1 = new double[6];
        for (int i = 0; i < 6; i = (int)((short)(i + 1))) {
            dif1[i] = fvalues[i + 1] - fvalues[i];
        }
        double[] dif2 = new double[5];
        for (int i = 0; i < 5; i = (int)((short)(i + 1))) {
            dif2[i] = dif1[i + 1] - dif1[i];
        }
        double[] dif3 = new double[4];
        for (int i = 0; i < 4; i = (int)((short)(i + 1))) {
            dif3[i] = dif2[i + 1] - dif2[i];
        }
        double[] dif4 = new double[3];
        for (int i = 0; i < 3; i = (int)((short)(i + 1))) {
            dif4[i] = dif3[i + 1] - dif3[i];
        }
        double[] dif5 = new double[2];
        for (int i = 0; i < 2; i = (int)((short)(i + 1))) {
            dif5[i] = dif4[i + 1] - dif4[i];
        }
        if (deriv_type == TDerivativeType.FirstDerivative) {
            return ((dif1[2] + dif1[3]) / 2.0 - (dif3[1] + dif3[2]) / 12.0 + (dif5[0] + dif5[1]) / 60.0) / deriv_step;
        }
        return (dif2[2] - dif4[1] / 12.0 + (dif5[1] - dif5[0]) / 90.0) / (deriv_step * deriv_step);
    }
}

