/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.numintegration;

public class NumIntegration {
    public static double getInEllipticIntegral1(double k, double phi_radians, double eps) {
        phi_radians = (Math.asin(k * Math.sin(phi_radians)) + phi_radians) / 2.0;
        if (1.0 - k < eps) {
            return Math.log(Math.tan(phi_radians / 2.0 + 0.7853981633974483));
        }
        return 2.0 / (1.0 + k) * NumIntegration.getInEllipticIntegral1(2.0 * Math.sqrt(k) / (1.0 + k), phi_radians, eps);
    }

    public static double getInEllipticIntegral2(double k, double phi_radians, double eps) {
        double n_phi = (Math.asin(k * Math.sin(phi_radians)) + phi_radians) / 2.0;
        if (1.0 - k < eps) {
            return (1.0 + k) * Math.sin(n_phi) + (1.0 - k) * NumIntegration.getInEllipticIntegral1(2.0 * Math.sqrt(k) / (1.0 + k), n_phi, eps) - k * Math.sin(phi_radians);
        }
        double n_k = 2.0 * Math.sqrt(k) / (1.0 + k);
        return (1.0 + k) * NumIntegration.getInEllipticIntegral2(n_k, n_phi, eps) + (1.0 - k) * NumIntegration.getInEllipticIntegral1(n_k, n_phi, eps) - k * Math.sin(phi_radians);
    }
}

