/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.planeintersection;

public class PlaneIntersection {
    public static boolean get2PlanesIntersection(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4, double x5, double y5, double z5, double x6, double y6, double z6, double x0, double y0, double z0, double[] xi, double[] yi, double[] zi, double[] ux, double[] uy, double[] uz) {
        double u1x = x2 - x1;
        double u1y = y2 - y1;
        double u1z = z2 - z1;
        double v1x = x3 - x1;
        double v1y = y3 - y1;
        double v1z = z3 - z1;
        double n1x = u1y * v1z - v1y * u1z;
        double n1y = u1z * v1x - v1z * u1x;
        double n1z = u1x * v1y - v1x * u1y;
        double n1_norm = Math.sqrt(n1x * n1x + n1y * n1y + n1z * n1z);
        n1x /= n1_norm;
        n1y /= n1_norm;
        n1z /= n1_norm;
        double u2x = x5 - x4;
        double u2y = y5 - y4;
        double u2z = z5 - z4;
        double v2x = x6 - x4;
        double v2y = y6 - y4;
        double v2z = z6 - z4;
        double n2x = u2y * v2z - v2y * u2z;
        double n2y = u2z * v2x - v2z * u2x;
        double n2z = u2x * v2y - v2x * u2y;
        double n2_norm = Math.sqrt(n2x * n2x + n2y * n2y + n2z * n2z);
        n2x /= n2_norm;
        n2y /= n2_norm;
        n2z /= n2_norm;
        double k0 = n1x * n1x;
        double k1 = n1y * n1y;
        double k2 = n1z * n1z;
        double k3 = n2x * n2x;
        double k4 = n2y * n2y;
        double k5 = n2z * n2z;
        double k6 = k0 + k1;
        double k7 = k3 + k4;
        double k8 = k3 + k5;
        double k9 = k4 + k5;
        double k10 = n1x * n2x;
        double k11 = n1y * n2y;
        double k12 = n1z * n2z;
        double k13 = n1x * n2y;
        double k14 = n1x * n2z;
        double k15 = n1y * n2x;
        double k16 = n1y * n2z;
        double k17 = n1z * n2x;
        double k18 = n1z * n2y;
        double k19 = k15 * n2y;
        double k20 = k17 * n2z;
        double k21 = k15 * n1x;
        double k22 = k13 * n1y;
        double k23 = k0 + k1 + k2;
        double k24 = k3 + k4 + k5;
        double detA = 2.0 * (k0 * k9 - 2.0 * k10 * k12 + k2 * k7 - 2.0 * k11 * (k10 + k12) + k1 * k8);
        if (detA < 1.0E-15) {
            return false;
        }
        double a11 = (k18 - k16) * (k18 - k16) / detA;
        double a12 = (k14 - k17) * (k18 - k16) / detA;
        double a13 = (k13 - k15) * (k16 - k18) / detA;
        double a14 = 2.0 * (-k19 - k20 + n1x * k9) / detA;
        double a15 = 2.0 * (k15 * n1y - k22 + n1z * (k17 - k14)) / detA;
        double a22 = (k17 - k14) * (k17 - k14) / detA;
        double a23 = (k13 - k15) * (k17 - k14) / detA;
        double a24 = 2.0 * (n1y * k8 - n2y * (k10 + k12)) / detA;
        double a25 = 2.0 * (k13 * n1x - k21 + n1z * (k18 - k16)) / detA;
        double a33 = (k15 - k13) * (k15 - k13) / detA;
        double a34 = 2.0 * (n1z * k7 - (k10 + k11) * n2z) / detA;
        double a35 = 2.0 * (k6 * n2z - n1z * (k10 + k11)) / detA;
        double a44 = -4.0 * k24 / detA;
        double a45 = 4.0 * (k10 + k11 + k12) / detA;
        double a55 = -4.0 * k23 / detA;
        ux[0] = n1y * n2z - n2y * n1z;
        uy[0] = n1z * n2x - n2z * n1x;
        uz[0] = n1x * n2y - n2x * n1y;
        double b11 = 2.0 * x0;
        double b21 = 2.0 * y0;
        double b31 = 2.0 * z0;
        double b41 = x1 * n1x + y1 * n1y + z1 * n1z;
        double b51 = x4 * n2x + y4 * n2y + z4 * n2z;
        xi[0] = a11 * b11 + a12 * b21 + a13 * b31 + a14 * b41 + a15 * b51;
        yi[0] = a12 * b11 + a22 * b21 + a23 * b31 + a24 * b41 + a25 * b51;
        zi[0] = a13 * b11 + a23 * b21 + a33 * b31 + a34 * b41 + a35 * b51;
        return true;
    }
}

