/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.quartic;

import java.util.List;

public class Quartic {
    public static void solveR(double a, double b, double c, double d, double e, List<Double> roots) {
        double y;
        double A = b / a;
        double B = c / a;
        double C = d / a;
        double D = e / a;
        double q = A * B * C / 3.0 - A * A * D - 2.0 * B * B * B / 27.0 - C * C + 8.0 * B * D / 3.0;
        double q2 = 0.5 * q;
        double p = A * C - B * B / 3.0 - 4.0 * D;
        double p3 = p / 3.0;
        double delta = q2 * q2 + p3 * p3 * p3;
        if (delta >= 0.0) {
            y = Math.cbrt(-q / 2.0 + Math.sqrt(delta)) + Math.cbrt(-q / 2.0 - Math.sqrt(delta));
        } else {
            double r = Math.sqrt(-p3 * p3 * p3);
            double theta = Math.acos(-q / (2.0 * r)) / 3.0;
            y = 2.0 * Math.cbrt(r) * Math.cos(theta);
        }
        double discr1 = A * A - 8.0 * B / 3.0 + 4.0 * y;
        if (discr1 < 0.0 && discr1 > -1.0E-5) {
            discr1 = 0.0;
        }
        if (discr1 < 0.0) {
            return;
        }
        double g1 = (A + Math.sqrt(discr1)) / 2.0;
        double g2 = (A - Math.sqrt(discr1)) / 2.0;
        double yB = y + B / 3.0;
        double discr2 = yB * yB - 4.0 * D;
        if (discr2 < 0.0 && discr2 > -1.0E-5) {
            discr2 = 0.0;
        }
        if (discr2 < 0.0) {
            return;
        }
        double h1 = (y + B / 3.0 + Math.sqrt(discr2)) / 2.0;
        double h2 = (y + B / 3.0 - Math.sqrt(discr2)) / 2.0;
        double discr3 = g1 * g1 - 4.0 * h2;
        double discr4 = g2 * g2 - 4.0 * h1;
        if (discr3 < 0.0 && discr3 > -1.0E-5) {
            discr3 = 0.0;
        }
        if (discr4 < 0.0 && discr4 > -1.0E-5) {
            discr4 = 0.0;
        }
        if (discr3 >= 0.0) {
            double x1 = (-g1 + Math.sqrt(discr3)) / 2.0;
            double x2 = (-g1 - Math.sqrt(discr3)) / 2.0;
            roots.add(x1);
            roots.add(x2);
        }
        if (discr4 >= 0.0) {
            double x3 = (-g2 + Math.sqrt(discr4)) / 2.0;
            double x4 = (-g2 - Math.sqrt(discr4)) / 2.0;
            roots.add(x3);
            roots.add(x4);
        }
    }
}

