/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.simplexmethod;

import detectprojv2j.algorithms.nonlinearleastsquares.NonLinearLeastSquares;
import detectprojv2j.structures.matrix.Matrix;
import detectprojv2j.types.IResiduals;
import java.io.PrintStream;
import java.util.Random;

public class SimplexMethod {
    public static double NelderMead(IResiduals function, Matrix W, Matrix X, Matrix Y, Matrix V, Matrix XMIN, Matrix XMAX, int[] iterations, double max_error, int max_iterations, boolean add_x0, PrintStream s) {
        int n = XMIN.cols();
        int m = n + 1;
        int m1 = W.rows();
        double Rho = 1.0;
        double Xi = 2.0;
        double Gama = 0.5;
        double Sigma = 0.5;
        Matrix IX = new Matrix(m, 1);
        Matrix VV2 = new Matrix(m, 1);
        Matrix VR = new Matrix(m1, 1);
        Matrix VS = new Matrix(m1, 1);
        Matrix VE = new Matrix(m1, 1);
        Matrix VCO = new Matrix(m1, 1);
        Matrix VCI = new Matrix(m1, 1);
        Matrix YR = new Matrix(m1, 1);
        Matrix YS = new Matrix(m1, 1);
        Matrix YE = new Matrix(m1, 1);
        Matrix YCO = new Matrix(m1, 1);
        Matrix YCI = new Matrix(m1, 1);
        Matrix WR = new Matrix(m1, m1, 0.0, 1.0);
        Matrix WS = new Matrix(m1, m1, 0.0, 1.0);
        Matrix WE = new Matrix(m1, m1, 0.0, 1.0);
        Matrix WCO = new Matrix(m1, m1, 0.0, 1.0);
        Matrix WCI = new Matrix(m1, m1, 0.0, 1.0);
        Matrix YBEST = new Matrix(m1, 1);
        Matrix VBEST = new Matrix(1, 1);
        Matrix WBEST = new Matrix(m1, m1, 0.0, 1.0);
        Matrix XX = new Matrix(m, n);
        if (add_x0) {
            XX.replace(X, 0, 0);
        }
        SimplexMethod.createRandSimplex(XMIN, XMAX, XX, add_x0);
        iterations[0] = 0;
        for (int i = 0; i < m; ++i) {
            double res2;
            Matrix VVI = new Matrix(m1, 1);
            Matrix YI = new Matrix(m1, 1);
            Matrix WI = new Matrix(m1, m1, 0.0, 1.0);
            Matrix XXI = XX.row(i);
            function.f(XXI, YI, VVI, WI);
            VV2.items[i][0] = res2 = VVI.trans().mult(W).mult(VVI).norm();
        }
        VV2.sort(IX, -1);
        Matrix XS = new Matrix(m, n);
        for (int i = 0; i < m; ++i) {
            XS.row(XX.row((int)IX.items[i][0]), i);
        }
        XX.copy(XS);
        do {
            Matrix XC = XX.getMatrix(0, n - 1, 0, n - 1).sumCols().mult(1.0 / (double)n);
            Matrix XR = XC.mult(2.0).minus(XX.getMatrix(n, n, 0, n - 1).mult(1.0));
            SimplexMethod.reflection(XMIN, XMAX, n, XR);
            function.f(XR, YR, VR, WR);
            double fr = VR.trans().mult(W).mult(VR).norm();
            if (VV2.items[0][0] <= fr && fr < VV2.items[n - 1][0]) {
                XX.replace(XR, n, 0);
                VV2.items[n][0] = fr;
            } else if (fr < VV2.items[0][0]) {
                Matrix XE = XC.mult(3.0).minus(XX.getMatrix(n, n, 0, n - 1).mult(1.0).mult(2.0));
                SimplexMethod.reflection(XMIN, XMAX, n, XE);
                function.f(XE, YE, VE, WE);
                double fe = VE.trans().mult(W).mult(VE).norm();
                if (fe < fr) {
                    XX.replace(XE, n, 0);
                    VV2.items[n][0] = fe;
                } else {
                    XX.replace(XR, n, 0);
                    VV2.items[n][0] = fr;
                }
            } else if (VV2.items[n - 1][0] <= fr && fr < VV2.items[n][0]) {
                Matrix XCO = XC.mult(1.5).minus(XX.getMatrix(n, n, 0, n - 1).mult(0.5));
                SimplexMethod.reflection(XMIN, XMAX, n, XCO);
                function.f(XCO, YCO, VCO, WCO);
                double fco = VCO.trans().mult(W).mult(VCO).norm();
                if (fco < VV2.items[n][0]) {
                    XX.replace(XCO, n, 0);
                    VV2.items[n][0] = fco;
                } else {
                    SimplexMethod.shrink(function, W, XX, XMIN, XMAX, Y, VV2, 0.5);
                    iterations[0] = iterations[0] + 1;
                }
            } else {
                Matrix XCI = XC.mult(0.5).plus(XX.getMatrix(n, n, 0, n - 1).mult(0.5));
                SimplexMethod.reflection(XMIN, XMAX, n, XCI);
                function.f(XCI, YCI, VCI, WCI);
                double fci = VCI.trans().mult(W).mult(VCI).norm();
                if (fci < VV2.items[n][0]) {
                    XX.replace(XCI, n, 0);
                    VV2.items[n][0] = fci;
                } else {
                    SimplexMethod.shrink(function, W, XX, XMIN, XMAX, Y, VV2, 0.5);
                    iterations[0] = iterations[0] + 1;
                }
            }
            VV2.sort(IX, -1);
            for (int i = 0; i < m; ++i) {
                XS.row(XX.row((int)IX.items[i][0]), i);
            }
            XX.copy(XS);
            iterations[0] = iterations[0] + 1;
        } while (iterations[0] < max_iterations && Math.abs(VV2.items[0][0] - VV2.items[n][0]) > max_error);
        X.copy(XX.getMatrix(0, 0, 0, n - 1));
        function.f(X, Y, V, W);
        double fx_min = V.trans().mult(W).mult(V).norm();
        return fx_min;
    }

    public static void createRandSimplex(Matrix XMIN, Matrix XMAX, Matrix XX, boolean add_x0) {
        int dim = XMIN.cols();
        Random rn = new Random();
        for (int i = 0; i < dim + 1; ++i) {
            if ((i == 0 || !add_x0) && add_x0) continue;
            for (int j = 0; j < dim; ++j) {
                double rand_num;
                XX.items[i][j] = rand_num = XMIN.items[0][j] + (XMAX.items[0][j] - XMIN.items[0][j]) * rn.nextDouble();
            }
        }
    }

    public static void shrink(IResiduals function, Matrix W, Matrix XX, Matrix XMIN, Matrix XMAX, Matrix Y, Matrix VV2, double Sigma) {
        double fv1;
        int m = XX.rows();
        int n = XX.cols();
        int m1 = W.rows();
        Matrix V1 = new Matrix(m1, 1);
        Matrix VSH = new Matrix(m1, 1);
        Matrix Y1 = new Matrix(m1, 1);
        Matrix YSH = new Matrix(m1, 1);
        Matrix W1 = new Matrix(m1, m1, 0.0, 1.0);
        Matrix WSH = new Matrix(m1, m1, 0.0, 1.0);
        Matrix X1 = XX.getMatrix(0, 0, 0, n - 1);
        function.f(X1, Y1, V1, W1);
        VV2.items[0][0] = fv1 = V1.trans().mult(W1).mult(V1).norm();
        for (int i = 1; i < n + 1; ++i) {
            Matrix XSH = XX.getMatrix(0, 0, 0, n - 1).plus(XX.getMatrix(i, i, 0, n - 1).minus(XX.getMatrix(0, 0, 0, n - 1)).mult(Sigma));
            SimplexMethod.reflection(XMIN, XMAX, n, XSH);
            function.f(XSH, YSH, VSH, WSH);
            double fvs = VSH.trans().mult(WSH).mult(VSH).norm();
            XX.replace(XSH, i, 0);
            VV2.items[i][0] = fvs;
        }
    }

    public static void reflection(Matrix XMIN, Matrix XMAX, int dim, Matrix X) {
        Matrix XT = X.trans();
        NonLinearLeastSquares.reflection(XT, XMIN.trans(), XMAX.trans());
        X.copy(XT.trans());
    }
}

