/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.singularitydetection;

import detectprojv2j.algorithms.carttransformation.CartTransformation;
import detectprojv2j.exceptions.MathException;
import detectprojv2j.exceptions.MathLatSingularityException;
import detectprojv2j.exceptions.MathLonSingularityException;
import detectprojv2j.structures.projection.Projection;

public class SingularityDetection {
    public static boolean checkDiscontinuityLR(double fxi_2, double fxi_1, double fxi, double fxi1, double fxi2, double fmax) {
        double LR_MAX = 0.9;
        if (Double.isNaN(fxi_2) || Double.isInfinite(fxi_2) || Math.abs(fxi_2) > fmax) {
            return true;
        }
        if (Double.isNaN(fxi_1) || Double.isInfinite(fxi_1) || Math.abs(fxi_1) > fmax) {
            return true;
        }
        if (Double.isNaN(fxi) || Double.isInfinite(fxi) || Math.abs(fxi) > fmax) {
            return true;
        }
        if (Double.isNaN(fxi1) || Double.isInfinite(fxi1) || Math.abs(fxi1) > fmax) {
            return true;
        }
        if (Double.isNaN(fxi2) || Double.isInfinite(fxi2) || Math.abs(fxi2) > fmax) {
            return true;
        }
        double fr = 3.0 * fxi - 4.0 * fxi1 + fxi2;
        double fl = 3.0 * fxi - 4.0 * fxi_1 + fxi_2;
        double lr = Math.abs((fr * fr - fl * fl) / (fr * fr + fl * fl + 1.0E-4));
        return lr > 0.9;
    }

    public static void checkProjDiscontinuity(double lat, double lon, Projection proj, double alpha, double fmax, double h) {
        boolean lon_direction_subset_inf_sing;
        boolean[] id_lat = new boolean[]{false, false, false, false, false};
        boolean[] id_lon = new boolean[]{false, false, false, false, false};
        double[] lats_trans = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        double[] lons_trans = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        double[] lats = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        double[] lons = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        double[] X_lat = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        double[] Y_lat = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        double[] X_lon = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        double[] Y_lon = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        double lat_trans = CartTransformation.latToLatTrans(lat, lon, proj.getCartPole().getLat(), proj.getCartPole().getLon());
        double lon_trans = CartTransformation.lonToLonTrans(lat, lon, proj.getCartPole().getLat(), proj.getCartPole().getLon(), proj.getLonDir());
        double lon_trans_r = CartTransformation.redLon0(lon_trans, proj.getLon0());
        if (lat_trans < 90.0 && 90.0 - lat_trans < 2.0 * h) {
            lat_trans = 90.0 - 2.0 * h;
        } else if (lat_trans > -90.0 && lat_trans - -90.0 < 2.0 * h) {
            lat_trans = -90.0 + 2.0 * h;
        }
        if (lon_trans_r < 180.0 && 180.0 - lon_trans_r < 2.0 * h) {
            lon_trans_r = 180.0 - 2.0 * h;
        } else if (lon_trans_r > -180.0 && lon_trans_r - -180.0 < 2.0 * h) {
            lon_trans_r = -180.0 + 2.0 * h;
        }
        lat_trans -= 2.0 * h;
        lon_trans_r -= 2.0 * h;
        int i = 0;
        while (i < 5) {
            lats_trans[i] = lat_trans;
            lons_trans[i] = lon_trans_r;
            ++i;
            lat_trans += h;
            lon_trans_r += h;
        }
        for (i = 0; i < 5; ++i) {
            double[] latt = new double[]{0.0};
            double[] lont = new double[]{0.0};
            double[] X = new double[]{0.0};
            double[] Y = new double[]{0.0};
            try {
                CartTransformation.latLonToXY(lats_trans[i], lons_trans[2], proj.getR(), proj.getLat1(), proj.getLat2(), 90.0, 0.0, proj.getLonDir(), 0.0, proj.getDx(), proj.getDy(), proj.getC(), proj.getX(), proj.getY(), alpha, latt, lont, X, Y);
                X_lat[i] = X[0];
                Y_lat[i] = Y[0];
            }
            catch (MathException error) {
                id_lat[i] = true;
            }
            try {
                CartTransformation.latLonToXY(lats_trans[2], lons_trans[i], proj.getR(), proj.getLat1(), proj.getLat2(), 90.0, 0.0, proj.getLonDir(), 0.0, proj.getDx(), proj.getDy(), proj.getC(), proj.getX(), proj.getY(), alpha, latt, lont, X, Y);
                X_lon[i] = X[0];
                Y_lon[i] = Y[0];
            }
            catch (MathException error) {
                id_lon[i] = true;
            }
            id_lat[i] = id_lat[i] || Double.isNaN(X_lat[i]) || Double.isInfinite(X_lat[i]) || Double.isNaN(Y_lat[i]) || Double.isInfinite(Y_lat[i]);
            id_lon[i] = id_lon[i] || Double.isNaN(X_lon[i]) || Double.isInfinite(X_lon[i]) || Double.isNaN(Y_lon[i]) || Double.isInfinite(Y_lon[i]);
        }
        boolean lon_direction_inf_sing = id_lat[0] && id_lat[1] && id_lat[2] && id_lat[3] && id_lat[4];
        boolean lat_direction_inf_sing = id_lon[0] && id_lon[1] && id_lon[2] && id_lon[3] && id_lon[4];
        boolean lat_direction_subset_inf_sing = id_lat[0] || id_lat[1] || id_lat[2] || id_lat[3] || id_lat[4];
        boolean bl = lon_direction_subset_inf_sing = id_lon[0] || id_lon[1] || id_lon[2] || id_lon[3] || id_lon[4];
        if (lat_direction_subset_inf_sing && lon_direction_subset_inf_sing && !lon_direction_inf_sing && !lat_direction_inf_sing) {
            return;
        }
        boolean lat_direction_jump_sing = SingularityDetection.checkDiscontinuityLR(X_lat[0], X_lat[1], X_lat[2], X_lat[3], X_lat[4], fmax);
        lat_direction_jump_sing = lat_direction_jump_sing || SingularityDetection.checkDiscontinuityLR(Y_lat[0], Y_lat[1], Y_lat[2], Y_lat[3], Y_lat[4], fmax);
        boolean lon_direction_jump_sing = SingularityDetection.checkDiscontinuityLR(X_lon[0], X_lon[1], X_lon[2], X_lon[3], X_lon[4], fmax);
        boolean bl2 = lon_direction_jump_sing = lon_direction_jump_sing || SingularityDetection.checkDiscontinuityLR(Y_lon[0], Y_lon[1], Y_lon[2], Y_lon[3], Y_lon[4], fmax);
        if (!(lon_direction_inf_sing || lat_direction_inf_sing || lat_direction_subset_inf_sing || lon_direction_subset_inf_sing || lat_direction_jump_sing || lon_direction_jump_sing)) {
            return;
        }
        for (int i2 = 0; i2 < 5; ++i2) {
            double lat_trans_i = lat_direction_inf_sing || lat_direction_jump_sing ? lats_trans[i2] : lats_trans[2];
            double lon_trans_i = lat_direction_inf_sing || lat_direction_jump_sing ? lons_trans[2] : CartTransformation.redLon0(lons_trans[i2], -proj.getLon0());
            lats[i2] = CartTransformation.latTransToLat(lat_trans_i, lon_trans_i, proj.getCartPole().getLat(), proj.getCartPole().getLon(), proj.getLonDir());
            lons[i2] = CartTransformation.lonTransToLon(lat_trans_i, lon_trans_i, proj.getCartPole().getLat(), proj.getCartPole().getLon(), proj.getLonDir());
        }
        double dlat = 0.0;
        double dlon = 0.0;
        for (int i3 = 0; i3 < 4; ++i3) {
            dlat += Math.abs(lats[i3 + 1] - lats[i3]);
            dlon += Math.abs(lons[i3 + 1] - lons[i3]);
        }
        if (dlat < 1.0E-8 && dlon > 1.0E-8 && (lat_direction_inf_sing || lon_direction_inf_sing)) {
            throw new MathLatSingularityException("MathLatSingularitytException: error in coordinate function.", "Can not compute meridian points, lat = ", lat);
        }
        if (dlon < 1.0E-8 && dlat > 1.0E-8 && (lat_direction_inf_sing || lon_direction_inf_sing)) {
            throw new MathLonSingularityException("MathLatSingularitytException: error in coordinate function.", "Can not compute parallel points, lon = ", lon);
        }
        if (dlat < 1.0E-8 && dlon > 1.0E-8 && (lat_direction_jump_sing || lon_direction_jump_sing)) {
            throw new MathLonSingularityException("MathLatSingularitytException: error in coordinate function.", "Can not compute parallel points, lon = ", lon);
        }
        if (dlon < 1.0E-8 && dlat > 1.0E-8 && (lat_direction_jump_sing || lon_direction_jump_sing)) {
            throw new MathLatSingularityException("MathLatSingularitytException: error in coordinate function.", "Can not compute meridian points, lat = ", lat);
        }
    }
}

