/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.sphereintersection;

public class SphereIntersection {
    public static boolean getSphereAndLineIntersection(double xc, double yc, double zc, double r, double xa, double ya, double za, double ux, double uy, double uz, double[] xi1, double[] yi1, double[] zi1, double[] xi2, double[] yi2, double[] zi2) {
        double B = 2.0 * (xa * ux + ya * uy + za * uz - ux * xc - uy * yc - uz * zc);
        double A = ux * ux + uy * uy + uz * uz;
        double C = xa * xa - 2.0 * xa * xc + xc * xc + ya * ya - 2.0 * ya * yc + yc * yc + za * za - 2.0 * za * zc + zc * zc - r * r;
        double D = B * B - 4.0 * A * C;
        if (D < 0.0) {
            return false;
        }
        double t1 = (-B - Math.sqrt(D)) / (2.0 * A);
        xi1[0] = xa + t1 * ux;
        yi1[0] = ya + t1 * uy;
        zi1[0] = za + t1 * uz;
        if (Math.abs(D) < 1.0E-15) {
            xi2 = xi1;
            yi2 = yi1;
            zi2 = zi1;
            return true;
        }
        double t2 = (-B + Math.sqrt(D)) / (2.0 * A);
        xi2[0] = xa + t2 * ux;
        yi2[0] = ya + t2 * uy;
        zi2[0] = za + t2 * uz;
        if (Math.abs(t1 - 0.5) >= Math.abs(t2 - 0.5)) {
            double x_temp = xi1[0];
            double y_temp = yi1[0];
            double z_temp = zi1[0];
            xi1[0] = xi2[0];
            yi1[0] = yi2[0];
            zi1[0] = zi2[0];
            xi2[0] = x_temp;
            yi2[0] = y_temp;
            zi2[0] = z_temp;
        }
        return true;
    }
}

