/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.sphericaldistance;

import detectprojv2j.exceptions.MathInvalidArgumentException;
import detectprojv2j.structures.point.Point3DGeographic;

public class SphericalDistance {
    public static double distance(Point3DGeographic p1, Point3DGeographic p2, double R) {
        double lat1 = p1.getLat();
        double lon1 = p1.getLon();
        double lat2 = p2.getLat();
        double lon2 = p2.getLon();
        double arg = Math.sin(lat1 / 57.29577951308232) * Math.sin(lat2 / 57.29577951308232) + Math.cos(lat1 / 57.29577951308232) * Math.cos(lat2 / 57.29577951308232) * Math.cos((lon2 - lon1) / 57.29577951308232);
        if (Math.abs(arg) > 1.00000001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: ", "can not compute spherical distance, acos(arg), arg = ", arg);
        }
        if (Math.abs(arg) > 1.0) {
            arg = Math.signum(arg);
        }
        return Math.acos(arg) * R;
    }
}

