/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.algorithms.transformation;

import detectprojv2j.exceptions.BadDataException;
import detectprojv2j.exceptions.MathZeroDevisionException;
import detectprojv2j.structures.point.Point3DCartesian;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HelmertTransformation2D {
    private double x_mass_local = 0.0;
    private double y_mass_local = 0.0;
    private double x_mass_global = 0.0;
    private double y_mass_global = 0.0;
    private double c1 = 1.0;
    private double c2 = 1.0;
    private double J = 0.0;
    private double k = 0.0;

    public final double getXMassLocal() {
        return this.x_mass_local;
    }

    public final double getYMassLocal() {
        return this.y_mass_local;
    }

    public final double getXMassGlobal() {
        return this.x_mass_global;
    }

    public final double getYMassGlobal() {
        return this.y_mass_global;
    }

    public final double getC1() {
        return this.c1;
    }

    public final double getC2() {
        return this.c2;
    }

    public final double getJ() {
        return this.J;
    }

    public final double getK() {
        return this.k;
    }

    public void transformPoints(List<Point3DCartesian> global_points, List<Point3DCartesian> local_points, List<Point3DCartesian> transformed_points) {
        ArrayList<Double> weights = new ArrayList<Double>(Collections.nCopies(global_points.size(), 1.0));
        this.getTransformKey(global_points, local_points, weights);
        this.transform(global_points, local_points, transformed_points);
    }

    public void getTransformKey(List<Point3DCartesian> global_points, List<Point3DCartesian> local_points, List<Double> weights) {
        int n_global = global_points.size();
        int n_local = local_points.size();
        double sumx_local = 0.0;
        double sumy_local = 0.0;
        double sumx_global = 0.0;
        double sumy_global = 0.0;
        if (n_global < 2 || n_local < 2) {
            throw new BadDataException("BadDataException: not enough points. ", "Can not compute Helmert 2D transformation key. \n");
        }
        if (n_global > n_local) {
            throw new BadDataException("BadDataException: less local points than global points. ", "Can not compute Helmert 2D transformation key. \n");
        }
        double sum_weights = 0.0;
        for (int i = 0; i < n_global; ++i) {
            sumx_local += weights.get(i) * local_points.get(i).getX();
            sumy_local += weights.get(i) * local_points.get(i).getY();
            sumx_global += weights.get(i) * global_points.get(i).getX();
            sumy_global += weights.get(i) * global_points.get(i).getY();
            sum_weights += weights.get(i).doubleValue();
        }
        this.x_mass_local = sumx_local / sum_weights;
        this.y_mass_local = sumy_local / sum_weights;
        this.x_mass_global = sumx_global / sum_weights;
        this.y_mass_global = sumy_global / sum_weights;
        this.k = sum_weights;
        double k1 = 0.0;
        double k2 = 0.0;
        this.J = 0.0;
        for (int i = 0; i < n_global; ++i) {
            double x_red_local = local_points.get(i).getX() - this.x_mass_local;
            double y_red_local = local_points.get(i).getY() - this.y_mass_local;
            double xred_global = global_points.get(i).getX() - this.x_mass_global;
            double yred_global = global_points.get(i).getY() - this.y_mass_global;
            this.J += weights.get(i) * (x_red_local * x_red_local + y_red_local * y_red_local);
            k1 += weights.get(i) * (xred_global * x_red_local + yred_global * y_red_local);
            k2 += weights.get(i) * (yred_global * x_red_local - xred_global * y_red_local);
        }
        if (this.J == 0.0) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not compute Helmert 2D transformation key, ", " divider = 0.", this.J);
        }
        this.c1 = k1 / this.J;
        this.c2 = k2 / this.J;
    }

    public void transform(List<Point3DCartesian> global_points, List<Point3DCartesian> local_points, List<Point3DCartesian> transformed_points) {
        int n = local_points.size();
        if (transformed_points.size() != 0) {
            throw new BadDataException("BadDataException: list of tranformed points is not empty. ", "Can not compute Helmert 2D transformation.");
        }
        for (int i = 0; i < n; ++i) {
            double x_red_local = local_points.get(i).getX() - this.x_mass_local;
            double y_red_local = local_points.get(i).getY() - this.y_mass_local;
            double x_transform = this.c1 * x_red_local - this.c2 * y_red_local + this.x_mass_global;
            double y_transform = this.c2 * x_red_local + this.c1 * y_red_local + this.y_mass_global;
            transformed_points.add(new Point3DCartesian(x_transform, y_transform, 0.0));
        }
    }
}

