/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.comparators;

import detectprojv2j.algorithms.sphericaldistance.SphericalDistance;
import detectprojv2j.structures.point.Point3DGeographic;
import java.util.Comparator;

public class SortPointsByDistGeo
implements Comparator<Point3DGeographic> {
    private final Point3DGeographic p;
    private final double R;

    public SortPointsByDistGeo(Point3DGeographic p_, double R_) {
        this.p = p_;
        this.R = R_;
    }

    @Override
    public int compare(Point3DGeographic p1, Point3DGeographic p2) {
        double d2;
        double lat = this.p.getLat();
        double lon = this.p.getLon();
        double lat1 = p1.getLat();
        double lon1 = p1.getLon();
        double lat2 = p2.getLat();
        double lon2 = p2.getLon();
        double arg1 = Math.sin(lat / 57.29577951308232) * Math.sin(lat1 / 57.29577951308232) + Math.cos(lat / 57.29577951308232) * Math.cos(lat1 / 57.29577951308232) * Math.cos((lon1 - lon) / 57.29577951308232);
        double arg2 = Math.sin(lat / 57.29577951308232) * Math.sin(lat2 / 57.29577951308232) + Math.cos(lat / 57.29577951308232) * Math.cos(lat2 / 57.29577951308232) * Math.cos((lon2 - lon) / 57.29577951308232);
        double d1 = SphericalDistance.distance(this.p, p1, this.R);
        if (d1 < (d2 = SphericalDistance.distance(this.p, p2, this.R))) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        return 0;
    }
}

