/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.forms;

import detectprojv2j.comparators.sortJTableColumnByDouble;
import detectprojv2j.forms.EarlyMap;
import detectprojv2j.forms.OSMMap;
import detectprojv2j.structures.point.Point3DCartesian;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableRowSorter;

public class ControlPointsForm
extends JFrame {
    private final EarlyMap early_map;
    private final OSMMap map;
    private JPopupMenu pop_up_menu;
    private boolean[] add_test_point;
    private boolean[] add_reference_point;
    private boolean[] computation_in_progress;
    private int[] index_nearest;
    private int[] index_nearest_prev;
    private JTable controlPointsTable;
    private JScrollPane jScrollPane1;

    public ControlPointsForm(EarlyMap early_map_, OSMMap map_, boolean[] add_test_point_, boolean[] add_reference_point_, boolean[] computation_in_progress_, int[] index_nearest_, int[] index_nearest_prev_) {
        this.initComponents();
        this.early_map = early_map_;
        this.map = map_;
        this.add_test_point = add_test_point_;
        this.add_reference_point = add_reference_point_;
        this.computation_in_progress = computation_in_progress_;
        this.index_nearest = index_nearest_;
        this.index_nearest_prev = index_nearest_prev_;
        DefaultTableModel model = (DefaultTableModel)this.controlPointsTable.getModel();
        model.setRowCount(20);
        this.initializeTable();
        this.pop_up_menu = new JPopupMenu();
        JMenuItem deleteItem = new JMenuItem("Delete control point");
        deleteItem.addActionListener(new ActionListener(this){
            final /* synthetic */ ControlPointsForm this$0;
            {
                ControlPointsForm controlPointsForm = this$0;
                Objects.requireNonNull(controlPointsForm);
                this.this$0 = controlPointsForm;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!this.this$0.computation_in_progress[0] && this.this$0.index_nearest[0] >= 0) {
                    if (this.this$0.add_reference_point[0] && this.this$0.early_map.test_points.size() > this.this$0.index_nearest[0]) {
                        this.this$0.early_map.test_points.remove(this.this$0.index_nearest[0]);
                    }
                    if (this.this$0.add_test_point[0] && this.this$0.map.reference_points.size() > this.this$0.index_nearest[0]) {
                        this.this$0.map.deleteNearestPoint();
                    }
                    if (this.this$0.early_map.projected_points != null && this.this$0.early_map.projected_points.size() > this.this$0.index_nearest[0]) {
                        this.this$0.early_map.projected_points.remove(this.this$0.index_nearest[0]);
                    }
                    this.this$0.early_map.repaint();
                    this.this$0.map.repaint();
                    this.this$0.add_test_point[0] = true;
                    this.this$0.add_reference_point[0] = true;
                    this.this$0.clearTable();
                    this.this$0.printResult();
                }
            }
        });
        this.pop_up_menu.add(deleteItem);
        this.controlPointsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(this){
            final /* synthetic */ ControlPointsForm this$0;
            {
                ControlPointsForm controlPointsForm = this$0;
                Objects.requireNonNull(controlPointsForm);
                this.this$0 = controlPointsForm;
            }

            @Override
            public void valueChanged(ListSelectionEvent event) {
                int point_index;
                int sel_index = this.this$0.controlPointsTable.getSelectedRow();
                int n = point_index = sel_index > -1 ? this.this$0.controlPointsTable.convertRowIndexToModel(sel_index) : -1;
                if (point_index < Math.max(this.this$0.early_map.test_points.size(), this.this$0.map.reference_points.size()) && point_index >= 0) {
                    this.this$0.index_nearest_prev[0] = this.this$0.index_nearest[0];
                    this.this$0.index_nearest[0] = point_index;
                    this.this$0.early_map.repaint();
                    this.this$0.map.repaintMap();
                }
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.controlPointsTable = new JTable();
        this.setTitle("List of control points and residuals");
        this.setLocation(new Point(200, 500));
        this.setType(Window.Type.UTILITY);
        this.controlPointsTable.setModel(new DefaultTableModel(this, new Object[][]{{null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4", "Title 5", "Title 6", "Title 7", "Title 8"}){
            boolean[] canEdit;
            final /* synthetic */ ControlPointsForm this$0;
            {
                ControlPointsForm controlPointsForm = this$0;
                Objects.requireNonNull(controlPointsForm);
                this.this$0 = controlPointsForm;
                super(arg0, arg1);
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.controlPointsTable.setRequestFocusEnabled(false);
        this.controlPointsTable.setSelectionMode(0);
        this.controlPointsTable.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ ControlPointsForm this$0;
            {
                ControlPointsForm controlPointsForm = this$0;
                Objects.requireNonNull(controlPointsForm);
                this.this$0 = controlPointsForm;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                this.this$0.controlPointsTableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.controlPointsTable);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 862, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 368, Short.MAX_VALUE));
        this.pack();
    }

    private void controlPointsTableMouseClicked(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt) && this.index_nearest[0] != -1) {
            this.pop_up_menu.show(this.controlPointsTable, evt.getX(), evt.getY());
        }
    }

    private void initializeTable() {
        Object[] col_names = new String[]{"#", "X_test [pix]", "Y_test [pix]", "Lat_ref [deg]", "Lon_ref [deg]", "X_proj [pix]", "Y_proj [pix]", "dX [pix]", "dY [pix]"};
        DefaultTableModel model = (DefaultTableModel)this.controlPointsTable.getModel();
        model.setColumnIdentifiers(col_names);
        TableRowSorter<DefaultTableModel> trs = new TableRowSorter<DefaultTableModel>(model);
        for (int i = 0; i < col_names.length; ++i) {
            trs.setComparator(i, new sortJTableColumnByDouble());
        }
        this.controlPointsTable.setRowSorter(trs);
        JTableHeader header = this.controlPointsTable.getTableHeader();
        DefaultTableCellRenderer r_header = (DefaultTableCellRenderer)header.getDefaultRenderer();
        r_header.setHorizontalAlignment(0);
        header.setFont(header.getFont().deriveFont(12.0f));
        this.controlPointsTable.setFont(header.getFont().deriveFont(12.0f));
        DefaultTableCellRenderer r_cells = new DefaultTableCellRenderer();
        r_cells.setHorizontalAlignment(0);
        for (int i = 0; i < col_names.length; ++i) {
            this.controlPointsTable.getColumnModel().getColumn(i).setCellRenderer(r_cells);
        }
    }

    public void printResult() {
        int index;
        this.clearTable();
        DefaultTableModel model = (DefaultTableModel)this.controlPointsTable.getModel();
        int n_test = this.early_map.test_points.size();
        int n_reference = this.map.reference_points.size();
        int n_rows = Math.max(n_test, n_reference);
        if (n_rows >= 0) {
            model.setRowCount(n_rows);
        }
        for (index = 0; index < n_rows; ++index) {
            model.setValueAt(index + 1, index, 0);
        }
        for (index = 0; index < n_test; ++index) {
            String X_string = String.format(Locale.ROOT, "%10.3f", this.early_map.test_points.get(index).getX());
            String Y_string = String.format(Locale.ROOT, "%10.3f", this.early_map.test_points.get(index).getY());
            model.setValueAt(X_string, index, 1);
            model.setValueAt(Y_string, index, 2);
        }
        for (index = 0; index < n_reference; ++index) {
            String lat_string = String.format(Locale.ROOT, "%10.3f", this.map.reference_points.get(index).getLat());
            String lon_string = String.format(Locale.ROOT, "%10.3f", this.map.reference_points.get(index).getLon());
            model.setValueAt(lat_string, index, 3);
            model.setValueAt(lon_string, index, 4);
        }
        List<Point3DCartesian> reference_points_projected = this.early_map.getProjectedPoints();
        if (reference_points_projected != null) {
            int n_projected = reference_points_projected.size();
            for (int index2 = 0; index2 < n_projected; ++index2) {
                String X_proj_string = String.format(Locale.ROOT, "%10.3f", reference_points_projected.get(index2).getX());
                String Y_proj_string = String.format(Locale.ROOT, "%10.3f", reference_points_projected.get(index2).getY());
                String dX_string = String.format(Locale.ROOT, "%10.3f", this.early_map.test_points.get(index2).getX() - reference_points_projected.get(index2).getX());
                String dY_string = String.format(Locale.ROOT, "%10.3f", this.early_map.test_points.get(index2).getY() - reference_points_projected.get(index2).getY());
                model.setValueAt(X_proj_string, index2, 5);
                model.setValueAt(Y_proj_string, index2, 6);
                model.setValueAt(dX_string, index2, 7);
                model.setValueAt(dY_string, index2, 8);
            }
        }
    }

    public void clearTable() {
        DefaultTableModel model = (DefaultTableModel)this.controlPointsTable.getModel();
        int n = model.getRowCount();
        for (int index = 0; index < n; ++index) {
            model.setValueAt("", index, 0);
            model.setValueAt("", index, 1);
            model.setValueAt("", index, 2);
            model.setValueAt("", index, 3);
            model.setValueAt("", index, 4);
            model.setValueAt("", index, 5);
            model.setValueAt("", index, 6);
            model.setValueAt("", index, 7);
            model.setValueAt("", index, 8);
        }
    }
}

