/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.forms;

import detectprojv2j.comparators.SortPointsByDistCart;
import detectprojv2j.forms.ControlPointsForm;
import detectprojv2j.forms.OSMMap;
import detectprojv2j.structures.graticule.Meridian;
import detectprojv2j.structures.graticule.Parallel;
import detectprojv2j.structures.point.Point3DCartesian;
import detectprojv2j.structures.projection.Projection;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class EarlyMap
extends JPanel {
    public BufferedImage img;
    private double img_dpi;
    public OSMMap map;
    public List<Point3DCartesian> test_points;
    public List<Point3DCartesian> projected_points;
    private Projection proj;
    private List<Meridian> meridians;
    private List<Parallel> parallels;
    private List<List<Point3DCartesian>> meridians_proj;
    private List<List<Point3DCartesian>> parallels_proj;
    private AffineTransform at;
    private Point start;
    private Point end;
    private double zoom;
    private double dx;
    private double dy;
    private JPopupMenu pop_up_menu;
    private ControlPointsForm control_points_form;
    private boolean[] add_test_point;
    private boolean[] add_reference_point;
    private boolean[] enable_add_control_points;
    private boolean[] enable_panning_lm;
    private boolean[] enable_zoom_in_lm;
    private boolean[] enable_zoom_out_lm;
    private boolean[] enable_zoom_fit_all_lm;
    private boolean[] computation_in_progress;
    private int[] index_nearest;
    private int[] index_nearest_prev;

    public EarlyMap(OSMMap map_, ControlPointsForm control_points_form_, boolean[] add_test_point_, boolean[] add_reference_point_, boolean[] enable_add_control_points_, boolean[] enable_panning_lm_, boolean[] enable_zoom_in_lm_, boolean[] enable_zoom_out_lm_, boolean[] enable_zoom_fit_all_lm_, boolean[] computation_in_progress_, int[] index_nearest_, int[] index_nearest_prev_) {
        this.map = map_;
        this.img = null;
        try {
            URL url = this.getClass().getResource("/detectprojv2j/resources/world.jpg");
            if (url != null) {
                this.img = ImageIO.read(url);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.test_points = new ArrayList<Point3DCartesian>();
        this.projected_points = new ArrayList<Point3DCartesian>();
        this.proj = null;
        this.meridians = new ArrayList<Meridian>();
        this.parallels = new ArrayList<Parallel>();
        this.projected_points = new ArrayList<Point3DCartesian>();
        this.meridians_proj = new ArrayList<List<Point3DCartesian>>();
        this.parallels_proj = new ArrayList<List<Point3DCartesian>>();
        this.start = new Point(0, 0);
        this.end = new Point(0, 0);
        this.zoom = 1.0;
        this.dx = 0.0;
        this.dy = 0.0;
        this.img_dpi = 300.0;
        this.at = new AffineTransform();
        this.at.translate(0.0, 0.0);
        this.at.scale(1.0, 1.0);
        this.control_points_form = control_points_form_;
        this.add_test_point = add_test_point_;
        this.add_reference_point = add_reference_point_;
        this.enable_add_control_points = enable_add_control_points_;
        this.enable_panning_lm = enable_panning_lm_;
        this.enable_zoom_in_lm = enable_zoom_in_lm_;
        this.enable_zoom_out_lm = enable_zoom_out_lm_;
        this.enable_zoom_fit_all_lm = enable_zoom_fit_all_lm_;
        this.computation_in_progress = computation_in_progress_;
        this.index_nearest = index_nearest_;
        this.index_nearest_prev = index_nearest_prev_;
        this.setToolTipText("");
        this.pop_up_menu = new JPopupMenu();
        JMenuItem deleteItem = new JMenuItem("Delete control point");
        deleteItem.addActionListener(new ActionListener(this){
            final /* synthetic */ EarlyMap this$0;
            {
                EarlyMap earlyMap = this$0;
                Objects.requireNonNull(earlyMap);
                this.this$0 = earlyMap;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!this.this$0.computation_in_progress[0] && this.this$0.index_nearest[0] >= 0) {
                    if (this.this$0.add_reference_point[0] && this.this$0.test_points.size() > this.this$0.index_nearest[0]) {
                        this.this$0.test_points.remove(this.this$0.index_nearest[0]);
                    }
                    if (this.this$0.add_test_point[0] && this.this$0.map.reference_points.size() > this.this$0.index_nearest[0]) {
                        this.this$0.map.deleteNearestPoint();
                    }
                    if (this.this$0.projected_points != null && this.this$0.projected_points.size() > this.this$0.index_nearest[0]) {
                        this.this$0.projected_points.remove(this.this$0.index_nearest[0]);
                    }
                    this.this$0.repaint();
                    this.this$0.map.repaint();
                    this.this$0.add_test_point[0] = true;
                    this.this$0.add_reference_point[0] = true;
                    this.this$0.control_points_form.clearTable();
                    this.this$0.control_points_form.printResult();
                }
            }
        });
        this.pop_up_menu.add(deleteItem);
        this.addMouseWheelListener(new MouseAdapter(this){
            final /* synthetic */ EarlyMap this$0;
            {
                EarlyMap earlyMap = this$0;
                Objects.requireNonNull(earlyMap);
                this.this$0 = earlyMap;
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getPreciseWheelRotation() < 0.0) {
                    this.this$0.zoomIn();
                } else {
                    this.this$0.zoomOut();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ EarlyMap this$0;
            {
                EarlyMap earlyMap = this$0;
                Objects.requireNonNull(earlyMap);
                this.this$0 = earlyMap;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.this$0.start = e.getPoint();
                if (SwingUtilities.isLeftMouseButton(e) && !this.this$0.enable_panning_lm[0]) {
                    if (this.this$0.enable_zoom_in_lm[0]) {
                        this.this$0.zoomIn();
                    } else if (this.this$0.enable_zoom_out_lm[0]) {
                        this.this$0.zoomOut();
                    } else if (this.this$0.enable_zoom_fit_all_lm[0]) {
                        this.this$0.zoomFitAll();
                    } else if (this.this$0.add_test_point[0] && this.this$0.enable_add_control_points[0]) {
                        double xcur = (this.this$0.start.getX() - this.this$0.at.getTranslateX()) / this.this$0.at.getScaleX();
                        double ycur = (this.this$0.start.getY() - this.this$0.at.getTranslateY()) / this.this$0.at.getScaleY();
                        Point3DCartesian p = new Point3DCartesian(xcur, -ycur, 0.0);
                        this.this$0.test_points.add(p);
                        if (this.this$0.add_reference_point[0]) {
                            this.this$0.add_test_point[0] = false;
                        } else {
                            this.this$0.add_reference_point[0] = true;
                        }
                        this.this$0.control_points_form.clearTable();
                        this.this$0.control_points_form.printResult();
                    }
                } else if (this.this$0.index_nearest[0] == -1) {
                    this.this$0.end = this.this$0.start;
                } else {
                    this.this$0.pop_up_menu.show(this.this$0, e.getX(), e.getY());
                }
                this.this$0.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.this$0.start = e.getPoint();
                if (SwingUtilities.isMiddleMouseButton(e) || SwingUtilities.isRightMouseButton(e) || this.this$0.enable_panning_lm[0]) {
                    this.this$0.end = this.this$0.start;
                }
                this.this$0.repaint();
            }
        });
        this.addMouseMotionListener(new MouseAdapter(this){
            final /* synthetic */ EarlyMap this$0;
            {
                EarlyMap earlyMap = this$0;
                Objects.requireNonNull(earlyMap);
                this.this$0 = earlyMap;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && this.this$0.index_nearest[0] != -1 && this.this$0.index_nearest[0] < this.this$0.test_points.size()) {
                    Point pcur = e.getPoint();
                    double xcur = (pcur.getX() - this.this$0.at.getTranslateX()) / this.this$0.at.getScaleX();
                    double ycur = (pcur.getY() - this.this$0.at.getTranslateY()) / this.this$0.at.getScaleY();
                    Point3DCartesian p = this.this$0.test_points.get(this.this$0.index_nearest[0]);
                    p.setX(xcur);
                    p.setY(-ycur);
                } else if (SwingUtilities.isRightMouseButton(e) || this.this$0.enable_panning_lm[0]) {
                    this.this$0.start = this.this$0.end;
                    this.this$0.end = e.getPoint();
                    this.this$0.dx += this.this$0.end.getX() - this.this$0.start.getX();
                    this.this$0.dy += this.this$0.end.getY() - this.this$0.start.getY();
                }
                this.this$0.repaint();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (this.this$0.test_points.size() > 0) {
                    double threshold = 10.0 / this.this$0.zoom;
                    Point pcur = e.getPoint();
                    double xcur = (pcur.getX() - this.this$0.at.getTranslateX()) / this.this$0.at.getScaleX();
                    double ycur = (pcur.getY() - this.this$0.at.getTranslateY()) / this.this$0.at.getScaleY();
                    Point3DCartesian p_temp = new Point3DCartesian(xcur, -ycur, 0.0);
                    int[] index_nearest_point = new int[]{0};
                    double[] dist_nearest_point = new double[]{0.0};
                    this.this$0.getNearestPointIndex(p_temp, dist_nearest_point, index_nearest_point);
                    if (index_nearest_point[0] >= 0 && dist_nearest_point[0] < threshold) {
                        if (this.this$0.index_nearest[0] != index_nearest_point[0]) {
                            if (this.this$0.index_nearest[0] != -1) {
                                this.this$0.index_nearest_prev[0] = this.this$0.index_nearest[0];
                            }
                            this.this$0.index_nearest[0] = index_nearest_point[0];
                        }
                    } else {
                        if (this.this$0.index_nearest[0] != -1) {
                            this.this$0.index_nearest_prev[0] = this.this$0.index_nearest[0];
                        }
                        this.this$0.index_nearest[0] = -1;
                    }
                    this.this$0.repaint();
                    this.this$0.map.repaintMap();
                }
            }
        });
    }

    public void getNearestPointIndex(Point3DCartesian point, double[] dist_nearest, int[] index_nearest) {
        if (this.test_points.isEmpty()) {
            index_nearest[0] = -1;
            dist_nearest[0] = -1.0;
            return;
        }
        Point3DCartesian p_nearest = Collections.min(this.test_points, new SortPointsByDistCart(point));
        double dX = point.getX() - p_nearest.getX();
        double dY = point.getY() - p_nearest.getY();
        dist_nearest[0] = Math.sqrt(dX * dX + dY * dY);
        index_nearest[0] = this.test_points.indexOf(p_nearest);
    }

    public void zoomIn() {
        this.zoom = Math.min(this.zoom + 0.025, 10.0);
        this.repaint();
    }

    public void zoomOut() {
        this.zoom = Math.max(this.zoom - 0.025, 0.05);
        this.repaint();
    }

    public void zoomFitAll() {
        Dimension size = this.getVisibleRect().getSize();
        double width = size.getWidth();
        double height = size.getHeight();
        double qx = width / (double)this.img.getWidth();
        double qy = height / (double)this.img.getHeight();
        this.zoom = Math.min(qx, qy);
        this.dx = 0.0;
        this.dy = 0.0;
        this.repaint();
    }

    public void setMap(OSMMap map_) {
        this.map = map_;
    }

    public void setControlPointsForm(ControlPointsForm control_points_form_) {
        this.control_points_form = control_points_form_;
    }

    public String format(double value) {
        return NumberFormat.getNumberInstance().format(value);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(800, 600);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (this.img != null) {
            Dimension size = this.getVisibleRect().getSize();
            double width = size.getWidth();
            double height = size.getHeight();
            double zoomWidth = this.zoom * (double)this.img.getWidth();
            double zoomHeight = this.zoom * (double)this.img.getHeight();
            double x = (width - zoomWidth) / 2.0 + this.dx;
            double y = (height - zoomHeight) / 2.0 + this.dy;
            this.at = AffineTransform.getTranslateInstance(x, y);
            this.at.concatenate(AffineTransform.getScaleInstance(this.zoom, this.zoom));
            g2d.drawImage(this.img, this.at, this);
            if (this.test_points != null) {
                this.drawTestPoints(g2d);
            }
            if (this.projected_points != null) {
                this.drawProjectedPoints(g2d);
            }
            if (this.meridians_proj != null) {
                this.drawGraticuleElements(g2d, this.meridians_proj);
            }
            if (this.parallels_proj != null) {
                this.drawGraticuleElements(g2d, this.parallels_proj);
            }
            g2d.dispose();
        }
    }

    public void drawTestPoints(Graphics2D g2) {
        double marker_radius = 10.0 / this.zoom;
        for (Point3DCartesian p : this.test_points) {
            g2.setColor(Color.red);
            Ellipse2D.Float e = new Ellipse2D.Float((float)(p.getX() - marker_radius), (float)(-p.getY() - marker_radius), (float)(2.0 * marker_radius), (float)(2.0 * marker_radius));
            g2.fill(this.at.createTransformedShape(e));
            g2.setColor(Color.black);
            g2.draw(this.at.createTransformedShape(e));
        }
        if (this.index_nearest[0] != -1 && this.test_points.size() > this.index_nearest[0]) {
            g2.setColor(Color.CYAN);
            Ellipse2D.Float e = new Ellipse2D.Float((float)(this.test_points.get(this.index_nearest[0]).getX() - marker_radius), (float)(-this.test_points.get(this.index_nearest[0]).getY() - marker_radius), (float)(2.0 * marker_radius), (float)(2.0 * marker_radius));
            g2.fill(this.at.createTransformedShape(e));
            g2.setColor(Color.black);
            g2.draw(this.at.createTransformedShape(e));
        }
    }

    public void drawProjectedPoints(Graphics2D g2) {
        double marker_radius = 10.0 / this.zoom;
        for (int i = 0; i < this.projected_points.size(); ++i) {
            Point3DCartesian p_test = this.test_points.get(i);
            Point3DCartesian p_projected = this.projected_points.get(i);
            g2.setColor(Color.yellow);
            Ellipse2D.Float e = new Ellipse2D.Float((float)(p_projected.getX() - marker_radius), (float)(-p_projected.getY() - marker_radius), (float)(2.0 * marker_radius), (float)(2.0 * marker_radius));
            g2.fill(this.at.createTransformedShape(e));
            g2.setColor(Color.black);
            g2.draw(this.at.createTransformedShape(e));
            g2.setColor(Color.red);
            Line2D.Float l = new Line2D.Float((float)p_test.getX(), (float)(-p_test.getY()), (float)p_projected.getX(), (float)(-p_projected.getY()));
            g2.draw(this.at.createTransformedShape(l));
        }
    }

    public void drawGraticuleElements(Graphics2D g2, List<List<Point3DCartesian>> grat_elements) {
        g2.setStroke(new BasicStroke(2.0f));
        g2.setColor(Color.black);
        for (List<Point3DCartesian> el : grat_elements) {
            int n = el.size();
            float x1 = (float)el.get(0).getX();
            float y1 = (float)el.get(0).getY();
            for (int i = 1; i < n; ++i) {
                float x2 = (float)el.get(i).getX();
                float y2 = (float)el.get(i).getY();
                Line2D.Float line = new Line2D.Float();
                line.x1 = x1;
                line.y1 = -y1;
                line.x2 = x2;
                line.y2 = -y2;
                g2.draw(this.at.createTransformedShape(line));
                x1 = x2;
                y1 = y2;
            }
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        Object point_num_text = "";
        double xcur = 0.0;
        double ycur = 0.0;
        if (this.test_points.size() > this.index_nearest[0] && this.index_nearest[0] >= 0) {
            xcur = (this.test_points.get(this.index_nearest[0]).getX() - this.at.getTranslateX()) / this.at.getScaleX();
            ycur = (this.test_points.get(this.index_nearest[0]).getY() - this.at.getTranslateY()) / this.at.getScaleY();
            point_num_text = String.format(Locale.ROOT, "%3d", this.index_nearest[0] + 1) + " : ";
        } else {
            Point pcur = e.getPoint();
            xcur = (pcur.getX() - this.at.getTranslateX()) / this.at.getScaleX();
            ycur = (pcur.getY() - this.at.getTranslateY()) / this.at.getScaleY();
        }
        return (String)point_num_text + String.format(Locale.ROOT, "%2.2f", xcur) + "  " + String.format(Locale.ROOT, "%3.2f", ycur);
    }

    public Projection getProjection() {
        return this.proj;
    }

    public List<Point3DCartesian> getProjectedPoints() {
        return this.projected_points;
    }

    public List<Meridian> getMeridians() {
        return this.meridians;
    }

    public List<Parallel> getParallels() {
        return this.parallels;
    }

    public List<List<Point3DCartesian>> getProjectedMeridians() {
        return this.meridians_proj;
    }

    public List<List<Point3DCartesian>> getProjectedParalells() {
        return this.parallels_proj;
    }

    public double getDPI() {
        return this.img_dpi;
    }

    public void setProjection(Projection proj_) {
        this.proj = proj_;
    }

    public void setImage(BufferedImage img_) {
        this.img = img_;
    }

    public void setDPI(double img_dpi_) {
        this.img_dpi = img_dpi_;
    }

    public void setProjectedPoints(List<Point3DCartesian> projected_points_) {
        this.projected_points = projected_points_;
        this.repaint();
    }

    public void setMeridians(List<Meridian> meridians_) {
        this.meridians = meridians_;
    }

    public void setParallels(List<Parallel> parallels_) {
        this.parallels = parallels_;
    }

    public void setProjectedMeridians(List<List<Point3DCartesian>> meridians_proj_) {
        this.meridians_proj = meridians_proj_;
        this.repaint();
    }

    public void setProjectedParallels(List<List<Point3DCartesian>> parallels_proj_) {
        this.parallels_proj = parallels_proj_;
        this.repaint();
    }

    public void clearMeridians() {
        this.meridians.clear();
        this.repaint();
    }

    public void clearParallels() {
        this.parallels.clear();
        this.repaint();
    }

    public void clearProjectedMeridians() {
        this.meridians_proj.clear();
        this.repaint();
    }

    public void clearProjectedParallels() {
        this.parallels_proj.clear();
        this.repaint();
    }
}

