/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.forms;

import detectprojv2j.algorithms.cartanalysis.CartAnalysisMT;
import detectprojv2j.algorithms.carttransformation.CartTransformation;
import detectprojv2j.algorithms.graticule.Graticule;
import detectprojv2j.algorithms.imagedpireader.ImageDPIReader;
import detectprojv2j.comparators.SortPointsByLat;
import detectprojv2j.comparators.SortPointsByLon;
import detectprojv2j.forms.AboutBox;
import detectprojv2j.forms.ControlPointsForm;
import detectprojv2j.forms.EarlyMap;
import detectprojv2j.forms.MyMapMarker;
import detectprojv2j.forms.OSMMap;
import detectprojv2j.forms.ResultsForm;
import detectprojv2j.forms.Settings;
import detectprojv2j.io.DXFExport;
import detectprojv2j.io.IO;
import detectprojv2j.structures.graticule.Meridian;
import detectprojv2j.structures.graticule.Parallel;
import detectprojv2j.structures.point.Point3DCartesian;
import detectprojv2j.structures.point.Point3DGeographic;
import detectprojv2j.structures.projection.Projection;
import detectprojv2j.structures.projection.Projections;
import detectprojv2j.structures.tile.DPI;
import detectprojv2j.structures.tile.MercTile;
import detectprojv2j.types.IPoint3DFeatures;
import detectprojv2j.types.TAnalysisMethod;
import detectprojv2j.types.TGraticuleSampling;
import detectprojv2j.types.TInterval;
import detectprojv2j.types.TResult;
import detectprojv2j.types.TTransformedLongitudeDirection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;

public class MainApplication
extends JFrame {
    private final EarlyMap early_map;
    private final OSMMap map;
    private final List<Projection> projections;
    private final TreeMap<Double, TResult> results;
    private int index_method;
    private int index_optimization;
    private final short n_results;
    private final TTransformedLongitudeDirection[] default_lon_dir;
    private final boolean[] analyze_lon0;
    private final boolean[] add_test_point;
    private final boolean[] add_reference_point;
    private final boolean[] enable_add_control_points;
    private final boolean[] enable_panning_lm;
    private final boolean[] enable_zoom_in_lm;
    private final boolean[] enable_zoom_out_lm;
    private final boolean[] enable_zoom_fit_all_lm;
    private final boolean[] computation_in_progress;
    private final int[] index_nearest;
    private final int[] index_nearest_prev;
    private final boolean[] create_entire_graticule;
    private final double[] lat1_step;
    private final double[] lat2_step;
    private final double[] lat3_step;
    private final double[] lon1_step;
    private final double[] lon2_step;
    private final double[] lon3_step;
    private final double[] lat_incr;
    private final double[] lon_incr;
    private final TInterval lat_interval;
    private final TInterval lon_interval;
    private TAnalysisMethod method;
    private final ControlPointsForm control_points_form;
    private final ResultsForm results_form;
    private final AboutBox about_form;
    private final Settings settings_form;
    private JMenuItem aboutMenuItem;
    private JMenuItem addControPointsMenuItem;
    private JToggleButton addControlPointsToggleButton;
    private JMenu analysisMenu;
    private JToggleButton analyzeButton;
    private JMenuItem analyzeMapMenuItem;
    private JToolBar analyzeToolBar;
    private JButton clearAllButton;
    private JMenuItem clearAllMenuItem;
    private JButton clearResultsButton;
    private JMenuItem clearResultsMenuItem;
    private JToolBar controlPointsToolBar;
    private ButtonGroup detectionMethodGroup;
    private JMenu detectionMethodMenu;
    private JCheckBoxMenuItem differentialEvolutionCheckBoxMenuItem;
    private JPanel earlyMapPanel;
    private JMenuItem exitMenuItem;
    private JButton exportReferencePointsButton;
    private JMenuItem exportReferencePointsMenuItem;
    private JButton exportTestPointsButton;
    private JMenuItem exportTestPointsMenuItem;
    private ButtonGroup fileGroup;
    private JToolBar fileToolBar;
    private JMenu helpMenu;
    private JButton importMapButton;
    private JButton importReferencePointsButton;
    private JMenuItem importReferencePointsMenuItem;
    private JButton importTestPointsButton;
    private JMenuItem importTestPointsMenuItem;
    private JMenu jMenu1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator10;
    private JToolBar.Separator jSeparator11;
    private JToolBar.Separator jSeparator12;
    private JPopupMenu.Separator jSeparator13;
    private JToolBar.Separator jSeparator14;
    private JPopupMenu.Separator jSeparator15;
    private JToolBar.Separator jSeparator16;
    private JToolBar.Separator jSeparator17;
    private JToolBar.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JToolBar.Separator jSeparator6;
    private JPopupMenu.Separator jSeparator7;
    private JToolBar.Separator jSeparator8;
    private JToolBar.Separator jSeparator9;
    private JCheckBoxMenuItem m7CheckBoxMenuItem;
    private JCheckBoxMenuItem m8CheckBoxMenuItem;
    private JPanel mainMenuPanel;
    private JMenu mapMenu;
    private JMenuBar menuBar;
    private JCheckBoxMenuItem nelderMeadCheckBoxMenuItem;
    private JCheckBoxMenuItem nonLinearLeastSquaresCheckBoxMenuItem;
    private JMenuItem openMenuItem;
    private ButtonGroup optimizationTechniqueGroup;
    private JMenu optimizationTechniqueMenu;
    private JPanel osmMapPanel;
    private JMenuItem panningMenuItem;
    private JToggleButton panningToggleButton;
    private JMenu pointsMenu;
    private ButtonGroup resultsGroup;
    private JComboBox<String> selectDetectionMethodComboBox;
    private JPanel selectOptimizationPanel;
    private JComboBox<String> selectOptimizationTechniqueComboBox;
    private JButton settingsButton;
    private JMenuItem settingsMenuItem;
    private JButton showControlPointsButton;
    private JButton showResultsButton;
    private JMenuItem showResultsMenuItem;
    private JSplitPane splitPanels;
    private JLabel statusBarLabel;
    private JPanel statusBarPanel;
    private JSlider transparencySlider;
    private JMenuItem viewAllMenuItem;
    private JToggleButton viewAllToggleButton;
    private JMenu viewMenu;
    private ButtonGroup zoomGroup;
    private JMenuItem zoomInMenuItem;
    private JToggleButton zoomInToggleButton;
    private JMenuItem zoomOutMenuItem;
    private JToggleButton zoomOutToggleButton;
    private JToolBar zoomToolBar;

    public MainApplication() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initComponents();
        this.splitPanels.setResizeWeight(0.5);
        this.setExtendedState(6);
        this.projections = new ArrayList<Projection>();
        this.results = new TreeMap();
        this.default_lon_dir = new TTransformedLongitudeDirection[]{TTransformedLongitudeDirection.NormalDirection};
        this.analyze_lon0 = new boolean[]{false};
        this.add_test_point = new boolean[]{true};
        this.add_reference_point = new boolean[]{true};
        this.enable_add_control_points = new boolean[]{false};
        this.enable_panning_lm = new boolean[]{false};
        this.enable_zoom_in_lm = new boolean[]{false};
        this.enable_zoom_out_lm = new boolean[]{false};
        this.enable_zoom_fit_all_lm = new boolean[]{false};
        this.computation_in_progress = new boolean[]{false};
        this.create_entire_graticule = new boolean[]{false};
        this.lat1_step = new double[]{10.0};
        this.lat2_step = new double[]{1.0};
        this.lat3_step = new double[]{0.1};
        this.lon1_step = new double[]{10.0};
        this.lon2_step = new double[]{1.0};
        this.lon3_step = new double[]{0.1};
        this.lat_incr = new double[]{0.1 * this.lat1_step[0]};
        this.lon_incr = new double[]{0.1 * this.lon1_step[0]};
        this.index_nearest = new int[]{-1};
        this.index_nearest_prev = new int[]{-1};
        this.lat_interval = new TInterval(-90.0, 90.0);
        this.lon_interval = new TInterval(-180.0, 180.0);
        this.early_map = new EarlyMap(null, null, this.add_test_point, this.add_reference_point, this.enable_add_control_points, this.enable_panning_lm, this.enable_zoom_in_lm, this.enable_zoom_out_lm, this.enable_zoom_fit_all_lm, this.computation_in_progress, this.index_nearest, this.index_nearest_prev);
        this.map = new OSMMap(this.early_map, null, this.add_test_point, this.add_reference_point, this.enable_add_control_points, this.enable_panning_lm, this.enable_zoom_in_lm, this.enable_zoom_out_lm, this.enable_zoom_fit_all_lm, this.computation_in_progress, this.index_nearest, this.index_nearest_prev);
        this.early_map.setMap(this.map);
        this.earlyMapPanel.add(this.early_map);
        this.osmMapPanel.add(this.map);
        this.index_method = 1;
        this.index_optimization = 20;
        this.n_results = (short)20;
        this.selectDetectionMethodComboBox.setSelectedIndex(this.index_method - 1);
        this.selectOptimizationTechniqueComboBox.setSelectedIndex(this.index_optimization / 10 - 1);
        this.method = TAnalysisMethod.NMM8;
        this.control_points_form = new ControlPointsForm(this.early_map, this.map, this.add_test_point, this.add_reference_point, this.computation_in_progress, this.index_nearest, this.index_nearest_prev);
        this.results_form = new ResultsForm(this.early_map, this.map, this.results, this.computation_in_progress, this.n_results, this, this.transparencySlider, this.statusBarLabel);
        this.about_form = new AboutBox();
        this.settings_form = new Settings(this.map.reference_points, this.default_lon_dir, this.analyze_lon0, this.create_entire_graticule, this.lat1_step, this.lat2_step, this.lat3_step, this.lon1_step, this.lon2_step, this.lon3_step, this.lat_incr, this.lon_incr, this.lat_interval, this.lon_interval);
        this.early_map.setControlPointsForm(this.control_points_form);
        this.map.setControlPointsForm(this.control_points_form);
        DropTarget target_early_map = new DropTarget(this.early_map, new DragAndDrop(this));
        DropTarget target_map = new DropTarget(this.map, new DragAndDrop(this));
        ArrayList<Image> icons = new ArrayList<Image>();
        icons.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/detectprojv2j/resources/icon.png")));
        icons.add(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/detectprojv2j/resources/icon_task.png")));
        this.setIconImages(icons);
    }

    private void initComponents() {
        this.fileGroup = new ButtonGroup();
        this.zoomGroup = new ButtonGroup();
        this.resultsGroup = new ButtonGroup();
        this.detectionMethodGroup = new ButtonGroup();
        this.optimizationTechniqueGroup = new ButtonGroup();
        this.jMenu1 = new JMenu();
        this.mainMenuPanel = new JPanel();
        this.selectOptimizationPanel = new JPanel();
        this.selectDetectionMethodComboBox = new JComboBox();
        this.selectOptimizationTechniqueComboBox = new JComboBox();
        this.fileToolBar = new JToolBar();
        this.importMapButton = new JButton();
        this.zoomToolBar = new JToolBar();
        this.panningToggleButton = new JToggleButton();
        this.zoomInToggleButton = new JToggleButton();
        this.zoomOutToggleButton = new JToggleButton();
        this.viewAllToggleButton = new JToggleButton();
        this.controlPointsToolBar = new JToolBar();
        this.addControlPointsToggleButton = new JToggleButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.importTestPointsButton = new JButton();
        this.jSeparator11 = new JToolBar.Separator();
        this.importReferencePointsButton = new JButton();
        this.jSeparator8 = new JToolBar.Separator();
        this.showControlPointsButton = new JButton();
        this.jSeparator14 = new JToolBar.Separator();
        this.exportTestPointsButton = new JButton();
        this.jSeparator12 = new JToolBar.Separator();
        this.exportReferencePointsButton = new JButton();
        this.analyzeToolBar = new JToolBar();
        this.showResultsButton = new JButton();
        this.clearResultsButton = new JButton();
        this.jSeparator9 = new JToolBar.Separator();
        this.clearAllButton = new JButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.settingsButton = new JButton();
        this.jSeparator16 = new JToolBar.Separator();
        this.analyzeButton = new JToggleButton();
        this.jSeparator17 = new JToolBar.Separator();
        this.transparencySlider = new JSlider();
        this.splitPanels = new JSplitPane();
        this.earlyMapPanel = new JPanel();
        this.osmMapPanel = new JPanel();
        this.statusBarPanel = new JPanel();
        this.statusBarLabel = new JLabel();
        this.menuBar = new JMenuBar();
        this.mapMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.exitMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.panningMenuItem = new JMenuItem();
        this.zoomInMenuItem = new JMenuItem();
        this.zoomOutMenuItem = new JMenuItem();
        this.viewAllMenuItem = new JMenuItem();
        this.pointsMenu = new JMenu();
        this.addControPointsMenuItem = new JMenuItem();
        this.jSeparator7 = new JPopupMenu.Separator();
        this.importTestPointsMenuItem = new JMenuItem();
        this.importReferencePointsMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jMenuItem2 = new JMenuItem();
        this.jSeparator13 = new JPopupMenu.Separator();
        this.exportTestPointsMenuItem = new JMenuItem();
        this.exportReferencePointsMenuItem = new JMenuItem();
        this.analysisMenu = new JMenu();
        this.detectionMethodMenu = new JMenu();
        this.m7CheckBoxMenuItem = new JCheckBoxMenuItem();
        this.m8CheckBoxMenuItem = new JCheckBoxMenuItem();
        this.optimizationTechniqueMenu = new JMenu();
        this.nonLinearLeastSquaresCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.nelderMeadCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.differentialEvolutionCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.analyzeMapMenuItem = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.showResultsMenuItem = new JMenuItem();
        this.clearResultsMenuItem = new JMenuItem();
        this.jSeparator10 = new JPopupMenu.Separator();
        this.clearAllMenuItem = new JMenuItem();
        this.jSeparator15 = new JPopupMenu.Separator();
        this.settingsMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.jMenu1.setText("jMenu1");
        this.setDefaultCloseOperation(0);
        this.setTitle("Map projection analysis and reprojection: detectproj");
        this.setSize(new Dimension(20, 24));
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                this.this$0.formWindowClosing(evt);
            }

            @Override
            public void windowOpened(WindowEvent evt) {
                this.this$0.formWindowOpened(evt);
            }
        });
        this.mainMenuPanel.setLayout(new FlowLayout(0));
        this.selectOptimizationPanel.setLayout(new FlowLayout(1, 10, 5));
        this.selectDetectionMethodComboBox.setFont(new Font("Tahoma", 0, 11));
        this.selectDetectionMethodComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Method M7 (Unrotated Map)", "Method M8 (Rotated Map)"}));
        this.selectDetectionMethodComboBox.setToolTipText("Select detection method");
        this.selectDetectionMethodComboBox.addItemListener(new ItemListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                this.this$0.selectDetectionMethodComboBoxItemStateChanged(evt);
            }
        });
        this.selectOptimizationPanel.add(this.selectDetectionMethodComboBox);
        this.selectOptimizationTechniqueComboBox.setFont(new Font("Tahoma", 0, 11));
        this.selectOptimizationTechniqueComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Non-linear least squares", "Nelder-Mead", "Differential evolution"}));
        this.selectOptimizationTechniqueComboBox.setToolTipText("Select optimization technique");
        this.selectOptimizationTechniqueComboBox.addItemListener(new ItemListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                this.this$0.selectOptimizationTechniqueComboBoxItemStateChanged(evt);
            }
        });
        this.selectOptimizationPanel.add(this.selectOptimizationTechniqueComboBox);
        this.mainMenuPanel.add(this.selectOptimizationPanel);
        this.fileToolBar.setRollover(true);
        this.fileToolBar.setToolTipText("");
        this.fileToolBar.setMaximumSize(new Dimension(60, 35));
        this.fileToolBar.setMinimumSize(new Dimension(60, 35));
        this.fileToolBar.setPreferredSize(new Dimension(40, 35));
        this.fileToolBar.setRequestFocusEnabled(false);
        this.importMapButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/file_open2.png")));
        this.importMapButton.setToolTipText("Import early map from image.");
        this.importMapButton.setBorderPainted(false);
        this.importMapButton.setFocusable(false);
        this.importMapButton.setHorizontalTextPosition(0);
        this.importMapButton.setMaximumSize(new Dimension(24, 24));
        this.importMapButton.setMinimumSize(new Dimension(24, 24));
        this.importMapButton.setPreferredSize(new Dimension(24, 24));
        this.importMapButton.setVerticalTextPosition(3);
        this.importMapButton.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.importMapButtonActionPerformed(evt);
            }
        });
        this.fileToolBar.add(this.importMapButton);
        this.mainMenuPanel.add(this.fileToolBar);
        this.zoomToolBar.setRollover(true);
        this.zoomToolBar.setMaximumSize(new Dimension(90, 30));
        this.zoomToolBar.setMinimumSize(new Dimension(90, 30));
        this.zoomToolBar.setPreferredSize(new Dimension(110, 30));
        this.zoomGroup.add(this.panningToggleButton);
        this.panningToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/panning.png")));
        this.panningToggleButton.setToolTipText("Panning.");
        this.panningToggleButton.setFocusable(false);
        this.panningToggleButton.setHorizontalTextPosition(0);
        this.panningToggleButton.setMaximumSize(new Dimension(24, 24));
        this.panningToggleButton.setMinimumSize(new Dimension(24, 24));
        this.panningToggleButton.setPreferredSize(new Dimension(24, 24));
        this.panningToggleButton.setVerticalTextPosition(3);
        this.panningToggleButton.addChangeListener(new ChangeListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.panningToggleButtonStateChanged(evt);
            }
        });
        this.zoomToolBar.add(this.panningToggleButton);
        this.zoomGroup.add(this.zoomInToggleButton);
        this.zoomInToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/zoom_in.png")));
        this.zoomInToggleButton.setToolTipText("Zoom in.");
        this.zoomInToggleButton.setDoubleBuffered(true);
        this.zoomInToggleButton.setFocusable(false);
        this.zoomInToggleButton.setHorizontalTextPosition(0);
        this.zoomInToggleButton.setMaximumSize(new Dimension(24, 24));
        this.zoomInToggleButton.setMinimumSize(new Dimension(24, 24));
        this.zoomInToggleButton.setPreferredSize(new Dimension(24, 24));
        this.zoomInToggleButton.setVerticalTextPosition(3);
        this.zoomInToggleButton.addChangeListener(new ChangeListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.zoomInToggleButtonStateChanged(evt);
            }
        });
        this.zoomToolBar.add(this.zoomInToggleButton);
        this.zoomGroup.add(this.zoomOutToggleButton);
        this.zoomOutToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/zoom_out.png")));
        this.zoomOutToggleButton.setToolTipText("Zoom out.");
        this.zoomOutToggleButton.setFocusable(false);
        this.zoomOutToggleButton.setHorizontalTextPosition(0);
        this.zoomOutToggleButton.setMaximumSize(new Dimension(24, 24));
        this.zoomOutToggleButton.setMinimumSize(new Dimension(24, 24));
        this.zoomOutToggleButton.setPreferredSize(new Dimension(24, 24));
        this.zoomOutToggleButton.setVerticalTextPosition(3);
        this.zoomOutToggleButton.addChangeListener(new ChangeListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.zoomOutToggleButtonStateChanged(evt);
            }
        });
        this.zoomToolBar.add(this.zoomOutToggleButton);
        this.zoomGroup.add(this.viewAllToggleButton);
        this.viewAllToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/view-all.png")));
        this.viewAllToggleButton.setToolTipText("View all.");
        this.viewAllToggleButton.setFocusable(false);
        this.viewAllToggleButton.setHorizontalTextPosition(0);
        this.viewAllToggleButton.setMaximumSize(new Dimension(24, 24));
        this.viewAllToggleButton.setMinimumSize(new Dimension(24, 24));
        this.viewAllToggleButton.setPreferredSize(new Dimension(24, 24));
        this.viewAllToggleButton.setVerticalTextPosition(3);
        this.viewAllToggleButton.addChangeListener(new ChangeListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.viewAllToggleButtonStateChanged(evt);
            }
        });
        this.zoomToolBar.add(this.viewAllToggleButton);
        this.mainMenuPanel.add(this.zoomToolBar);
        this.controlPointsToolBar.setRollover(true);
        this.controlPointsToolBar.setMaximumSize(new Dimension(190, 30));
        this.controlPointsToolBar.setMinimumSize(new Dimension(190, 30));
        this.controlPointsToolBar.setPreferredSize(new Dimension(200, 30));
        this.addControlPointsToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/control_point.png")));
        this.addControlPointsToggleButton.setToolTipText("Enable/disable adding of control points");
        this.addControlPointsToggleButton.setFocusable(false);
        this.addControlPointsToggleButton.setHorizontalTextPosition(0);
        this.addControlPointsToggleButton.setMaximumSize(new Dimension(24, 24));
        this.addControlPointsToggleButton.setMinimumSize(new Dimension(24, 24));
        this.addControlPointsToggleButton.setPreferredSize(new Dimension(24, 24));
        this.addControlPointsToggleButton.setVerticalTextPosition(3);
        this.addControlPointsToggleButton.addChangeListener(new ChangeListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.addControlPointsToggleButtonStateChanged(evt);
            }
        });
        this.addControlPointsToggleButton.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.addControlPointsToggleButtonActionPerformed(evt);
            }
        });
        this.controlPointsToolBar.add(this.addControlPointsToggleButton);
        this.jSeparator2.setInheritsPopupMenu(true);
        this.jSeparator2.setMaximumSize(new Dimension(8, Short.MAX_VALUE));
        this.jSeparator2.setMinimumSize(new Dimension(8, 0));
        this.jSeparator2.setPreferredSize(new Dimension(8, 0));
        this.controlPointsToolBar.add(this.jSeparator2);
        this.importTestPointsButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/open_test.png")));
        this.importTestPointsButton.setToolTipText("Import control points to the analyzed map.");
        this.importTestPointsButton.setFocusable(false);
        this.importTestPointsButton.setHorizontalTextPosition(0);
        this.importTestPointsButton.setMaximumSize(new Dimension(24, 24));
        this.importTestPointsButton.setMinimumSize(new Dimension(26, 26));
        this.importTestPointsButton.setPreferredSize(new Dimension(26, 26));
        this.importTestPointsButton.setVerticalTextPosition(3);
        this.importTestPointsButton.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.importTestPointsButtonActionPerformed(evt);
            }
        });
        this.controlPointsToolBar.add(this.importTestPointsButton);
        this.jSeparator11.setMaximumSize(new Dimension(5, 0));
        this.jSeparator11.setMinimumSize(new Dimension(5, 0));
        this.jSeparator11.setName("");
        this.jSeparator11.setPreferredSize(new Dimension(5, 0));
        this.controlPointsToolBar.add(this.jSeparator11);
        this.importReferencePointsButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/open_reference.png")));
        this.importReferencePointsButton.setToolTipText("Import control points to the reference map.");
        this.importReferencePointsButton.setFocusable(false);
        this.importReferencePointsButton.setHorizontalTextPosition(0);
        this.importReferencePointsButton.setMaximumSize(new Dimension(24, 24));
        this.importReferencePointsButton.setMinimumSize(new Dimension(24, 24));
        this.importReferencePointsButton.setPreferredSize(new Dimension(26, 26));
        this.importReferencePointsButton.setVerticalTextPosition(3);
        this.importReferencePointsButton.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.importReferencePointsButtonActionPerformed(evt);
            }
        });
        this.controlPointsToolBar.add(this.importReferencePointsButton);
        this.jSeparator8.setMaximumSize(new Dimension(8, Short.MAX_VALUE));
        this.jSeparator8.setMinimumSize(new Dimension(8, 0));
        this.jSeparator8.setPreferredSize(new Dimension(8, 0));
        this.controlPointsToolBar.add(this.jSeparator8);
        this.showControlPointsButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/show_control_points.png")));
        this.showControlPointsButton.setToolTipText("Show list of control points on analyzed/reference maps.");
        this.showControlPointsButton.setFocusable(false);
        this.showControlPointsButton.setHorizontalTextPosition(0);
        this.showControlPointsButton.setMaximumSize(new Dimension(26, 26));
        this.showControlPointsButton.setMinimumSize(new Dimension(26, 26));
        this.showControlPointsButton.setPreferredSize(new Dimension(26, 26));
        this.showControlPointsButton.setVerticalTextPosition(3);
        this.showControlPointsButton.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.showControlPointsButtonActionPerformed(evt);
            }
        });
        this.controlPointsToolBar.add(this.showControlPointsButton);
        this.jSeparator14.setMinimumSize(new Dimension(8, 0));
        this.jSeparator14.setPreferredSize(new Dimension(8, 0));
        this.controlPointsToolBar.add(this.jSeparator14);
        this.exportTestPointsButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/save_test.png")));
        this.exportTestPointsButton.setToolTipText("Export control points from the analyzed map.");
        this.exportTestPointsButton.setFocusable(false);
        this.exportTestPointsButton.setHorizontalTextPosition(0);
        this.exportTestPointsButton.setMaximumSize(new Dimension(24, 24));
        this.exportTestPointsButton.setMinimumSize(new Dimension(24, 24));
        this.exportTestPointsButton.setPreferredSize(new Dimension(26, 26));
        this.exportTestPointsButton.setVerticalTextPosition(3);
        this.exportTestPointsButton.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.exportTestPointsButtonActionPerformed(evt);
            }
        });
        this.controlPointsToolBar.add(this.exportTestPointsButton);
        this.jSeparator12.setMaximumSize(new Dimension(5, 0));
        this.jSeparator12.setMinimumSize(new Dimension(5, 0));
        this.jSeparator12.setPreferredSize(new Dimension(5, 0));
        this.controlPointsToolBar.add(this.jSeparator12);
        this.exportReferencePointsButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/save_reference.png")));
        this.exportReferencePointsButton.setToolTipText("Export control points from the reference map.");
        this.exportReferencePointsButton.setFocusable(false);
        this.exportReferencePointsButton.setHorizontalTextPosition(0);
        this.exportReferencePointsButton.setMaximumSize(new Dimension(24, 24));
        this.exportReferencePointsButton.setMinimumSize(new Dimension(24, 24));
        this.exportReferencePointsButton.setPreferredSize(new Dimension(26, 26));
        this.exportReferencePointsButton.setVerticalTextPosition(3);
        this.exportReferencePointsButton.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.exportReferencePointsButtonActionPerformed(evt);
            }
        });
        this.controlPointsToolBar.add(this.exportReferencePointsButton);
        this.mainMenuPanel.add(this.controlPointsToolBar);
        this.analyzeToolBar.setRollover(true);
        this.showResultsButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/table.png")));
        this.showResultsButton.setToolTipText("Show results: list of the detected projections. + reproject");
        this.showResultsButton.setFocusable(false);
        this.showResultsButton.setHorizontalTextPosition(0);
        this.showResultsButton.setVerticalTextPosition(3);
        this.showResultsButton.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.showResultsButtonActionPerformed(evt);
            }
        });
        this.analyzeToolBar.add(this.showResultsButton);
        this.clearResultsButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/table_clear.png")));
        this.clearResultsButton.setToolTipText("Clear results: list of detected projections.");
        this.clearResultsButton.setFocusable(false);
        this.clearResultsButton.setHorizontalTextPosition(0);
        this.clearResultsButton.setVerticalTextPosition(3);
        this.clearResultsButton.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.clearResultsButtonActionPerformed(evt);
            }
        });
        this.analyzeToolBar.add(this.clearResultsButton);
        this.jSeparator9.setSeparatorSize(new Dimension(20, 24));
        this.analyzeToolBar.add(this.jSeparator9);
        this.clearAllButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/clear_all.png")));
        this.clearAllButton.setToolTipText("Clear all points, results and reconstructed graticules.");
        this.clearAllButton.setFocusable(false);
        this.clearAllButton.setHorizontalTextPosition(0);
        this.clearAllButton.setVerticalTextPosition(3);
        this.clearAllButton.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.clearAllButtonActionPerformed(evt);
            }
        });
        this.analyzeToolBar.add(this.clearAllButton);
        this.jSeparator6.setSeparatorSize(new Dimension(20, 24));
        this.analyzeToolBar.add(this.jSeparator6);
        this.settingsButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/settings.png")));
        this.settingsButton.setToolTipText("Setting parameters of detectproj.");
        this.settingsButton.setFocusable(false);
        this.settingsButton.setHorizontalTextPosition(0);
        this.settingsButton.setMaximumSize(new Dimension(24, 24));
        this.settingsButton.setMinimumSize(new Dimension(24, 24));
        this.settingsButton.setPreferredSize(new Dimension(24, 24));
        this.settingsButton.setVerticalTextPosition(3);
        this.settingsButton.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.settingsButtonActionPerformed(evt);
            }
        });
        this.analyzeToolBar.add(this.settingsButton);
        this.jSeparator16.setMaximumSize(new Dimension(20, 24));
        this.jSeparator16.setMinimumSize(new Dimension(20, 24));
        this.jSeparator16.setPreferredSize(new Dimension(20, 24));
        this.jSeparator16.setRequestFocusEnabled(false);
        this.analyzeToolBar.add(this.jSeparator16);
        this.analyzeButton.setFont(new Font("Tahoma", 1, 11));
        this.analyzeButton.setText("Analyze map");
        this.analyzeButton.setToolTipText("Start analysis.");
        this.analyzeButton.setBorder(BorderFactory.createEtchedBorder());
        this.analyzeButton.setFocusable(false);
        this.analyzeButton.setHorizontalTextPosition(0);
        this.analyzeButton.setMaximumSize(new Dimension(140, 29));
        this.analyzeButton.setMinimumSize(new Dimension(140, 29));
        this.analyzeButton.setPreferredSize(new Dimension(140, 29));
        this.analyzeButton.setVerticalTextPosition(3);
        this.analyzeButton.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.analyzeButtonActionPerformed(evt);
            }
        });
        this.analyzeToolBar.add(this.analyzeButton);
        this.jSeparator17.setMaximumSize(new Dimension(20, 24));
        this.jSeparator17.setMinimumSize(new Dimension(20, 24));
        this.jSeparator17.setPreferredSize(new Dimension(20, 24));
        this.analyzeToolBar.add(this.jSeparator17);
        this.mainMenuPanel.add(this.analyzeToolBar);
        this.transparencySlider.setMajorTickSpacing(25);
        this.transparencySlider.setMinorTickSpacing(5);
        this.transparencySlider.setPaintTicks(true);
        this.transparencySlider.setToolTipText("Set georeferenced map transparency.");
        this.transparencySlider.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.transparencySlider.setMinimumSize(new Dimension(36, 25));
        this.transparencySlider.setPreferredSize(new Dimension(200, 25));
        this.transparencySlider.addChangeListener(new ChangeListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.transparencySliderStateChanged(evt);
            }
        });
        this.mainMenuPanel.add(this.transparencySlider);
        this.splitPanels.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.splitPanels.setDividerLocation(940);
        this.splitPanels.setResizeWeight(0.5);
        this.earlyMapPanel.setBackground(new Color(255, 255, 255));
        this.earlyMapPanel.setBorder(BorderFactory.createEtchedBorder());
        this.earlyMapPanel.setToolTipText("Drag the analyzed map and control points here.");
        this.earlyMapPanel.setLayout(new BorderLayout());
        this.splitPanels.setLeftComponent(this.earlyMapPanel);
        this.osmMapPanel.setBackground(new Color(255, 255, 255));
        this.osmMapPanel.setBorder(BorderFactory.createEtchedBorder());
        this.osmMapPanel.setToolTipText("Drag the control points here.");
        this.osmMapPanel.setLayout(new BorderLayout());
        this.splitPanels.setRightComponent(this.osmMapPanel);
        this.statusBarPanel.setBorder(BorderFactory.createEtchedBorder());
        this.statusBarPanel.setPreferredSize(new Dimension(1900, 18));
        this.statusBarLabel.setHorizontalAlignment(11);
        this.statusBarLabel.setMaximumSize(new Dimension(14, 14));
        this.statusBarLabel.setMinimumSize(new Dimension(14, 14));
        this.statusBarLabel.setPreferredSize(new Dimension(14, 14));
        GroupLayout statusBarPanelLayout = new GroupLayout(this.statusBarPanel);
        this.statusBarPanel.setLayout(statusBarPanelLayout);
        statusBarPanelLayout.setHorizontalGroup(statusBarPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, statusBarPanelLayout.createSequentialGroup().addGap(0, 1396, Short.MAX_VALUE).addComponent(this.statusBarLabel, -2, 500, -2)));
        statusBarPanelLayout.setVerticalGroup(statusBarPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, statusBarPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.statusBarLabel, -2, -1, -2)));
        this.statusBarLabel.getAccessibleContext().setAccessibleDescription("");
        this.mapMenu.setText("Map");
        this.openMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/open.png")));
        this.openMenuItem.setText("Import map...");
        this.openMenuItem.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.importMapButtonActionPerformed(evt);
            }
        });
        this.mapMenu.add(this.openMenuItem);
        this.mapMenu.add(this.jSeparator4);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.exitMenuItemActionPerformed(evt);
            }
        });
        this.mapMenu.add(this.exitMenuItem);
        this.menuBar.add(this.mapMenu);
        this.viewMenu.setText("View");
        this.panningMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/panning.png")));
        this.panningMenuItem.setText("Panning");
        this.panningMenuItem.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.panningMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.panningMenuItem);
        this.zoomInMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/zoom_in.png")));
        this.zoomInMenuItem.setText("Zoom In");
        this.zoomInMenuItem.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.zoomInMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.zoomInMenuItem);
        this.zoomOutMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/zoom_out.png")));
        this.zoomOutMenuItem.setText("Zoom out");
        this.zoomOutMenuItem.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.zoomOutMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.zoomOutMenuItem);
        this.viewAllMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/view-all.png")));
        this.viewAllMenuItem.setText("View all");
        this.viewAllMenuItem.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.viewAllMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewAllMenuItem);
        this.menuBar.add(this.viewMenu);
        this.pointsMenu.setText("Points");
        this.addControPointsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/control_point.png")));
        this.addControPointsMenuItem.setText("Add control points");
        this.addControPointsMenuItem.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.addControlPointButtonActionPerformed(evt);
            }
        });
        this.pointsMenu.add(this.addControPointsMenuItem);
        this.pointsMenu.add(this.jSeparator7);
        this.importTestPointsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/open_test.png")));
        this.importTestPointsMenuItem.setText("Import test points...");
        this.importTestPointsMenuItem.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.importTestPointsButtonActionPerformed(evt);
            }
        });
        this.pointsMenu.add(this.importTestPointsMenuItem);
        this.importReferencePointsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/open_reference.png")));
        this.importReferencePointsMenuItem.setText("Import reference points...");
        this.importReferencePointsMenuItem.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.importReferencePointsButtonActionPerformed(evt);
            }
        });
        this.pointsMenu.add(this.importReferencePointsMenuItem);
        this.pointsMenu.add(this.jSeparator1);
        this.jMenuItem2.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/show_control_points.png")));
        this.jMenuItem2.setText("Show control points");
        this.jMenuItem2.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.showControlPointsButtonActionPerformed(evt);
            }
        });
        this.pointsMenu.add(this.jMenuItem2);
        this.pointsMenu.add(this.jSeparator13);
        this.exportTestPointsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/save_test.png")));
        this.exportTestPointsMenuItem.setText("Export test points...");
        this.exportTestPointsMenuItem.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.exportTestPointsButtonActionPerformed(evt);
            }
        });
        this.pointsMenu.add(this.exportTestPointsMenuItem);
        this.exportReferencePointsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/save_reference.png")));
        this.exportReferencePointsMenuItem.setText("Export reference points...");
        this.exportReferencePointsMenuItem.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.exportReferencePointsButtonActionPerformed(evt);
            }
        });
        this.pointsMenu.add(this.exportReferencePointsMenuItem);
        this.menuBar.add(this.pointsMenu);
        this.analysisMenu.setText("Analysis");
        this.analysisMenu.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.analysisMenuActionPerformed(evt);
            }
        });
        this.detectionMethodMenu.setText("Detection method");
        this.detectionMethodGroup.add(this.m7CheckBoxMenuItem);
        this.m7CheckBoxMenuItem.setSelected(true);
        this.m7CheckBoxMenuItem.setText("M7 (Unrotated Map,7 parameters)");
        this.m7CheckBoxMenuItem.addChangeListener(new ChangeListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.m7CheckBoxMenuItemStateChanged(evt);
            }
        });
        this.detectionMethodMenu.add(this.m7CheckBoxMenuItem);
        this.detectionMethodGroup.add(this.m8CheckBoxMenuItem);
        this.m8CheckBoxMenuItem.setText("M8 (Rotated Map, 8 parameters)");
        this.m8CheckBoxMenuItem.addChangeListener(new ChangeListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.m8CheckBoxMenuItemStateChanged(evt);
            }
        });
        this.detectionMethodMenu.add(this.m8CheckBoxMenuItem);
        this.analysisMenu.add(this.detectionMethodMenu);
        this.optimizationTechniqueMenu.setText("Optimization technique");
        this.optimizationTechniqueGroup.add(this.nonLinearLeastSquaresCheckBoxMenuItem);
        this.nonLinearLeastSquaresCheckBoxMenuItem.setText("Non-linear least squares");
        this.nonLinearLeastSquaresCheckBoxMenuItem.addChangeListener(new ChangeListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.nonLinearLeastSquaresCheckBoxMenuItemStateChanged(evt);
            }
        });
        this.optimizationTechniqueMenu.add(this.nonLinearLeastSquaresCheckBoxMenuItem);
        this.optimizationTechniqueGroup.add(this.nelderMeadCheckBoxMenuItem);
        this.nelderMeadCheckBoxMenuItem.setSelected(true);
        this.nelderMeadCheckBoxMenuItem.setText("Nelder-Mead");
        this.nelderMeadCheckBoxMenuItem.addChangeListener(new ChangeListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.nelderMeadCheckBoxMenuItemStateChanged(evt);
            }
        });
        this.optimizationTechniqueMenu.add(this.nelderMeadCheckBoxMenuItem);
        this.optimizationTechniqueGroup.add(this.differentialEvolutionCheckBoxMenuItem);
        this.differentialEvolutionCheckBoxMenuItem.setText("Differential evolution");
        this.differentialEvolutionCheckBoxMenuItem.addChangeListener(new ChangeListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void stateChanged(ChangeEvent evt) {
                this.this$0.differentialEvolutionCheckBoxMenuItemStateChanged(evt);
            }
        });
        this.optimizationTechniqueMenu.add(this.differentialEvolutionCheckBoxMenuItem);
        this.analysisMenu.add(this.optimizationTechniqueMenu);
        this.analysisMenu.add(this.jSeparator5);
        this.analyzeMapMenuItem.setText("Analyze map");
        this.analyzeMapMenuItem.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.analyzeButtonActionPerformed(evt);
            }
        });
        this.analysisMenu.add(this.analyzeMapMenuItem);
        this.analysisMenu.add(this.jSeparator3);
        this.showResultsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/table.png")));
        this.showResultsMenuItem.setText("Show results...");
        this.showResultsMenuItem.setCursor(new Cursor(0));
        this.showResultsMenuItem.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.showResultsButtonActionPerformed(evt);
            }
        });
        this.analysisMenu.add(this.showResultsMenuItem);
        this.clearResultsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/table_clear.png")));
        this.clearResultsMenuItem.setText("Clear results");
        this.clearResultsMenuItem.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.clearResultsButtonActionPerformed(evt);
            }
        });
        this.analysisMenu.add(this.clearResultsMenuItem);
        this.analysisMenu.add(this.jSeparator10);
        this.clearAllMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/clear_all.png")));
        this.clearAllMenuItem.setText("Clear all");
        this.clearAllMenuItem.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.clearAllButtonActionPerformed(evt);
            }
        });
        this.analysisMenu.add(this.clearAllMenuItem);
        this.analysisMenu.add(this.jSeparator15);
        this.settingsMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/settings.png")));
        this.settingsMenuItem.setText("Settings...");
        this.settingsMenuItem.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.settingsMenuItemActionPerformed(evt);
            }
        });
        this.analysisMenu.add(this.settingsMenuItem);
        this.menuBar.add(this.analysisMenu);
        this.helpMenu.setText("Help");
        this.jMenuItem1.setText("Help...");
        this.jMenuItem1.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jMenuItem1ActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.jMenuItem1);
        this.aboutMenuItem.setText("About...");
        this.aboutMenuItem.addActionListener(new ActionListener(this){
            final /* synthetic */ MainApplication this$0;
            {
                MainApplication mainApplication = this$0;
                Objects.requireNonNull(mainApplication);
                this.this$0 = mainApplication;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splitPanels, -1, 1900, Short.MAX_VALUE).addComponent(this.mainMenuPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusBarPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.mainMenuPanel, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.splitPanels, -1, 767, Short.MAX_VALUE).addGap(19, 19, 19)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 815, Short.MAX_VALUE).addComponent(this.statusBarPanel, -2, -1, -2))));
        this.pack();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.closeApplication();
    }

    private void analyzeButtonActionPerformed(ActionEvent evt) {
        if (!this.computation_in_progress[0]) {
            this.analyzeMapMenuItem.setEnabled(false);
            this.analyzeEarlyMap();
            this.analyzeButton.setSelected(false);
            this.analyzeMapMenuItem.setEnabled(true);
        }
    }

    private void selectDetectionMethodComboBoxItemStateChanged(ItemEvent evt) {
        this.zoomGroup.clearSelection();
        this.addControlPointsToggleButton.setSelected(false);
        this.index_method = this.selectDetectionMethodComboBox.getSelectedIndex() + 1;
        if (this.index_method == 1) {
            this.m7CheckBoxMenuItem.setSelected(true);
        } else {
            this.m8CheckBoxMenuItem.setSelected(true);
        }
    }

    private void selectOptimizationTechniqueComboBoxItemStateChanged(ItemEvent evt) {
        this.zoomGroup.clearSelection();
        this.addControlPointsToggleButton.setSelected(false);
        this.index_optimization = 10 * (this.selectOptimizationTechniqueComboBox.getSelectedIndex() + 1);
        if (this.index_optimization == 10) {
            this.nonLinearLeastSquaresCheckBoxMenuItem.setSelected(true);
        } else if (this.index_optimization == 20) {
            this.nelderMeadCheckBoxMenuItem.setSelected(true);
        } else {
            this.differentialEvolutionCheckBoxMenuItem.setSelected(true);
        }
    }

    private void importMapButtonActionPerformed(ActionEvent evt) {
        this.zoomGroup.clearSelection();
        this.addControlPointsToggleButton.setSelected(false);
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Images", "jpg", "png");
        fc.setFileFilter(filter);
        fc.setDialogTitle("Upload early map");
        fc.setCurrentDirectory(new File(System.getProperty("user.home")));
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            this.importEarlyMap(fc.getSelectedFile());
            try {
                DPI dpi = ImageDPIReader.readDPI(fc.getSelectedFile());
                if (dpi != null) {
                    this.early_map.setDPI(dpi.x_dpi);
                    this.statusBarLabel.setText("Determined resolution is " + Double.toString(dpi.x_dpi) + " DPI.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.statusBarLabel.setText("Resolution detection failed, default value " + Double.toString(this.early_map.getDPI()) + " DPI.");
            }
        }
    }

    private void clearAllButtonActionPerformed(ActionEvent evt) {
        if (!this.computation_in_progress[0]) {
            Object[] options;
            int response;
            this.zoomGroup.clearSelection();
            this.addControlPointsToggleButton.setSelected(false);
            if ((this.early_map.test_points.size() > 0 || this.map.reference_points.size() > 0) && (response = JOptionPane.showOptionDialog(null, "All results and control points will be deleted. Do you want to continue?", "Warning", 0, 2, null, options = new Object[]{"Clear all ", "Cancel"}, options[1])) == 0) {
                this.clearAll();
                this.early_map.repaint();
                this.map.repaint();
                this.add_test_point[0] = true;
                this.add_reference_point[0] = true;
                this.index_nearest[0] = -1;
                this.index_nearest_prev[0] = -1;
            }
        }
    }

    private void showResultsButtonActionPerformed(ActionEvent evt) {
        this.zoomGroup.clearSelection();
        this.addControlPointsToggleButton.setSelected(false);
        this.zoomGroup.clearSelection();
        this.results_form.printResults(this.n_results);
        this.results_form.setVisible(true);
    }

    private void clearResultsButtonActionPerformed(ActionEvent evt) {
        if (!this.computation_in_progress[0]) {
            Object[] options;
            int response;
            this.zoomGroup.clearSelection();
            this.addControlPointsToggleButton.setSelected(false);
            if (this.results.size() > 0 && (response = JOptionPane.showOptionDialog(null, "All results will be deleted. Do you want to continue?", "Warning", 0, 2, null, options = new Object[]{"Clear all ", "Cancel"}, options[1])) == 0) {
                this.clearResults();
                this.early_map.repaint();
            }
        }
    }

    private void zoomInToggleButtonStateChanged(ChangeEvent evt) {
        if (this.zoomInToggleButton.isSelected()) {
            this.enable_zoom_in_lm[0] = true;
            this.addControlPointsToggleButton.setSelected(false);
        } else {
            this.enable_zoom_in_lm[0] = false;
        }
    }

    private void zoomOutToggleButtonStateChanged(ChangeEvent evt) {
        if (this.zoomOutToggleButton.isSelected()) {
            this.enable_zoom_out_lm[0] = true;
            this.addControlPointsToggleButton.setSelected(false);
        } else {
            this.enable_zoom_out_lm[0] = false;
        }
    }

    private void viewAllToggleButtonStateChanged(ChangeEvent evt) {
        if (this.viewAllToggleButton.isSelected()) {
            this.enable_zoom_fit_all_lm[0] = true;
            this.addControlPointsToggleButton.setSelected(false);
        } else {
            this.enable_zoom_fit_all_lm[0] = false;
        }
    }

    private void addControlPointButtonActionPerformed(ActionEvent evt) {
        if (!this.computation_in_progress[0]) {
            this.enable_add_control_points[0] = !this.enable_add_control_points[0];
            this.addControlPointsToggleButton.setSelected(this.enable_add_control_points[0]);
            this.zoomGroup.clearSelection();
        }
    }

    private void importTestPointsButtonActionPerformed(ActionEvent evt) {
        if (!this.computation_in_progress[0]) {
            this.zoomGroup.clearSelection();
            this.addControlPointsToggleButton.setSelected(false);
            this.importPoints(this.early_map.test_points, "Import test points", Point3DCartesian.class);
            this.early_map.repaint();
            this.control_points_form.clearTable();
            this.control_points_form.printResult();
        }
    }

    private void importReferencePointsButtonActionPerformed(ActionEvent evt) {
        if (!this.computation_in_progress[0]) {
            this.zoomGroup.clearSelection();
            this.addControlPointsToggleButton.setSelected(false);
            this.importPoints(this.map.reference_points, "Import reference points", Point3DGeographic.class);
            this.map.repaint();
            this.control_points_form.clearTable();
            this.control_points_form.printResult();
        }
    }

    private void exportTestPointsButtonActionPerformed(ActionEvent evt) {
        if (this.early_map.test_points.size() > 0) {
            this.exportPoints(this.early_map.test_points, "Export test points", "test_points.txt");
        }
    }

    private void exportReferencePointsButtonActionPerformed(ActionEvent evt) {
        if (this.map.reference_points.size() > 0) {
            this.exportPoints(this.map.reference_points, "Export reference points", "reference_points.txt");
        }
    }

    private void zoomInMenuItemActionPerformed(ActionEvent evt) {
        this.enable_panning_lm[0] = false;
        this.enable_zoom_in_lm[0] = true;
        this.enable_zoom_out_lm[0] = false;
        this.enable_zoom_fit_all_lm[0] = false;
        this.addControlPointsToggleButton.setSelected(false);
    }

    private void viewAllMenuItemActionPerformed(ActionEvent evt) {
        this.enable_panning_lm[0] = false;
        this.enable_zoom_fit_all_lm[0] = true;
        this.enable_zoom_in_lm[0] = false;
        this.enable_zoom_out_lm[0] = false;
        this.addControlPointsToggleButton.setSelected(false);
    }

    private void zoomOutMenuItemActionPerformed(ActionEvent evt) {
        this.enable_panning_lm[0] = false;
        this.enable_zoom_out_lm[0] = true;
        this.enable_zoom_in_lm[0] = false;
        this.enable_zoom_fit_all_lm[0] = false;
        this.addControlPointsToggleButton.setSelected(false);
    }

    private void m7CheckBoxMenuItemStateChanged(ChangeEvent evt) {
        this.zoomGroup.clearSelection();
        this.addControlPointsToggleButton.setSelected(false);
        if (this.m7CheckBoxMenuItem.isSelected()) {
            this.index_method = 1;
            this.selectDetectionMethodComboBox.setSelectedIndex(this.index_method - 1);
        }
    }

    private void m8CheckBoxMenuItemStateChanged(ChangeEvent evt) {
        this.zoomGroup.clearSelection();
        this.addControlPointsToggleButton.setSelected(false);
        if (this.m8CheckBoxMenuItem.isSelected()) {
            this.index_method = 2;
            this.selectDetectionMethodComboBox.setSelectedIndex(this.index_method - 1);
        }
    }

    private void nonLinearLeastSquaresCheckBoxMenuItemStateChanged(ChangeEvent evt) {
        this.zoomGroup.clearSelection();
        this.addControlPointsToggleButton.setSelected(false);
        if (this.nonLinearLeastSquaresCheckBoxMenuItem.isSelected()) {
            this.index_optimization = 10;
            this.selectOptimizationTechniqueComboBox.setSelectedIndex(this.index_optimization / 10 - 1);
        }
    }

    private void nelderMeadCheckBoxMenuItemStateChanged(ChangeEvent evt) {
        this.zoomGroup.clearSelection();
        this.addControlPointsToggleButton.setSelected(false);
        if (this.nelderMeadCheckBoxMenuItem.isSelected()) {
            this.index_optimization = 20;
            this.selectOptimizationTechniqueComboBox.setSelectedIndex(this.index_optimization / 10 - 1);
        }
    }

    private void differentialEvolutionCheckBoxMenuItemStateChanged(ChangeEvent evt) {
        this.zoomGroup.clearSelection();
        this.addControlPointsToggleButton.setSelected(false);
        this.index_optimization = 30;
        this.selectOptimizationTechniqueComboBox.setSelectedIndex(this.index_optimization / 10 - 1);
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        this.about_form.setVisible(true);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeApplication();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.early_map.zoomFitAll();
    }

    private void showControlPointsButtonActionPerformed(ActionEvent evt) {
        this.zoomGroup.clearSelection();
        this.control_points_form.printResult();
        this.control_points_form.setVisible(true);
    }

    private void addControlPointsToggleButtonStateChanged(ChangeEvent evt) {
        if (!this.computation_in_progress[0]) {
            if (this.addControlPointsToggleButton.isSelected()) {
                this.enable_add_control_points[0] = true;
                this.zoomGroup.clearSelection();
            } else {
                this.enable_add_control_points[0] = false;
            }
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        try {
            Path path = Files.createTempFile(null, ".chm", new FileAttribute[0]);
            InputStream res = this.getClass().getResourceAsStream("/detectprojv2j/resources/detectproj.chm");
            Files.copy(res, path, StandardCopyOption.REPLACE_EXISTING);
            Desktop.getDesktop().open(path.toFile());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void settingsMenuItemActionPerformed(ActionEvent evt) {
        this.settings_form.setVisible(true);
    }

    private void settingsButtonActionPerformed(ActionEvent evt) {
        this.settings_form.setVisible(true);
    }

    private void panningToggleButtonStateChanged(ChangeEvent evt) {
        if (this.panningToggleButton.isSelected()) {
            this.enable_panning_lm[0] = true;
            this.addControlPointsToggleButton.setSelected(false);
        } else {
            this.enable_panning_lm[0] = false;
        }
    }

    private void panningMenuItemActionPerformed(ActionEvent evt) {
        this.enable_panning_lm[0] = true;
        this.enable_zoom_in_lm[0] = false;
        this.enable_zoom_out_lm[0] = false;
        this.enable_zoom_fit_all_lm[0] = false;
        this.addControlPointsToggleButton.setSelected(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transparencySliderStateChanged(ChangeEvent evt) {
        List<MercTile> tiles_reproj;
        int transparency = this.transparencySlider.getValue();
        List<MercTile> list = tiles_reproj = Collections.synchronizedList(this.map.getReprojectedTiles());
        synchronized (list) {
            for (MercTile tile : tiles_reproj) {
                tile.alpha = 0.01f * (float)transparency;
            }
            this.map.repaintMap();
        }
    }

    private void analysisMenuActionPerformed(ActionEvent evt) {
    }

    private void addControlPointsToggleButtonActionPerformed(ActionEvent evt) {
    }

    public void closeApplication() {
        Object[] options = new Object[]{"Exit detectproj", "Cancel"};
        int response = JOptionPane.showOptionDialog(null, "Detectproj will be closed. Are you sure you want to exit?", "Warning", 0, 2, null, options, options[1]);
        if (response == 0) {
            System.exit(0);
        }
    }

    public void analyzeEarlyMap() {
        int n_test = this.early_map.test_points.size();
        int n_reference = this.map.reference_points.size();
        if (!this.computation_in_progress[0]) {
            this.clearResults();
            Projections.init(this.projections, this.default_lon_dir[0]);
            switch (this.index_method + this.index_optimization) {
                case 11: {
                    this.method = TAnalysisMethod.NLSM7;
                    break;
                }
                case 12: {
                    this.method = TAnalysisMethod.NLSM8;
                    break;
                }
                case 21: {
                    this.method = TAnalysisMethod.NMM7;
                    break;
                }
                case 22: {
                    this.method = TAnalysisMethod.NMM8;
                    break;
                }
                case 31: {
                    this.method = TAnalysisMethod.DEM7;
                    break;
                }
                case 32: {
                    this.method = TAnalysisMethod.DEM8;
                }
            }
            if (Math.abs(n_test - n_reference) == 1) {
                Object[] options = new Object[]{"Delete point", "Cancel"};
                int response = JOptionPane.showOptionDialog(null, "Different amount of control points (1 point is missing). The analysis cannot be computed. Delete LAST collected point?", "Warning", 0, 2, null, options, options[1]);
                if (response == 0) {
                    if (n_test > n_reference) {
                        this.early_map.test_points.remove(n_test - 1);
                    } else {
                        this.map.deletePoint(n_reference - 1);
                    }
                    this.early_map.repaint();
                    this.map.repaintMap();
                    this.add_test_point[0] = true;
                    this.add_reference_point[0] = true;
                }
            } else if (Math.abs(n_test - n_reference) > 1) {
                Object[] options = new Object[]{"Delete points", "Cancel"};
                int response = JOptionPane.showOptionDialog(null, "Wrong data, " + Math.abs(n_test - n_reference) + " poins are missing! The analysis cannot be computed. Delete ALL collected points?", "Warning", 0, 2, null, options, options[1]);
                if (response == 0) {
                    this.clearAll();
                }
                return;
            }
            if (n_test < 5) {
                return;
            }
            CartAnalysisMT ca = new CartAnalysisMT(this.early_map.test_points, this.map.reference_points, this.projections, this.results, this.method, this.analyze_lon0[0], System.out, this.analyzeButton, new Runnable(this){
                final /* synthetic */ MainApplication this$0;
                {
                    MainApplication mainApplication = this$0;
                    Objects.requireNonNull(mainApplication);
                    this.this$0 = mainApplication;
                }

                @Override
                public void run() {
                    double lat_step;
                    this.this$0.results_form.printResults(this.this$0.n_results);
                    double lat_min = this.this$0.create_entire_graticule[0] ? -89.0 : Collections.min(this.this$0.map.reference_points, new SortPointsByLat()).getLat();
                    double lat_max = this.this$0.create_entire_graticule[0] ? 89.0 : Collections.max(this.this$0.map.reference_points, new SortPointsByLat()).getLat();
                    double lon_min = this.this$0.create_entire_graticule[0] ? -180.0 : Collections.min(this.this$0.map.reference_points, new SortPointsByLon()).getLon();
                    double lon_max = this.this$0.create_entire_graticule[0] ? 180.0 : Collections.max(this.this$0.map.reference_points, new SortPointsByLon()).getLon();
                    double lat_aver = 0.5 * (lat_min + lat_max);
                    double lon_aver = 0.5 * (lon_min + lon_max);
                    if ((lon_min < -140.0 || lon_max > 140.0) && lon_max - lon_min > 200.0) {
                        lon_min = -180.0;
                        lon_max = 180.0;
                    }
                    this.this$0.lat_interval.min_value = lat_min;
                    this.this$0.lat_interval.max_value = lat_max;
                    this.this$0.lon_interval.min_value = lon_min;
                    this.this$0.lon_interval.max_value = lon_max;
                    double dlat = lat_max - lat_min;
                    double dlon = lon_max - lon_min;
                    double d = dlat < 20.0 ? (dlat < 2.0 ? Math.max(this.this$0.lat3_step[0], dlat / 50.0) : Math.max(this.this$0.lat2_step[0], dlat / 50.0)) : (lat_step = Math.max(this.this$0.lat1_step[0], dlat / 50.0));
                    double lon_step = dlon < 20.0 ? (dlon < 2.0 ? Math.max(this.this$0.lon3_step[0], dlon / 50.0) : Math.max(this.this$0.lon2_step[0], dlon / 50.0)) : Math.max(this.this$0.lon1_step[0], dlon / 50.0);
                    this.this$0.lat_incr[0] = Math.max(this.this$0.lat_incr[0], dlat / 20000.0 * lat_step);
                    this.this$0.lon_incr[0] = Math.max(this.this$0.lon_incr[0], dlon / 40000.0 * lon_step);
                    int index = 0;
                    for (Map.Entry<Double, TResult> entry : this.this$0.results.entrySet()) {
                        ArrayList<Meridian> meridians = new ArrayList<Meridian>();
                        ArrayList<Parallel> parallels = new ArrayList<Parallel>();
                        ArrayList<List<Point3DCartesian>> meridians_proj = new ArrayList<List<Point3DCartesian>>();
                        ArrayList<List<Point3DCartesian>> parallels_proj = new ArrayList<List<Point3DCartesian>>();
                        Double key = entry.getKey();
                        TResult value = entry.getValue();
                        double alpha = value.map_rotation;
                        List<Point3DCartesian> points_proj = CartTransformation.latsLonsToXY(this.this$0.map.reference_points, value.proj, alpha);
                        long startTime = System.currentTimeMillis();
                        Graticule gr = new Graticule(this.this$0.lat_incr[0], this.this$0.lon_incr[0], 5.0, 0, 20);
                        gr.createGraticule(value.proj, this.this$0.lat_interval, this.this$0.lon_interval, lat_step, lon_step, alpha, meridians, meridians_proj, parallels, parallels_proj, TGraticuleSampling.UniformSampling, 100, 1.0E9, 0.001);
                        long estimatedTime = System.currentTimeMillis() - startTime;
                        value.meridians = meridians;
                        value.parallels = parallels;
                        value.points_proj = points_proj;
                        value.meridians_proj = meridians_proj;
                        value.parallels_proj = parallels_proj;
                        ++index;
                    }
                    TResult result_first = this.this$0.results.firstEntry().getValue();
                    this.this$0.early_map.setMeridians(result_first.meridians);
                    this.this$0.early_map.setParallels(result_first.parallels);
                    this.this$0.early_map.setProjection(result_first.proj);
                    this.this$0.early_map.setProjectedMeridians(result_first.meridians_proj);
                    this.this$0.early_map.setProjectedParallels(result_first.parallels_proj);
                    this.this$0.early_map.setProjectedPoints(result_first.points_proj);
                    this.this$0.setTitle("Map projection analysis: " + result_first.proj.getName() + " projection");
                    this.this$0.early_map.repaint();
                    this.this$0.results_form.setVisible(true);
                    this.this$0.computation_in_progress[0] = false;
                }
            });
            this.computation_in_progress[0] = true;
            Thread t = new Thread(ca);
            t.start();
        }
    }

    public void importEarlyMap() {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Images", "jpg", "png");
        fc.setFileFilter(filter);
        fc.setDialogTitle("Upload early map");
        fc.setCurrentDirectory(new File(System.getProperty("user.home")));
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            this.importEarlyMap(fc.getSelectedFile());
        }
    }

    private void importEarlyMap(File file) {
        try {
            BufferedImage img = ImageIO.read(file);
            this.early_map.setImage(img);
            this.early_map.zoomFitAll();
        }
        catch (FileNotFoundException exception) {
            exception.printStackTrace();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public <Point> void importPoints(List<Point> points, String window_title, Class<Point> o_class) {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Text files", "txt");
        fc.setFileFilter(filter);
        fc.setDialogTitle(window_title);
        fc.setCurrentDirectory(new File(System.getProperty("user.home")));
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            this.importPoints(points, fc.getSelectedFile(), o_class);
        }
    }

    private <Point> void importPoints(List<Point> points, File file, Class<Point> o_class) {
        try {
            Object[] options;
            int response;
            if (this.early_map.test_points.size() > 0 && this.map.reference_points.size() > 0 && (response = JOptionPane.showOptionDialog(null, "All results and control points will be deleted. Do you want to continue?", "Warning", 0, 2, null, options = new Object[]{"Continue", "Cancel"}, options[1])) == 0) {
                this.clearAll();
            }
            String points_file = file.toString();
            IO.load2DPoints(points_file, points, o_class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (o_class == Point3DGeographic.class) {
            for (Point3DGeographic point : this.map.reference_points) {
                MyMapMarker m = new MyMapMarker(point.getLat(), point.getLon(), 10.0);
                this.map.addMapMarker(m);
            }
        }
    }

    public <Point extends IPoint3DFeatures> void exportPoints(List<Point> points, String window_title, String file_test_points) {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Text files", "txt");
        fc.setFileFilter(filter);
        fc.setDialogTitle(window_title);
        fc.setCurrentDirectory(new File(System.getProperty("user.home")));
        fc.setSelectedFile(new File(file_test_points));
        int result = fc.showSaveDialog(this);
        if (result == 0) {
            try {
                file_test_points = fc.getSelectedFile().toString();
                IO.save2DPoints(file_test_points, points);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void exportGraticule() {
        double lat_step = 10.0;
        double lon_step = 10.0;
        List<Point3DCartesian> reference_points_proj = this.early_map.getProjectedPoints();
        List<Meridian> meridians = this.early_map.getMeridians();
        List<Parallel> parallels = this.early_map.getParallels();
        Projection proj = this.early_map.getProjection();
        List<List<Point3DCartesian>> meridians_proj = this.early_map.getProjectedMeridians();
        List<List<Point3DCartesian>> parallels_proj = this.early_map.getProjectedParalells();
        if (meridians != null && parallels != null && proj != null && meridians_proj != null && parallels_proj != null) {
            JFileChooser fc = new JFileChooser();
            fc.setAcceptAllFileFilterUsed(false);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("CAD files", "dxf");
            fc.setFileFilter(filter);
            Object file_graticule_text = "grat_" + proj.getName() + ".dxf";
            fc.setDialogTitle("Export graticule");
            fc.setCurrentDirectory(new File(System.getProperty("user.home")));
            fc.setSelectedFile(new File((String)file_graticule_text));
            int result = fc.showSaveDialog(this);
            if (result == 0) {
                try {
                    file_graticule_text = fc.getSelectedFile().toString();
                    double font_height = 0.05 * proj.getR() * Math.min(10.0, 10.0) * Math.PI / 180.0;
                    DXFExport.exportGraticuleToDXF((String)file_graticule_text, meridians, meridians_proj, parallels, parallels_proj, this.early_map.test_points, reference_points_proj, font_height, Math.min(10.0, 10.0));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void setChangeButtonStatus(boolean status) {
        this.addControlPointsToggleButton.setEnabled(status);
        this.importTestPointsButton.setEnabled(status);
        this.importReferencePointsButton.setEnabled(status);
        this.clearAllButton.setEnabled(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAll() {
        this.early_map.test_points.clear();
        this.map.reference_points.clear();
        this.clearResults();
        OSMMap oSMMap = this.map;
        synchronized (oSMMap) {
            this.map.removeAllMapMarkers();
        }
    }

    private void clearResults() {
        this.results.clear();
        this.projections.clear();
        this.early_map.clearMeridians();
        this.early_map.clearParallels();
        this.early_map.clearProjectedMeridians();
        this.early_map.clearProjectedParallels();
        this.map.clearReprojectedTiles();
        this.results_form.clearTable();
        this.setTitle("Map projection analysis and reprojection: detectproj");
        List<MapMarker> map_markers = Collections.synchronizedList(this.map.getMapMarkerList());
        int np = this.map.reference_points.size();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainApplication.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MainApplication.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MainApplication.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainApplication.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainApplication().setVisible(true);
            }
        });
    }

    private class DragAndDrop
    implements DropTargetListener {
        final /* synthetic */ MainApplication this$0;

        private DragAndDrop(MainApplication mainApplication) {
            MainApplication mainApplication2 = mainApplication;
            Objects.requireNonNull(mainApplication2);
            this.this$0 = mainApplication2;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            block9: {
                try {
                    dtde.acceptDrop(3);
                    List dragged_files = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    File dragged_file = (File)dragged_files.get(0);
                    String dragged_file_name = dragged_file.toString().toLowerCase();
                    DropTarget target = (DropTarget)dtde.getSource();
                    if (target.getComponent() == this.this$0.early_map) {
                        if (dragged_file_name.endsWith(".jpg") || dragged_file_name.endsWith(".png")) {
                            this.this$0.importEarlyMap(dragged_file);
                            try {
                                DPI dpi = ImageDPIReader.readDPI(dragged_file);
                                if (dpi != null) {
                                    this.this$0.early_map.setDPI(dpi.x_dpi);
                                    this.this$0.statusBarLabel.setText("Determined resolution is " + Double.toString(dpi.x_dpi) + " DPI.");
                                }
                                break block9;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.this$0.statusBarLabel.setText("Resolution detection failed, default value " + Double.toString(this.this$0.early_map.getDPI()) + " DPI.");
                            }
                            break block9;
                        }
                        if (dragged_file_name.endsWith(".txt")) {
                            this.this$0.zoomGroup.clearSelection();
                            this.this$0.addControlPointsToggleButton.setSelected(false);
                            this.this$0.importPoints(this.this$0.early_map.test_points, dragged_file, Point3DCartesian.class);
                            this.this$0.early_map.repaint();
                            this.this$0.control_points_form.clearTable();
                            this.this$0.control_points_form.printResult();
                        }
                        break block9;
                    }
                    if (target.getComponent() == this.this$0.map && dragged_file_name.endsWith(".txt")) {
                        this.this$0.zoomGroup.clearSelection();
                        this.this$0.addControlPointsToggleButton.setSelected(false);
                        this.this$0.importPoints(this.this$0.map.reference_points, dragged_file, Point3DGeographic.class);
                        this.this$0.map.repaint();
                        this.this$0.control_points_form.clearTable();
                        this.this$0.control_points_form.printResult();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

