/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.forms;

import detectprojv2j.algorithms.carttransformation.CartTransformation;
import detectprojv2j.algorithms.graticuleAS.GraticuleAS;
import detectprojv2j.algorithms.sphericaldistance.SphericalDistance;
import detectprojv2j.comparators.SortPointsByDistGeo;
import detectprojv2j.forms.ControlPointsForm;
import detectprojv2j.forms.EarlyMap;
import detectprojv2j.forms.MyMapMarker;
import detectprojv2j.structures.graticule.Meridian;
import detectprojv2j.structures.graticule.Parallel;
import detectprojv2j.structures.point.Point3DCartesian;
import detectprojv2j.structures.point.Point3DGeographic;
import detectprojv2j.structures.projection.ProjectionCylindrical;
import detectprojv2j.structures.projection.Projections;
import detectprojv2j.structures.tile.MercTile;
import detectprojv2j.types.TInterval;
import detectprojv2j.types.TTransformedLongitudeDirection;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.DefaultMapController;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerCircle;
import org.openstreetmap.gui.jmapviewer.MapPolygonImpl;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;

public class OSMMap
extends JMapViewer {
    public List<Point3DGeographic> reference_points = new ArrayList<Point3DGeographic>();
    private EarlyMap early_map;
    private JPopupMenu pop_up_menu;
    private ControlPointsForm control_points_form;
    private boolean[] add_test_point;
    private boolean[] add_reference_point;
    private boolean[] enable_add_control_points;
    private boolean[] enable_panning_lm;
    private boolean[] enable_zoom_in_lm;
    private boolean[] enable_zoom_out_lm;
    private boolean[] enable_zoom_fit_all_lm;
    private boolean[] computation_in_progress;
    private int[] index_nearest;
    private int[] index_nearest_prev;
    private List<MercTile> tiles_reproj;

    public OSMMap(EarlyMap early_map_, ControlPointsForm control_points_form_, boolean[] add_test_point_, boolean[] add_reference_point_, boolean[] enable_add_control_points_, boolean[] enable_panning_lm_, boolean[] enable_zoom_in_lm_, boolean[] enable_zoom_out_lm_, boolean[] enable_zoom_fit_all_lm_, boolean[] computation_in_progress_, int[] index_nearest_, int[] index_nearest_prev_) {
        this.early_map = early_map_;
        this.control_points_form = control_points_form_;
        this.add_test_point = add_test_point_;
        this.add_reference_point = add_reference_point_;
        this.enable_add_control_points = enable_add_control_points_;
        this.enable_panning_lm = enable_panning_lm_;
        this.enable_zoom_in_lm = enable_zoom_in_lm_;
        this.enable_zoom_out_lm = enable_zoom_out_lm_;
        this.enable_zoom_fit_all_lm = enable_zoom_fit_all_lm_;
        this.computation_in_progress = computation_in_progress_;
        this.index_nearest = index_nearest_;
        this.index_nearest_prev = index_nearest_prev_;
        this.tiles_reproj = new ArrayList<MercTile>();
        this.setToolTipText("");
        this.setScrollWrapEnabled(false);
        this.pop_up_menu = new JPopupMenu();
        JMenuItem deleteItem = new JMenuItem("Delete control point.");
        deleteItem.addActionListener(new ActionListener(this){
            final /* synthetic */ OSMMap this$0;
            {
                OSMMap oSMMap = this$0;
                Objects.requireNonNull(oSMMap);
                this.this$0 = oSMMap;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!this.this$0.computation_in_progress[0] && this.this$0.index_nearest[0] >= 0) {
                    if (this.this$0.add_reference_point[0] && this.this$0.early_map.test_points.size() > this.this$0.index_nearest[0]) {
                        this.this$0.early_map.test_points.remove(this.this$0.index_nearest[0]);
                    }
                    if (this.this$0.add_test_point[0] && this.this$0.reference_points.size() > this.this$0.index_nearest[0]) {
                        this.this$0.deleteNearestPoint();
                    }
                    if (this.this$0.early_map.projected_points != null && this.this$0.early_map.projected_points.size() > this.this$0.index_nearest[0]) {
                        this.this$0.early_map.projected_points.remove(this.this$0.index_nearest[0]);
                    }
                    this.this$0.early_map.repaint();
                    this.this$0.repaint();
                    this.this$0.add_test_point[0] = true;
                    this.this$0.add_reference_point[0] = true;
                    this.this$0.control_points_form.clearTable();
                    this.this$0.control_points_form.printResult();
                }
            }
        });
        this.pop_up_menu.add(deleteItem);
        new DefaultMapController(this, this){
            final /* synthetic */ OSMMap this$0;
            {
                OSMMap oSMMap = this$0;
                Objects.requireNonNull(oSMMap);
                this.this$0 = oSMMap;
                super(map);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (this.this$0.enable_panning_lm[0]) {
                    this.setMovementMouseButton(1);
                } else {
                    this.setMovementMouseButton(3);
                }
                super.mousePressed(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (this.this$0.enable_zoom_in_lm[0]) {
                        this.this$0.zoomIn();
                    } else if (this.this$0.enable_zoom_out_lm[0]) {
                        this.this$0.zoomOut();
                    } else if (this.this$0.enable_zoom_fit_all_lm[0]) {
                        this.this$0.setZoom(1);
                    } else if (this.this$0.add_reference_point[0] && this.this$0.enable_add_control_points[0]) {
                        Point pcur = e.getPoint();
                        double lat = this.map.getPosition(pcur).getLat();
                        double lon = CartTransformation.redLon0(this.map.getPosition(pcur).getLon() % 360.0, 0.0);
                        Point3DGeographic pg = new Point3DGeographic(lat, lon, 0.0);
                        this.this$0.reference_points.add(pg);
                        MyMapMarker m = new MyMapMarker(lat, lon, 10.0);
                        this.map.addMapMarker(m);
                        if (this.this$0.add_test_point[0]) {
                            this.this$0.add_reference_point[0] = false;
                        } else {
                            this.this$0.add_test_point[0] = true;
                        }
                        this.this$0.repaintMap();
                        this.this$0.control_points_form.clearTable();
                        this.this$0.control_points_form.printResult();
                    }
                } else if (this.this$0.index_nearest[0] != -1) {
                    this.this$0.pop_up_menu.show(this.map, e.getX(), e.getY());
                }
                this.this$0.repaintMap();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (this.this$0.reference_points.size() > 0) {
                    double threshold = 0.02 * this.map.getMeterPerPixel();
                    Point pcur = e.getPoint();
                    double lat = this.map.getPosition(pcur).getLat();
                    double lon = CartTransformation.redLon0(this.map.getPosition(pcur).getLon() % 360.0, 0.0);
                    Point3DGeographic p_temp = new Point3DGeographic(lat, lon, 0.0);
                    int[] index_nearest_point = new int[]{0};
                    double[] dist_nearest_point = new double[]{0.0};
                    this.this$0.getNearestPointIndex(p_temp, 6380.0, dist_nearest_point, index_nearest_point);
                    if (index_nearest_point[0] >= 0 && dist_nearest_point[0] < threshold) {
                        if (this.this$0.index_nearest[0] != index_nearest_point[0]) {
                            if (this.this$0.index_nearest[0] != -1) {
                                this.this$0.index_nearest_prev[0] = this.this$0.index_nearest[0];
                            }
                            this.this$0.index_nearest[0] = index_nearest_point[0];
                        }
                    } else {
                        if (this.this$0.index_nearest[0] != -1) {
                            this.this$0.index_nearest_prev[0] = this.this$0.index_nearest[0];
                        }
                        this.this$0.index_nearest[0] = -1;
                    }
                    this.this$0.repaintMap();
                    this.this$0.early_map.repaint();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseDragged(MouseEvent e) {
                super.mouseDragged(e);
                if (SwingUtilities.isLeftMouseButton(e) && this.this$0.index_nearest[0] != -1 && this.this$0.index_nearest[0] < this.this$0.reference_points.size()) {
                    List<MapMarker> markers;
                    if (this.this$0.enable_panning_lm[0]) {
                        this.setMovementMouseButton(3);
                    }
                    Point pcur = e.getPoint();
                    double lat = this.map.getPosition(pcur).getLat();
                    double lon = CartTransformation.redLon0(this.map.getPosition(pcur).getLon() % 360.0, 0.0);
                    Point3DGeographic p = this.this$0.reference_points.get(this.this$0.index_nearest[0]);
                    p.setLat(lat);
                    p.setLon(lon);
                    List<MapMarker> list = markers = Collections.synchronizedList(this.map.getMapMarkerList());
                    synchronized (list) {
                        markers.get(this.this$0.index_nearest[0]).setLat(lat);
                        markers.get(this.this$0.index_nearest[0]).setLon(lon);
                    }
                }
                this.this$0.repaintMap();
            }
        };
        ArrayList<MapPolygonImpl> graticule = new ArrayList<MapPolygonImpl>();
        this.createOSMGraticule(graticule);
        for (MapPolygonImpl pol : graticule) {
            this.addMapPolygon(pol);
        }
    }

    public void setEarlyMap(EarlyMap early_map_) {
        this.early_map = early_map_;
    }

    public void setControlPointsForm(ControlPointsForm control_points_form_) {
        this.control_points_form = control_points_form_;
    }

    public void getNearestPointIndex(Point3DGeographic point, double R, double[] dist_nearest, int[] index_nearest) {
        if (this.reference_points.isEmpty()) {
            index_nearest[0] = -1;
            dist_nearest[0] = -1.0;
            return;
        }
        Point3DGeographic p_nearest = Collections.min(this.reference_points, new SortPointsByDistGeo(point, R));
        dist_nearest[0] = SphericalDistance.distance(point, p_nearest, R);
        index_nearest[0] = this.reference_points.indexOf(p_nearest);
    }

    public void deleteNearestPoint() {
        if (this.index_nearest[0] >= 0 && this.reference_points.size() > this.index_nearest[0]) {
            this.deletePoint(this.index_nearest[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePoint(int index) {
        if (index < this.reference_points.size() && index >= 0) {
            List<MapMarker> markers;
            this.reference_points.remove(index);
            List<MapMarker> list = markers = Collections.synchronizedList(this.getMapMarkerList());
            synchronized (list) {
                markers.remove(index);
                this.repaintMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getToolTipText(MouseEvent e) {
        Object point_num_text = "";
        double lat = 0.0;
        double lon = 0.0;
        if (this.reference_points.size() > this.index_nearest[0] && this.index_nearest[0] >= 0) {
            List<MapMarker> markers;
            MapMarkerCircle m = null;
            List<MapMarker> list = markers = Collections.synchronizedList(this.getMapMarkerList());
            synchronized (list) {
                m = (MapMarkerCircle)markers.get(this.index_nearest[0]);
                lat = m.getLat();
                lon = m.getLon();
                point_num_text = String.format(Locale.ROOT, "%3d", this.index_nearest[0] + 1) + " : ";
            }
        } else {
            Point pcur = e.getPoint();
            lat = this.getPosition(pcur).getLat();
            lon = CartTransformation.redLon0(this.getPosition(pcur).getLon() % 360.0, 0.0);
        }
        return (String)point_num_text + String.format(Locale.ROOT, "%2.2f", lat) + "  " + String.format(Locale.ROOT, "%3.2f", lon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintMap() {
        List<MapMarker> markers;
        MapMarkerCircle m = null;
        List<MapMarker> list = markers = Collections.synchronizedList(this.getMapMarkerList());
        synchronized (list) {
            if (this.reference_points.size() > this.index_nearest_prev[0] && this.index_nearest_prev[0] >= 0) {
                m = (MapMarkerCircle)markers.get(this.index_nearest_prev[0]);
                m.setBackColor(Color.YELLOW);
                m.setColor(Color.BLACK);
            }
            if (this.reference_points.size() > this.index_nearest[0] && this.index_nearest[0] >= 0) {
                m = (MapMarkerCircle)markers.get(this.index_nearest[0]);
                m.setBackColor(Color.MAGENTA);
                m.setColor(Color.MAGENTA);
            }
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        if (this.tiles_reproj != null) {
            for (MercTile tile : this.tiles_reproj) {
                if (tile == null) continue;
                Point nw = this.getMapPosition(new Coordinate(tile.lat_nw, tile.lon_nw), false);
                Point se = this.getMapPosition(new Coordinate(tile.lat_se, tile.lon_se), false);
                if (nw == null || se == null) continue;
                int x_min = Math.min(nw.x, se.x);
                int y_min = Math.min(nw.y, se.y);
                int x_max = Math.max(nw.x, se.x);
                int y_max = Math.max(nw.y, se.y);
                if (x_max <= 0 || y_max <= 0 || x_min >= this.getWidth() || y_min >= this.getHeight()) continue;
                Composite old = g2.getComposite();
                g2.setComposite(AlphaComposite.SrcOver.derive((float)tile.alpha));
                g2.drawImage(tile.image, x_min, y_min, x_max, y_max, 0, 0, tile.image.getWidth(), tile.image.getHeight(), null);
                g2.setComposite(old);
            }
            g2.dispose();
        }
    }

    public void createOSMGraticule(List<MapPolygonImpl> graticule) {
        ArrayList<Meridian> meridians = new ArrayList<Meridian>();
        ArrayList<Parallel> parallels = new ArrayList<Parallel>();
        ArrayList<List<Point3DCartesian>> meridians_proj = new ArrayList<List<Point3DCartesian>>();
        ArrayList<List<Point3DCartesian>> parallels_proj = new ArrayList<List<Point3DCartesian>>();
        ProjectionCylindrical eqc = new ProjectionCylindrical(57.29577951308232, 90.0, 0.0, 0.0, TTransformedLongitudeDirection.NormalDirection2, 0.0, 0.0, 0.0, 1.0, Projections::F_eqc, Projections::G_eqc, Projections::F_eqc, Projections::G_eqc, "Equidistant", "eqc");
        TInterval lat_interval = new TInterval(-80.0, 80.0);
        TInterval lon_interval = new TInterval(-180.0, 180.0);
        double alpha = 0.0;
        double lat_step = 5.0;
        double lon_step = 5.0;
        GraticuleAS.createGraticule(eqc, lat_interval, lon_interval, 5.0, 5.0, 0.5, 0.5, 0.0, meridians, meridians_proj, parallels, parallels_proj);
        this.graticuleToOSMGraticule(meridians_proj, graticule);
        this.graticuleToOSMGraticule(parallels_proj, graticule);
    }

    public void graticuleToOSMGraticule(List<List<Point3DCartesian>> grat_elements, List<MapPolygonImpl> graticule) {
        for (List<Point3DCartesian> grat_element : grat_elements) {
            int n = grat_element.size();
            Coordinate[] points = new Coordinate[n];
            for (int i = 0; i < n; ++i) {
                points[i] = new Coordinate(grat_element.get(i).getY(), grat_element.get(i).getX());
            }
            ArrayList<Coordinate> grat_element_osm = new ArrayList<Coordinate>(Arrays.asList(points));
            MapPolygonImpl grat_element_osm_pol = new MapPolygonImpl(grat_element_osm);
            grat_element_osm_pol.setColor(Color.black);
            graticule.add(grat_element_osm_pol);
        }
    }

    public List<MercTile> getReprojectedTiles() {
        return this.tiles_reproj;
    }

    public void setReprojectedTiles(List<MercTile> tiles_reproj_) {
        this.tiles_reproj = tiles_reproj_;
    }

    public void clearReprojectedTiles() {
        this.tiles_reproj.clear();
        this.repaint();
    }
}

