/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.forms;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerCircle;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;

public class RasterMapMarker
extends MapMarkerCircle
implements MapMarker {
    private Coordinate sw;
    private Coordinate ne;
    private BufferedImage img;
    private float alphat;
    private JMapViewer map;

    public RasterMapMarker(Coordinate sw_, Coordinate ne_, BufferedImage img_, float alphat_, JMapViewer map_) {
        this(sw_, ne_, 0.0, img_, alphat_, map_);
    }

    public RasterMapMarker(Coordinate sw_, Coordinate ne_, double radius, BufferedImage img_, float alphat_, JMapViewer map_) {
        super(sw_, radius);
        this.sw = sw_;
        this.ne = ne_;
        this.img = img_;
        this.alphat = alphat_;
        this.map = map_;
    }

    public Coordinate getSWCorner() {
        return this.sw;
    }

    public void setSWCorner(Coordinate sw_) {
        this.sw = sw_;
    }

    public Coordinate getNECorner() {
        return this.ne;
    }

    public void setNECorner(Coordinate ne_) {
        this.ne = ne_;
    }

    public BufferedImage getTile() {
        return this.img;
    }

    public void setTile(BufferedImage img_) {
        this.img = img_;
    }

    public float getTransparency() {
        return this.alphat;
    }

    public void setTransparency(float alphat_) {
        this.alphat = alphat_;
    }

    @Override
    public void paint(Graphics g, Point position, int sc) {
        super.paint(g, position, sc);
        if (this.img != null && this.map != null) {
            Rectangle r = this.map.getVisibleRect();
            double x1r = r.x;
            double y1r = (double)r.y + 0.5 * (double)r.height;
            double x2r = r.x + r.width;
            double y2r = y1r;
            ICoordinate v1r = this.map.getPosition((int)x1r, (int)y1r);
            ICoordinate v2r = this.map.getPosition((int)x2r, (int)y2r);
            double lon1r = v1r.getLon();
            double lon2r = v2r.getLon();
            double R_km = 6378.137;
            double dXr = x2r - x1r;
            double dxr = (lon2r - lon1r) * 6378.137 * Math.PI / 180.0;
            double scale = dxr / dXr;
            double lat_sw = this.sw.getLat();
            double lon_sw = this.sw.getLon();
            double lat_ne = this.ne.getLat();
            double lon_ne = this.ne.getLon();
            double x_sw = 6378.137 * lon_sw * Math.PI / 180.0;
            double y_sw = 6378.137 * Math.log(Math.tan(0.5 * lat_sw * Math.PI / 180.0 + 0.7853981633974483));
            double x_ne = 6378.137 * lon_ne * Math.PI / 180.0;
            double y_ne = 6378.137 * Math.log(Math.tan(0.5 * lat_ne * Math.PI / 180.0 + 0.7853981633974483));
            double dx = x_ne - x_sw;
            double dy = y_ne - y_sw;
            double dM = Math.sqrt(dx * dx + dy * dy);
            double w = this.img.getWidth();
            double h = this.img.getHeight();
            double dr = Math.sqrt(w * w + h * h);
            double mr = dM / (dr * scale);
            int wres = (int)Math.round(w * mr);
            int hres = (int)Math.round(h * mr);
            int px = (int)((double)wres / w);
            Graphics2D g2d = (Graphics2D)g;
            AlphaComposite ac = AlphaComposite.getInstance(3, this.alphat);
            g2d.setComposite(ac);
            int xw = position.x;
            int yw = position.y - hres;
            g2d.drawImage(this.img, xw - px / 2, yw - px / 2, wres + px, hres + px, null);
        }
    }
}

