/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.forms;

import detectprojv2j.algorithms.mapreproject.MapReproject;
import detectprojv2j.algorithms.mosaicmapexport.MosaicMapExport;
import detectprojv2j.comparators.sortJTableColumnByDouble;
import detectprojv2j.forms.EarlyMap;
import detectprojv2j.forms.OSMMap;
import detectprojv2j.io.DXFExport;
import detectprojv2j.io.IO;
import detectprojv2j.structures.graticule.Meridian;
import detectprojv2j.structures.graticule.Parallel;
import detectprojv2j.structures.point.Point3DCartesian;
import detectprojv2j.structures.projection.Projection;
import detectprojv2j.structures.projection.ProjectionCylindrical;
import detectprojv2j.structures.projection.Projections;
import detectprojv2j.types.TMosaicMap;
import detectprojv2j.types.TResult;
import detectprojv2j.types.TTransformedLongitudeDirection;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableRowSorter;

public class ResultsForm
extends JFrame {
    private final EarlyMap early_map;
    private final OSMMap map;
    private final TreeMap<Double, TResult> results;
    private int proj_index;
    boolean[] computation_in_progress;
    private final JFrame frame;
    private JSlider slider;
    private JLabel label;
    private JButton deleteAllInverseReprojectionsButton;
    private JButton deleteInverseReprojectionButton;
    private JToolBar exportGraticuleToolbar;
    private JButton inverseReprojectionButton;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator3;
    private JToolBar reprojectionToolbar;
    private JTable resultsTable;
    private JButton saveInverseReprojectionButton;
    private JButton saveProjectionGraticuleButton;

    public ResultsForm(EarlyMap early_map_, OSMMap map_, TreeMap<Double, TResult> results_, boolean[] computation_in_progress_, int n_rows, JFrame frame_, JSlider slider_, JLabel label_) {
        this.initComponents();
        this.early_map = early_map_;
        this.map = map_;
        this.results = results_;
        this.proj_index = -1;
        this.computation_in_progress = computation_in_progress_;
        this.frame = frame_;
        this.slider = slider_;
        this.label = label_;
        DefaultTableModel model = (DefaultTableModel)this.resultsTable.getModel();
        model.setRowCount(n_rows);
        this.initializeTable();
        this.resultsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(this){
            final /* synthetic */ ResultsForm this$0;
            {
                ResultsForm resultsForm = this$0;
                Objects.requireNonNull(resultsForm);
                this.this$0 = resultsForm;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                this.this$0.proj_index = this.this$0.getSelectedProjIndex();
                if (this.this$0.proj_index < this.this$0.results.size() && this.this$0.proj_index >= 0) {
                    TResult res = this.this$0.results.get(this.this$0.results.keySet().toArray()[this.this$0.proj_index]);
                    this.this$0.early_map.setProjection(res.proj);
                    this.this$0.early_map.setMeridians(res.meridians);
                    this.this$0.early_map.setParallels(res.parallels);
                    this.this$0.early_map.setProjectedMeridians(res.meridians_proj);
                    this.this$0.early_map.setProjectedParallels(res.parallels_proj);
                    this.this$0.early_map.setProjectedPoints(res.points_proj);
                    this.this$0.map.setReprojectedTiles(res.tiles);
                    this.this$0.early_map.repaint();
                    this.this$0.frame.setTitle("Map projection analysis: " + res.proj.getName() + " projection");
                    this.this$0.map.repaintMap();
                }
            }
        });
        this.resultsTable.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ ResultsForm this$0;
            {
                ResultsForm resultsForm = this$0;
                Objects.requireNonNull(resultsForm);
                this.this$0 = resultsForm;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.this$0.proj_index = this.this$0.getSelectedProjIndex();
                if (e.getClickCount() == 2) {
                    this.this$0.performReprojection();
                }
                this.this$0.printResults(20);
                System.out.println("results");
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.resultsTable = new JTable();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.reprojectionToolbar = new JToolBar();
        this.inverseReprojectionButton = new JButton();
        this.saveInverseReprojectionButton = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.deleteInverseReprojectionButton = new JButton();
        this.deleteAllInverseReprojectionsButton = new JButton();
        this.jLabel4 = new JLabel();
        this.exportGraticuleToolbar = new JToolBar();
        this.saveProjectionGraticuleButton = new JButton();
        this.setTitle("List of detected projections and their properties");
        this.setLocation(new Point(50, 500));
        this.setType(Window.Type.UTILITY);
        this.resultsTable.setFont(new Font("Tahoma", 0, 12));
        this.resultsTable.setModel(new DefaultTableModel(this, new Object[][]{{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4", "Title 5", "Title 6", "Title 7", "Title 8", "Title 9", "Title 10", "Title 11", "Title 12", "Title 13", "Title 14", "Title 15", "Title 16", "Title 17", "Title 18", "Title 19"}){
            boolean[] canEdit;
            final /* synthetic */ ResultsForm this$0;
            {
                ResultsForm resultsForm = this$0;
                Objects.requireNonNull(resultsForm);
                this.this$0 = resultsForm;
                super(arg0, arg1);
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.resultsTable.setToolTipText("List of determined projections sorted according to the residuals.. Click on the row to see the reconstructed meridians/parallels, points.");
        this.resultsTable.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.resultsTable);
        this.jLabel1.setText("+ Map  scale refers to the determined  image resolution of:");
        this.jLabel3.setText("* Inverse formulas are supported");
        this.reprojectionToolbar.setRollover(true);
        this.reprojectionToolbar.setMaximumSize(new Dimension(176, 35));
        this.reprojectionToolbar.setMinimumSize(new Dimension(176, 35));
        this.reprojectionToolbar.setPreferredSize(new Dimension(176, 35));
        this.inverseReprojectionButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/reproject3.png")));
        this.inverseReprojectionButton.setToolTipText("Reproject map by tiles to the Web Mercator.");
        this.inverseReprojectionButton.setFocusable(false);
        this.inverseReprojectionButton.setHorizontalTextPosition(0);
        this.inverseReprojectionButton.setVerticalTextPosition(3);
        this.inverseReprojectionButton.addActionListener(new ActionListener(this){
            final /* synthetic */ ResultsForm this$0;
            {
                ResultsForm resultsForm = this$0;
                Objects.requireNonNull(resultsForm);
                this.this$0 = resultsForm;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.inverseReprojectionButtonActionPerformed(evt);
            }
        });
        this.reprojectionToolbar.add(this.inverseReprojectionButton);
        this.saveInverseReprojectionButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/reproject_save3.png")));
        this.saveInverseReprojectionButton.setToolTipText("Save reprojected and georeferenced raster as PNG file.");
        this.saveInverseReprojectionButton.setFocusable(false);
        this.saveInverseReprojectionButton.setHorizontalTextPosition(0);
        this.saveInverseReprojectionButton.setVerticalTextPosition(3);
        this.saveInverseReprojectionButton.addActionListener(new ActionListener(this){
            final /* synthetic */ ResultsForm this$0;
            {
                ResultsForm resultsForm = this$0;
                Objects.requireNonNull(resultsForm);
                this.this$0 = resultsForm;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.saveInverseReprojectionButtonActionPerformed(evt);
            }
        });
        this.reprojectionToolbar.add(this.saveInverseReprojectionButton);
        this.jSeparator3.setDoubleBuffered(true);
        this.reprojectionToolbar.add(this.jSeparator3);
        this.deleteInverseReprojectionButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/reproject_clear2.png")));
        this.deleteInverseReprojectionButton.setToolTipText("Delete selected reprojected raster.");
        this.deleteInverseReprojectionButton.setFocusable(false);
        this.deleteInverseReprojectionButton.setHorizontalTextPosition(0);
        this.deleteInverseReprojectionButton.setVerticalTextPosition(3);
        this.deleteInverseReprojectionButton.addActionListener(new ActionListener(this){
            final /* synthetic */ ResultsForm this$0;
            {
                ResultsForm resultsForm = this$0;
                Objects.requireNonNull(resultsForm);
                this.this$0 = resultsForm;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.deleteInverseReprojectionButtonActionPerformed(evt);
            }
        });
        this.reprojectionToolbar.add(this.deleteInverseReprojectionButton);
        this.deleteAllInverseReprojectionsButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/reproject_clear_all2.png")));
        this.deleteAllInverseReprojectionsButton.setToolTipText("Clear all reproject rasters.");
        this.deleteAllInverseReprojectionsButton.setFocusable(false);
        this.deleteAllInverseReprojectionsButton.setHorizontalTextPosition(0);
        this.deleteAllInverseReprojectionsButton.setVerticalTextPosition(3);
        this.deleteAllInverseReprojectionsButton.addActionListener(new ActionListener(this){
            final /* synthetic */ ResultsForm this$0;
            {
                ResultsForm resultsForm = this$0;
                Objects.requireNonNull(resultsForm);
                this.this$0 = resultsForm;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.deleteAllInverseReprojectionsButtonActionPerformed(evt);
            }
        });
        this.reprojectionToolbar.add(this.deleteAllInverseReprojectionsButton);
        this.exportGraticuleToolbar.setRollover(true);
        this.exportGraticuleToolbar.setMaximumSize(new Dimension(35, 35));
        this.exportGraticuleToolbar.setMinimumSize(new Dimension(35, 35));
        this.exportGraticuleToolbar.setPreferredSize(new Dimension(40, 35));
        this.saveProjectionGraticuleButton.setIcon(new ImageIcon(this.getClass().getResource("/detectprojv2j/resources/reproject_export2.png")));
        this.saveProjectionGraticuleButton.setToolTipText("Save reprojected graticule in DXF file");
        this.saveProjectionGraticuleButton.setFocusable(false);
        this.saveProjectionGraticuleButton.setHorizontalTextPosition(0);
        this.saveProjectionGraticuleButton.setVerticalTextPosition(3);
        this.saveProjectionGraticuleButton.addActionListener(new ActionListener(this){
            final /* synthetic */ ResultsForm this$0;
            {
                ResultsForm resultsForm = this$0;
                Objects.requireNonNull(resultsForm);
                this.this$0 = resultsForm;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.saveProjectionGraticuleButtonActionPerformed(evt);
            }
        });
        this.exportGraticuleToolbar.add(this.saveProjectionGraticuleButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 1800, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4, -2, 110, -2).addContainerGap()).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.exportGraticuleToolbar, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reprojectionToolbar, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.reprojectionToolbar, -2, 31, Short.MAX_VALUE).addComponent(this.exportGraticuleToolbar, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 339, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, -2, 16, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel3))).addGap(6, 6, 6)));
        this.pack();
    }

    private void inverseReprojectionButtonActionPerformed(ActionEvent evt) {
        this.proj_index = this.getSelectedProjIndex();
        if (this.proj_index >= 0) {
            this.performReprojection();
        }
        this.printResults(20);
    }

    public void performReprojection() {
        TResult res = this.results.get(this.results.keySet().toArray()[this.proj_index]);
        if (!this.computation_in_progress[0]) {
            ExecutorService es = Executors.newFixedThreadPool(5);
            this.computation_in_progress[0] = true;
            if (res.tiles == null || res.tiles.size() == 0) {
                double R = 6378137.0;
                double latp = 90.0;
                double lonp = 0.0;
                double lat1 = 0.0;
                double lon0 = 0.0;
                double dX = 0.0;
                double dY = 0.0;
                double c = 1.0;
                double[] sx = new double[]{0.0};
                double[] sy = new double[]{0.0};
                double[] ratio = new double[]{0.0};
                double[] lat_sw = new double[]{0.0};
                double[] lon_sw = new double[]{0.0};
                double[] lat_ne = new double[]{0.0};
                double[] lon_ne = new double[]{0.0};
                this.computation_in_progress[0] = true;
                ProjectionCylindrical merc = new ProjectionCylindrical(6378137.0, 90.0, 0.0, 0.0, TTransformedLongitudeDirection.NormalDirection, 0.0, 0.0, 0.0, 1.0, Projections::F_merc, Projections::G_merc, Projections::FI_merc, Projections::GI_merc, "Mercator", "merc");
                int r_size_max = Math.max(this.early_map.img.getWidth(), this.early_map.img.getHeight());
                int min_tile = 500;
                int max_tile = 1000;
                int tile_size = Math.max(Math.min(r_size_max / 10, 1000), 500);
                MapReproject mw = new MapReproject(this.early_map.img, res.proj, merc, res.map_rotation, tile_size, this.label, this.map);
                Future<?> f = es.submit(mw);
                es.submit(() -> {
                    try {
                        this.computation_in_progress[0] = false;
                        this.label.setText("");
                        res.tiles = this.map.getReprojectedTiles();
                        f.get();
                        this.printResults(20);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            } else {
                this.map.setReprojectedTiles(res.tiles);
                this.map.repaintMap();
            }
            es.shutdown();
            this.computation_in_progress[0] = false;
        }
    }

    private void saveProjectionGraticuleButtonActionPerformed(ActionEvent evt) {
        double lat_step = 10.0;
        double lon_step = 10.0;
        if (this.proj_index >= 0 && !this.computation_in_progress[0] && this.results.size() > 0) {
            this.computation_in_progress[0] = true;
            TResult res = this.results.get(this.results.keySet().toArray()[this.proj_index]);
            List<Point3DCartesian> reference_points_proj = res.points_proj;
            List<Meridian> meridians = res.meridians;
            List<Parallel> parallels = res.parallels;
            Projection proj = res.proj;
            List<List<Point3DCartesian>> meridians_proj = res.meridians_proj;
            List<List<Point3DCartesian>> parallels_proj = res.parallels_proj;
            if (meridians != null && parallels != null && proj != null && meridians_proj != null && parallels_proj != null) {
                JFileChooser fc = new JFileChooser();
                fc.setAcceptAllFileFilterUsed(false);
                FileNameExtensionFilter filter = new FileNameExtensionFilter("CAD files", "dxf");
                fc.setFileFilter(filter);
                Object file_graticule_text = "grat_" + proj.getName() + ".dxf";
                fc.setDialogTitle("Export graticule");
                fc.setCurrentDirectory(new File(System.getProperty("user.home")));
                fc.setSelectedFile(new File((String)file_graticule_text));
                if (fc.showSaveDialog(this) == 0) {
                    try {
                        file_graticule_text = fc.getSelectedFile().toString();
                        double font_height = 0.05 * proj.getR() * Math.min(10.0, 10.0) * Math.PI / 180.0;
                        DXFExport.exportGraticuleToDXF((String)file_graticule_text, meridians, meridians_proj, parallels, parallels_proj, this.early_map.test_points, reference_points_proj, font_height, Math.min(10.0, 10.0));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    private void saveInverseReprojectionButtonActionPerformed(ActionEvent evt) {
        if (this.proj_index >= 0 && !this.computation_in_progress[0] && this.results.size() > 0) {
            this.computation_in_progress[0] = true;
            TResult res = this.results.get(this.results.keySet().toArray()[this.proj_index]);
            if (res.tiles.size() > 0) {
                String mask = "png";
                String file_name = "raster_georef_" + res.proj.getID();
                JFileChooser fc = new JFileChooser();
                fc.setAcceptAllFileFilterUsed(false);
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Image files", "png");
                fc.setFileFilter(filter);
                fc.setDialogTitle("Export georeferenced raster file");
                fc.setCurrentDirectory(new File(System.getProperty("user.home")));
                fc.setSelectedFile(new File(file_name));
                if (fc.showSaveDialog(this) == 0) {
                    ExecutorService es = Executors.newFixedThreadPool(5);
                    try {
                        String file_name_get = fc.getSelectedFile().getPath();
                        MosaicMapExport export = new MosaicMapExport(this.map.getReprojectedTiles(), -1.0, 10000);
                        Future<TMosaicMap> img_reproj_fut = es.submit(export);
                        es.submit(() -> {
                            TMosaicMap img_reproj_mosaic = null;
                            try {
                                img_reproj_mosaic = (TMosaicMap)img_reproj_fut.get();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            String mask2 = "png";
                            IO.saveImage(img_reproj_mosaic.map, file_name_get + ".png", "png");
                            MosaicMapExport.writePGW(img_reproj_mosaic.x_min, img_reproj_mosaic.y_max, img_reproj_mosaic.resolution, file_name_get);
                            MosaicMapExport.writePRJ(file_name_get);
                        });
                        es.shutdown();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.computation_in_progress[0] = false;
        }
    }

    private void deleteInverseReprojectionButtonActionPerformed(ActionEvent evt) {
        if (this.results.size() > 0 && !this.computation_in_progress[0]) {
            this.computation_in_progress[0] = true;
            this.proj_index = this.getSelectedProjIndex();
            if (this.proj_index >= 0) {
                TResult res = this.results.get(this.results.keySet().toArray()[this.proj_index]);
                if (res.tiles != null && res.tiles.size() > 0) {
                    Object[] options = new Object[]{"Clear ", "Cancel"};
                    int response = JOptionPane.showOptionDialog(null, "The reprojected tiles will be deleted. Do you want to continue?", "Warning", 0, 2, null, options, options[1]);
                    if (response == 0) {
                        res.tiles.clear();
                        this.printResults(20);
                    }
                    this.map.repaint();
                }
            }
            this.computation_in_progress[0] = false;
        }
    }

    private void deleteAllInverseReprojectionsButtonActionPerformed(ActionEvent evt) {
        Object[] options;
        int response;
        if (this.results.size() > 0 && !this.computation_in_progress[0] && (response = JOptionPane.showOptionDialog(null, "All reprojected tiles in the list will be deleted. Do you want to continue?", "Warning", 0, 2, null, options = new Object[]{"Clear all ", "Cancel"}, options[1])) == 0) {
            this.computation_in_progress[0] = true;
            for (Map.Entry<Double, TResult> m : this.results.entrySet()) {
                TResult res = m.getValue();
                if (res.tiles == null || res.tiles.size() <= 0) continue;
                res.tiles.clear();
            }
            this.printResults(20);
            this.map.repaint();
            this.computation_in_progress[0] = false;
        }
    }

    private void initializeTable() {
        Object[] col_names = new String[]{"#", "Family", "Projection*", "Reproj.", "Residuals", "R", "latk", "lonk", "lat1", "lat2", "lon0", "dX", "dY", "k", "Map scale+", "Map rotation", "q1", "q2", "Iterations"};
        DefaultTableModel model = (DefaultTableModel)this.resultsTable.getModel();
        model.setColumnIdentifiers(col_names);
        TableRowSorter<DefaultTableModel> trs = new TableRowSorter<DefaultTableModel>(model);
        this.resultsTable.setRowSorter(trs);
        for (int i = 0; i < col_names.length; ++i) {
            trs.setComparator(i, new sortJTableColumnByDouble());
        }
        JTableHeader header = this.resultsTable.getTableHeader();
        DefaultTableCellRenderer r_header_center = (DefaultTableCellRenderer)header.getDefaultRenderer();
        r_header_center.setHorizontalAlignment(0);
        header.setFont(header.getFont().deriveFont(12.0f));
        this.resultsTable.setFont(header.getFont().deriveFont(12.0f));
        DefaultTableCellRenderer r_cells_center = new DefaultTableCellRenderer();
        DefaultTableCellRenderer r_cells_left = new DefaultTableCellRenderer();
        r_cells_center.setHorizontalAlignment(0);
        r_cells_left.setHorizontalAlignment(2);
        for (int i = 0; i < col_names.length; ++i) {
            this.resultsTable.getColumnModel().getColumn(i).setCellRenderer(r_cells_center);
        }
        this.resultsTable.getColumnModel().getColumn(1).setCellRenderer(r_cells_left);
        this.resultsTable.getColumnModel().getColumn(2).setCellRenderer(r_cells_left);
        int col_width = this.resultsTable.getColumnModel().getColumn(1).getPreferredWidth();
        this.resultsTable.getColumnModel().getColumn(0).setPreferredWidth(col_width / 3);
        this.resultsTable.getColumnModel().getColumn(3).setPreferredWidth(col_width / 2);
        this.resultsTable.getColumnModel().getColumn(2).setPreferredWidth((int)(3.2 * (double)col_width));
    }

    public void printResults(int n_results) {
        this.clearTable();
        DefaultTableModel model = (DefaultTableModel)this.resultsTable.getModel();
        model.setRowCount(this.results.size());
        double pixels_mm = this.early_map.getDPI() / 25.4 * 1000.0;
        this.jLabel4.setText(Double.toString(this.early_map.getDPI()) + " DPI");
        int index = 0;
        for (Map.Entry<Double, TResult> resuls_item : this.results.entrySet()) {
            double fx = resuls_item.getKey();
            TResult result = resuls_item.getValue();
            Projection proj = result.proj;
            String reproj_string = result.tiles == null || result.tiles.size() == 0 ? "-" : "x";
            String fx_string = String.format(Locale.ROOT, "%10.3e", fx);
            String R_string = String.format(Locale.ROOT, "%12.3f", proj.getR());
            String latp_string = String.format(Locale.ROOT, "%7.4f", proj.getCartPole().getLat());
            String lonp_string = String.format(Locale.ROOT, "%7.4f", proj.getCartPole().getLon());
            String lat1_string = String.format(Locale.ROOT, "%7.4f", proj.getLat1());
            String lat2_string = String.format(Locale.ROOT, "%7.4f", proj.getLat2());
            String lon0_string = String.format(Locale.ROOT, "%7.4f", proj.getLon0());
            String dX_string = String.format(Locale.ROOT, "%7.3f", proj.getDx());
            String dY_string = String.format(Locale.ROOT, "%7.3f", proj.getDy());
            String c_string = String.format(Locale.ROOT, "%7.3f", proj.getC());
            String map_scale_string = String.format(Locale.ROOT, "%15.1f", result.map_scale * pixels_mm);
            String map_rotation_string = String.format(Locale.ROOT, "%10.4f", result.map_rotation);
            String q1_string = String.format(Locale.ROOT, "%10.8f", result.q1);
            String q2_string = String.format(Locale.ROOT, "%10.8f", result.q2);
            String iterations_string = String.format(Locale.ROOT, "%10d", result.iterations);
            model.setValueAt(index + 1, index, 0);
            model.setValueAt("  " + proj.getFamily(), index, 1);
            model.setValueAt("  " + proj.getName(), index, 2);
            model.setValueAt(reproj_string, index, 3);
            model.setValueAt(fx_string, index, 4);
            model.setValueAt(R_string, index, 5);
            model.setValueAt(latp_string, index, 6);
            model.setValueAt(lonp_string, index, 7);
            model.setValueAt(lat1_string, index, 8);
            model.setValueAt(lat2_string, index, 9);
            model.setValueAt(lon0_string, index, 10);
            model.setValueAt(dX_string, index, 11);
            model.setValueAt(dY_string, index, 12);
            model.setValueAt(c_string, index, 13);
            model.setValueAt(map_scale_string, index, 14);
            model.setValueAt(map_rotation_string, index, 15);
            model.setValueAt(q1_string, index, 16);
            model.setValueAt(q2_string, index, 17);
            model.setValueAt(iterations_string, index, 18);
            ++index;
        }
        this.sortByColumn(4);
    }

    public void clearTable() {
        DefaultTableModel model = (DefaultTableModel)this.resultsTable.getModel();
        int n = model.getRowCount();
        this.proj_index = -1;
        for (int index = 0; index < n; ++index) {
            model.setValueAt("", index, 0);
            model.setValueAt("", index, 1);
            model.setValueAt("", index, 2);
            model.setValueAt("", index, 3);
            model.setValueAt("", index, 4);
            model.setValueAt("", index, 5);
            model.setValueAt("", index, 6);
            model.setValueAt("", index, 7);
            model.setValueAt("", index, 8);
            model.setValueAt("", index, 9);
            model.setValueAt("", index, 10);
            model.setValueAt("", index, 11);
            model.setValueAt("", index, 12);
            model.setValueAt("", index, 13);
            model.setValueAt("", index, 14);
            model.setValueAt("", index, 15);
            model.setValueAt("", index, 16);
            model.setValueAt("", index, 17);
            model.setValueAt("", index, 18);
        }
    }

    private void sortByColumn(int col_index_sort) {
        TableRowSorter trs = (TableRowSorter)this.resultsTable.getRowSorter();
        ArrayList<RowSorter.SortKey> data = new ArrayList<RowSorter.SortKey>();
        data.add(new RowSorter.SortKey(col_index_sort, SortOrder.ASCENDING));
        trs.setSortKeys(data);
        trs.sort();
    }

    private int getSelectedProjIndex() {
        int sel_index = this.resultsTable.getSelectedRow();
        return sel_index > -1 ? this.resultsTable.convertRowIndexToModel(sel_index) : -1;
    }
}

