/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.forms;

import detectprojv2j.comparators.SortPointsByLat;
import detectprojv2j.comparators.SortPointsByLon;
import detectprojv2j.structures.point.Point3DGeographic;
import detectprojv2j.types.TInterval;
import detectprojv2j.types.TTransformedLongitudeDirection;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class Settings
extends JDialog {
    private final List<Point3DGeographic> reference_points;
    private final TTransformedLongitudeDirection[] default_lon_dir;
    private final boolean[] analyze_lon0;
    private final boolean[] create_entire_graticule;
    private final double[] lat1_step;
    private final double[] lat2_step;
    private final double[] lat3_step;
    private final double[] lon1_step;
    private final double[] lon2_step;
    private final double[] lon3_step;
    private final double[] lat_incr;
    private final double[] lon_incr;
    private TInterval lat_extent;
    private TInterval lon_extent;
    private JPanel SamplingStepsPanel;
    private JPanel additionalParametersPanel;
    private JPanel cartographicParametersPanel;
    private JLabel degLabel;
    private JLabel degLabel2;
    private JCheckBox determineLon0CheckBox;
    private JCheckBox generateGraticuleCheckBox;
    private JPanel intervalBetweenMeridianasPanel;
    private JPanel intervalBetweenParallelsPanel;
    private JButton jButton1;
    private JComboBox<String> latitudeExtentComboBox;
    private JLabel latitudeExtentLabel;
    private JLabel latitudeIntervalLabel;
    private JTextField latitudeIntervalTextField;
    private JLabel latitudeOffsetLabel;
    private JComboBox<String> longitudeDirectionComboBox;
    private JLabel longitudeDirectionLabel;
    private JComboBox<String> longitudeExtentComboBox;
    private JLabel longitudeExtentLabel;
    private JLabel longitudeIntervalLabel;
    private JTextField longitudeIntervalTextField;
    private JLabel longitudeOffsetLabel;
    private JLabel meridianSamplingLabel;
    private JTextField meridianSamplingTextField;
    private JLabel parallelSamplingLabel;
    private JTextField parallelSamplingTextField;

    public Settings(List<Point3DGeographic> reference_points_, TTransformedLongitudeDirection[] default_lon_dir_, boolean[] analyze_lon0_, boolean[] create_entire_graticule_, double[] lat1_step_, double[] lat2_step_, double[] lat3_step_, double[] lon1_step_, double[] lon2_step_, double[] lon3_step_, double[] lat_incr_, double[] lon_incr_, TInterval lat_extent_, TInterval lon_extent_) {
        this.initComponents();
        this.reference_points = reference_points_;
        this.default_lon_dir = default_lon_dir_;
        this.analyze_lon0 = analyze_lon0_;
        this.create_entire_graticule = create_entire_graticule_;
        this.lat1_step = lat1_step_;
        this.lat2_step = lat2_step_;
        this.lat3_step = lat3_step_;
        this.lon1_step = lon1_step_;
        this.lon2_step = lon2_step_;
        this.lon3_step = lon3_step_;
        this.lat_incr = lat_incr_;
        this.lon_incr = lon_incr_;
        this.lat_extent = lat_extent_;
        this.lon_extent = lon_extent_;
        InputVerifier lon_step_verifier = new InputVerifier(this){
            final /* synthetic */ Settings this$0;
            {
                Settings settings = this$0;
                Objects.requireNonNull(settings);
                this.this$0 = settings;
            }

            @Override
            public boolean verify(JComponent input) {
                String text = ((JTextField)input).getText();
                try {
                    double lon_step_trial = Double.parseDouble(text);
                    if ((this.this$0.lon_extent.max_value - this.this$0.lon_extent.min_value) / lon_step_trial > 50.0) {
                        JOptionPane.showMessageDialog(this.this$0, "Too small step, computation will take a long time");
                        return false;
                    }
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        };
        InputVerifier lat_step_verifier = new InputVerifier(this){
            final /* synthetic */ Settings this$0;
            {
                Settings settings = this$0;
                Objects.requireNonNull(settings);
                this.this$0 = settings;
            }

            @Override
            public boolean verify(JComponent input) {
                String text = ((JTextField)input).getText();
                try {
                    double lat_step = Double.parseDouble(text);
                    if ((this.this$0.lat_extent.max_value - this.this$0.lat_extent.min_value) / lat_step > 50.0 && this.this$0.reference_points.size() > 1) {
                        JOptionPane.showMessageDialog(this.this$0, "Too small step, computation will take a long time");
                        return false;
                    }
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        };
        InputVerifier lat_sampling_step_verifier = new InputVerifier(this){
            final /* synthetic */ Settings this$0;
            {
                Settings settings = this$0;
                Objects.requireNonNull(settings);
                this.this$0 = settings;
            }

            @Override
            public boolean verify(JComponent input) {
                String text = ((JTextField)input).getText();
                try {
                    double lat_sampling_step = Double.parseDouble(text);
                    if ((this.this$0.lat_extent.max_value - this.this$0.lat_extent.min_value) / lat_sampling_step > 20000.0 && this.this$0.reference_points.size() > 1) {
                        JOptionPane.showMessageDialog(this.this$0, "Too small sampling step, computation will take a long time");
                        return false;
                    }
                    if (lat_sampling_step > 0.5 && this.this$0.reference_points.size() > 1) {
                        JOptionPane.showMessageDialog(this.this$0, "Too large step, inappropriate shape of meridians");
                        return false;
                    }
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        };
        InputVerifier lon_sampling_step_verifier = new InputVerifier(this){
            final /* synthetic */ Settings this$0;
            {
                Settings settings = this$0;
                Objects.requireNonNull(settings);
                this.this$0 = settings;
            }

            @Override
            public boolean verify(JComponent input) {
                String text = ((JTextField)input).getText();
                try {
                    double lon_sampling_step = Double.parseDouble(text);
                    if ((this.this$0.lon_extent.max_value - this.this$0.lon_extent.min_value) / lon_sampling_step > 40000.0 && this.this$0.reference_points.size() > 1) {
                        JOptionPane.showMessageDialog(this.this$0, "Too small step, computation will take a long time");
                        return false;
                    }
                    if (lon_sampling_step > 0.5 && this.this$0.reference_points.size() > 1) {
                        JOptionPane.showMessageDialog(this.this$0, "Too large step, inappropriate shape of parallels");
                        return false;
                    }
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        };
        this.longitudeIntervalTextField.setInputVerifier(lon_step_verifier);
        this.latitudeIntervalTextField.setInputVerifier(lat_step_verifier);
        this.meridianSamplingTextField.setInputVerifier(lat_sampling_step_verifier);
        this.parallelSamplingTextField.setInputVerifier(lon_sampling_step_verifier);
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.cartographicParametersPanel = new JPanel();
        this.longitudeDirectionLabel = new JLabel();
        this.longitudeDirectionComboBox = new JComboBox();
        this.determineLon0CheckBox = new JCheckBox();
        this.intervalBetweenParallelsPanel = new JPanel();
        this.latitudeExtentLabel = new JLabel();
        this.latitudeOffsetLabel = new JLabel();
        this.latitudeExtentComboBox = new JComboBox();
        this.degLabel2 = new JLabel();
        this.latitudeIntervalTextField = new JTextField();
        this.additionalParametersPanel = new JPanel();
        this.generateGraticuleCheckBox = new JCheckBox();
        this.intervalBetweenMeridianasPanel = new JPanel();
        this.longitudeExtentLabel = new JLabel();
        this.longitudeExtentComboBox = new JComboBox();
        this.longitudeOffsetLabel = new JLabel();
        this.degLabel = new JLabel();
        this.longitudeIntervalTextField = new JTextField();
        this.SamplingStepsPanel = new JPanel();
        this.meridianSamplingLabel = new JLabel();
        this.latitudeIntervalLabel = new JLabel();
        this.parallelSamplingLabel = new JLabel();
        this.longitudeIntervalLabel = new JLabel();
        this.meridianSamplingTextField = new JTextField();
        this.parallelSamplingTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Settings");
        this.setLocation(new Point(800, 300));
        this.setModal(true);
        this.setResizable(false);
        this.setType(Window.Type.UTILITY);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ Settings this$0;
            {
                Settings settings = this$0;
                Objects.requireNonNull(settings);
                this.this$0 = settings;
            }

            @Override
            public void windowActivated(WindowEvent evt) {
                this.this$0.formWindowActivated(evt);
            }
        });
        this.jButton1.setText("Close");
        this.jButton1.addActionListener(new ActionListener(this){
            final /* synthetic */ Settings this$0;
            {
                Settings settings = this$0;
                Objects.requireNonNull(settings);
                this.this$0 = settings;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButton1ActionPerformed(evt);
            }
        });
        this.cartographicParametersPanel.setBorder(BorderFactory.createTitledBorder("Cartographic parameters"));
        this.longitudeDirectionLabel.setText("Transformed longitude direction");
        this.longitudeDirectionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Mode M1 (Normal Direction)", "Mode M2 (Reversed Direction)", "Mode M3 (Normal Direction 2)", "Mode M4  (Reversed Direction 2)"}));
        this.longitudeDirectionComboBox.addItemListener(new ItemListener(this){
            final /* synthetic */ Settings this$0;
            {
                Settings settings = this$0;
                Objects.requireNonNull(settings);
                this.this$0 = settings;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                this.this$0.longitudeDirectionComboBoxItemStateChanged(evt);
            }
        });
        this.determineLon0CheckBox.setText("Determine lon0' as the unknown parameter");
        this.determineLon0CheckBox.addItemListener(new ItemListener(this){
            final /* synthetic */ Settings this$0;
            {
                Settings settings = this$0;
                Objects.requireNonNull(settings);
                this.this$0 = settings;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                this.this$0.determineLon0CheckBoxItemStateChanged(evt);
            }
        });
        GroupLayout cartographicParametersPanelLayout = new GroupLayout(this.cartographicParametersPanel);
        this.cartographicParametersPanel.setLayout(cartographicParametersPanelLayout);
        cartographicParametersPanelLayout.setHorizontalGroup(cartographicParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cartographicParametersPanelLayout.createSequentialGroup().addContainerGap().addGroup(cartographicParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cartographicParametersPanelLayout.createSequentialGroup().addComponent(this.longitudeDirectionLabel).addGap(40, 40, 40).addComponent(this.longitudeDirectionComboBox, -2, -1, -2)).addComponent(this.determineLon0CheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        cartographicParametersPanelLayout.setVerticalGroup(cartographicParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(cartographicParametersPanelLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(cartographicParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.longitudeDirectionLabel).addComponent(this.longitudeDirectionComboBox, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.determineLon0CheckBox).addContainerGap(13, Short.MAX_VALUE)));
        this.intervalBetweenParallelsPanel.setBorder(BorderFactory.createTitledBorder("Interval between parallels"));
        this.latitudeExtentLabel.setText("Latitude extent of territory");
        this.latitudeOffsetLabel.setText("Latitude interval");
        this.latitudeExtentComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{">20 deg", ">2 deg", "<2 deg"}));
        this.latitudeExtentComboBox.addItemListener(new ItemListener(this){
            final /* synthetic */ Settings this$0;
            {
                Settings settings = this$0;
                Objects.requireNonNull(settings);
                this.this$0 = settings;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                this.this$0.latitudeExtentComboBoxItemStateChanged(evt);
            }
        });
        this.degLabel2.setText("deg");
        this.latitudeIntervalTextField.setText("10");
        this.latitudeIntervalTextField.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ Settings this$0;
            {
                Settings settings = this$0;
                Objects.requireNonNull(settings);
                this.this$0 = settings;
            }

            @Override
            public void focusLost(FocusEvent evt) {
                this.this$0.latitudeIntervalTextFieldFocusLost(evt);
            }
        });
        GroupLayout intervalBetweenParallelsPanelLayout = new GroupLayout(this.intervalBetweenParallelsPanel);
        this.intervalBetweenParallelsPanel.setLayout(intervalBetweenParallelsPanelLayout);
        intervalBetweenParallelsPanelLayout.setHorizontalGroup(intervalBetweenParallelsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(intervalBetweenParallelsPanelLayout.createSequentialGroup().addContainerGap().addGroup(intervalBetweenParallelsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.latitudeExtentLabel).addComponent(this.latitudeOffsetLabel)).addGap(65, 65, 65).addGroup(intervalBetweenParallelsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(intervalBetweenParallelsPanelLayout.createSequentialGroup().addComponent(this.latitudeIntervalTextField, -2, 36, -2).addGap(21, 21, 21).addComponent(this.degLabel2)).addComponent(this.latitudeExtentComboBox, -2, 92, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        intervalBetweenParallelsPanelLayout.setVerticalGroup(intervalBetweenParallelsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(intervalBetweenParallelsPanelLayout.createSequentialGroup().addGap(18, 18, 18).addGroup(intervalBetweenParallelsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.latitudeExtentLabel).addComponent(this.latitudeExtentComboBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(intervalBetweenParallelsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.latitudeOffsetLabel).addComponent(this.degLabel2).addComponent(this.latitudeIntervalTextField, -2, -1, -2)).addContainerGap(17, Short.MAX_VALUE)));
        this.additionalParametersPanel.setBorder(BorderFactory.createTitledBorder("Additional parameters"));
        this.generateGraticuleCheckBox.setText("Generate graticule over entire planisphere");
        this.generateGraticuleCheckBox.addItemListener(new ItemListener(this){
            final /* synthetic */ Settings this$0;
            {
                Settings settings = this$0;
                Objects.requireNonNull(settings);
                this.this$0 = settings;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                this.this$0.generateGraticuleCheckBoxItemStateChanged(evt);
            }
        });
        GroupLayout additionalParametersPanelLayout = new GroupLayout(this.additionalParametersPanel);
        this.additionalParametersPanel.setLayout(additionalParametersPanelLayout);
        additionalParametersPanelLayout.setHorizontalGroup(additionalParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(additionalParametersPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.generateGraticuleCheckBox, -2, 355, -2).addContainerGap(-1, Short.MAX_VALUE)));
        additionalParametersPanelLayout.setVerticalGroup(additionalParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(additionalParametersPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.generateGraticuleCheckBox, -2, 40, -2).addContainerGap(15, Short.MAX_VALUE)));
        this.intervalBetweenMeridianasPanel.setBorder(BorderFactory.createTitledBorder("Interval between meridians"));
        this.longitudeExtentLabel.setText("Longitude extent of territory");
        this.longitudeExtentComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{">20 deg", ">2 deg", "<2 deg"}));
        this.longitudeExtentComboBox.addItemListener(new ItemListener(this){
            final /* synthetic */ Settings this$0;
            {
                Settings settings = this$0;
                Objects.requireNonNull(settings);
                this.this$0 = settings;
            }

            @Override
            public void itemStateChanged(ItemEvent evt) {
                this.this$0.longitudeExtentComboBoxItemStateChanged(evt);
            }
        });
        this.longitudeOffsetLabel.setText("Longitude interval");
        this.degLabel.setText("deg");
        this.longitudeIntervalTextField.setText("10");
        this.longitudeIntervalTextField.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ Settings this$0;
            {
                Settings settings = this$0;
                Objects.requireNonNull(settings);
                this.this$0 = settings;
            }

            @Override
            public void focusLost(FocusEvent evt) {
                this.this$0.longitudeIntervalTextFieldFocusLost(evt);
            }
        });
        GroupLayout intervalBetweenMeridianasPanelLayout = new GroupLayout(this.intervalBetweenMeridianasPanel);
        this.intervalBetweenMeridianasPanel.setLayout(intervalBetweenMeridianasPanelLayout);
        intervalBetweenMeridianasPanelLayout.setHorizontalGroup(intervalBetweenMeridianasPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(intervalBetweenMeridianasPanelLayout.createSequentialGroup().addContainerGap().addGroup(intervalBetweenMeridianasPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.longitudeExtentLabel).addComponent(this.longitudeOffsetLabel)).addGap(55, 55, 55).addGroup(intervalBetweenMeridianasPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(intervalBetweenMeridianasPanelLayout.createSequentialGroup().addComponent(this.longitudeIntervalTextField, -2, 36, -2).addGap(21, 21, 21).addComponent(this.degLabel)).addComponent(this.longitudeExtentComboBox, -2, 92, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        intervalBetweenMeridianasPanelLayout.setVerticalGroup(intervalBetweenMeridianasPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(intervalBetweenMeridianasPanelLayout.createSequentialGroup().addGap(18, 18, 18).addGroup(intervalBetweenMeridianasPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.longitudeExtentLabel).addComponent(this.longitudeExtentComboBox, -2, -1, -2)).addGap(18, 18, 18).addGroup(intervalBetweenMeridianasPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.longitudeOffsetLabel).addComponent(this.degLabel).addComponent(this.longitudeIntervalTextField, -2, -1, -2)).addContainerGap(17, Short.MAX_VALUE)));
        this.SamplingStepsPanel.setBorder(BorderFactory.createTitledBorder("Meridian/parallel sampling step"));
        this.meridianSamplingLabel.setText("Meridian points sampling step");
        this.latitudeIntervalLabel.setText("x  latitude interval");
        this.parallelSamplingLabel.setText("Parallel points sampling step");
        this.longitudeIntervalLabel.setText("x  longitude interval");
        this.meridianSamplingTextField.setText("0.1");
        this.meridianSamplingTextField.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ Settings this$0;
            {
                Settings settings = this$0;
                Objects.requireNonNull(settings);
                this.this$0 = settings;
            }

            @Override
            public void focusLost(FocusEvent evt) {
                this.this$0.meridianSamplingTextFieldFocusLost(evt);
            }
        });
        this.parallelSamplingTextField.setText("0.1");
        this.parallelSamplingTextField.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ Settings this$0;
            {
                Settings settings = this$0;
                Objects.requireNonNull(settings);
                this.this$0 = settings;
            }

            @Override
            public void focusLost(FocusEvent evt) {
                this.this$0.parallelSamplingTextFieldFocusLost(evt);
            }
        });
        GroupLayout SamplingStepsPanelLayout = new GroupLayout(this.SamplingStepsPanel);
        this.SamplingStepsPanel.setLayout(SamplingStepsPanelLayout);
        SamplingStepsPanelLayout.setHorizontalGroup(SamplingStepsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SamplingStepsPanelLayout.createSequentialGroup().addContainerGap().addGroup(SamplingStepsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.meridianSamplingLabel).addComponent(this.parallelSamplingLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(SamplingStepsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.meridianSamplingTextField, -2, 32, -2).addComponent(this.parallelSamplingTextField, -2, 32, -2)).addGap(22, 22, 22).addGroup(SamplingStepsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.longitudeIntervalLabel, -1, -1, Short.MAX_VALUE).addComponent(this.latitudeIntervalLabel, -1, -1, Short.MAX_VALUE)).addGap(39, 39, 39)));
        SamplingStepsPanelLayout.setVerticalGroup(SamplingStepsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(SamplingStepsPanelLayout.createSequentialGroup().addContainerGap().addGroup(SamplingStepsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.meridianSamplingLabel).addComponent(this.latitudeIntervalLabel).addComponent(this.meridianSamplingTextField, -2, -1, -2)).addGap(18, 18, 18).addGroup(SamplingStepsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.parallelSamplingLabel).addComponent(this.longitudeIntervalLabel).addComponent(this.parallelSamplingTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cartographicParametersPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.intervalBetweenMeridianasPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.intervalBetweenParallelsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.SamplingStepsPanel, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.additionalParametersPanel, -1, -1, Short.MAX_VALUE))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton1, -2, 95, -2).addGap(195, 195, 195)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.cartographicParametersPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.intervalBetweenMeridianasPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.intervalBetweenParallelsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.SamplingStepsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.additionalParametersPanel, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jButton1, -2, 33, -2).addGap(8, 8, 8)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void longitudeDirectionComboBoxItemStateChanged(ItemEvent evt) {
        this.default_lon_dir[0] = TTransformedLongitudeDirection.values()[this.longitudeDirectionComboBox.getSelectedIndex() + 1];
    }

    private void determineLon0CheckBoxItemStateChanged(ItemEvent evt) {
        this.analyze_lon0[0] = this.determineLon0CheckBox.isSelected();
    }

    private void latitudeExtentComboBoxItemStateChanged(ItemEvent evt) {
        switch (this.latitudeExtentComboBox.getSelectedIndex()) {
            case 0: {
                this.latitudeIntervalTextField.setText(String.valueOf(this.lat1_step[0]));
                break;
            }
            case 1: {
                this.latitudeIntervalTextField.setText(String.valueOf(this.lat2_step[0]));
                break;
            }
            case 2: {
                this.latitudeIntervalTextField.setText(String.valueOf(this.lat3_step[0]));
            }
        }
    }

    private void generateGraticuleCheckBoxItemStateChanged(ItemEvent evt) {
        this.create_entire_graticule[0] = this.generateGraticuleCheckBox.isSelected();
    }

    private void longitudeExtentComboBoxItemStateChanged(ItemEvent evt) {
        switch (this.longitudeExtentComboBox.getSelectedIndex()) {
            case 0: {
                this.longitudeIntervalTextField.setText(String.valueOf(this.lon1_step[0]));
                break;
            }
            case 1: {
                this.longitudeIntervalTextField.setText(String.valueOf(this.lon2_step[0]));
                break;
            }
            case 2: {
                this.longitudeIntervalTextField.setText(String.valueOf(this.lon3_step[0]));
            }
        }
    }

    private void longitudeIntervalTextFieldFocusLost(FocusEvent evt) {
        double lon_step_trial = Double.parseDouble(this.longitudeIntervalTextField.getText());
        switch (this.longitudeExtentComboBox.getSelectedIndex()) {
            case 0: {
                this.lon1_step[0] = lon_step_trial;
                break;
            }
            case 1: {
                this.lon1_step[0] = lon_step_trial;
                break;
            }
            case 2: {
                this.lon1_step[0] = lon_step_trial;
            }
        }
    }

    private void latitudeIntervalTextFieldFocusLost(FocusEvent evt) {
        double lat_step_trial = Double.parseDouble(this.latitudeIntervalTextField.getText());
        switch (this.longitudeExtentComboBox.getSelectedIndex()) {
            case 0: {
                this.lat1_step[0] = lat_step_trial;
                break;
            }
            case 1: {
                this.lat2_step[0] = lat_step_trial;
                break;
            }
            case 2: {
                this.lat3_step[0] = lat_step_trial;
            }
        }
    }

    private void meridianSamplingTextFieldFocusLost(FocusEvent evt) {
        double lat_step_trial_ratio = Double.parseDouble(this.meridianSamplingTextField.getText());
        switch (this.latitudeExtentComboBox.getSelectedIndex()) {
            case 0: {
                this.lat_incr[0] = lat_step_trial_ratio * this.lat1_step[0];
                break;
            }
            case 1: {
                this.lat_incr[0] = lat_step_trial_ratio * this.lat2_step[0];
                break;
            }
            case 2: {
                this.lat_incr[0] = lat_step_trial_ratio * this.lat3_step[0];
            }
        }
    }

    private void parallelSamplingTextFieldFocusLost(FocusEvent evt) {
        double lon_step_trial_ratio = Double.parseDouble(this.parallelSamplingTextField.getText());
        switch (this.latitudeExtentComboBox.getSelectedIndex()) {
            case 0: {
                this.lon_incr[0] = lon_step_trial_ratio * this.lon1_step[0];
                break;
            }
            case 1: {
                this.lon_incr[0] = lon_step_trial_ratio * this.lon2_step[0];
                break;
            }
            case 2: {
                this.lon_incr[0] = lon_step_trial_ratio * this.lon3_step[0];
            }
        }
    }

    private void formWindowActivated(WindowEvent evt) {
        if (this.reference_points.size() > 1) {
            double lat_min = this.create_entire_graticule[0] ? -89.0 : Collections.min(this.reference_points, new SortPointsByLat()).getLat();
            double lat_max = this.create_entire_graticule[0] ? 89.0 : Collections.max(this.reference_points, new SortPointsByLat()).getLat();
            double lon_min = this.create_entire_graticule[0] ? -180.0 : Collections.min(this.reference_points, new SortPointsByLon()).getLon();
            double lon_max = this.create_entire_graticule[0] ? 180.0 : Collections.max(this.reference_points, new SortPointsByLon()).getLon();
            this.lat_extent.min_value = lat_min;
            this.lat_extent.max_value = lat_max;
            this.lon_extent.min_value = lon_min;
            this.lon_extent.max_value = lon_max;
        }
    }
}

