/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.io;

import detectprojv2j.structures.graticule.Meridian;
import detectprojv2j.structures.graticule.Parallel;
import detectprojv2j.structures.point.Point3DCartesian;
import detectprojv2j.types.IPoint3DFeatures;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Locale;

public class DXFExport {
    public static void exportGraticuleToDXF(String file_name, List<Meridian> meridians, List<List<Point3DCartesian>> meridians_proj, List<Parallel> parallels, List<List<Point3DCartesian>> parallels_proj, List<Point3DCartesian> test_points, List<Point3DCartesian> reference_points_proj, double font_height, double step) {
        int color_graticule = 8;
        int color_test_points = 5;
        boolean color_reference_points = true;
        String level_meridians = "Meridians";
        String level_parallels = "Parallels";
        String level_meridian_labels = "Meridian_labels";
        String level_parallel_labels = "Parallel_labels";
        String level_test_points = "Test_points";
        String level_test_point_labels = "Test_point_labels";
        String level_proj_reference_points = "Reference_points_proj";
        String level_proj_reference_point_labels = "Reference_points_proj_labels";
        try {
            PrintStream file = new PrintStream(new FileOutputStream(file_name));
            DXFExport.createHeaderSection(file);
            DXFExport.createTableSection(file);
            DXFExport.createLayerSection(file, "Meridians", 8);
            DXFExport.createLayerSection(file, "Parallels", 8);
            DXFExport.createLayerSection(file, "Meridian_labels", 8);
            DXFExport.createLayerSection(file, "Parallel_labels", 8);
            DXFExport.createLayerSection(file, "Test_points", 5);
            DXFExport.createLayerSection(file, "Test_point_labels", 5);
            DXFExport.createLayerSection(file, "Reference_points_proj", 1);
            DXFExport.createLayerSection(file, "Reference_points_proj_labels", 1);
            DXFExport.endTableSection(file);
            DXFExport.createEntitySection(file);
            int nm = meridians_proj.size();
            for (int i = 0; i < nm; ++i) {
                DXFExport.processGraticuleElements(file, meridians_proj.get(i), meridians.get(i).getLon(), "Meridians", "Meridian_labels", font_height, step, 8);
            }
            int np = parallels_proj.size();
            for (int i = 0; i < np; ++i) {
                DXFExport.processGraticuleElements(file, parallels_proj.get(i), parallels.get(i).getLat(), "Parallels", "Parallel_labels", font_height, step, 8);
            }
            int index_test = 0;
            for (Point3DCartesian point : test_points) {
                DXFExport.createPoint(file, "Test_points", point.getX(), point.getY(), point.getZ(), 5);
                String point_label = String.valueOf(++index_test);
                DXFExport.createText(file, "Test_point_labels", point_label, point.getX() + 0.5 * font_height, point.getY() - 0.5 * font_height, point.getZ(), 0.0, font_height, 5);
            }
            int index_reference = 0;
            for (Point3DCartesian point : reference_points_proj) {
                DXFExport.createPoint(file, "Reference_points_proj", point.getX(), point.getY(), point.getZ(), 1);
                String point_label = String.valueOf(++index_reference);
                DXFExport.createText(file, "Reference_points_proj_labels", point_label, point.getX() + 0.5 * font_height, point.getY() - 0.5 * font_height, point.getZ(), 0.0, font_height, 1);
            }
            DXFExport.endHeaderSection(file);
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void exportGraticuleToDXF(String file_name, List<Meridian> meridians, List<List<Point3DCartesian>> meridians_proj, List<Parallel> parallels, List<List<Point3DCartesian>> parallels_proj, double font_height, double step) {
        int color_graticule = 8;
        int color_test_points = 5;
        boolean color_reference_points = true;
        String level_meridians = "Meridians";
        String level_parallels = "Parallels";
        String level_meridian_labels = "Meridian_labels";
        String level_parallel_labels = "Parallel_labels";
        try {
            PrintStream file = new PrintStream(new FileOutputStream(file_name));
            DXFExport.createHeaderSection(file);
            DXFExport.createTableSection(file);
            DXFExport.createLayerSection(file, "Meridians", 8);
            DXFExport.createLayerSection(file, "Parallels", 8);
            DXFExport.createLayerSection(file, "Meridian_labels", 8);
            DXFExport.createLayerSection(file, "Parallel_labels", 8);
            DXFExport.endTableSection(file);
            DXFExport.createEntitySection(file);
            int nm = meridians_proj.size();
            for (int i = 0; i < nm; ++i) {
                DXFExport.processGraticuleElements(file, meridians_proj.get(i), meridians.get(i).getLon(), "Meridians", "Meridian_labels", font_height, step, 8);
            }
            int np = parallels_proj.size();
            for (int i = 0; i < np; ++i) {
                DXFExport.processGraticuleElements(file, parallels_proj.get(i), parallels.get(i).getLat(), "Parallels", "Parallel_labels", font_height, step, 8);
            }
            DXFExport.endHeaderSection(file);
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <Point extends IPoint3DFeatures> void exportPointsToDXF(String file_name, List<Point> points, double font_height, int color) {
        String level_points = "Points";
        String level_point_labels = "Point_labels";
        try {
            PrintStream file = new PrintStream(new FileOutputStream(file_name));
            DXFExport.createHeaderSection(file);
            DXFExport.createTableSection(file);
            DXFExport.createLayerSection(file, level_points, color);
            DXFExport.createLayerSection(file, level_point_labels, color);
            DXFExport.endTableSection(file);
            DXFExport.createEntitySection(file);
            for (IPoint3DFeatures point : points) {
                DXFExport.createPoint(file, level_points, point.getVal1(), point.getVal2(), point.getVal3(), color);
                String point_label = String.valueOf(point.getVal1());
                DXFExport.createText(file, level_point_labels, point_label, (double)point.getVal1() + 0.5 * font_height, point.getVal2() - 0.5 * font_height, point.getVal3(), 0.0, font_height, color);
            }
            DXFExport.endHeaderSection(file);
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createHeaderSection(PrintStream file) {
        String object_type_id = "0";
        String object_type = "SECTION";
        String header_id = "2";
        String header_name = "HEADER";
        String variable_name = "9";
        String acad_version = "$ACADVER";
        String acad_version_id = "1";
        String acad_version_val = "AC1006";
        String section_terminator = "ENDSEC";
        file.println("0");
        file.println("SECTION");
        file.println("2");
        file.println("HEADER");
        file.println("9");
        file.println("$ACADVER");
        file.println("1");
        file.println("AC1006");
        file.println("0");
        file.println("ENDSEC");
    }

    public static void endHeaderSection(PrintStream file) {
        String entity_id = "0";
        String section_terminator = "ENDSEC";
        String file_terminator = "EOF";
        file.println("0");
        file.println("ENDSEC");
        file.println("0");
        file.println("EOF");
    }

    public static void createTableSection(PrintStream file) {
        String object_type_id = "0";
        String object_name = "SECTION";
        String table_id = "2";
        String table = "TABLES";
        String table_name = "TABLE";
        String layer_name = "LAYER";
        String max_number_of_entries_id = "70";
        String max_number_of_entries = "0";
        file.println("0");
        file.println("SECTION");
        file.println("2");
        file.println("TABLES");
        file.println("0");
        file.println("TABLE");
        file.println("2");
        file.println("LAYER");
        file.println("70");
        file.println("0");
    }

    public static void endTableSection(PrintStream file) {
        String object_type_id = "0";
        String table_end_name = "ENDTAB";
        String section_end_name = "ENDSEC";
        file.println("0");
        file.println("ENDTAB");
        file.println("0");
        file.println("ENDSEC");
    }

    public static void createLayerSection(PrintStream file, String layer_name, int color) {
        String object_type_id = "0";
        String object_name = "LAYER";
        String layer_name_id = "2";
        String layer_flag_id = "70";
        String layer_flag = "0";
        String color_number_id = "62";
        String line_type_id = "6";
        String line_type_name = "CONTINUOUS";
        file.println("0");
        file.println("LAYER");
        file.println("2");
        file.println(layer_name);
        file.println("70");
        file.println("0");
        file.println("62");
        file.println(color);
        file.println("6");
        file.println("CONTINUOUS");
    }

    public static void createEntitySection(PrintStream file) {
        String object_type_id = "0";
        String object_name = "SECTION";
        String entity_name_id = "2";
        String entity_name = "ENTITIES";
        file.println("0");
        file.println("SECTION");
        file.println("2");
        file.println("ENTITIES");
    }

    public static void createLine(PrintStream file, String layer_name, double x1, double y1, double z1, double x2, double y2, double z2) {
        String entity_id = "0";
        String entity_name = "LINE";
        String level_id = "8";
        String xi_id = "10";
        String yi_id = "20";
        String zi_id = "30";
        String xii_id = "11";
        String yii_id = "21";
        String zii_id = "31";
        file.println("0");
        file.println("LINE");
        file.println("8");
        file.println(layer_name);
        file.println("10");
        file.printf(Locale.ROOT, "%.5f%n", x1);
        file.println("20");
        file.printf(Locale.ROOT, "%.5f%n", y1);
        file.println("30");
        file.printf(Locale.ROOT, "%.5f%n", z1);
        file.println("11");
        file.printf(Locale.ROOT, "%.5f%n", x2);
        file.println("21");
        file.printf(Locale.ROOT, "%.5f%n", y2);
        file.println("31");
        file.printf(Locale.ROOT, "%.5f%n", z2);
    }

    public static void createPoint(PrintStream file, String layer_name, double x, double y, double z, int color) {
        String entity_id = "0";
        String entity_name = "POINT";
        String level_id = "8";
        String color_id = "62";
        String xi_id = "10";
        String yi_id = "20";
        String zi_id = "30";
        file.println("0");
        file.println("POINT");
        file.println("8");
        file.println(layer_name);
        file.println("62");
        file.printf(Locale.ROOT, "%d%n", color);
        file.println("10");
        file.printf(Locale.ROOT, "%.5f%n", x);
        file.println("20");
        file.printf(Locale.ROOT, "%.5f%n", y);
        file.println("30");
        file.printf(Locale.ROOT, "%.5f%n", z);
    }

    public static void createText(PrintStream file, String layer_name, String text, double x, double y, double z, double rotation, double height, int color) {
        String entity_id = "0";
        String entity_name = "TEXT";
        String style_id = "7";
        String text_style = "PNTNUM";
        String rotation_id = "50";
        String level_id = "8";
        String color_id = "62";
        String xi_id = "10";
        String yi_id = "20";
        String zi_id = "30";
        String height_id = "40";
        String text_id = "1";
        file.println("0");
        file.println("TEXT");
        file.println("7");
        file.println("PNTNUM");
        file.println("50");
        file.printf(Locale.ROOT, "%.5f%n", rotation);
        file.println("8");
        file.println(layer_name);
        file.println("62");
        file.printf(Locale.ROOT, "%d%n", color);
        file.println("10");
        file.printf(Locale.ROOT, "%.5f%n", x);
        file.println("20");
        file.printf(Locale.ROOT, "%.5f%n", y);
        file.println("30");
        file.printf(Locale.ROOT, "%.5f%n", z);
        file.println("40");
        file.printf(Locale.ROOT, "%.5f%n", height);
        file.println("1");
        file.println(text);
    }

    public static void processGraticuleElements(PrintStream file, List<Point3DCartesian> part, double val, String layer_graticule_name, String layer_labels_name, double font_height, double step, int color) {
        int n = part.size();
        for (int i = 1; i < n; ++i) {
            Point3DCartesian p = part.get(i);
            Point3DCartesian p_previous = part.get(i - 1);
            DXFExport.createLine(file, layer_graticule_name, p_previous.getX(), p_previous.getY(), p_previous.getZ(), p.getX(), p.getY(), p.getZ());
        }
        if (n > 1) {
            String point_id_text = step > 1.0 ? String.format("%.1f", val) : (step > 0.1 ? String.format("%.2f", val) : String.format("%.3f", val));
            Point3DCartesian p1 = part.get(n / 2 - 1);
            Point3DCartesian p2 = part.get(n / 2);
            double bearing = Math.atan2(p2.getY() - p1.getY(), p2.getX() - p1.getX()) * 57.29577951308232;
            DXFExport.createText(file, layer_labels_name, point_id_text, part.get(n / 2 - 1).getX() + 0.5 * font_height * Math.cos(bearing * Math.PI / 180.0), part.get(n / 2 - 1).getY() + 0.5 * font_height * Math.sin(bearing * Math.PI / 180.0), part.get(0).getZ(), bearing, font_height, color);
        }
    }
}

