/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.io;

import detectprojv2j.exceptions.BadDataException;
import detectprojv2j.types.GenericType;
import detectprojv2j.types.IPoint3DFeatures;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import javax.imageio.ImageIO;

public class IO {
    public static <Point> void load3DPoints(String file, List<Point> points, Class<Point> o_class) {
        List<List<String>> file_content = IO.loadFileToWords(file);
        IO.convertTo3DPoints(file_content, points, o_class);
    }

    public static <Point> void load2DPoints(String file, List<Point> points, Class<Point> o_class) {
        List<List<String>> file_content = IO.loadFileToWords(file);
        IO.convertTo2DPoints(file_content, points, o_class);
    }

    public static List<List<String>> loadFileToWords(String file_name) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        try {
            Scanner s = new Scanner(new File(file_name));
            while (s.hasNextLine()) {
                String[] words = s.nextLine().split("\\s+");
                if (words[0].isEmpty()) continue;
                ArrayList<String> line = new ArrayList<String>(Arrays.asList(words));
                list.add(line);
            }
            s.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static <Point> void convertTo2DPoints(List<List<String>> file_content, List<Point> points, Class<Point> o_class) {
        points.clear();
        for (int i = 0; i < file_content.size(); ++i) {
            Point point_temp;
            GenericType<Point> gp;
            if (file_content.get(i).size() == 3) {
                gp = new GenericType<Point>(o_class);
                point_temp = gp.create(file_content.get(i).get(0), Double.parseDouble(file_content.get(i).get(1)), Double.parseDouble(file_content.get(i).get(2)), 0.0);
                points.add(point_temp);
                continue;
            }
            if (file_content.get(i).size() == 2) {
                gp = new GenericType<Point>(o_class);
                point_temp = gp.create(Double.parseDouble(file_content.get(i).get(0)), Double.parseDouble(file_content.get(i).get(1)), 0.0);
                points.add(point_temp);
                continue;
            }
            throw new BadDataException("BadDataException: unknown data format. ", "Can't read the file.");
        }
    }

    public static <Point> void convertTo3DPoints(List<List<String>> file_content, List<Point> points, Class<Point> o_class) {
        points.clear();
        for (int i = 0; i < file_content.size(); ++i) {
            Point point_temp;
            GenericType<Point> gp;
            if (file_content.get(i).size() == 4) {
                gp = new GenericType<Point>(o_class);
                point_temp = gp.create(file_content.get(i).get(0), Double.parseDouble(file_content.get(i).get(1)), Double.parseDouble(file_content.get(i).get(2)), Double.parseDouble(file_content.get(i).get(3)));
                points.add(point_temp);
                continue;
            }
            if (file_content.get(i).size() == 3) {
                gp = new GenericType<Point>(o_class);
                point_temp = gp.create(Double.parseDouble(file_content.get(i).get(0)), Double.parseDouble(file_content.get(i).get(1)), Double.parseDouble(file_content.get(i).get(2)));
                points.add(point_temp);
                continue;
            }
            throw new BadDataException("BadDataException: unknown data format. ", "Can't read the file.");
        }
    }

    public static <Point extends IPoint3DFeatures> void save2DPoints(String file_text, List<Point> points) {
        try {
            File file = new File(file_text);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            for (IPoint3DFeatures point : points) {
                fw.write(point.getVal2() + "\t" + point.getVal3() + "\n");
            }
            fw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveImage(BufferedImage img, String file_name, String mask) {
        try {
            File output_file = new File(file_name);
            ImageIO.write((RenderedImage)img, mask, output_file);
        }
        catch (IOException evt) {
            evt.printStackTrace();
        }
    }

    public static void saveTextFile(String text, String file_name) {
        try {
            File output_file = new File(file_name);
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(output_file), StandardCharsets.US_ASCII);
            w.write(text);
            ((Writer)w).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

