/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.structures.graticule;

import detectprojv2j.algorithms.angle3points.Angle3Points;
import detectprojv2j.algorithms.carttransformation.CartTransformation;
import detectprojv2j.algorithms.round.Round;
import detectprojv2j.algorithms.singularitydetection.SingularityDetection;
import detectprojv2j.exceptions.MathException;
import detectprojv2j.exceptions.MathInvalidArgumentException;
import detectprojv2j.structures.point.Point3DCartesian;
import detectprojv2j.structures.projection.Projection;
import detectprojv2j.types.TInterval;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Meridian {
    private final double lon;
    private final TInterval lat_interval;
    private final double dlat;
    private final double dff;
    private final double lat_min_shift;
    private final double lat_max_shift;
    private final List<Double> lats;

    public Meridian(double lon_) {
        this.lon = lon_;
        this.lat_interval = new TInterval(-90.0, 90.0);
        this.dlat = 10.0;
        this.dff = 0.0;
        this.lat_min_shift = 0.0;
        this.lat_max_shift = 0.0;
        this.lats = new ArrayList<Double>();
        this.createMeridian();
    }

    public Meridian(double lon_, TInterval lat_interval_, double dlat_, double lat_min_shift_, double lat_max_shift_) {
        this.lon = lon_;
        this.lat_interval = lat_interval_;
        this.dlat = dlat_;
        this.dff = 0.0;
        this.lat_min_shift = lat_min_shift_;
        this.lat_max_shift = lat_max_shift_;
        this.lats = new ArrayList<Double>();
        this.createMeridian();
    }

    public Meridian(double lon_, TInterval lat_interval_, double dff_, double lat_min_shift_, double lat_max_shift_, Projection proj, double alpha, List<Point3DCartesian> mer_proj, double fmax_, int dmin_, int dmax_, double eps_) {
        this.lon = lon_;
        this.lat_interval = lat_interval_;
        this.dlat = 0.0;
        this.dff = dff_;
        this.lat_min_shift = lat_min_shift_;
        this.lat_max_shift = lat_max_shift_;
        this.lats = new ArrayList<Double>();
        this.createMeridianAS(proj, alpha, mer_proj, fmax_, dmin_, dmax_, eps_);
    }

    public double getLon() {
        return this.lon;
    }

    public TInterval getLatInterval() {
        return this.lat_interval;
    }

    public double getDLat() {
        return this.dlat;
    }

    public double getLatMinShift() {
        return this.lat_min_shift;
    }

    public double getLatMaxShift() {
        return this.lat_max_shift;
    }

    public List<Double> getLats() {
        return this.lats;
    }

    public void createMeridian() {
        double lat_start = Round.roundToMultipleFloor(this.lat_interval.min_value, this.dlat) + this.dlat;
        double lat_end = Round.roundToMultipleCeil(this.lat_interval.max_value, this.dlat) - this.dlat;
        double lat_lb = Math.max(Math.min(this.lat_interval.min_value + this.lat_min_shift, 90.0), -90.0);
        lat_lb = Math.min(lat_lb, this.lat_interval.max_value);
        this.lats.add(lat_lb);
        for (double lat_point = lat_start; lat_point <= lat_end; lat_point += this.dlat) {
            this.lats.add(lat_point);
        }
        double lat_ub = Math.min(Math.max(this.lat_interval.max_value - this.lat_max_shift, -90.0), 90.0);
        lat_ub = Math.max(lat_ub, this.lat_interval.min_value);
        this.lats.add(lat_ub);
    }

    public void project(Projection proj, double alpha, List<Point3DCartesian> mer) {
        for (double lat : this.lats) {
            double[] X = new double[]{0.0};
            double[] Y = new double[]{0.0};
            double[] lat_trans = new double[]{0.0};
            double[] lon_trans = new double[]{0.0};
            try {
                CartTransformation.latLonToXY(lat, this.lon, proj, alpha, lat_trans, lon_trans, X, Y);
                if (Double.isNaN(X[0]) || Double.isInfinite(X[0])) {
                    throw new MathInvalidArgumentException("MathException: can not project meridian point, ", "1.0 / r, r = 0:", X[0]);
                }
                if (Double.isNaN(Y[0]) || Double.isInfinite(Y[0])) {
                    throw new MathInvalidArgumentException("MathException: can not project meridian point, ", "1.0 / r, r = 0:", Y[0]);
                }
            }
            catch (MathException error) {
                SingularityDetection.checkProjDiscontinuity(lat, this.lon, proj, alpha, 1.0E9, 0.001);
            }
            Point3DCartesian p_proj = new Point3DCartesian(X[0], Y[0], 0.0);
            mer.add(p_proj);
        }
    }

    public void print(PrintStream output) {
        for (double lat : this.lats) {
            output.println("[" + lat + ", " + this.lon + "]  ");
        }
        output.println(20);
    }

    public void createMeridianAS(Projection proj, double alpha, List<Point3DCartesian> mer_proj, double fmax, int dmin, int dmax, double eps) {
        this.asInit(proj, alpha, mer_proj, fmax, dmin, dmax, eps);
    }

    public void asInit(Projection proj, double alpha, List<Point3DCartesian> mer_proj, double fmax, int dmin, int dmax, double eps) {
        int d = 0;
        double[] xa = new double[]{0.0};
        double[] ya = new double[]{0.0};
        double[] xb = new double[]{0.0};
        double[] yb = new double[]{0.0};
        double[] lat_trans_a = new double[]{0.0};
        double[] lon_trans_a = new double[]{0.0};
        double[] lat_trans_b = new double[]{0.0};
        double[] lon_trans_b = new double[]{0.0};
        double a = this.lat_interval.min_value;
        double b = this.lat_interval.max_value;
        SingularityDetection.checkProjDiscontinuity(a, this.lon, proj, alpha, fmax, 0.5 * eps);
        SingularityDetection.checkProjDiscontinuity(b, this.lon, proj, alpha, fmax, 0.5 * eps);
        CartTransformation.latLonToXY(a, this.lon, proj, alpha, lat_trans_a, lon_trans_a, xa, ya);
        CartTransformation.latLonToXY(b, this.lon, proj, alpha, lat_trans_b, lon_trans_b, xb, yb);
        this.lats.add(a);
        Point3DCartesian pa = new Point3DCartesian(xa[0], ya[0]);
        mer_proj.add(pa);
        this.asPoints3(proj, alpha, mer_proj, a, b, a, b, xa[0], ya[0], xb[0], yb[0], d, fmax, dmin, dmax, eps);
        this.lats.add(b);
        Point3DCartesian pb = new Point3DCartesian(xb[0], yb[0]);
        mer_proj.add(pb);
    }

    public void asPoints3(Projection proj, double alpha, List<Point3DCartesian> mer_proj, double a, double b, double ap, double bn, double xa, double ya, double xb, double yb, int d, double fmax, int dmin, int dmax, double eps) {
        double alpha4;
        double r_min = 0.45;
        double r_max = 0.55;
        Random r = new Random();
        if (d >= dmax) {
            return;
        }
        if (b - a < eps) {
            return;
        }
        double r0 = 0.55;
        double r1 = 0.45 + r.nextDouble() * 0.10000000000000003;
        double r2 = 0.45 + r.nextDouble() * 0.10000000000000003;
        double r3 = 0.45 + r.nextDouble() * 0.10000000000000003;
        double r4 = 0.55;
        double lat0 = a + 0.55 * (ap - a) / 2.0;
        double lat1 = a + r1 * (b - a) / 2.0;
        double lat2 = a + r2 * (b - a);
        double lat3 = a + r3 * (b - a) * 3.0 / 2.0;
        double lat4 = b + 0.55 * (bn - b) / 2.0;
        double[] x0 = new double[]{0.0};
        double[] y0 = new double[]{0.0};
        double[] x1 = new double[]{0.0};
        double[] y1 = new double[]{0.0};
        double[] x2 = new double[]{0.0};
        double[] y2 = new double[]{0.0};
        double[] x3 = new double[]{0.0};
        double[] y3 = new double[]{0.0};
        double[] x4 = new double[]{0.0};
        double[] y4 = new double[]{0.0};
        double[] lat_trans = new double[]{0.0};
        double[] lon_trans = new double[]{0.0};
        try {
            CartTransformation.latLonToXY(lat0, this.lon, proj, alpha, lat_trans, lon_trans, x0, y0);
            if (Double.isNaN(x0[0]) || Double.isInfinite(x0[0])) {
                throw new MathInvalidArgumentException("MathException: can not project meridian point, ", "1.0 / r, r = 0:", x0[0]);
            }
            if (Double.isNaN(y0[0]) || Double.isInfinite(y0[0])) {
                throw new MathInvalidArgumentException("MathException: can not project meridian point, ", "1.0 / r, r = 0:", y0[0]);
            }
        }
        catch (MathException error) {
            SingularityDetection.checkProjDiscontinuity(lat0, this.lon, proj, alpha, fmax, 0.5 * eps);
        }
        try {
            CartTransformation.latLonToXY(lat1, this.lon, proj, alpha, lat_trans, lon_trans, x1, y1);
            if (Double.isNaN(x1[0]) || Double.isInfinite(x1[0])) {
                throw new MathInvalidArgumentException("MathException: can not project meridian point, ", "1.0 / r, r = 0:", x1[0]);
            }
            if (Double.isNaN(y1[0]) || Double.isInfinite(y1[0])) {
                throw new MathInvalidArgumentException("MathException: can not project meridian point, ", "1.0 / r, r = 0:", y1[0]);
            }
        }
        catch (MathException error) {
            SingularityDetection.checkProjDiscontinuity(lat1, this.lon, proj, alpha, fmax, 0.5 * eps);
        }
        try {
            CartTransformation.latLonToXY(lat2, this.lon, proj, alpha, lat_trans, lon_trans, x2, y2);
            if (Double.isNaN(x2[0]) || Double.isInfinite(x2[0])) {
                throw new MathInvalidArgumentException("MathException: can not project meridian point, ", "1.0 / r, r = 0:", x2[0]);
            }
            if (Double.isNaN(y2[0]) || Double.isInfinite(y2[0])) {
                throw new MathInvalidArgumentException("MathException: can not project meridian point, ", "1.0 / r, r = 0:", y2[0]);
            }
        }
        catch (MathException error) {
            SingularityDetection.checkProjDiscontinuity(lat2, this.lon, proj, alpha, fmax, 0.5 * eps);
        }
        try {
            CartTransformation.latLonToXY(lat3, this.lon, proj, alpha, lat_trans, lon_trans, x3, y3);
            if (Double.isNaN(x3[0]) || Double.isInfinite(x3[0])) {
                throw new MathInvalidArgumentException("MathException: can not project meridian point, ", "1.0 / r, r = 0:", x3[0]);
            }
            if (Double.isNaN(y3[0]) || Double.isInfinite(y3[0])) {
                throw new MathInvalidArgumentException("MathException: can not project meridian point, ", "1.0 / r, r = 0:", y3[0]);
            }
        }
        catch (MathException error) {
            SingularityDetection.checkProjDiscontinuity(lat3, this.lon, proj, alpha, fmax, 0.5 * eps);
        }
        try {
            CartTransformation.latLonToXY(lat4, this.lon, proj, alpha, lat_trans, lon_trans, x4, y4);
            if (Double.isNaN(x4[0]) || Double.isInfinite(x4[0])) {
                throw new MathInvalidArgumentException("MathException: can not project meridian point, ", "1.0 / r, r = 0:", x4[0]);
            }
            if (Double.isNaN(y4[0]) || Double.isInfinite(y4[0])) {
                throw new MathInvalidArgumentException("MathException: can not project meridian point, ", "1.0 / r, r = 0:", y4[0]);
            }
        }
        catch (MathException error) {
            SingularityDetection.checkProjDiscontinuity(lat4, this.lon, proj, alpha, fmax, 0.5 * eps);
        }
        double alpha0 = Math.abs(lat0 - a) > eps ? Math.abs(Angle3Points.getAngle3Points(x0[0], y0[0], xa, ya, x1[0], y1[0]) - 180.0) : 0.0;
        double alpha1 = Math.abs(Angle3Points.getAngle3Points(xa, ya, x1[0], y1[0], x2[0], y2[0]) - 180.0);
        double alpha2 = Math.abs(Angle3Points.getAngle3Points(x1[0], y1[0], x2[0], y2[0], x3[0], y3[0]) - 180.0);
        double alpha3 = Math.abs(Angle3Points.getAngle3Points(x2[0], y2[0], x3[0], y3[0], xb, yb) - 180.0);
        double d2 = alpha4 = Math.abs(lat4 - b) > eps ? Math.abs(Angle3Points.getAngle3Points(x3[0], y3[0], xb, yb, x4[0], y4[0]) - 180.0) : 0.0;
        if (alpha0 > this.dff || alpha1 > this.dff || alpha2 > this.dff || alpha3 > this.dff || alpha4 > this.dff || d < dmin) {
            this.asPoints3(proj, alpha, mer_proj, a, lat1, lat0, lat2, xa, ya, x1[0], y1[0], d + 1, fmax, dmin, dmax, eps);
        }
        this.lats.add(lat1);
        Point3DCartesian p1 = new Point3DCartesian(x1[0], y1[0]);
        mer_proj.add(p1);
        if (alpha0 > this.dff || alpha1 > this.dff || alpha2 > this.dff || alpha3 > this.dff || alpha4 > this.dff || d < dmin) {
            this.asPoints3(proj, alpha, mer_proj, lat1, lat2, a, lat3, x1[0], y1[0], x2[0], y2[0], d + 1, fmax, dmin, dmax, eps);
        }
        this.lats.add(lat2);
        Point3DCartesian p2 = new Point3DCartesian(x2[0], y2[0]);
        mer_proj.add(p2);
        if (alpha0 > this.dff || alpha1 > this.dff || alpha2 > this.dff || alpha3 > this.dff || alpha4 > this.dff || d < dmin) {
            this.asPoints3(proj, alpha, mer_proj, lat2, lat3, lat1, b, x2[0], y2[0], x3[0], y3[0], d + 1, fmax, dmin, dmax, eps);
        }
        this.lats.add(lat3);
        Point3DCartesian p3 = new Point3DCartesian(x3[0], y3[0]);
        mer_proj.add(p3);
        if (alpha0 > this.dff || alpha1 > this.dff || alpha2 > this.dff || alpha3 > this.dff || alpha4 > this.dff || d < dmin) {
            this.asPoints3(proj, alpha, mer_proj, lat3, b, lat2, lat4, x3[0], y3[0], xb, yb, d + 1, fmax, dmin, dmax, eps);
        }
    }
}

