/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.structures.graticule;

import detectprojv2j.algorithms.angle3points.Angle3Points;
import detectprojv2j.algorithms.carttransformation.CartTransformation;
import detectprojv2j.algorithms.round.Round;
import detectprojv2j.algorithms.singularitydetection.SingularityDetection;
import detectprojv2j.exceptions.MathException;
import detectprojv2j.exceptions.MathInvalidArgumentException;
import detectprojv2j.structures.point.Point3DCartesian;
import detectprojv2j.structures.point.Point3DGeographic;
import detectprojv2j.structures.projection.Projection;
import detectprojv2j.types.TInterval;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Parallel {
    private final double lat;
    private final TInterval lon_interval;
    private final double dlon;
    private final double dff;
    private final double lon_min_shift;
    private final double lon_max_shift;
    private final List<Double> lons;

    public Parallel(double lat_) {
        this.lat = lat_;
        this.lon_interval = new TInterval(-180.0, 180.0);
        this.dlon = 10.0;
        this.dff = 0.0;
        this.lon_min_shift = 0.0;
        this.lon_max_shift = 0.0;
        this.lons = new ArrayList<Double>();
        this.createParallel();
    }

    public Parallel(double lat_, TInterval lon_interval_, double dlon_, double lon_min_shift_, double lon_max_shift_) {
        this.lat = lat_;
        this.lon_interval = lon_interval_;
        this.dlon = dlon_;
        this.dff = 0.0;
        this.lon_min_shift = lon_min_shift_;
        this.lon_max_shift = lon_max_shift_;
        this.lons = new ArrayList<Double>();
        this.createParallel();
    }

    public Parallel(double lat_, TInterval lon_interval_, double dff_, double lon_min_shift_, double lon_max_shift_, Projection proj, double alpha, List<Point3DCartesian> mer_proj, double fmax_, int dmin_, int dmax_, double eps_) {
        this.lat = lat_;
        this.lon_interval = lon_interval_;
        this.dlon = 0.0;
        this.dff = dff_;
        this.lon_min_shift = lon_min_shift_;
        this.lon_max_shift = lon_max_shift_;
        this.lons = new ArrayList<Double>();
        this.createParallelAS(proj, alpha, mer_proj, fmax_, dmin_, dmax_, eps_);
    }

    public double getLat() {
        return this.lat;
    }

    public TInterval getLonInterval() {
        return this.lon_interval;
    }

    public double getDLon() {
        return this.dlon;
    }

    public double getLonMinShift() {
        return this.lon_min_shift;
    }

    public double getLonMaxShift() {
        return this.lon_max_shift;
    }

    public List<Double> getLons() {
        return this.lons;
    }

    public void createParallel() {
        double lon_start = Round.roundToMultipleFloor(this.lon_interval.min_value, this.dlon) + this.dlon;
        double lon_end = Round.roundToMultipleCeil(this.lon_interval.max_value, this.dlon) - this.dlon;
        double lon_lb = Math.max(Math.min(this.lon_interval.min_value + this.lon_min_shift, 180.0), -180.0);
        lon_lb = Math.min(lon_lb, this.lon_interval.max_value);
        this.lons.add(lon_lb);
        for (double lon_point = lon_start; lon_point <= lon_end; lon_point += this.dlon) {
            this.lons.add(lon_point);
        }
        double lon_ub = Math.min(Math.max(this.lon_interval.max_value - this.lon_max_shift, -180.0), 180.0);
        lon_ub = Math.max(lon_ub, this.lon_interval.min_value);
        this.lons.add(lon_ub);
    }

    public void project(Projection proj, double alpha, List<Point3DCartesian> par) {
        Point3DGeographic pole = proj.getCartPole();
        for (double lon : this.lons) {
            double[] X = new double[]{0.0};
            double[] Y = new double[]{0.0};
            double[] lat_trans = new double[]{0.0};
            double[] lon_trans = new double[]{0.0};
            try {
                CartTransformation.latLonToXY(this.lat, lon, proj, alpha, lat_trans, lon_trans, X, Y);
                if (Double.isNaN(X[0]) || Double.isInfinite(X[0])) {
                    throw new MathInvalidArgumentException("MathException: can not project parallel point, ", "1.0 / r, r = 0:", X[0]);
                }
                if (Double.isNaN(Y[0]) || Double.isInfinite(Y[0])) {
                    throw new MathInvalidArgumentException("MathException: can not project parallel point, ", "1.0 / r, r = 0:", Y[0]);
                }
            }
            catch (MathException error) {
                SingularityDetection.checkProjDiscontinuity(this.lat, lon, proj, alpha, 1.0E9, 0.001);
            }
            Point3DCartesian p_proj = new Point3DCartesian(X[0], Y[0], 0.0);
            par.add(p_proj);
        }
    }

    public void print(PrintStream output) {
        for (double lon : this.lons) {
            output.println("[" + this.lat + ", " + lon + "]  ");
        }
        output.println(20);
    }

    public void createParallelAS(Projection proj, double alpha, List<Point3DCartesian> par_proj, double fmax, int dmin, int dmax, double eps) {
        this.asInit(proj, alpha, par_proj, fmax, dmin, dmax, eps);
    }

    public void asInit(Projection proj, double alpha, List<Point3DCartesian> par_proj, double fmax, int dmin, int dmax, double eps) {
        int d = 0;
        double[] xa = new double[]{0.0};
        double[] xb = new double[]{0.0};
        double[] ya = new double[]{0.0};
        double[] yb = new double[]{0.0};
        double[] lat_trans_a = new double[]{0.0};
        double[] lat_trans_b = new double[]{0.0};
        double[] lon_trans_a = new double[]{0.0};
        double[] lon_trans_b = new double[]{0.0};
        double a = this.lon_interval.min_value;
        double b = this.lon_interval.max_value;
        SingularityDetection.checkProjDiscontinuity(this.lat, a, proj, alpha, fmax, 0.5 * eps);
        SingularityDetection.checkProjDiscontinuity(this.lat, b, proj, alpha, fmax, 0.5 * eps);
        CartTransformation.latLonToXY(this.lat, a, proj, alpha, lat_trans_a, lon_trans_a, xa, ya);
        CartTransformation.latLonToXY(this.lat, b, proj, alpha, lat_trans_b, lon_trans_b, xb, yb);
        this.lons.add(a);
        Point3DCartesian pa = new Point3DCartesian(xa[0], ya[0]);
        par_proj.add(pa);
        this.asPoints3(proj, alpha, par_proj, a, b, a, b, xa[0], ya[0], xb[0], yb[0], d, fmax, dmin, dmax, eps);
        this.lons.add(b);
        Point3DCartesian pb = new Point3DCartesian(xb[0], yb[0]);
        par_proj.add(pb);
    }

    public void asPoints3(Projection proj, double alpha, List<Point3DCartesian> par_proj, double a, double b, double ap, double bn, double xa, double ya, double xb, double yb, int d, double fmax, int dmin, int dmax, double eps) {
        double alpha4;
        double r_min = 0.45;
        double r_max = 0.55;
        Random r = new Random();
        if (d >= dmax) {
            return;
        }
        if (b - a < eps) {
            return;
        }
        double r0 = 0.55;
        double r1 = 0.45 + r.nextDouble() * 0.10000000000000003;
        double r2 = 0.45 + r.nextDouble() * 0.10000000000000003;
        double r3 = 0.45 + r.nextDouble() * 0.10000000000000003;
        double r4 = 0.55;
        double lon0 = a + 0.55 * (ap - a) / 2.0;
        double lon1 = a + r1 * (b - a) / 2.0;
        double lon2 = a + r2 * (b - a);
        double lon3 = a + r3 * (b - a) * 3.0 / 2.0;
        double lon4 = b + 0.55 * (bn - b) / 2.0;
        double[] x0 = new double[]{0.0};
        double[] y0 = new double[]{0.0};
        double[] x1 = new double[]{0.0};
        double[] y1 = new double[]{0.0};
        double[] x2 = new double[]{0.0};
        double[] y2 = new double[]{0.0};
        double[] x3 = new double[]{0.0};
        double[] y3 = new double[]{0.0};
        double[] x4 = new double[]{0.0};
        double[] y4 = new double[]{0.0};
        double[] lat_trans = new double[]{0.0};
        double[] lon_trans = new double[]{0.0};
        try {
            CartTransformation.latLonToXY(this.lat, lon0, proj, alpha, lat_trans, lon_trans, x0, y0);
            if (Double.isNaN(x0[0]) || Double.isInfinite(x0[0])) {
                throw new MathInvalidArgumentException("MathException: can not project parallel point, ", "1.0 / r, r = 0:", x0[0]);
            }
            if (Double.isNaN(y0[0]) || Double.isInfinite(y0[0])) {
                throw new MathInvalidArgumentException("MathException: can not project parallel point, ", "1.0 / r, r = 0:", y0[0]);
            }
        }
        catch (MathException error) {
            SingularityDetection.checkProjDiscontinuity(this.lat, lon0, proj, alpha, fmax, 0.5 * eps);
        }
        try {
            CartTransformation.latLonToXY(this.lat, lon1, proj, alpha, lat_trans, lon_trans, x1, y1);
            if (Double.isNaN(x1[0]) || Double.isInfinite(x1[0])) {
                throw new MathInvalidArgumentException("MathException: can not project parallel point, ", "1.0 / r, r = 0:", x1[0]);
            }
            if (Double.isNaN(y1[0]) || Double.isInfinite(y1[0])) {
                throw new MathInvalidArgumentException("MathException: can not project parallel point, ", "1.0 / r, r = 0:", y1[0]);
            }
        }
        catch (MathException error) {
            SingularityDetection.checkProjDiscontinuity(this.lat, lon1, proj, alpha, fmax, 0.5 * eps);
        }
        try {
            CartTransformation.latLonToXY(this.lat, lon2, proj, alpha, lat_trans, lon_trans, x2, y2);
            if (Double.isNaN(x2[0]) || Double.isInfinite(x2[0])) {
                throw new MathInvalidArgumentException("MathException: can not project parallel point, ", "1.0 / r, r = 0:", x2[0]);
            }
            if (Double.isNaN(y2[0]) || Double.isInfinite(y2[0])) {
                throw new MathInvalidArgumentException("MathException: can not project parallel point, ", "1.0 / r, r = 0:", y2[0]);
            }
        }
        catch (MathException error) {
            SingularityDetection.checkProjDiscontinuity(this.lat, lon2, proj, alpha, fmax, 0.5 * eps);
        }
        try {
            CartTransformation.latLonToXY(this.lat, lon3, proj, alpha, lat_trans, lon_trans, x3, y3);
            if (Double.isNaN(x3[0]) || Double.isInfinite(x3[0])) {
                throw new MathInvalidArgumentException("MathException: can not project parallel point, ", "1.0 / r, r = 0:", x3[0]);
            }
            if (Double.isNaN(y3[0]) || Double.isInfinite(y3[0])) {
                throw new MathInvalidArgumentException("MathException: can not project parallel point, ", "1.0 / r, r = 0:", y3[0]);
            }
        }
        catch (MathException error) {
            SingularityDetection.checkProjDiscontinuity(this.lat, lon3, proj, alpha, fmax, 0.5 * eps);
        }
        try {
            CartTransformation.latLonToXY(this.lat, lon4, proj, alpha, lat_trans, lon_trans, x4, y4);
            if (Double.isNaN(x4[0]) || Double.isInfinite(x4[0])) {
                throw new MathInvalidArgumentException("MathException: can not project parallel point, ", "1.0 / r, r = 0:", x4[0]);
            }
            if (Double.isNaN(y4[0]) || Double.isInfinite(y4[0])) {
                throw new MathInvalidArgumentException("MathException: can not project parallel point, ", "1.0 / r, r = 0:", y4[0]);
            }
        }
        catch (MathException error) {
            SingularityDetection.checkProjDiscontinuity(this.lat, lon4, proj, alpha, fmax, 0.5 * eps);
        }
        double alpha0 = Math.abs(lon0 - a) > eps ? Math.abs(Angle3Points.getAngle3Points(x0[0], y0[0], xa, ya, x1[0], y1[0]) - 180.0) : 0.0;
        double alpha1 = Math.abs(Angle3Points.getAngle3Points(xa, ya, x1[0], y1[0], x2[0], y2[0]) - 180.0);
        double alpha2 = Math.abs(Angle3Points.getAngle3Points(x1[0], y1[0], x2[0], y2[0], x3[0], y3[0]) - 180.0);
        double alpha3 = Math.abs(Angle3Points.getAngle3Points(x2[0], y2[0], x3[0], y3[0], xb, yb) - 180.0);
        double d2 = alpha4 = Math.abs(lon4 - b) > eps ? Math.abs(Angle3Points.getAngle3Points(x3[0], y3[0], xb, yb, x4[0], y4[0]) - 180.0) : 0.0;
        if (alpha0 > this.dff || alpha1 > this.dff || alpha2 > this.dff || alpha3 > this.dff || alpha4 > this.dff || d < dmin) {
            this.asPoints3(proj, alpha, par_proj, a, lon1, lon0, lon2, xa, ya, x1[0], y1[0], d + 1, fmax, dmin, dmax, eps);
        }
        this.lons.add(lon1);
        Point3DCartesian p1 = new Point3DCartesian(x1[0], y1[0]);
        par_proj.add(p1);
        if (alpha0 > this.dff || alpha1 > this.dff || alpha2 > this.dff || alpha3 > this.dff || alpha4 > this.dff || d < dmin) {
            this.asPoints3(proj, alpha, par_proj, lon1, lon2, a, lon3, x1[0], y1[0], x2[0], y2[0], d + 1, fmax, dmin, dmax, eps);
        }
        this.lons.add(lon2);
        Point3DCartesian p2 = new Point3DCartesian(x2[0], y2[0]);
        par_proj.add(p2);
        if (alpha0 > this.dff || alpha1 > this.dff || alpha2 > this.dff || alpha3 > this.dff || alpha4 > this.dff || d < dmin) {
            this.asPoints3(proj, alpha, par_proj, lon2, lon3, lon1, b, x2[0], y2[0], x3[0], y3[0], d + 1, fmax, dmin, dmax, eps);
        }
        this.lons.add(lon3);
        Point3DCartesian p3 = new Point3DCartesian(x3[0], y3[0]);
        par_proj.add(p3);
        if (alpha0 > this.dff || alpha1 > this.dff || alpha2 > this.dff || alpha3 > this.dff || alpha4 > this.dff || d < dmin) {
            this.asPoints3(proj, alpha, par_proj, lon3, b, lon2, lon4, x3[0], y3[0], xb, yb, d + 1, fmax, dmin, dmax, eps);
        }
    }
}

