/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.structures.matrix;

import detectprojv2j.comparators.IndexComparator;
import detectprojv2j.exceptions.BadDataException;
import detectprojv2j.exceptions.MathMatrixDifferentSizeException;
import detectprojv2j.exceptions.MathMatrixNotSquareException;
import detectprojv2j.exceptions.MathOverflowException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class Matrix {
    public final double[][] items;
    private final int rows_count;
    private final int columns_count;

    public Matrix(int rows_count_, int columns_count_) {
        this.rows_count = rows_count_;
        this.columns_count = columns_count_;
        this.items = new double[this.rows_count][this.columns_count];
    }

    public Matrix(int rows_count_, int columns_count_, double item) {
        this.rows_count = rows_count_;
        this.columns_count = columns_count_;
        for (double[] row : this.items = new double[this.rows_count][this.columns_count]) {
            Arrays.fill(row, item);
        }
    }

    public Matrix(int rows_count_, int columns_count_, double non_diag_val, double diag_val) {
        this.rows_count = rows_count_;
        this.columns_count = columns_count_;
        for (double[] row : this.items = new double[this.rows_count][this.columns_count]) {
            Arrays.fill(row, non_diag_val);
        }
        for (int i = 0; i < this.rows_count; ++i) {
            this.items[i][i] = diag_val;
        }
    }

    public int rows() {
        return this.rows_count;
    }

    public int cols() {
        return this.columns_count;
    }

    public Matrix(Matrix A) {
        this(A.items);
    }

    public Matrix(double[][] data) {
        this.rows_count = data.length;
        this.columns_count = data[0].length;
        this.items = new double[this.rows_count][this.columns_count];
        for (int i = 0; i < this.rows_count; ++i) {
            for (int j = 0; j < this.columns_count; ++j) {
                this.items[i][j] = data[i][j];
            }
        }
    }

    public void copy(Matrix A) {
        for (int i = 0; i < this.rows_count; ++i) {
            for (int j = 0; j < this.columns_count; ++j) {
                this.items[i][j] = A.items[i][j];
            }
        }
    }

    public Matrix clone() {
        return new Matrix(this.items);
    }

    public Matrix plus(Matrix B) {
        if (this.rows_count != B.rows()) {
            throw new MathMatrixDifferentSizeException("MathMatrixDifferentSizeException: ", " different rows count.  Cannot compute A += B. ", this, B);
        }
        if (this.columns_count != B.cols()) {
            throw new MathMatrixDifferentSizeException("MathMatrixDifferentSizeException: ", " different columns count.  Cannot compute A += B. ", this, B);
        }
        Matrix A = this;
        Matrix C = new Matrix(this.rows_count, this.columns_count);
        for (int i = 0; i < this.rows_count; ++i) {
            for (int j = 0; j < this.columns_count; ++j) {
                C.items[i][j] = A.items[i][j] + B.items[i][j];
            }
        }
        return C;
    }

    public Matrix minus(Matrix B) {
        if (this.rows_count != B.rows()) {
            throw new MathMatrixDifferentSizeException("MathMatrixDifferentSizeException: ", " different rows_count count.  Cannot compute A += B. ", this, B);
        }
        if (this.columns_count != B.cols()) {
            throw new MathMatrixDifferentSizeException("ErrorMathRange: ", " different columns count.  Cannot compute A += B. ", this, B);
        }
        Matrix C = new Matrix(this.rows_count, this.columns_count);
        for (int i = 0; i < this.rows_count; ++i) {
            for (int j = 0; j < this.columns_count; ++j) {
                C.items[i][j] = this.items[i][j] - B.items[i][j];
            }
        }
        return C;
    }

    public Matrix mult(Matrix B) {
        int m2 = B.rows();
        int n2 = B.cols();
        if (this.columns_count != m2) {
            throw new MathMatrixDifferentSizeException("MathMatrixDifferentSizeException: ", " different rows count.  Cannot compute A += B. ", this, B);
        }
        Matrix C = new Matrix(this.rows_count, n2);
        for (int i = 0; i < this.rows_count; ++i) {
            for (int k = 0; k < this.columns_count; ++k) {
                for (int j = 0; j < n2; ++j) {
                    double[] dArray = C.items[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.items[i][k] * B.items[k][j];
                }
            }
        }
        return C;
    }

    public Matrix mult(double val) {
        Matrix A = new Matrix(this.rows_count, this.columns_count);
        for (int i = 0; i < this.rows_count; ++i) {
            for (int j = 0; j < this.columns_count; ++j) {
                A.items[i][j] = this.items[i][j] * val;
            }
        }
        return A;
    }

    public Matrix row(int r) {
        if (r > this.rows_count) {
            throw new IndexOutOfBoundsException("IndexOutOfBoundsException: row index exceeds rows_count.  ");
        }
        return this.getMatrix(r, r, 0, this.columns_count - 1);
    }

    public Matrix col(int c) {
        if (c > this.columns_count) {
            throw new IndexOutOfBoundsException("IndexOutOfBoundsException: col index exceeds columns_count.  ");
        }
        return this.getMatrix(0, this.rows_count - 1, c, c);
    }

    public void row(Matrix M, int r) {
        if (r > this.rows_count) {
            throw new IndexOutOfBoundsException("IndexOutOfBoundsException:  row index exceeds rows_count.  ");
        }
        if (M.cols() != this.columns_count) {
            throw new MathMatrixDifferentSizeException("ErrorMathMatrixDifferentSize: ", " invalid dimension of the matrices (columns_count count).  ", this, M);
        }
        this.replace(M, r, 0);
    }

    public void col(Matrix M, int c) {
        if (c > this.columns_count) {
            throw new IndexOutOfBoundsException("IndexOutOfBoundsException: col index exceeds columns_count.  ");
        }
        if (M.rows() != this.rows_count) {
            throw new MathMatrixDifferentSizeException("ErrorMathMatrixDifferentSize: ", " invalid dimension of the matrices (rows_count count).  ", this, M);
        }
        this.replace(M, 0, c);
    }

    public void replace(Matrix M, int row, int col) {
        int m = M.rows();
        int n = M.cols();
        if (m + row > this.rows_count) {
            throw new ArrayIndexOutOfBoundsException("ErrorIndexOutOfBound: a submatrix does not fit at the specified row position, can not append a submatrix to the matrix. ");
        }
        if (n + col > this.columns_count) {
            throw new ArrayIndexOutOfBoundsException("ErrorIndexOutOfBound: a submatrix does not fit at the specified row position, can not append a submatrix to the matrix. ");
        }
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                this.items[i + row][j + col] = M.items[i][j];
            }
        }
    }

    public Matrix getMatrix(int r1, int r2, int c1, int c2) {
        if (r2 > this.rows_count) {
            throw new BadDataException("BadDataException: row index r2 must not be greater than A.rows_count. ", " Can not create the submatrix. ");
        }
        if (c2 > this.columns_count) {
            throw new BadDataException("BadDataException: col index c2 must not be greater than A.columns_count. ", " Can not create the submatrix. ");
        }
        if (r1 > r2) {
            throw new BadDataException("BadDataException: row index r2 must not be smaller then r1. ", " Can not create the submatrix. ");
        }
        if (c1 > c2) {
            throw new BadDataException("BadDataException: col index c2 must not be smaller then c1. ", " Can not create the submatrix. ");
        }
        Matrix M = new Matrix(r2 - r1 + 1, c2 - c1 + 1);
        for (int i = r1; i <= r2; ++i) {
            for (int j = c1; j <= c2; ++j) {
                M.items[i - r1][j - c1] = this.items[i][j];
            }
        }
        return M;
    }

    public Matrix trans() {
        Matrix A_trans = new Matrix(this.columns_count, this.rows_count);
        for (int i = 0; i < this.rows_count; ++i) {
            for (int j = 0; j < this.columns_count; ++j) {
                A_trans.items[j][i] = this.items[i][j];
            }
        }
        return A_trans;
    }

    public double min(int[] pos) {
        double min_value = this.items[0][0];
        for (int i = 0; i < this.rows_count; ++i) {
            for (int j = 0; j < this.columns_count; ++j) {
                if (!(this.items[i][j] < min_value)) continue;
                min_value = this.items[i][j];
                pos[0] = i;
                pos[1] = j;
            }
        }
        return min_value;
    }

    public double min() {
        int[] pos = new int[]{0, 0};
        return this.min(pos);
    }

    double max(int[] pos) {
        double max_value = this.items[0][0];
        for (int i = 0; i < this.rows_count; ++i) {
            for (int j = 0; j < this.columns_count; ++j) {
                if (!(this.items[i][j] > max_value)) continue;
                max_value = this.items[i][j];
                pos[0] = i;
                pos[1] = j;
            }
        }
        return max_value;
    }

    public double max() {
        int[] pos = new int[]{0, 0};
        return this.max(pos);
    }

    public double sumRow(int row) {
        if (row < 0 || row > this.rows_count) {
            throw new IndexOutOfBoundsException("IndexOutOfBoundsException: can not compute row sum, invalid row (row < 0 || row > rows_count)");
        }
        double sum = 0.0;
        for (int j = 0; j < this.columns_count; ++j) {
            sum += this.items[row][j];
        }
        return sum;
    }

    public double sumCol(int col) {
        if (col < 0 || col > this.columns_count) {
            throw new IndexOutOfBoundsException("IndexOutOfBoundsException: can not compute col sum, invalid col (col < 0 || col > columns_count)");
        }
        double sum = 0.0;
        for (int i = 0; i < this.rows_count; ++i) {
            sum += this.items[i][col];
        }
        return sum;
    }

    public Matrix sumRows() {
        Matrix SR = new Matrix(this.rows_count, 1);
        for (int i = 0; i < this.rows_count; ++i) {
            SR.items[i][0] = this.sumRow(i);
        }
        return SR;
    }

    public Matrix sumCols() {
        Matrix SC = new Matrix(1, this.columns_count);
        for (int i = 0; i < this.columns_count; ++i) {
            SC.items[0][i] = this.sumCol(i);
        }
        return SC;
    }

    public Matrix had(Matrix M) {
        int m2 = M.rows();
        int n2 = M.cols();
        if (this.rows_count != m2) {
            throw new MathMatrixDifferentSizeException("MathMatrixDifferentSizeException: ", " different rows_count count. Cannot compute A .* B.", this, M);
        }
        if (this.columns_count != n2) {
            throw new MathMatrixDifferentSizeException("MathMatrixDifferentSizeException: ", " different columns_count count.  Cannot compute A .* B. ", this, M);
        }
        Matrix C = new Matrix(m2, n2);
        for (int i = 0; i < this.rows_count; ++i) {
            for (int j = 0; j < this.columns_count; ++j) {
                C.items[i][j] = this.items[i][j] * M.items[i][j];
            }
        }
        return C;
    }

    public double sum() {
        double sum = 0.0;
        for (int i = 0; i < this.rows_count; ++i) {
            for (int j = 0; j < this.columns_count; ++j) {
                sum += this.items[i][j];
            }
        }
        return sum;
    }

    public double sum2() {
        double sum = 0.0;
        for (int i = 0; i < this.rows_count; ++i) {
            for (int j = 0; j < this.columns_count; ++j) {
                sum += this.items[i][j] * this.items[i][j];
            }
        }
        return sum;
    }

    public double norm() {
        return Math.sqrt(this.sum2());
    }

    public void sort(Matrix IX, int c) {
        int i2;
        int m1 = this.rows_count;
        int n1 = this.columns_count;
        int m2 = IX.rows();
        int n2 = IX.cols();
        if (m1 != m2) {
            throw new MathMatrixDifferentSizeException("MathMatrixDifferentSizeException: ", " different rows count for A, IX, can not sort a matrix:  ", this, IX);
        }
        if (n1 != n2) {
            throw new MathMatrixDifferentSizeException("MathMatrixDifferentSizeException: ", " different columns count for A, IX, can not sort a matrix:  ", this, IX);
        }
        if (c > n1 - 1 || c < -1) {
            throw new IndexOutOfBoundsException("ErrorIndexOutOfBound: can not sort matrix by a column c, invalid c (c < -1 || col > columns_count)");
        }
        int n = i2 = c >= 0 ? c + 1 : n1;
        for (int i1 = c >= 0 ? c : 0; i1 < i2; ++i1) {
            int j;
            Matrix col = this.getMatrix(0, m1 - 1, i1, i1).trans();
            ArrayList<Double> col1D = new ArrayList<Double>();
            for (int i = 0; i < this.rows_count; ++i) {
                col1D.add(col.items[0][i]);
            }
            ArrayList<Integer> ix = new ArrayList<Integer>(m1);
            for (j = 0; j < m1; ++j) {
                ix.add(j);
            }
            Collections.sort(ix, new IndexComparator(col1D));
            for (j = 0; j < m1; ++j) {
                this.items[j][i1] = (Double)col1D.get((Integer)ix.get(j));
                IX.items[j][i1] = ((Integer)ix.get(j)).intValue();
            }
        }
    }

    public void sortrows(Matrix IX, int c) {
        int m1 = this.rows();
        int n1 = this.cols();
        int m2 = IX.rows();
        int n2 = IX.cols();
        if (m1 != m2) {
            throw new MathMatrixDifferentSizeException("MathMatrixDifferentSizeException: ", " different rows count for A, IX, can not sort rows of a matrix:  ", this, IX);
        }
        if (n2 != 1) {
            throw new MathMatrixDifferentSizeException("MathMatrixDifferentSizeException: ", " IX does not have 1 column, can not sort rows of a matrix:  ", this, IX);
        }
        if (c > n1 - 1 || c < -1) {
            throw new IndexOutOfBoundsException("IndexOutOfBoundException: can not sort rows of the matrix by a column c, invalid c (c < -1 || col > columns_count)");
        }
        Matrix col = this.getMatrix(0, m1 - 1, c, c).trans();
        ArrayList<Double> col1D = new ArrayList<Double>();
        for (int i = 0; i < this.rows_count; ++i) {
            col1D.add(col.items[0][i]);
        }
        ArrayList<Integer> ix = new ArrayList<Integer>(m1);
        for (int j = 0; j < m1; ++j) {
            ix.add(j);
        }
        Collections.sort(ix, new IndexComparator(col1D));
        Matrix AP = new Matrix(this);
        for (int i = 0; i < m1; ++i) {
            IX.items[i][0] = ((Integer)ix.get(i)).intValue();
            AP.replace(this.getMatrix((Integer)ix.get(i), (Integer)ix.get(i), 0, n1 - 1), i, 0);
        }
        this.copy(AP);
    }

    public double det() {
        int m = this.rows_count;
        int n = this.columns_count;
        Matrix A = new Matrix(this);
        if (m != n) {
            throw new MathMatrixNotSquareException("MathMatrixNotSquareException: ", " invalid dimension of the matrix (rectangle matrix), can not compute determinant; (rows_count, columns_count):  ", A);
        }
        Matrix L = new Matrix(m, m);
        Matrix U = new Matrix(m, m);
        Matrix P = new Matrix(m, m, 0.0, 1.0);
        short[] sign = new short[]{1};
        A.lu(L, U, P, sign);
        double determ = 1.0;
        for (int i = 0; i < m; ++i) {
            determ *= U.items[i][i];
        }
        return (double)sign[0] * determ;
    }

    public void lu(Matrix L, Matrix U, Matrix P, short[] sign) {
        int i;
        int m = this.rows_count;
        int n = this.columns_count;
        sign[0] = 1;
        if (m != n) {
            throw new MathMatrixNotSquareException("MathMatrixNotSquareException: ", " invalid dimension of the matrix (rectangle matrix), can not perform LU decomposition; (rows_count, columns_count):  ", this);
        }
        Matrix PR = new Matrix(1, n);
        Matrix S = new Matrix(1, n);
        for (i = 0; i < m; ++i) {
            L.items[i][i] = 1.0;
            PR.items[0][i] = i;
            for (int j = 0; j < m; ++j) {
                if (j != i) {
                    L.items[i][j] = 0.0;
                }
                P.items[i][j] = 0.0;
            }
        }
        U.copy(this);
        for (i = 0; i < n; ++i) {
            double max_val = 0.0;
            for (int j = 0; j < n; ++j) {
                if (!(Math.abs(U.items[i][j]) > max_val)) continue;
                max_val = Math.abs(U.items[i][j]);
            }
            if (!(max_val > 1.0E-37)) continue;
            S.items[0][i] = 1.0 / max_val;
        }
        for (int j = 0; j < n; ++j) {
            for (int i2 = 0; i2 < j; ++i2) {
                double sum = U.items[i2][j];
                for (int k = 0; k < i2; ++k) {
                    sum -= U.items[i2][k] * U.items[k][j];
                }
                U.items[i2][j] = sum;
            }
            double max_val = 0.0;
            int i_pivot = n;
            for (int i3 = j; i3 < n; ++i3) {
                double sum = U.items[i3][j];
                for (int k = 0; k < j; ++k) {
                    sum -= U.items[i3][k] * U.items[k][j];
                }
                U.items[i3][j] = sum;
                double val = S.items[0][i3] * Math.abs(sum);
                if (!(val >= max_val)) continue;
                max_val = val;
                i_pivot = i3;
            }
            if (j != i_pivot && i_pivot < n) {
                Matrix U_temp = U.getMatrix(i_pivot, i_pivot, 0, n - 1);
                U.replace(U.getMatrix(j, j, 0, n - 1), i_pivot, 0);
                U.replace(U_temp, j, 0);
                int perm_temp = (int)PR.items[0][i_pivot];
                PR.items[0][i_pivot] = PR.items[0][j];
                PR.items[0][j] = perm_temp;
                S.items[0][i_pivot] = S.items[0][j];
                sign[0] = (short)(sign[0] * -1);
            }
            if (U.items[j][j] == 0.0) {
                U.items[j][j] = 1.0E-37;
            }
            if (j == n - 1) continue;
            double val = 1.0 / U.items[j][j];
            for (int i4 = j + 1; i4 < n; ++i4) {
                double[] dArray = U.items[i4];
                int n2 = j;
                dArray[n2] = dArray[n2] * val;
            }
        }
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                L.items[i][j] = U.items[i][j];
                U.items[i][j] = 0.0;
            }
            P.items[i][(int)PR.items[0][i]] = 1.0;
        }
    }

    public Matrix inv() {
        int m = this.rows_count;
        int n = this.columns_count;
        Matrix A = new Matrix(this);
        if (m != n) {
            throw new MathMatrixNotSquareException("MathMatrixNotSquareException: ", " invalid dimension of the matrix (rectangle matrix), can not compute inverse matrix; (rows_count, columns_count):  ", A);
        }
        double max_val = A.max();
        if (max_val > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: bad scaled matrix, can not compute inverse matrix. ", "Max item > MAX_FLOAT.", max_val);
        }
        Matrix L = new Matrix(m, m);
        Matrix U = new Matrix(m, m);
        Matrix P = new Matrix(m, m, 0.0, 1.0);
        short[] sign = new short[]{1};
        A.lu(L, U, P, sign);
        Matrix X = new Matrix(m, m);
        for (int j = 0; j < m; ++j) {
            X.items[j][j] = 1.0;
            for (int i = j + 1; i < m; ++i) {
                double sum = 0.0;
                for (int k = j; k <= i - 1; ++k) {
                    sum -= L.items[i][k] * X.items[k][j];
                }
                X.items[i][j] = sum;
            }
        }
        Matrix Y = new Matrix(m, m);
        for (int j = 0; j < m; ++j) {
            Y.items[j][j] = 1.0 / U.items[j][j];
            for (int i = j - 1; i >= 0; --i) {
                double sum = 0.0;
                for (int k = i + 1; k <= j; ++k) {
                    sum -= U.items[i][k] * Y.items[k][j] / U.items[i][i];
                }
                Y.items[i][j] = sum;
            }
        }
        return Y.mult(X).mult(P);
    }

    public void qr(Matrix Q, Matrix R) {
        int m = this.rows_count;
        int n = this.columns_count;
        Q.copy(this);
        for (int i = 0; i < n; ++i) {
            double tt = 0.0;
            double t = Q.getMatrix(0, m - 1, i, i).norm();
            boolean orthogonalize = true;
            while (orthogonalize) {
                for (int j = 0; j <= i - 1; ++j) {
                    Matrix S = Q.getMatrix(0, m - 1, j, j).trans().mult(Q.getMatrix(0, m - 1, i, i));
                    R.items[j][i] = R.items[j][i] + S.items[0][0];
                    Q.replace(Q.getMatrix(0, m - 1, i, i).minus(Q.getMatrix(0, m - 1, j, j).mult(S.items[0][0])), 0, i);
                }
                tt = Q.getMatrix(0, m - 1, i, i).norm();
                if (tt > 1.0000000000000001E-36 * t && tt < t / 10.0) {
                    orthogonalize = true;
                    t = tt;
                    continue;
                }
                orthogonalize = false;
                if (!(tt < 1.0000000000000001E-36 * t)) continue;
                tt = 0.0;
            }
            R.items[i][i] = tt;
            tt = tt * 1.0E-37 != 0.0 ? 1.0 / tt : 0.0;
            Q.replace(Q.getMatrix(0, m - 1, i, i).mult(tt), 0, i);
        }
    }

    void qr(Matrix Q, Matrix R, Matrix P) {
        int i;
        int i2;
        int m = this.rows_count;
        int n = this.columns_count;
        if (m < n) {
            throw new BadDataException("BadDataException: invalid dimension of the matrix A, m < n.", "Can not compute QR decomposition with columns pivoting.");
        }
        if (Q.rows() != m || Q.cols() != m) {
            throw new BadDataException("BadDataException: invalid dimension of the matrix Q(m, m).", "Can not compute QR decomposition with columns pivoting.");
        }
        if (R.rows() != m || R.cols() != n) {
            throw new BadDataException("BadDataException: invalid dimension of the matrix R (m, n).", "Can not compute QR decomposition with columns pivoting.");
        }
        if (P.rows() != n || P.cols() != n) {
            throw new BadDataException("BadDataException: Matrix A is rank deficient (m <n).", "Can not compute QR decomposition with columns pivoting, must be of m >=n.");
        }
        R.copy(this);
        for (i2 = 0; i2 < m; ++i2) {
            Q.items[i2][i2] = 1.0;
        }
        for (i2 = 0; i2 < n; ++i2) {
            P.items[i2][i2] = 1.0;
        }
        Matrix col_norms = new Matrix(1, n);
        for (i = 0; i < n; ++i) {
            Matrix col_norm = R.getMatrix(0, m - 1, i, i).trans().mult(R.getMatrix(0, m - 1, i, i));
            col_norms.items[0][i] = col_norm.items[0][0];
        }
        for (i = 0; i < n - 1; ++i) {
            double max_col_norm = col_norms.items[0][i];
            int permut_index = i;
            for (int j = i + 1; j < n; ++j) {
                if (!(col_norms.items[0][j] > max_col_norm)) continue;
                max_col_norm = col_norms.items[0][j];
                permut_index = j;
            }
            if (col_norms.items[0][permut_index] == 0.0) break;
            if (permut_index != i) {
                Matrix TMP = P.getMatrix(0, n - 1, i, i);
                P.replace(P.getMatrix(0, n - 1, permut_index, permut_index), 0, i);
                P.replace(TMP, 0, permut_index);
                Matrix TMP2 = R.getMatrix(0, m - 1, i, i);
                R.replace(R.getMatrix(0, m - 1, permut_index, permut_index), 0, i);
                R.replace(TMP2, 0, permut_index);
                double tmp = col_norms.items[0][i];
                col_norms.items[0][i] = col_norms.items[0][permut_index];
                col_norms.items[0][permut_index] = tmp;
            }
            Matrix H = R.getMatrix(0, m - 1, i, i).hous(i, m - 1);
            R.copy(R.minus(H.mult(H.trans().mult(R))));
            Q.copy(Q.minus(Q.mult(H).mult(H.trans())));
            Matrix col_norm = R.getMatrix(i, i, i + 1, n - 1).had(R.getMatrix(i, i, i + 1, n - 1));
            col_norms.replace(col_norms.getMatrix(0, 0, i + 1, n - 1).minus(col_norm), 0, i + 1);
        }
    }

    public Matrix hous(int i, int j) {
        int m = this.rows_count;
        int n = this.columns_count;
        if (n > 1) {
            throw new BadDataException("BadDataException: Matrix A is not a column vector. ", "Can not compute the Householder vector.");
        }
        if (i > j) {
            throw new BadDataException("BadDataException: index i > j. ", "Can bot compute the Householder vector.");
        }
        if (j > m - 1) {
            throw new BadDataException("BadDataException: index i > n - 1 . ", "Can bot compute the Householder vector.");
        }
        Matrix H = new Matrix(m, n);
        H.replace(this.getMatrix(i, j, 0, 0), i, 0);
        H.items[i][0] = H.items[i][0] + (this.items[i][0] >= 0.0 ? this.getMatrix(i, j, 0, 0).norm() : -this.getMatrix(i, j, 0, 0).norm());
        Matrix norm2 = H.trans().mult(H);
        if (norm2.items[0][0] > 0.0) {
            H = H.mult(Math.sqrt(2.0 / norm2.items[0][0]));
        }
        return H;
    }

    public Matrix pinv() {
        int k;
        int m = this.rows_count;
        int n = this.columns_count;
        boolean transpose = false;
        Matrix AT = new Matrix(n, m);
        if (m < n) {
            AT = this.trans();
            int temp = m;
            m = n;
            n = temp;
            transpose = true;
        }
        Matrix AA = transpose ? AT : this;
        Matrix Q = new Matrix(m, m);
        Matrix R = new Matrix(m, n);
        Matrix P = new Matrix(n, n);
        AA.qr(Q, R, P);
        Matrix PR = new Matrix(1, n);
        Matrix M = new Matrix(1, n);
        for (int i = 0; i < n; ++i) {
            M.items[0][i] = i;
        }
        PR = M.mult(P);
        Matrix PR_R = new Matrix(1, n);
        for (int i = 0; i < n; ++i) {
            PR_R.items[0][(int)PR.items[0][i]] = i;
        }
        double eps = (double)Math.max(m, n) * this.norm() * 1.0E-15;
        for (k = 0; k < n && !(Math.abs(R.items[k][k]) < eps); ++k) {
        }
        Matrix RS = R.getMatrix(0, k - 1, 0, n - 1);
        Matrix QTS = Q.getMatrix(0, m - 1, 0, k - 1).trans();
        if (k == n) {
            Matrix P_R = new Matrix(n, n);
            for (int i = 0; i < n; ++i) {
                P_R.items[i][(int)PR_R.items[0][i]] = 1.0;
            }
            Matrix RI = RS.inv().mult(QTS);
            return P_R.mult(RI);
        }
        Matrix Q2 = new Matrix(n, k);
        Matrix R2 = new Matrix(k, k);
        RS.trans().qr(Q2, R2);
        Matrix P_R = new Matrix(n, k);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < k; ++j) {
                P_R.items[i][j] = Q2.items[(int)PR_R.items[0][i]][j];
            }
        }
        Matrix R2T = R2.trans();
        Matrix R2I = R2T.inv().mult(QTS);
        Matrix AA_I = P_R.mult(R2I);
        return transpose ? AA_I.trans() : AA_I;
    }

    public void print() {
        System.out.println("");
        for (int i = 0; i < this.rows_count; ++i) {
            for (int j = 0; j < this.columns_count; ++j) {
                System.out.print(this.items[i][j] + " ");
            }
            System.out.println("");
        }
    }
}

