/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.structures.projection;

import detectprojv2j.structures.point.Point3DGeographic;
import detectprojv2j.structures.projection.Projections;
import detectprojv2j.types.ICoordFunctionProj;
import detectprojv2j.types.TInterval;
import detectprojv2j.types.TTransformedLongitudeDirection;

public abstract class Projection {
    protected double R;
    protected double lon0;
    protected double dx;
    protected double dy;
    protected double c;
    ICoordFunctionProj F;
    ICoordFunctionProj G;
    ICoordFunctionProj FI;
    ICoordFunctionProj GI;
    protected String name;
    protected String id;

    public Projection() {
        this.R = 1.0;
        this.lon0 = 0.0;
        this.dx = 0.0;
        this.dy = 0.0;
        this.c = 1.0;
        this.F = Projections::F_aea;
        this.G = Projections::G_def;
        this.FI = Projections::F_aea;
        this.GI = Projections::G_def;
        this.name = "Azimuthal equal area";
        this.id = "aea";
    }

    Projection(double R_, double lon0_, double dx_, double dy_, double c_, ICoordFunctionProj pF, ICoordFunctionProj pG, ICoordFunctionProj pFI, ICoordFunctionProj pGI, String name_, String id_) {
        this.R = R_;
        this.lon0 = lon0_;
        this.dx = dx_;
        this.dy = dy_;
        this.c = c_;
        this.F = pF;
        this.G = pG;
        this.FI = pFI;
        this.GI = pGI;
        this.name = name_;
        this.id = id_;
    }

    public final double getR() {
        return this.R;
    }

    public final double getLon0() {
        return this.lon0;
    }

    public final double getDx() {
        return this.dx;
    }

    public final double getDy() {
        return this.dy;
    }

    public final double getC() {
        return this.c;
    }

    public final double getX(double lat, double lon) {
        return this.F.f(lat, lon, this.getR(), this.getLat1(), this.getLat2(), this.getLon0(), this.getDx(), this.getDy(), this.getC());
    }

    public final double getX(double lat, double lon, double R_, double lat1_, double lat2_, double lon0_, double dx_, double dy_, double c_) {
        return this.F.f(lat, lon, R_, lat1_, lat2_, lon0_, dx_, dy_, c_);
    }

    public final ICoordFunctionProj getX() {
        return this.F;
    }

    public final double getY(double lat, double lon) {
        return this.G.f(lat, lon, this.getR(), this.getLat1(), this.getLat2(), this.getLon0(), this.getDx(), this.getDy(), this.getC());
    }

    public final double getY(double lat, double lon, double R_, double lat1_, double lat2_, double lon0_, double dx_, double dy_, double c_) {
        return this.G.f(lat, lon, R_, lat1_, lat2_, lon0_, dx_, dy_, c_);
    }

    public final ICoordFunctionProj getY() {
        return this.G;
    }

    public final double getLat(double x, double y) {
        return this.FI.f(x, y, this.getR(), this.getLat1(), this.getLat2(), this.getLon0(), this.getDx(), this.getDy(), this.getC());
    }

    public final double getLat(double x_, double y_, double R_, double lat1_, double lat2_, double lon0_, double dx_, double dy_, double c_) {
        return this.FI.f(x_, y_, R_, lat1_, lat2_, lon0_, dx_, dy_, c_);
    }

    public final ICoordFunctionProj getLat() {
        return this.FI;
    }

    public final double getLon(double x, double y) {
        return this.GI.f(x, y, this.getR(), this.getLat1(), this.getLat2(), this.getLon0(), this.getDx(), this.getDy(), this.getC());
    }

    public final double getLon(double x, double y, double R_, double lat1_, double lat2_, double lon0_, double dx_, double dy_, double c_) {
        return this.GI.f(x, y, R_, lat1_, lat2_, lon0_, dx_, dy_, c_);
    }

    public final ICoordFunctionProj getLon() {
        return this.GI;
    }

    public final String getName() {
        return this.name;
    }

    public final String getID() {
        return this.id;
    }

    public void setR(double R_) {
        this.R = R_;
    }

    public void setLon0(double lon0_) {
        this.lon0 = lon0_;
    }

    public void setDx(double dx_) {
        this.dx = dx_;
    }

    public void setDy(double dy_) {
        this.dy = dy_;
    }

    public void setC(double c_) {
        this.c = c_;
    }

    public void setName(String name_) {
        this.name = name_;
    }

    public void setID(String id_) {
        this.id = id_;
    }

    public abstract Point3DGeographic getCartPole();

    public abstract double getLat1();

    public abstract double getLat2();

    public abstract double getA();

    public abstract double getB();

    public abstract TTransformedLongitudeDirection getLonDir();

    public abstract String getFamily();

    public abstract TInterval getLatPInterval();

    public abstract TInterval getLonPInterval();

    public abstract TInterval getLat1Interval();

    public abstract void setCartPole(Point3DGeographic var1);

    public abstract void setLat1(double var1);

    public abstract void setLat2(double var1);

    public abstract void setA(double var1);

    public abstract void setB(double var1);

    public abstract void setLonDir(TTransformedLongitudeDirection var1);
}

