/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.structures.projection;

import detectprojv2j.structures.point.Point3DGeographic;
import detectprojv2j.structures.projection.Projection;
import detectprojv2j.types.ICoordFunctionProj;
import detectprojv2j.types.TInterval;
import detectprojv2j.types.TTransformedLongitudeDirection;

public class ProjectionAzimuthal
extends Projection {
    protected Point3DGeographic cart_pole;
    protected TTransformedLongitudeDirection lon_dir;

    public ProjectionAzimuthal() {
        this.cart_pole = new Point3DGeographic(90.0, 0.0, 0.0);
        this.lon_dir = TTransformedLongitudeDirection.NormalDirection2;
    }

    public ProjectionAzimuthal(double R_, double latp_, double lonp_, TTransformedLongitudeDirection lon_dir_, double lon0_, double dx_, double dy_, double c_, ICoordFunctionProj pF_, ICoordFunctionProj pG_, ICoordFunctionProj pFI_, ICoordFunctionProj pGI_, String name_, String id_) {
        super(R_, lon0_, dx_, dy_, c_, pF_, pG_, pFI_, pGI_, name_, id_);
        this.cart_pole = new Point3DGeographic(latp_, lonp_, 0.0);
        this.lon_dir = lon_dir_;
    }

    @Override
    public Point3DGeographic getCartPole() {
        return this.cart_pole;
    }

    @Override
    public double getLat1() {
        return 0.0;
    }

    @Override
    public double getLat2() {
        return 0.0;
    }

    @Override
    public double getA() {
        return this.R;
    }

    @Override
    public double getB() {
        return this.R;
    }

    @Override
    public TTransformedLongitudeDirection getLonDir() {
        return this.lon_dir;
    }

    @Override
    public String getFamily() {
        return "Azimuthal";
    }

    @Override
    public TInterval getLatPInterval() {
        return new TInterval(-90.0, 90.0);
    }

    @Override
    public TInterval getLonPInterval() {
        return new TInterval(-180.0, 180.0);
    }

    @Override
    public TInterval getLat1Interval() {
        return new TInterval(0.0, 0.0);
    }

    @Override
    public void setCartPole(Point3DGeographic cart_pole_) {
        this.cart_pole = cart_pole_;
    }

    @Override
    public void setLat1(double lat1_) {
    }

    @Override
    public void setLat2(double lat2_) {
    }

    @Override
    public void setA(double a_) {
    }

    @Override
    public void setB(double b_) {
    }

    @Override
    public void setLonDir(TTransformedLongitudeDirection lon_dir_) {
        this.lon_dir = lon_dir_;
    }
}

