/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.structures.projection;

import detectprojv2j.structures.point.Point3DGeographic;
import detectprojv2j.structures.projection.Projection;
import detectprojv2j.types.ICoordFunctionProj;
import detectprojv2j.types.TInterval;
import detectprojv2j.types.TTransformedLongitudeDirection;

public class ProjectionEllipsoidal
extends Projection {
    protected double a;
    protected double b;
    protected double lat1;

    public ProjectionEllipsoidal() {
        this.lat1 = 0.0;
        this.a = 1.0;
        this.b = 1.0;
    }

    public ProjectionEllipsoidal(double R_, double a_, double b_, double lat1_, double lon0_, double dx_, double dy_, double c_, ICoordFunctionProj pF_, ICoordFunctionProj pG_, ICoordFunctionProj pFI_, ICoordFunctionProj pGI_, String name_, String id_) {
        super(R_, lon0_, dx_, dy_, c_, pF_, pG_, pFI_, pGI_, name_, id_);
        this.lat1 = lat1_;
        this.a = a_;
        this.b = b_;
    }

    @Override
    public Point3DGeographic getCartPole() {
        return new Point3DGeographic(90.0, 0.0, 0.0);
    }

    @Override
    public double getLat1() {
        return this.lat1;
    }

    @Override
    public double getLat2() {
        return this.lat1;
    }

    @Override
    public double getA() {
        return this.a;
    }

    @Override
    public double getB() {
        return this.b;
    }

    @Override
    public TTransformedLongitudeDirection getLonDir() {
        return TTransformedLongitudeDirection.NoDirection;
    }

    @Override
    public String getFamily() {
        return "Elipsoidal";
    }

    @Override
    public TInterval getLatPInterval() {
        return new TInterval(90.0, 90.0);
    }

    @Override
    public TInterval getLonPInterval() {
        return new TInterval(0.0, 0.0);
    }

    @Override
    public TInterval getLat1Interval() {
        return new TInterval(0.0, 85.0);
    }

    @Override
    public void setCartPole(Point3DGeographic cart_pole_) {
    }

    @Override
    public void setLat1(double lat1_) {
        this.lat1 = lat1_;
    }

    @Override
    public void setLat2(double lat2_) {
    }

    @Override
    public void setA(double a_) {
        this.a = a_;
    }

    @Override
    public void setB(double b_) {
        this.b = this.b;
    }

    @Override
    public void setLonDir(TTransformedLongitudeDirection lon_dir_) {
    }
}

