/*
 * Decompiled with CFR 0.152.
 */
package detectprojv2j.structures.projection;

import detectprojv2j.algorithms.carttransformation.CartTransformation;
import detectprojv2j.algorithms.newtonraphson.FILat;
import detectprojv2j.algorithms.newtonraphson.FILatDer;
import detectprojv2j.algorithms.newtonraphson.FILon;
import detectprojv2j.algorithms.newtonraphson.FILonDer;
import detectprojv2j.algorithms.newtonraphson.FTheta;
import detectprojv2j.algorithms.newtonraphson.FThetaDer;
import detectprojv2j.algorithms.newtonraphson.NewtonRaphson;
import detectprojv2j.algorithms.numintegration.NumIntegration;
import detectprojv2j.algorithms.quartic.Quartic;
import detectprojv2j.exceptions.MathInvalidArgumentException;
import detectprojv2j.exceptions.MathOverflowException;
import detectprojv2j.exceptions.MathZeroDevisionException;
import detectprojv2j.structures.projection.Projection;
import detectprojv2j.structures.projection.ProjectionAzimuthal;
import detectprojv2j.structures.projection.ProjectionConic;
import detectprojv2j.structures.projection.ProjectionCylindrical;
import detectprojv2j.structures.projection.ProjectionMiscellaneous;
import detectprojv2j.structures.projection.ProjectionPolyConic;
import detectprojv2j.structures.projection.ProjectionPseudoAzimuthal;
import detectprojv2j.structures.projection.ProjectionPseudoConic;
import detectprojv2j.structures.projection.ProjectionPseudoCylindrical;
import detectprojv2j.types.ICoordFunctionProjJI;
import detectprojv2j.types.ICoordFunctionProjRI;
import detectprojv2j.types.TTransformedLongitudeDirection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Projections {
    public static void init(List<Projection> projections, TTransformedLongitudeDirection default_lon_dir) {
        ProjectionMiscellaneous adamh = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_adamh, Projections::G_adamh, Projections::F_adamh, Projections::G_adamh, "Adams, hemisphere in square", "adamh");
        ProjectionMiscellaneous adams1 = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_adams1, Projections::G_adams1, Projections::F_adams1, Projections::G_adams1, "Adams, world in square I.", "adams1");
        ProjectionMiscellaneous adams2 = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_adams2, Projections::G_adams2, Projections::F_adams2, Projections::G_adams2, "Adams, world in square II.", "adams2");
        ProjectionConic aea = new ProjectionConic(6380.0, 90.0, 0.0, 40.0, 50.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_aea, Projections::G_aea, Projections::FI_aea, Projections::GI_aea, "Albers, equal area*", "aea");
        ProjectionAzimuthal aeqd = new ProjectionAzimuthal(6380.0, 90.0, 0.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_aeqd, Projections::G_aeqd, Projections::FI_aeqd, Projections::GI_aeqd, "Equidistant*", "aeqd");
        ProjectionPseudoAzimuthal aitoff = new ProjectionPseudoAzimuthal(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_aitoff, Projections::G_aitoff, Projections::FI_aitoff, Projections::GI_aitoff, "Aitoff*", "aitoff");
        ProjectionMiscellaneous api = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_api, Projections::G_api, Projections::F_api, Projections::G_api, "Apianus", "api");
        ProjectionMiscellaneous apiel = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_apiel, Projections::G_apiel, Projections::FI_apiel, Projections::GI_apiel, "Apianus, elliptic*", "apiel");
        ProjectionMiscellaneous armad = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_armad, Projections::G_armad, Projections::FI_armad, Projections::GI_armad, "Armadillo*", "armad");
        ProjectionMiscellaneous august = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_august, Projections::G_august, Projections::FI_august, Projections::GI_august, "August, epicycloidal*", "august");
        ProjectionMiscellaneous bacon = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_bacon, Projections::G_bacon, Projections::F_bacon, Projections::G_bacon, "Bacon, globular", "bacon");
        ProjectionCylindrical behr = new ProjectionCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_behr, Projections::G_behr, Projections::FI_behr, Projections::GI_behr, "Behrmann*", "behr");
        ProjectionPseudoCylindrical boggs = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_boggs, Projections::G_boggs, Projections::FI_boggs, Projections::GI_boggs, "Boggs, eumorphic*", "boggs");
        ProjectionPseudoConic bonne = new ProjectionPseudoConic(6380.0, 90.0, 0.0, 40.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_bonne, Projections::G_bonne, Projections::FI_bonne, Projections::GI_bonne, "Bonne*", "bonne");
        ProjectionAzimuthal breus = new ProjectionAzimuthal(6380.0, 90.0, 0.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_breus, Projections::G_breus, Projections::F_breus, Projections::G_breus, "Breusign", "breus");
        ProjectionPseudoCylindrical bries = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_bries, Projections::G_bries, Projections::FI_bries, Projections::GI_bries, "Briesenmeister*", "bries");
        ProjectionCylindrical cc = new ProjectionCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_cc, Projections::G_cc, Projections::FI_cc, Projections::GI_cc, "Central, perspective*", "cc");
        ProjectionCylindrical cea = new ProjectionCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_cea, Projections::G_cea, Projections::FI_cea, Projections::GI_cea, "Lambert, equal area*", "cea");
        ProjectionAzimuthal clar = new ProjectionAzimuthal(6380.0, 90.0, 0.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_clar, Projections::G_clar, Projections::FI_clar, Projections::GI_clar, "Clark, perspective*", "clar");
        ProjectionMiscellaneous collg = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_collg, Projections::G_collg, Projections::FI_collg, Projections::GI_collg, "Collignon*", "collg");
        ProjectionMiscellaneous crast = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_crast, Projections::G_crast, Projections::FI_crast, Projections::GI_crast, "Craster, parabolic*", "crast");
        ProjectionMiscellaneous cwe = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_cwe, Projections::G_cwe, Projections::F_cwe, Projections::G_cwe, "Conformal world in ellipse", "cwe");
        ProjectionPseudoCylindrical denoy = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_denoy, Projections::G_denoy, Projections::FI_denoy, Projections::GI_denoy, "Denoyer, semi-elliptical*", "denoy");
        ProjectionPseudoCylindrical eck1 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_eck1, Projections::G_eck1, Projections::FI_eck1, Projections::GI_eck1, "Eckert I.*", "eck1");
        ProjectionPseudoCylindrical eck2 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_eck2, Projections::G_eck2, Projections::FI_eck2, Projections::GI_eck2, "Eckert II.*", "eck2");
        ProjectionPseudoCylindrical eck3 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_eck3, Projections::G_eck3, Projections::FI_eck3, Projections::GI_eck3, "Eckert III.*", "eck3");
        ProjectionPseudoCylindrical eck4 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_eck4, Projections::G_eck4, Projections::FI_eck4, Projections::GI_eck4, "Eckert IV.*", "eck4");
        ProjectionPseudoCylindrical eck5 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_eck5, Projections::G_eck5, Projections::FI_eck5, Projections::GI_eck5, "Eckert V.*", "eck5");
        ProjectionPseudoCylindrical eck6 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_eck6, Projections::G_eck6, Projections::FI_eck6, Projections::GI_eck6, "Eckert VI.*", "eck6");
        ProjectionPseudoCylindrical eckgr = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_eckgr, Projections::G_eckgr, Projections::FI_eckgr, Projections::GI_eckgr, "Eckert-Greifendorff*", "eckgr");
        ProjectionMiscellaneous eisen = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_eisen, Projections::G_eisen, Projections::F_eisen, Projections::G_eisen, "Eisenlohr", "eisen");
        ProjectionCylindrical eqc = new ProjectionCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_eqc, Projections::G_eqc, Projections::FI_eqc, Projections::GI_eqc, "Equidistant*", "eqc");
        ProjectionConic eqdc = new ProjectionConic(6380.0, 90.0, 0.0, 40.0, 50.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_eqdc, Projections::G_eqdc, Projections::FI_eqdc, Projections::GI_eqdc, "Equidistant (true parallel lat1)*", "eqdc");
        ProjectionConic eqdc2 = new ProjectionConic(6380.0, 90.0, 0.0, 40.0, 50.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_eqdc2, Projections::G_eqdc2, Projections::FI_eqdc2, Projections::GI_eqdc2, "Equidistant (true parallel lat1, pole = point)*", "eqdc2");
        ProjectionConic eqdc3 = new ProjectionConic(6380.0, 90.0, 0.0, 40.0, 50.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_eqdc3, Projections::G_eqdc3, Projections::FI_eqdc3, Projections::GI_eqdc3, "Equidistant (true parallels lat1, lat2)*", "eqdc3");
        ProjectionPseudoCylindrical fahey = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_fahey, Projections::G_fahey, Projections::FI_fahey, Projections::GI_fahey, "Fahey*", "fahey");
        ProjectionPseudoCylindrical fouc = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_fouc, Projections::G_fouc, Projections::FI_fouc, Projections::GI_fouc, "Foucaut, sine-tangent*", "fouc");
        ProjectionPseudoCylindrical fouc_s = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_fouc_s, Projections::G_fouc_s, Projections::FI_fouc_s, Projections::GI_fouc_s, "Foucaut, sinusoidal*", "fouc_s");
        ProjectionMiscellaneous fourn = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_fourn, Projections::G_fourn, Projections::F_fourn, Projections::G_fourn, "Fournier I., globular", "fourn");
        ProjectionMiscellaneous fourn2 = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_fourn2, Projections::G_fourn2, Projections::F_fourn2, Projections::G_fourn2, "Fournier II., elliptical", "fourn2");
        ProjectionCylindrical gall = new ProjectionCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_gall, Projections::G_gall, Projections::FI_gall, Projections::GI_gall, "Gall, stereographic*", "gall");
        ProjectionPolyConic gins4 = new ProjectionPolyConic(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_gins4, Projections::G_gins4, Projections::FI_gins8, Projections::GI_gins8, "Ginsburg IV.", "gins4");
        ProjectionPolyConic gins5 = new ProjectionPolyConic(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_gins5, Projections::G_gins5, Projections::FI_gins8, Projections::GI_gins8, "Ginsburg V.", "gins5");
        ProjectionPolyConic gins6 = new ProjectionPolyConic(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_gins6, Projections::G_gins6, Projections::FI_gins8, Projections::GI_gins8, "Ginsburg VI.", "gins6");
        ProjectionPolyConic gins9 = new ProjectionPolyConic(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_gins9, Projections::G_gins9, Projections::FI_gins8, Projections::GI_gins8, "Ginsburg IX.", "gins9");
        ProjectionPolyConic gins8 = new ProjectionPolyConic(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_gins8, Projections::G_gins8, Projections::FI_gins8, Projections::GI_gins8, "Ginsburg VIII.*", "gins8");
        ProjectionAzimuthal gnom = new ProjectionAzimuthal(6380.0, 90.0, 0.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_gnom, Projections::G_gnom, Projections::FI_gnom, Projections::GI_gnom, "Gnomonic*", "gnom");
        ProjectionPseudoCylindrical goode = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_goode, Projections::G_goode, Projections::F_goode, Projections::G_goode, "Goode, homolosine", "goode");
        ProjectionMiscellaneous guyou = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_guyou, Projections::G_guyou, Projections::F_guyou, Projections::G_guyou, "Guyou", "guyou");
        ProjectionPseudoAzimuthal hammer = new ProjectionPseudoAzimuthal(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_hammer, Projections::G_hammer, Projections::FI_hammer, Projections::GI_hammer, "Hammer*", "hammer");
        ProjectionPseudoCylindrical hataea = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_hataea, Projections::G_hataea, Projections::FI_hataea, Projections::GI_hataea, "Hatano, asymmetrical, equal area*", "hataea");
        ProjectionAzimuthal hire = new ProjectionAzimuthal(6380.0, 90.0, 0.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_hire, Projections::G_hire, Projections::FI_hire, Projections::GI_hire, "La Hire*", "hire");
        ProjectionAzimuthal jam = new ProjectionAzimuthal(6380.0, 90.0, 0.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_jam, Projections::G_jam, Projections::FI_jam, Projections::GI_jam, "James, perspective*", "jam");
        ProjectionPseudoCylindrical kav5 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_kav5, Projections::G_kav5, Projections::FI_kav5, Projections::GI_kav5, "Kavrayskiy V.*", "kav5");
        ProjectionPseudoCylindrical kav7 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_kav7, Projections::G_kav7, Projections::FI_kav7, Projections::GI_kav7, "Kavrayskiy VII.*", "kav7");
        ProjectionAzimuthal laea = new ProjectionAzimuthal(6380.0, 90.0, 0.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_laea, Projections::G_laea, Projections::FI_laea, Projections::GI_laea, "Lambert, equal area*", "laea");
        ProjectionMiscellaneous lagrng = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_lagrng, Projections::G_lagrng, Projections::FI_lagrng, Projections::GI_lagrng, "Lagrange, conformal*", "lagrng");
        ProjectionMiscellaneous larr = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_larr, Projections::G_larr, Projections::FI_larr, Projections::GI_larr, "Larrivee*", "larr");
        ProjectionPseudoCylindrical lask = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_lask, Projections::G_lask, Projections::FI_lask, Projections::GI_lask, "Laskowski*", "lask");
        ProjectionConic lcc = new ProjectionConic(6380.0, 90.0, 0.0, 40.0, 50.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_lcc, Projections::G_lcc, Projections::FI_lcc, Projections::GI_lcc, "Lambert, conformal*", "lcc");
        ProjectionConic leac = new ProjectionConic(6380.0, 90.0, 0.0, 40.0, 50.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_leac, Projections::G_leac, Projections::FI_leac, Projections::GI_leac, "Lambert, equal area (standard parallel lat1)*", "leac");
        ProjectionConic leac2 = new ProjectionConic(6380.0, 90.0, 0.0, 40.0, 50.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_leac2, Projections::G_leac2, Projections::FI_leac2, Projections::GI_leac2, "Lambert, equal area (standard parallel lat1, pole = point)*", "leac2");
        ProjectionMiscellaneous litt = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_litt, Projections::G_litt, Projections::FI_litt, Projections::GI_litt, "Littrow*", "litt");
        ProjectionPseudoCylindrical loxim = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_loxim, Projections::G_loxim, Projections::FI_loxim, Projections::GI_loxim, "Loximuthal*", "loxim");
        ProjectionPseudoCylindrical maurer = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_maurer, Projections::G_maurer, Projections::FI_maurer, Projections::GI_maurer, "Maurer*", "maurer");
        ProjectionPseudoCylindrical mbt_s = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_mbt_s, Projections::G_mbt_s, Projections::FI_mbt_s, Projections::GI_mbt_s, "McBryde-Thomas, sine I.*", "mbt_s");
        ProjectionPseudoCylindrical mbt_s3 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_mbt_s3, Projections::G_mbt_s3, Projections::F_mbt_s3, Projections::G_mbt_s3, "McBryde-Thomas, flat-pole sine III.", "mbt_s3");
        ProjectionPseudoCylindrical mbtfpp = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_mbtfpq, Projections::G_mbtfpq, Projections::FI_mbtfpp, Projections::GI_mbtfpp, "McBryde-Thomas, flat-pole parabolic*", "mbtfpp");
        ProjectionPseudoCylindrical mbtfpq = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_mbtfpq, Projections::G_mbtfpq, Projections::FI_mbtfpq, Projections::GI_mbtfpq, "McBryde-Thomas, flat-pole quartic*", "mbtfpq");
        ProjectionPseudoCylindrical mbtfps = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_mbtfps, Projections::G_mbtfps, Projections::FI_mbtfps, Projections::GI_mbtfps, "McBryde-Thomas, flat-pole sine I.*", "mbtfps");
        ProjectionPseudoCylindrical mbtfps2 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_mbtfps2, Projections::G_mbtfps2, Projections::F_mbtfps2, Projections::G_mbtfps2, "McBryde-Thomas, flat-pole sine II.", "mbtfps2");
        ProjectionCylindrical merc = new ProjectionCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_merc, Projections::G_merc, Projections::FI_merc, Projections::GI_merc, "Mercator*", "merc");
        ProjectionCylindrical mill = new ProjectionCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_mill, Projections::G_mill, Projections::FI_mill, Projections::GI_mill, "Miller*", "mill");
        ProjectionPseudoCylindrical moll = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_moll, Projections::G_moll, Projections::FI_moll, Projections::GI_moll, "Mollweide*", "moll");
        ProjectionPseudoCylindrical nell = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_nell, Projections::G_nell, Projections::FI_nell, Projections::GI_nell, "Nell*", "nell");
        ProjectionPseudoCylindrical nell_h = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_nell_h, Projections::G_nell_h, Projections::FI_nell_h, Projections::GI_nell_h, "Nell-Hammer*", "nell_h");
        ProjectionMiscellaneous nicol = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_nicol, Projections::G_nicol, Projections::FI_nicol, Projections::GI_nicol, "Nicolosi, globular*", "nicol");
        ProjectionPseudoCylindrical ortel = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_ortel, Projections::G_ortel, Projections::F_ortel, Projections::G_ortel, "Ortelius", "ortel");
        ProjectionAzimuthal ortho = new ProjectionAzimuthal(6380.0, 90.0, 0.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_ortho, Projections::G_ortho, Projections::FI_ortho, Projections::GI_ortho, "Orthographic*", "ortho");
        ProjectionPseudoCylindrical parab = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_parab, Projections::G_parab, Projections::F_parab, Projections::G_parab, "Parabolic", "parab");
        ProjectionMiscellaneous peiq = new ProjectionMiscellaneous(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_peiq, Projections::G_peiq, Projections::F_peiq, Projections::G_peiq, "Peirce, quincuncial", "peiq");
        ProjectionAzimuthal pers = new ProjectionAzimuthal(6380.0, 90.0, 0.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_pers, Projections::G_pers, Projections::FI_pers, Projections::GI_pers, "Perspective*", "pers");
        ProjectionAzimuthal persf = new ProjectionAzimuthal(6380.0, 90.0, 0.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_persf, Projections::G_persf, Projections::FI_persf, Projections::GI_persf, "Far-side, perspective*", "persf");
        ProjectionAzimuthal persn = new ProjectionAzimuthal(6380.0, 90.0, 0.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_persn, Projections::G_persn, Projections::FI_persn, Projections::GI_persn, "Near-side, perspective*", "persn");
        ProjectionPolyConic poly = new ProjectionPolyConic(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_poly, Projections::G_poly, Projections::FI_poly, Projections::GI_poly, "Hassler,  American, polyconic*", "poly");
        ProjectionPseudoCylindrical putp1 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_putp1, Projections::G_putp1, Projections::FI_putp1, Projections::GI_putp1, "Putnins P1*", "putp1");
        ProjectionPseudoCylindrical putp2 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_putp2, Projections::G_putp2, Projections::FI_putp2, Projections::GI_putp2, "Putnins P2*", "putp2");
        ProjectionPseudoCylindrical putp3 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_putp3, Projections::G_putp3, Projections::FI_putp3, Projections::GI_putp3, "Putnins P3*", "putp3");
        ProjectionPseudoCylindrical putp3p = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_putp3p, Projections::G_putp3p, Projections::FI_putp3p, Projections::GI_putp3p, "Putnins P3P*", "putp3p");
        ProjectionPseudoCylindrical putp4p = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_putp4p, Projections::G_putp4p, Projections::FI_putp4p, Projections::GI_putp4p, "Putnins P4P*", "putp4p");
        ProjectionPseudoCylindrical putp5 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_putp5, Projections::G_putp5, Projections::FI_putp5, Projections::GI_putp5, "Putnins P5*", "putp5");
        ProjectionPseudoCylindrical putp5p = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_putp5p, Projections::G_putp5p, Projections::FI_putp5p, Projections::GI_putp5p, "Putnins P5P*", "putp5p");
        ProjectionPseudoCylindrical putp6 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_putp6, Projections::G_putp6, Projections::FI_putp6, Projections::GI_putp6, "Putnins P6*", "putp6");
        ProjectionPseudoCylindrical putp6p = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_putp6p, Projections::G_putp6p, Projections::F_putp6p, Projections::G_putp6p, "Putnins P6p*", "putp6p");
        ProjectionPseudoCylindrical qua_aut = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_qua_aut, Projections::G_qua_aut, Projections::FI_qua_aut, Projections::GI_qua_aut, "Quartic, authalic*", "qua_aut");
        ProjectionPseudoCylindrical rpoly = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_rpoly, Projections::G_rpoly, Projections::FI_rpoly, Projections::GI_rpoly, "Rectangular, polyconic*", "rpoly");
        ProjectionPseudoCylindrical sinu = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_sinu, Projections::G_sinu, Projections::FI_sinu, Projections::GI_sinu, "Sinusoidal*", "sinu");
        ProjectionAzimuthal solo = new ProjectionAzimuthal(6380.0, 90.0, 0.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_solo, Projections::G_solo, Projections::FI_solo, Projections::GI_solo, "Solovyev,azimuthal*", "solo");
        ProjectionAzimuthal stere = new ProjectionAzimuthal(6380.0, 90.0, 0.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_stere, Projections::G_stere, Projections::FI_stere, Projections::GI_stere, "Stereographic*", "stere");
        ProjectionAzimuthal twi = new ProjectionAzimuthal(6380.0, 90.0, 0.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_twi, Projections::G_twi, Projections::FI_twi, Projections::GI_twi, "Twilight, general vertical perspective*", "twi");
        ProjectionPseudoCylindrical urm5 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_urm5, Projections::G_urm5, Projections::FI_urm5, Projections::GI_urm5, "Urmaev V.*", "urm5");
        ProjectionPolyConic vandg = new ProjectionPolyConic(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_vandg, Projections::G_vandg, Projections::FI_vandg, Projections::GI_vandg, "Van der Grinten I.*", "vandg");
        ProjectionPolyConic vandg2 = new ProjectionPolyConic(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_vandg2, Projections::G_vandg2, Projections::FI_vandg2, Projections::GI_vandg2, "Van der Grinten II.*", "vandg2");
        ProjectionPolyConic vandg3 = new ProjectionPolyConic(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_vandg3, Projections::G_vandg3, Projections::FI_vandg3, Projections::GI_vandg3, "Van der Grinten III.*", "vandg3");
        ProjectionPolyConic vandg4 = new ProjectionPolyConic(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_vandg4, Projections::G_vandg4, Projections::FI_vandg4, Projections::GI_vandg4, "Van der Grinten IV.*", "vandg4");
        ProjectionPseudoCylindrical wag1 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_wag1, Projections::G_wag1, Projections::F_wag1, Projections::G_wag1, "Wagner I.*", "wag1");
        ProjectionPseudoCylindrical wag2 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_wag2, Projections::G_wag2, Projections::FI_wag2, Projections::GI_wag2, "Wagner II.*", "wag2");
        ProjectionPseudoCylindrical wag3 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_wag3, Projections::G_wag3, Projections::FI_wag3, Projections::GI_wag3, "Wagner III.*", "wag3");
        ProjectionPseudoCylindrical wag4 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_wag4, Projections::G_wag4, Projections::FI_wag4, Projections::GI_wag4, "Wagner IV.*", "wag4");
        ProjectionPseudoCylindrical wag6 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_wag6, Projections::G_wag6, Projections::FI_wag6, Projections::GI_wag6, "Wagner VI.*", "wag6");
        ProjectionPseudoCylindrical wag7 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_wag7, Projections::G_wag7, Projections::FI_wag7, Projections::GI_wag7, "Wagner VII.*", "wag7");
        ProjectionPseudoAzimuthal wer = new ProjectionPseudoAzimuthal(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_wer, Projections::G_wer, Projections::FI_wer, Projections::GI_wer, "Werner-Staab", "wer");
        ProjectionPseudoCylindrical weren = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_weren, Projections::G_weren, Projections::FI_weren, Projections::GI_weren, "Werenskiold I.*", "weren");
        ProjectionPseudoAzimuthal wiech = new ProjectionPseudoAzimuthal(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_wiech, Projections::G_wiech, Projections::F_wiech, Projections::G_wiech, "Wiechel", "wiech");
        ProjectionPseudoCylindrical wink1 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_wink1, Projections::G_wink1, Projections::FI_wink1, Projections::GI_wink1, "Winkel I.*", "wink1");
        ProjectionPseudoCylindrical wink2 = new ProjectionPseudoCylindrical(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_wink2, Projections::G_wink2, Projections::FI_wink2, Projections::GI_wink2, "Winkel II.*", "wink2");
        ProjectionPseudoAzimuthal wintri = new ProjectionPseudoAzimuthal(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_wintri, Projections::G_wintri, Projections::FI_wintri, Projections::GI_wintri, "Winkel, tripel*", "wintri");
        ProjectionPseudoAzimuthal wintrib = new ProjectionPseudoAzimuthal(6380.0, 90.0, 0.0, 10.0, default_lon_dir, 0.0, 0.0, 0.0, 1.0, Projections::F_wintri_bopc, Projections::G_wintri_bopc, Projections::FI_wintri, Projections::GI_wintri, "Winkel, tripel, BOPC", "wintrib");
        projections.add(adamh);
        projections.add(adams1);
        projections.add(adams2);
        projections.add(aea);
        projections.add(aeqd);
        projections.add(aitoff);
        projections.add(api);
        projections.add(apiel);
        projections.add(armad);
        projections.add(august);
        projections.add(bacon);
        projections.add(behr);
        projections.add(boggs);
        projections.add(bonne);
        projections.add(breus);
        projections.add(bries);
        projections.add(cc);
        projections.add(cea);
        projections.add(clar);
        projections.add(collg);
        projections.add(crast);
        projections.add(cwe);
        projections.add(denoy);
        projections.add(eck1);
        projections.add(eck2);
        projections.add(eck3);
        projections.add(eck4);
        projections.add(eck5);
        projections.add(eck6);
        projections.add(eckgr);
        projections.add(eisen);
        projections.add(eqc);
        projections.add(eqdc);
        projections.add(eqdc2);
        projections.add(eqdc3);
        projections.add(fahey);
        projections.add(fouc);
        projections.add(fouc_s);
        projections.add(fourn);
        projections.add(fourn2);
        projections.add(gall);
        projections.add(gins4);
        projections.add(gins5);
        projections.add(gins6);
        projections.add(gins9);
        projections.add(gins8);
        projections.add(gnom);
        projections.add(goode);
        projections.add(guyou);
        projections.add(hammer);
        projections.add(hataea);
        projections.add(hire);
        projections.add(jam);
        projections.add(kav5);
        projections.add(kav7);
        projections.add(laea);
        projections.add(lagrng);
        projections.add(larr);
        projections.add(lask);
        projections.add(lcc);
        projections.add(leac);
        projections.add(leac2);
        projections.add(litt);
        projections.add(loxim);
        projections.add(maurer);
        projections.add(mbt_s);
        projections.add(mbt_s3);
        projections.add(mbtfpp);
        projections.add(mbtfpq);
        projections.add(mbtfps);
        projections.add(mbtfps2);
        projections.add(merc);
        projections.add(mill);
        projections.add(moll);
        projections.add(nell);
        projections.add(nell_h);
        projections.add(nicol);
        projections.add(ortel);
        projections.add(ortho);
        projections.add(parab);
        projections.add(peiq);
        projections.add(pers);
        projections.add(persf);
        projections.add(persn);
        projections.add(poly);
        projections.add(putp1);
        projections.add(putp2);
        projections.add(putp3);
        projections.add(putp3p);
        projections.add(putp4p);
        projections.add(putp5);
        projections.add(putp5p);
        projections.add(putp6);
        projections.add(putp6p);
        projections.add(qua_aut);
        projections.add(rpoly);
        projections.add(sinu);
        projections.add(solo);
        projections.add(stere);
        projections.add(twi);
        projections.add(urm5);
        projections.add(vandg);
        projections.add(vandg2);
        projections.add(vandg3);
        projections.add(vandg4);
        projections.add(wag1);
        projections.add(wag2);
        projections.add(wag3);
        projections.add(wag4);
        projections.add(wag6);
        projections.add(wag7);
        projections.add(wer);
        projections.add(weren);
        projections.add(wiech);
        projections.add(wink1);
        projections.add(wink2);
        projections.add(wintri);
        projections.add(wintrib);
    }

    public static double F_def(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        return lat / 57.29577951308232;
    }

    public static double G_def(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        return lon / 57.29577951308232;
    }

    public static double F_adamh(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double a = Math.cos(lat / 57.29577951308232) * Math.sin(lonr / 57.29577951308232);
        if (Math.abs(a) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(a) in F_adamh coordinate function, ", "abs(a) > 1: ", a);
        }
        double A = Math.acos(a);
        double B = 1.5707963267948966 - lat / 57.29577951308232;
        double v = 0.5 * (A - B);
        double m = Math.sqrt(2.0) * Math.sin(v);
        if (m > 1.00001 || m < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(m) in F_adamh coordinate function, ", "abs(m) > 1: ", m);
        }
        if (m > 1.0) {
            m = 1.0;
        } else if (m < -1.0) {
            m = -1.0;
        }
        double M = Math.asin(m);
        double u = 0.5 * (A + B);
        double n = Math.sqrt(2.0) * Math.cos(u);
        if (n > 1.00001 || n < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(n) in F_adamh coordinate function, ", "abs(n) > 1: ", n);
        }
        if (n > 1.0) {
            n = 1.0;
        } else if (n < -1.0) {
            n = -1.0;
        }
        double N = Math.asin(n);
        double Xe = NumIntegration.getInEllipticIntegral1(Math.sqrt(0.5), M, 1.0E-14);
        double Ye = NumIntegration.getInEllipticIntegral1(Math.sqrt(0.5), N, 1.0E-14);
        double X = R * 0.5 * (Ye - Xe) / Math.sqrt(2.0) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_adamh coordinate function, ", "F_adamh > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_adamh(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double a = Math.cos(lat / 57.29577951308232) * Math.sin(lonr / 57.29577951308232);
        if (Math.abs(a) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(a) in G_adamh coordinate function, ", "abs(a) > 1: ", a);
        }
        double A = Math.acos(a);
        double B = 1.5707963267948966 - lat / 57.29577951308232;
        double v = 0.5 * (A - B);
        double m = Math.sqrt(2.0) * Math.sin(v);
        if (m > 1.00001 || m < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(m) in G_adamh coordinate function, ", "abs(m) > 1: ", m);
        }
        if (m > 1.0) {
            m = 1.0;
        } else if (m < -1.0) {
            m = -1.0;
        }
        double M = Math.asin(m);
        double u = 0.5 * (A + B);
        double n = Math.sqrt(2.0) * Math.cos(u);
        if (n > 1.00001 || n < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(n) in G_adamh coordinate function, ", "abs(n) > 1: ", n);
        }
        if (n > 1.0) {
            n = 1.0;
        } else if (n < -1.0) {
            n = -1.0;
        }
        double N = Math.asin(n);
        double Xe = NumIntegration.getInEllipticIntegral1(Math.sqrt(0.5), M, 1.0E-14);
        double Ye = NumIntegration.getInEllipticIntegral1(Math.sqrt(0.5), N, 1.0E-14);
        double Y = R * 0.5 * (Ye + Xe) / Math.sqrt(2.0) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_adamh coordinate function, ", "G_adamh > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_adams1(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double phi = Math.asin(Math.tan(0.5 * lat / 57.29577951308232));
        double a = (Math.cos(phi) * Math.sin(0.5 * lonr / 57.29577951308232) - Math.sin(phi)) / Math.sqrt(2.0);
        if (Math.abs(a) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(a) in F_adams1 coordinate function, ", "abs(a) > 1: ", a);
        }
        double A = Math.acos(a);
        double b = (Math.cos(phi) * Math.sin(0.5 * lonr / 57.29577951308232) + Math.sin(phi)) / Math.sqrt(2.0);
        if (Math.abs(b) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(b) in F_adams1 coordinate function, ", "abs(b) > 1: ", b);
        }
        double B = Math.acos(b);
        double u = 0.5 * (A + B);
        double n = Math.sqrt(2.0) * Math.cos(u);
        if (n > 1.00001 || n < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(n) in F_adams1 coordinate function, ", "abs(n) > 1: ", n);
        }
        if (n > 1.0) {
            n = 1.0;
        } else if (n < -1.0) {
            n = -1.0;
        }
        double N = Math.asin(n);
        double Xe = NumIntegration.getInEllipticIntegral1(Math.sqrt(0.5), N, 1.0E-14);
        double X = R * Xe + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_adams1 coordinate function, ", "F_adams1 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_adams1(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double phi = Math.asin(Math.tan(0.5 * lat / 57.29577951308232));
        double a = (Math.cos(phi) * Math.sin(0.5 * lonr / 57.29577951308232) - Math.sin(phi)) / Math.sqrt(2.0);
        if (Math.abs(a) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(a) in G_adams1 coordinate function, ", "abs(a) > 1: ", a);
        }
        double A = Math.acos(a);
        double b = (Math.cos(phi) * Math.sin(0.5 * lonr / 57.29577951308232) + Math.sin(phi)) / Math.sqrt(2.0);
        if (Math.abs(b) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(b) in G_adams1 coordinate function, ", "abs(b) > 1: ", b);
        }
        double B = Math.acos(b);
        double v = 0.5 * (A - B);
        double m = Math.sqrt(2.0) * Math.sin(v);
        if (m > 1.00001 || m < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(m) in G_adams1 coordinate function, ", "abs(m) > 1: ", m);
        }
        if (m > 1.0) {
            m = 1.0;
        } else if (m < -1.0) {
            m = -1.0;
        }
        double M = Math.asin(m);
        double Ye = NumIntegration.getInEllipticIntegral1(Math.sqrt(0.5), M, 1.0E-14);
        double Y = R * Ye + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_adams1 coordinate function, ", "G_adams1 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_adams2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double phi = Math.asin(Math.tan(0.5 * lat / 57.29577951308232));
        double a = Math.cos(phi) * Math.sin(0.5 * lonr / 57.29577951308232);
        if (Math.abs(a) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(a) in F_adams2 coordinate function, ", "abs(a) > 1: ", a);
        }
        double A = Math.acos(a);
        double b = Math.sin(phi);
        double B = Math.acos(b);
        double v = 0.5 * (A - B);
        double m = Math.sqrt(2.0) * Math.sin(v);
        if (m > 1.00001 || m < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(m) in F_adams2 coordinate function, ", "abs(m) > 1: ", m);
        }
        if (m > 1.0) {
            m = 1.0;
        } else if (m < -1.0) {
            m = -1.0;
        }
        double M = Math.asin(m);
        double u = 0.5 * (A + B);
        double n = Math.sqrt(2.0) * Math.cos(u);
        if (n > 1.00001 || n < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(n) in F_adams2 coordinate function, ", "abs(n) > 1: ", n);
        }
        if (n > 1.0) {
            n = 1.0;
        } else if (n < -1.0) {
            n = -1.0;
        }
        double N = Math.asin(n);
        double Xe = NumIntegration.getInEllipticIntegral1(Math.sqrt(0.5), M, 1.0E-14);
        double Ye = NumIntegration.getInEllipticIntegral1(Math.sqrt(0.5), N, 1.0E-14);
        double X = R * 0.5 * (Ye - Xe) / Math.sqrt(2.0) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_adams2 coordinate function, ", "F_adams2 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_adams2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double phi = Math.asin(Math.tan(0.5 * lat / 57.29577951308232));
        double a = Math.cos(phi) * Math.sin(0.5 * lonr / 57.29577951308232);
        if (Math.abs(a) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(a) in G_adams2 coordinate function, ", "abs(a) > 1: ", a);
        }
        double A = Math.acos(a);
        double b = Math.sin(phi);
        double B = Math.acos(b);
        double v = 0.5 * (A - B);
        double m = Math.sqrt(2.0) * Math.sin(v);
        if (m > 1.00001 || m < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(m) in G_adams2 coordinate function, ", "abs(m) > 1: ", m);
        }
        if (m > 1.0) {
            m = 1.0;
        } else if (m < -1.0) {
            m = -1.0;
        }
        double M = Math.asin(m);
        double u = 0.5 * (A + B);
        double n = Math.sqrt(2.0) * Math.cos(u);
        if (n > 1.00001 || n < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(n) in G_adams2 coordinate function, ", "abs(n) > 1: ", n);
        }
        if (n > 1.0) {
            n = 1.0;
        } else if (n < -1.0) {
            n = -1.0;
        }
        double N = Math.asin(n);
        double Xe = NumIntegration.getInEllipticIntegral1(Math.sqrt(0.5), M, 1.0E-14);
        double Ye = NumIntegration.getInEllipticIntegral1(Math.sqrt(0.5), N, 1.0E-14);
        double Y = R * 0.5 * (Ye + Xe) / Math.sqrt(2.0) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_adams2 coordinate function, ", "G_adams2 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_aea(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double n = 0.5 * (Math.sin(lat1 / 57.29577951308232) + Math.sin(lat2 / 57.29577951308232));
        if (Math.abs(n) < 1.0E-37) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate G_aea coordinate function, ", "1 / n, n = 0:", n);
        }
        double B = Math.cos(lat1 / 57.29577951308232) * Math.cos(lat1 / 57.29577951308232);
        double C = B + 2.0 * n * Math.sin(lat1 / 57.29577951308232);
        double D = C - 2.0 * n * Math.sin(lat / 57.29577951308232);
        if (D < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in F_aea coordinate function, ", "D < 0: ", D);
        }
        double rho = R * Math.sqrt(D) / n;
        double X = rho * Math.sin(n * lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_aea coordinate function, ", "F_aea > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_aea(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double n = 0.5 * (Math.sin(lat1 / 57.29577951308232) + Math.sin(lat2 / 57.29577951308232));
        if (Math.abs(n) < 1.0E-37) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate G_aea coordinate function, ", "1 / n, n = 0:", n);
        }
        double B = Math.cos(lat1 / 57.29577951308232) * Math.cos(lat1 / 57.29577951308232);
        double C = B + 2.0 * n * Math.sin(lat1 / 57.29577951308232);
        double D = C - 2.0 * n * Math.sin(lat / 57.29577951308232);
        if (D < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in G_aea coordinate function, ", "D < 0: ", D);
        }
        double rho = R * Math.sqrt(D) / n;
        double E = C - 2.0 * n * Math.sin(lat1 / 57.29577951308232);
        if (E < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(E) in G_aea coordinate function, ", "E < 0: ", E);
        }
        double rho0 = R * Math.sqrt(E) / n;
        double Y = rho0 - rho * Math.cos(n * lonr / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_aea coordinate function, ", "G_AEA > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_aea(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_aea coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_aea coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double n = 0.5 * (Math.sin(lat1 / 57.29577951308232) + Math.sin(lat2 / 57.29577951308232));
        if (Math.abs(n) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate FI_leac2 coordinate function, ", "1.0 / n, n = 0:", n);
        }
        double A = Math.cos(lat1 / 57.29577951308232) * Math.cos(lat1 / 57.29577951308232);
        double C = A + 2.0 * n * Math.sin(lat1 / 57.29577951308232);
        double E = C - 2.0 * n * Math.sin(lat1 / 57.29577951308232);
        if (E < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(E) in FI_aea coordinate function, ", "E < 0: ", E);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double rho0 = R * Math.sqrt(E) / n;
        double B = rho0 - Yr;
        double rho = Math.sqrt(Xr * Xr + B * B);
        double D = A / (2.0 * n) + Math.sin(lat1 / 57.29577951308232) - n * rho * rho / (2.0 * R * R);
        if (D > 1.00001 || D < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(D) in FI_aea coordinate function, ", "abs(D) > 1: ", D);
        }
        if (D > 1.0) {
            D = 1.0;
        } else if (D < -1.0) {
            D = -1.0;
        }
        double lat = Math.asin(D) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_aea coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_aea(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_aea coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_aea coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double n = 0.5 * (Math.sin(lat1 / 57.29577951308232) + Math.sin(lat2 / 57.29577951308232));
        if (Math.abs(n) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_aea coordinate function, ", "1.0 / n, n = 0:", n);
        }
        double A = Math.cos(lat1 / 57.29577951308232) * Math.cos(lat1 / 57.29577951308232);
        double C = A + 2.0 * n * Math.sin(lat1 / 57.29577951308232);
        double E = C - 2.0 * n * Math.sin(lat1 / 57.29577951308232);
        if (E < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(E) in GI_aea coordinate function, ", "E < 0: ", E);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double rho0 = R * Math.sqrt(E) / n;
        double B = rho0 - Yr;
        double eps = Math.atan2(Xr, B) * 57.29577951308232;
        double lonr = eps / n;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_aea coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_aeqd(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double rho = R * (90.0 - lat) / 57.29577951308232;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = rho * Math.sin(lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_aeqd coordinate function, ", "F_aeqd > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_aeqd(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double rho = R * (90.0 - lat) / 57.29577951308232;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double Y = -rho * Math.cos(lonr / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_aeqd coordinate function, ", "G_aeqd > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_aeqd(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_aeqd coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_aeqd coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double dist = Math.sqrt(Xr * Xr + Yr * Yr);
        double lat = 90.0 - dist / R * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_aeqd coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_aeqd(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_aeqd coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_aeqd coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double lonr = Math.atan2(Xr, -Yr) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_aeqd coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_aitoff(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double X = 0.0;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = Math.cos(lat / 57.29577951308232) * Math.cos(lonr / 2.0 / 57.29577951308232);
        if (Math.abs(A) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(A) in F_aitoff coordinate function, ", "A > 1: ", A);
        }
        double theta = Math.acos(A);
        if (Math.abs(theta) < 1.0E-37) {
            X = dx;
        } else {
            double C = Math.sin(lat / 57.29577951308232) / Math.sin(theta);
            double D = 1.0 - C * C;
            if (D < -1.0E-5) {
                System.out.println(lat + " " + lon);
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in F_aitoff coordinate function, ", "D < 0: ", D);
            }
            if (D < 0.0) {
                D = 0.0;
            }
            X = 2.0 * R * theta * Math.signum(lonr) * Math.sqrt(D) + dx;
        }
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_aitoff coordinate function, ", "F_aitoff > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_aitoff(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = 0.0;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = Math.cos(lat / 57.29577951308232) * Math.cos(lonr / 2.0 / 57.29577951308232);
        if (A > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(A) in G_aitoff coordinate function, ", "A > 1: ", A);
        }
        double theta = Math.acos(A);
        if (Math.abs(theta) < 1.0E-37) {
            Y = dy;
        } else {
            double C = Math.sin(lat / 57.29577951308232) / Math.sin(theta);
            Y = R * theta * C + dy;
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_aitoff coordinate function, ", "G_aitoff > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_aitoff(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_aitoff coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_aitoff coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double theta = Math.signum(Yr) * Math.sqrt(Xr * Xr + 4.0 * Yr * Yr) / (2.0 * R) * 57.29577951308232;
        double arg = Yr * Math.sin(theta / 57.29577951308232) / (R * theta / 57.29577951308232);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_aitoff coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double lat = Math.asin(arg) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_aitoff coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_aitoff(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_aitoff coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_aitoff coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double theta = Math.signum(Yr) * Math.sqrt(Xr * Xr + 4.0 * Yr * Yr) / (2.0 * R) * 57.29577951308232;
        double arg = Yr * Math.sin(theta / 57.29577951308232) / (R * theta / 57.29577951308232);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in GI_aitoff coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double lat = Math.asin(arg) * 57.29577951308232;
        double arg2 = Xr * Math.sin(theta / 57.29577951308232) / (2.0 * R * theta / 57.29577951308232 * Math.cos(lat / 57.29577951308232));
        if (arg2 > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg2) in GI_aitoff coordinate function, ", "abs(arg2) > 1: ", arg2);
        }
        if (arg2 > 1.0) {
            arg2 = 1.0;
        } else if (arg2 < -1.0) {
            arg2 = -1.0;
        }
        double lonr = 2.0 * Math.asin(arg2) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_aitoff coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_api(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 0.0;
        if (Math.abs(lonr) < 1.0E-9) {
            X = dx;
        } else {
            double Y;
            if (Math.abs(lonr) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_api coordinate function, ", "1.0 / lonr, lonr = 0:", lonr);
            }
            double F = (141.3716694115407 / Math.abs(lonr) + Math.abs(lonr) / 57.29577951308232) / 2.0;
            double G = F * F - (Y = R * lat / 57.29577951308232) * Y / (R * R);
            if (G < 0.0) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(G) in F_bacon coordinate function, ", "G < 0: ", G);
            }
            X = R * Math.signum(lonr) * (Math.abs(lonr) / 57.29577951308232 - F + Math.sqrt(G)) + dx;
        }
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_api coordinate function, ", "F_api > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_api(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = R * lat / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_api coordinate function, ", "G_api > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_apiel(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = 2.0 * lat / 180.0;
        if (A > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(A) in F_apiel coordinate function, ", "A > 1: ", A);
        }
        double X = R * lonr / 57.29577951308232 * Math.cos(Math.asin(A)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_apiel coordinate function, ", "F_apiel > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_apiel(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = R * lat / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_apiel coordinate function, ", "G_apiel > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_apiel(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_apiel coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = (Y - dy) / R * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_apiel                          coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_apiel(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_apiel coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_apiel coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        if (Math.abs(lat1) > 89.999999999) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_apiel coordinate function, ", "1.0 / cos(lat1), lat1 = +-90.", lat1);
        }
        double lat = Projections.FI_apiel(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double A = 2.0 * lat / 180.0;
        if (A > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(A) in GI_apiel coordinate function, ", "A > 1: ", A);
        }
        double lonr = (X - dx) / (R * Math.cos(Math.asin(A))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_apiel coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_armad(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double lat_int = -Math.atan(Math.cos(0.5 * lonr / 57.29577951308232) / Math.tan(0.3490658503988659)) * 57.29577951308232;
        double lat_ = lat < lat_int ? lat_int : lat;
        double X = R * (1.0 + Math.cos(lat_ / 57.29577951308232)) * Math.sin(lonr / 2.0 / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_armad coordinate function, ", "F_armad > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_armad(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double lat_int = -Math.atan(Math.cos(0.5 * lonr / 57.29577951308232) / Math.tan(0.3490658503988659)) * 57.29577951308232;
        double lat_ = lat < lat_int ? lat_int : lat;
        double C0 = (1.0 + Math.sin(0.3490658503988659) - Math.cos(0.3490658503988659)) / 2.0;
        double Y = R * (C0 + Math.sin(lat_ / 57.29577951308232) * Math.cos(0.3490658503988659) - (1.0 + Math.cos(lat_ / 57.29577951308232)) * Math.sin(0.3490658503988659) * Math.cos(lonr / 2.0 / 57.29577951308232)) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_armad coordinate function, ", "G_armad > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_armad(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_armad coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_armad coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double C0 = (1.0 + Math.sin(0.3490658503988659) - Math.cos(0.3490658503988659)) / 2.0;
        double A1 = Xr * Math.sin(0.3490658503988659);
        double A2 = R * C0 - Yr;
        double A = A1 * A1 + A2 * A2;
        double B = 4.0 * R * (R * C0 - Yr) * Math.cos(0.3490658503988659);
        double C = 4.0 * R * R * Math.cos(0.3490658503988659) * Math.cos(0.3490658503988659);
        double D = 4.0 * R * R * Math.sin(0.3490658503988659) * Math.sin(0.3490658503988659);
        ArrayList<Double> roots = new ArrayList<Double>();
        Quartic.solveR(A / D, B / D, (2.0 * A + C) / D, B / D, (A - D) / D, roots);
        if (roots.size() == 0) {
            // empty if block
        }
        double lat = 0.0;
        Iterator iterator = roots.iterator();
        while (iterator.hasNext()) {
            double root = (Double)iterator.next();
            double latn = 2.0 * Math.atan(root) * 57.29577951308232;
            if (!(Math.abs(latn) <= 90.0)) continue;
            double lon = 2.0 * Math.atan(Xr * Math.sin(0.3490658503988659) / (R * (C0 + Math.sin(latn / 57.29577951308232) * Math.cos(0.3490658503988659)) - Yr)) * 57.29577951308232;
            double Xn = R * (1.0 + Math.cos(latn / 57.29577951308232)) * Math.sin(lon / 2.0 / 57.29577951308232) + dx;
            if (!(Math.abs(Xn - X) < 1.0E-5)) continue;
            lat = latn;
            break;
        }
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_armad coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_armad(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_apiel coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_apiel coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double lat = Projections.FI_armad(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double C0 = (1.0 + Math.sin(0.3490658503988659) - Math.cos(0.3490658503988659)) / 2.0;
        double lonr = 2.0 * Math.atan(Xr * Math.sin(0.3490658503988659) / (R * (C0 + Math.sin(lat / 57.29577951308232) * Math.cos(0.3490658503988659)) - Yr)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_apiel coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_august(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double yl;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double C1 = Math.sqrt(1.0 - Math.tan(0.5 * lat / 57.29577951308232) * Math.tan(0.5 * lat / 57.29577951308232));
        double C = 1.0 + C1 * Math.cos(0.5 * lonr / 57.29577951308232);
        if (Math.abs(C) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_august coordinate function, ", "1 / C, C = 0:", C);
        }
        double xl = Math.sin(0.5 * lonr / 57.29577951308232) * C1 / C;
        double X = 4.0 * R * xl * (3.0 + xl * xl - 3.0 * (yl = Math.tan(0.5 * lat / 57.29577951308232) / C) * yl) / 3.0 + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_august coordinate function, ", "F_armad > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_august(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double C1 = Math.sqrt(1.0 - Math.tan(0.5 * lat / 57.29577951308232) * Math.tan(0.5 * lat / 57.29577951308232));
        double C = 1.0 + C1 * Math.cos(0.5 * lonr / 57.29577951308232);
        if (Math.abs(C) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_august coordinate function, ", "1 / C, C = 0:", C);
        }
        double xl = Math.sin(0.5 * lonr / 57.29577951308232) * C1 / C;
        double yl = Math.tan(0.5 * lat / 57.29577951308232) / C;
        double Y = 4.0 * R * yl * (3.0 + 3.0 * xl * xl - yl * yl) / 3.0 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_august coordinate function, ", "G_armad > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_august(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_august coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_august coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double rho = 1.0 + 9.0 * (Xr * Xr + Yr * Yr) / (64.0 * R * R);
        double discr1 = rho * rho - 0.5625 * Yr * Yr / (R * R);
        if (discr1 < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_august coordinate function, ", "sqrt(discr1) < 0.", discr1);
        }
        double discr2 = 0.5 * (rho - Math.sqrt(discr1));
        if (discr2 < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_august coordinate function, ", "sqrt(discr2) < 0.", discr2);
        }
        double eta = Math.asin(Math.sqrt(discr2)) / 3.0;
        if (Math.abs(eta) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate FI_august coordinate function, ", "1.0 / eta, eta = 0:", eta);
        }
        double arg = 3.0 * Yr / (8.0 * R * Math.sin(3.0 * eta));
        double xi = Math.log(arg + Math.sqrt(arg * arg - 1.0)) / 3.0;
        double xl = 2.0 * Math.sinh(xi) * Math.cos(eta);
        double yl = 2.0 * Math.cosh(xi) * Math.sin(eta);
        double lat = 2.0 * Math.atan(2.0 * yl / (1.0 + xl * xl + yl * yl)) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_august coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_august(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_august coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_august coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double rho = 1.0 + 9.0 * (Xr * Xr + Yr * Yr) / (64.0 * R * R);
        double discr1 = rho * rho - 0.5625 * Yr * Yr / (R * R);
        if (discr1 < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_august coordinate function, ", "sqrt(discr1) < 0.", discr1);
        }
        double discr2 = 0.5 * (rho - Math.sqrt(discr1));
        if (discr2 < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_august coordinate function, ", "sqrt(discr2) < 0.", discr2);
        }
        double eta = Math.asin(Math.sqrt(discr2)) / 3.0;
        if (Math.abs(eta) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_august coordinate function, ", "1.0 / eta, eta = 0:", eta);
        }
        double arg = 3.0 * Yr / (8.0 * R * Math.sin(3.0 * eta));
        double xi = Math.log(arg + Math.sqrt(arg * arg - 1.0)) / 3.0;
        double xl = 2.0 * Math.sinh(xi) * Math.cos(eta);
        double yl = 2.0 * Math.cosh(xi) * Math.sin(eta);
        double lonr = 2.0 * Math.signum(Xr) * Math.atan(2.0 * xl / (1.0 - xl * xl - yl * yl)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_apiel coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_bacon(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 0.0;
        if (Math.abs(lonr) < 1.0E-9) {
            X = dx;
        } else {
            double Y;
            double F = (141.3716694115407 / Math.abs(lonr) + Math.abs(lonr) / 57.29577951308232) / 2.0;
            double G = F * F - (Y = R * Math.PI / 2.0 * Math.sin(lat / 57.29577951308232)) * Y / (R * R);
            if (G < -1.0E-5) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(G) in F_bacon coordinate function, ", "G < 0: ", G);
            }
            if (G < 0.0) {
                G = 0.0;
            }
            X = R * Math.signum(lonr) * (Math.abs(lonr) / 57.29577951308232 - F + Math.sqrt(G)) + dx;
        }
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_bacon coordinate function, ", "F_bacon > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_bacon(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = R * 1.5707963267948966 * Math.sin(lat / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_bacon coordinate function, ", "G_bacon > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_behr(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = R * lonr * Math.cos(0.5235987755982988) / 57.29577951308232 + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_behr coordinate function, ", "F_behr > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_behr(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = R * Math.sin(lat / 57.29577951308232) / Math.cos(0.5235987755982988) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_behr coordinate function, ", "G_behr > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_behr(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_behr coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double lat1_cos = Math.cos(0.5235987755982988);
        double arg = Yr * lat1_cos / R;
        if (Math.abs(arg) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_behr coordinate function, ", "abs(asin(arg)) > 1.0.", arg);
        }
        double lat = Math.asin(arg) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_behr coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_behr(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_behr coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        double Xr = X - dx;
        double lat1_cos = Math.cos(0.5235987755982988);
        double lonr = Xr / (R * lat1_cos) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_behr coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_boggs(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cx = 2.00276;
        double A = 1.11072;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_moll);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_moll);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double B = 1.0 / Math.cos(lat / 57.29577951308232) + 1.11072 / Math.cos(theta / 57.29577951308232);
        if (Math.abs(B) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_boggs coordinate function, ", "1.0 / B, B = 0:", B);
        }
        double X = 2.00276 * R * lonr / 57.29577951308232 / B + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_boggs coordinate function, ", "F_boggs > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_boggs(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = 0.49931;
        double D = Math.sqrt(2.0);
        double lonr = CartTransformation.redLon0(lon, lon0);
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_moll);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_moll);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double Y = 0.49931 * R * (lat / 57.29577951308232 + D * Math.sin(theta / 57.29577951308232)) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_boggs coordinate function, ", "G_boggs > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_boggs(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_boggs coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_boggs coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = 0.49931;
        double D = Math.sqrt(2.0);
        double arg = Yr / (0.49931 * R);
        double theta0 = -Projections.FITheta_boggs(arg, 0.0) / Projections.FIThetaDer_boggs(arg, 0.0);
        if (Math.abs(theta0) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_boggs coordinate function, ", "abs(theta0)  > 90.", theta0);
        }
        FTheta ft = new FTheta(arg, Projections::FITheta_boggs);
        FThetaDer ftd = new FThetaDer(arg, Projections::FIThetaDer_boggs);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double lat = arg * 57.29577951308232 - D * Math.sin(theta / 57.29577951308232) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_boggs coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_boggs(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_boggs coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_boggs coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double cx = 2.00276;
        double cy = 0.49931;
        double C = 1.11072;
        double D = Math.sqrt(2.0);
        double Xr = X - dx;
        double Yr = Y - dy;
        double arg = Yr / (0.49931 * R);
        double theta0 = -Projections.FITheta_boggs(arg, 0.0) / Projections.FIThetaDer_boggs(arg, 0.0);
        if (Math.abs(theta0) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_boggs coordinate function, ", "abs(theta0)  > 90.", theta0);
        }
        FTheta ft = new FTheta(arg, Projections::FITheta_boggs);
        FThetaDer ftd = new FThetaDer(arg, Projections::FIThetaDer_boggs);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double lat = arg * 57.29577951308232 - D * Math.sin(theta / 57.29577951308232) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_boggs coordinate function, ", "abs(lat)  > 90.", lat);
        }
        double E = 1.0 / Math.cos(lat / 57.29577951308232) + 1.11072 / Math.cos(theta / 57.29577951308232);
        if (Math.abs(E) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_boggs coordinate function, ", "1.0 / E, E = 0:", E);
        }
        double lonr = Xr * E / (2.00276 * R) * 57.29577951308232;
        double lon = CartTransformation.redLon0(lonr, -lon0);
        if (Math.abs(lon) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_boggs coordinate function, ", "abs(lon)  > 180.", lon);
        }
        return lon;
    }

    public static double FITheta_boggs(double arg, double theta) {
        double c1 = 0.3183098861837907;
        double c2 = Math.sqrt(2.0);
        return Math.asin(0.3183098861837907 * (2.0 * theta / 57.29577951308232 + Math.sin(2.0 * theta / 57.29577951308232))) + c2 * Math.sin(theta / 57.29577951308232) - arg;
    }

    public static double FIThetaDer_boggs(double lat, double theta) {
        double c1 = 0.3183098861837907;
        double c2 = Math.sqrt(2.0);
        double A = 0.3183098861837907 * (2.0 * theta / 57.29577951308232 + Math.sin(2.0 * theta / 57.29577951308232));
        double B = 1.0 - A * A;
        if (Math.abs(B) < 1.0E-37) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate FI_boggs coordinate function, ", "1 / B, B = 0:", B);
        }
        return (0.6366197723675814 * (1.0 + Math.cos(2.0 * theta / 57.29577951308232)) / Math.sqrt(B) + c2 * Math.cos(theta / 57.29577951308232)) / 57.29577951308232;
    }

    public static double F_bonne(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = Math.tan(lat1 / 57.29577951308232);
        if (Math.abs(lat1) == 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate tan(lat1) in F_bonne coordinate function, ", "lat1 = +-90: ", lat1);
        }
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate F_bonne coordinate function, ", "1 / A, A = 0:", A);
        }
        double rho0 = R / A;
        double rho = rho0 + R * (lat1 - lat) / 57.29577951308232;
        double X = rho * Math.sin(R * lonr / 57.29577951308232 * Math.cos(lat / 57.29577951308232) / rho) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_bonne coordinate function, ", "F_bonne > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_bonne(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = Math.tan(lat1 / 57.29577951308232);
        if (Math.abs(lat1) == 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate tan(lat1) in G_bonne coordinate function, ", "lat1 = +-90: ", lat1);
        }
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate G_bonne coordinate function, ", "1 / A, A = 0:", A);
        }
        double rho0 = R / A;
        double rho = rho0 + R * (lat1 - lat) / 57.29577951308232;
        if (Math.abs(rho) < 1.0E-37) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate G_bonne coordinate function, ", "1 / B, B = 0:", rho);
        }
        double Y = rho0 - rho * Math.cos(R * lonr / 57.29577951308232 * Math.cos(lat / 57.29577951308232) / rho) + dy;
        return Y;
    }

    public static double FI_bonne(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_bonne coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_bonne coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        if (Math.abs(lat1) > 89.999999999) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate FI_bonne coordinate function, ", "1.0 / cos(lat1), lat1 = +-90.", lat1);
        }
        double A = Math.tan(lat1 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate FI_bonne coordinate function, ", "1.0 / A, A = 0:", A);
        }
        double rho0 = R / A;
        double Xr = X - dx;
        double Yr = Y - dy;
        double B = rho0 - Yr;
        double rho = Math.signum(lat1) * Math.sqrt(Xr * Xr + B * B);
        double lat = (rho0 - rho) / R * 57.29577951308232 + lat1;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_bonne coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_bonne(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lat;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_bonne coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_bonne coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        if (Math.abs(lat1) > 89.999999999) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_bonne coordinate function, ", "1.0 / cos(lat1), lat1 = +-90.", lat1);
        }
        double A = Math.tan(lat1 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_bonne coordinate function, ", "1.0 / A, A = 0:", A);
        }
        double rho0 = R / A;
        double Xr = X - dx;
        double Yr = Y - dy;
        double B = rho0 - Yr;
        double rho = Math.signum(lat1) * Math.sqrt(Xr * Xr + B * B);
        double lonr = rho / R / Math.cos((lat = (rho0 - rho) / R * 57.29577951308232 + lat1) / 57.29577951308232) * Math.atan2(Xr, B) * 57.29577951308232;
        double lon = CartTransformation.redLon0(lonr, -lon0);
        if (Math.abs(lon) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_bonne coordinate function, ", "abs(lon)  > 180.", lon);
        }
        return lon;
    }

    public static double F_breus(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = (90.0 - lat) / 2.0 / 57.29577951308232;
        double B = Math.cos(A);
        if (B < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(B) in F_breus coordinate function, ", "B < 0: ", B);
        }
        double rho = 2.0 * R * Math.sin(A) * Math.sqrt(B);
        double X = rho * Math.sin(lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_breus coordinate function, ", "F_breus > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_breus(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = (90.0 - lat) / 2.0 / 57.29577951308232;
        double B = Math.cos(A);
        if (B < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(B) in G_breus coordinate function, ", "B < 0: ", B);
        }
        double rho = 2.0 * R * Math.sin(A) * Math.sqrt(B);
        double Y = -rho * Math.cos(lonr / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_breus coordinate function, ", "G_breus > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_bries(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double W = 0.5;
        double M = Math.sqrt(0.875);
        double D = 2.0 / (1.0 + Math.cos(lat / 57.29577951308232) * Math.cos(0.5 * lonr / 57.29577951308232));
        double X = R * Math.sqrt(D) / 0.5 * M * Math.cos(lat / 57.29577951308232) * Math.sin(0.5 * lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_bries coordinate function, ", "F_bries > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_bries(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double W = 0.5;
        double M = Math.sqrt(0.875);
        double D = 2.0 / (1.0 + Math.cos(lat / 57.29577951308232) * Math.cos(0.5 * lonr / 57.29577951308232));
        double Y = R * Math.sqrt(D) / M * Math.sin(lat / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_bries coordinate function, ", "G_bries > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_bries(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Xr;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_bries coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_bries coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double F = 0.25;
        double Yr = Y - dy;
        double M = Math.sqrt(0.875);
        double A = 4.0 * R * R * Yr * Yr * M * M - Yr * Yr * Yr * Yr * M * M * M * M - 0.0625 * (Xr = X - dx) * Xr * Yr * Yr;
        if (A < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(A) in FI_bries coordinate function, ", "A < 0: ", A);
        }
        double B = Math.sqrt(A) / (2.0 * R * R);
        if (Math.abs(B) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(B) in FI_bries coordinate function, ", "abs(B) > 1: ", B);
        }
        double lat = Math.signum(Yr) * Math.asin(B) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_bries coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_bries(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_bries coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_bries coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_bries(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double A = Math.sin(lat / 57.29577951308232);
        double B = Math.cos(lat / 57.29577951308232);
        double F = 0.25;
        double M = Math.sqrt(0.875);
        double Xr = X - dx;
        double Yr = Y - dy;
        double C = 2.0 * R * R * A * A - Yr * Yr * M * M;
        double D = Yr * Yr * Yr * Yr * M * M * M * M * B * B - C * C;
        if (D < -1.0E-5) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in GI_bries coordinate function, ", "D < 0: ", D);
        }
        if (D < 0.0) {
            D = 0.0;
        }
        if (Math.abs(lonr = 4.0 * Math.signum(X) * Math.atan2(Math.sqrt(D), C) * 57.29577951308232) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_bries coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_cc(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = R * lonr / 57.29577951308232 * Math.cos(lat1 / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_cc coordinate function, ", "F_cc > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_cc(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(Math.abs(lat) - 90.0) < 1.0E-9) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate tan(lat) in G_cc coordinate function, ", "lat = +-90: ", lat);
        }
        double Y = R * Math.tan(lat / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_cc coordinate function, ", "G_cc > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_cc(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_cc coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Math.atan((Y - dy) / R) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_cc coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_cc(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_cc coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(lat1) > 89.999999999) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_cc coordinate function, ", "1.0 / cos(lat1), lat1 = +-90.", lat1);
        }
        double lonr = (X - dx) / (R * Math.cos(lat1 / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_cc coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_cea(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = R * lonr * Math.cos(lat1 / 57.29577951308232) / 57.29577951308232 + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_cea coordinate function, ", "F_cea > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_cea(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = R * Math.sin(lat / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_cea coordinate function, ", "G_cea > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_cea(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_cea coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double arg = Yr / R;
        if (Math.abs(arg) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_cea coordinate function, ", "abs(asin(arg)) > 1.0.", arg);
        }
        double lat = Math.asin(arg) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_cea coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_cea(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_cea coordinate function, ", "FI_cea > MAX_FLOAT: ", X);
        }
        if (Math.abs(lat1) > 89.999999999) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_cea coordinate function, ", "1.0 / cos(lat1), lat1 = +-90.", lat1);
        }
        double Xr = X - dx;
        double lonr = Xr / (R * Math.cos(lat1 / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_cea coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_clar(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double h = 2.368;
        return Projections.F_persf(lat, lon, R, lat1, lat2, lon0, dx, dy, 2.368);
    }

    public static double G_clar(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double h = 2.368;
        return Projections.G_persf(lat, lon, R, lat1, lat2, lon0, dx, dy, 2.368);
    }

    public static double FI_clar(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double h = 2.368;
        return Projections.FI_persf(X, Y, R, lat1, lat2, lon0, dx, dy, 2.368);
    }

    public static double GI_clar(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double h = 2.368;
        return Projections.GI_persf(X, Y, R, lat1, lat2, lon0, dx, dy, 2.368);
    }

    public static double F_collg(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr;
        double cx = 2.0 / Math.sqrt(Math.PI);
        double X = cx * R * (lonr = CartTransformation.redLon0(lon, lon0)) / 57.29577951308232 * Math.sqrt(1.0 - Math.sin(lat / 57.29577951308232)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_collg coordinate function, ", "F_collg > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_collg(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = Math.sqrt(Math.PI);
        double Y = cy * R * (1.0 - Math.sqrt(1.0 - Math.sin(lat / 57.29577951308232))) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_collg coordinate function, ", "G_collg > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_collg(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_collg coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_collg coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = Math.sqrt(Math.PI);
        double A = 1.0 - Yr / (R * cy);
        double arg = 1.0 - A * A + dy;
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_collg coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double lat = Math.asin(arg) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_collg coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_collg(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_collg coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_collg coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_collg(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double Xr = X - dx;
        double cx = 2.0 / Math.sqrt(Math.PI);
        double lonr = Xr / (R * cx * Math.sqrt(1.0 - Math.sin(lat / 57.29577951308232))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_collg coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_crast(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr;
        double cx = Math.sqrt(0.954929658551372);
        double X = R * cx * (lonr = CartTransformation.redLon0(lon, lon0)) / 57.29577951308232 * (2.0 * Math.cos(2.0 * lat / 3.0 / 57.29577951308232) - 1.0) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_crast coordinate function, ", "F_crast > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_crast(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = Math.sqrt(Math.PI * 3);
        double Y = R * cy * Math.sin(lat / 3.0 / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_crast coordinate function, ", "G_crast > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_crast(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_crast coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = Math.sqrt(Math.PI * 3);
        double arg = Yr / (R * cy);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_crast coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double lat = 3.0 * Math.asin(arg) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_crast coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_crast(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_crast coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_crast coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_crast(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double Xr = X - dx;
        double cx = Math.sqrt(0.954929658551372);
        double lonr = Xr / (R * cx * (2.0 * Math.cos(0.6666666666666666 * lat / 57.29577951308232) - 1.0)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_crast coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_cwe(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double C;
        double B;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double theta = 23.8958;
        double ks = Math.sin(0.417060387398061);
        double kc = Math.cos(0.417060387398061);
        double K = NumIntegration.getInEllipticIntegral1(kc, 1.5707963267948966, 1.0E-14);
        double u1 = 2.0 * (1.0 - kc) * Math.cos(lat / 57.29577951308232);
        double v1 = (1.0 + kc) * (1.0 + Math.cos(lat / 57.29577951308232) * Math.cos(lonr / 57.29577951308232));
        double A = ks * ks * (1.0 - Math.cos(lat / 57.29577951308232) * Math.cos(lonr / 57.29577951308232));
        double D = A * A - 4.0 * kc * (B = u1 - v1) * (C = u1 + v1);
        if (D < -1.0E-5) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in F_cwe coordinate function, ", "D < 0: ", D);
        }
        if (D < 0.0) {
            D = 0.0;
        }
        double R1 = A - Math.sqrt(D);
        if (Math.abs(kc) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_cwe coordinate function, ", "1.0 / kc, kc = 0: ", kc);
        }
        if (Math.abs(C) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_cwe coordinate function, ", "1.0 / C, C = 0: ", C);
        }
        double R2 = R1 / (2.0 * C * kc);
        if (R2 > 1.00001 || R2 < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(R2) in F_cwe coordinate function, ", "abs(R2) > 1: ", R2);
        }
        if (R2 > 1.0) {
            R2 = 1.0;
        } else if (R2 < -1.0) {
            R2 = -1.0;
        }
        double lambda = -Math.asin(R2);
        if (Math.abs(B) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_cwe coordinate function, ", "1.0 / B, B = 0: ", B);
        }
        double E = 1.0 - R1 * R1 / (4.0 * B * B);
        if (E < -1.0E-5) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(E) in F_cwe coordinate function, ", "E < 0: ", E);
        }
        if (E < 0.0) {
            E = 0.0;
        }
        if (Math.abs(ks) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_cwe coordinate function, ", "1.0 / ks, ks = 0: ", ks);
        }
        double F = Math.sqrt(E) / ks;
        if (F > 1.00001 || F < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(F) in F_cwe coordinate function, ", "abs(F) > 1: ", F);
        }
        if (F > 1.0) {
            F = 1.0;
        } else if (F < -1.0) {
            F = -1.0;
        }
        double phi = Math.asin(F);
        double u2 = NumIntegration.getInEllipticIntegral1(ks, phi, 1.0E-14);
        double v2 = K - NumIntegration.getInEllipticIntegral1(kc, lambda, 1.0E-14);
        double u3 = Math.exp(Math.PI * u2 / (4.0 * K));
        double v3 = Math.PI * v2 / (4.0 * K);
        double X = R * Math.signum(lonr) * 0.5 * (u3 + 1.0 / u3) * Math.sin(v3) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_cwe coordinate function, ", "F_cwe > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_cwe(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double C;
        double B;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double theta = 23.8958;
        double ks = Math.sin(0.417060387398061);
        double kc = Math.cos(0.417060387398061);
        double K = NumIntegration.getInEllipticIntegral1(kc, 1.5707963267948966, 1.0E-14);
        double u1 = 2.0 * (1.0 - kc) * Math.cos(lat / 57.29577951308232);
        double v1 = (1.0 + kc) * (1.0 + Math.cos(lat / 57.29577951308232) * Math.cos(lonr / 57.29577951308232));
        double A = ks * ks * (1.0 - Math.cos(lat / 57.29577951308232) * Math.cos(lonr / 57.29577951308232));
        double D = A * A - 4.0 * kc * (B = u1 - v1) * (C = u1 + v1);
        if (D < -1.0E-5) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in G_cwe coordinate function, ", "D < 0: ", D);
        }
        if (D < 0.0) {
            D = 0.0;
        }
        double R1 = A - Math.sqrt(D);
        if (Math.abs(kc) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_cwe coordinate function, ", "1.0 / kc, kc = 0: ", kc);
        }
        if (Math.abs(C) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_cwe coordinate function, ", "1.0 / C, C = 0: ", C);
        }
        double R2 = R1 / (2.0 * C * kc);
        if (R2 > 1.00001 || R2 < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(R2) in G_cwe coordinate function, ", "abs(R2) > 1: ", R2);
        }
        if (R2 > 1.0) {
            R2 = 1.0;
        } else if (R2 < -1.0) {
            R2 = -1.0;
        }
        double lambda = -Math.asin(R2);
        if (Math.abs(B) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_cwe coordinate function, ", "1.0 / B, B = 0: ", B);
        }
        double E = 1.0 - R1 * R1 / (4.0 * B * B);
        if (E < -1.0E-5) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(E) in G_cwe coordinate function, ", "E < 0: ", E);
        }
        if (E < 0.0) {
            E = 0.0;
        }
        if (Math.abs(ks) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_cwe coordinate function, ", "1.0 / ks, ks = 0: ", ks);
        }
        double F = Math.sqrt(E) / ks;
        if (F > 1.00001 || F < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(F) in G_cwe coordinate function, ", "abs(F) > 1: ", F);
        }
        if (F > 1.0) {
            F = 1.0;
        } else if (F < -1.0) {
            F = -1.0;
        }
        double phi = Math.asin(F);
        double u2 = NumIntegration.getInEllipticIntegral1(ks, phi, 1.0E-14);
        double v2 = K - NumIntegration.getInEllipticIntegral1(kc, lambda, 1.0E-14);
        double u3 = Math.exp(Math.PI * u2 / (4.0 * K));
        double v3 = Math.PI * v2 / (4.0 * K);
        double Y = R * Math.signum(lat) * 0.5 * (u3 - 1.0 / u3) * Math.cos(v3) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_cwe coordinate function, ", "G_cwe > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_denoy(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double C;
        double A;
        double B;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = R * lonr / 57.29577951308232 * Math.cos((B = 0.95 - 0.08333333333333333 * (A = Math.abs(lonr) / 57.29577951308232) + 0.0016666666666666668 * A * A * A) * (C = 0.9 * lat / 57.29577951308232 + 0.03 * Math.pow(lat / 57.29577951308232, 5.0))) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_denoy coordinate function, ", "F_denoy > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_denoy(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = R * lat / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_denoy coordinate function, ", "G_denoy > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_denoy(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_denoy coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_denoy coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double lat = Yr / R * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_denoy coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_denoy(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_denoy coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_denoy coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double lonr0 = 0.0;
        FILon fl = new FILon(X, Y, R, lat1, lat2, lon0, dx, dy, Projections::FILon_denoy);
        FILonDer fld = new FILonDer(X, Y, R, lat1, lat2, lon0, dx, dy, Projections::FILonDer_denoy);
        double lonr = NewtonRaphson.findRoot(fl::function, fld::function, 0.0, 20, 1.0E-5);
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_denoy coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double FILon_denoy(double lon_i, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy) {
        double Xr = X - dx;
        double Yr = Y - dy;
        double A = Math.abs(lon_i) / 57.29577951308232;
        double B = 0.95 - 0.08333333333333333 * A + 0.0016666666666666668 * A * A * A;
        double C1 = 0.9 * Yr / R + 0.03 * Math.pow(Yr / R, 5.0);
        double C2 = Xr / R;
        return R * lon_i / 57.29577951308232 * Math.cos(B * C1) - Xr;
    }

    public static double FILonDer_denoy(double lon_i, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy) {
        double Xr = X - dx;
        double Yr = Y - dy;
        double A = Math.abs(lon_i) / 57.29577951308232;
        double B = 0.95 - 0.08333333333333333 * A + 0.0016666666666666668 * A * A * A;
        double C1 = 0.9 * Yr / R + 0.03 * Math.pow(Yr / R, 5.0);
        double D = Math.signum(lon_i) / 12.0 - 3.0 * lon_i * lon_i / 1969683.8100070462 * Math.signum(lon_i);
        return (R * Math.cos(B * C1) + R * C1 * D * lon_i / 57.29577951308232 * Math.sin(B * C1)) / 57.29577951308232;
    }

    public static double F_eck1(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr;
        double cx = 2.0 * Math.sqrt(0.2122065907891938);
        double X = cx * R * (lonr = CartTransformation.redLon0(lon, lon0)) / 57.29577951308232 * (1.0 - Math.abs(lat / 180.0)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_eck1 coordinate function, ", "F_eck1 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_eck1(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = 2.0 * Math.sqrt(0.2122065907891938);
        double Y = cy * R * lat / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_eck1 coordinate function, ", "G_eck1 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_eck1(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eck1 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eck1 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = 2.0 * Math.sqrt(0.2122065907891938);
        double lat = Yr / (cy * R) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_eck1 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_eck1(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eck1 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eck1 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_eck1(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double Xr = X - dx;
        double cx = 2.0 * Math.sqrt(0.2122065907891938);
        double lonr = Xr / (R * cx * (1.0 - Math.abs(lat / Math.PI / 57.29577951308232))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_eck1 coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_eck2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr;
        double cx = 2.0 / Math.sqrt(Math.PI * 6);
        double X = cx * R * (lonr = CartTransformation.redLon0(lon, lon0)) / 57.29577951308232 * Math.sqrt(4.0 - 3.0 * Math.sin(Math.abs(lat / 57.29577951308232))) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_eck2 coordinate function, ", "F_eck2 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_eck2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = Math.sqrt(2.0943951023931953);
        double Y = cy * R * (2.0 - Math.sqrt(4.0 - 3.0 * Math.sin(Math.abs(lat / 57.29577951308232)))) * Math.signum(lat) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_eck2 coordinate function, ", "G_eck2 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_eck2(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eck2 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eck2 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = Math.sqrt(2.0943951023931953);
        double A = 2.0 - Math.abs(Yr) / (R * cy);
        double arg = (4.0 - A * A) / 3.0;
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_eck2 coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double lat = Math.signum(Y) * Math.asin(arg) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_eck2 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_eck2(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eck2 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eck2 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_eck2(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double Xr = X - dx;
        double cx = 2.0 / Math.sqrt(Math.PI * 6);
        double lonr = Xr / (R * cx * Math.sqrt(4.0 - 3.0 * Math.sin(Math.abs(lat) / 57.29577951308232))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_eck2 coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_eck3(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cx = 2.0 / Math.sqrt(22.43597501544853);
        double A = 1.0;
        double B = 4.0;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double D = 1.0 - 4.0 * Math.pow(lat / 180.0, 2.0);
        if (D < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in F_eck3 coordinate function, ", "D < 0: ", D);
        }
        double X = cx * R * lonr / 57.29577951308232 * (1.0 + Math.sqrt(D)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_eck3 coordinate function, ", "F_eck3 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_eck3(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = 4.0 / Math.sqrt(22.43597501544853);
        double Y = cy * R * lat / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_eck3 coordinate function, ", "G_eck3 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_eck3(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eck3 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eck3 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = 4.0 / Math.sqrt(22.43597501544853);
        double lat = Yr / (R * cy) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_eck3 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_eck3(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eck3 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eck3 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_eck3(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double cx = 2.0 / Math.sqrt(22.43597501544853);
        double A = 1.0;
        double B = 4.0;
        double Xr = X - dx;
        double D = 1.0 - 4.0 * Math.pow(lat / 180.0, 2.0);
        if (D < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in GI_eck3 coordinate function, ", "D < 0: ", D);
        }
        double lonr = Xr / (R * cx * (1.0 + Math.sqrt(D))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_eck3 coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_eck4(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double c1 = 2.0 / Math.sqrt(22.43597501544853);
        double lonr = CartTransformation.redLon0(lon, lon0);
        double latr = lat / 57.29577951308232;
        double theta0 = (0.895168 * latr + 0.0218849 * latr * latr * latr + 0.00806809 * latr * latr * latr * latr * latr) * 57.29577951308232;
        FTheta ft = new FTheta(lat, Projections::FTheta_eck4);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_eck4);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double X = c1 * R * lonr / 57.29577951308232 * (1.0 + Math.cos(theta / 57.29577951308232)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_eck4 coordinate function, ", "F_eck4 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_eck4(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double c2 = 2.0 * Math.sqrt(0.43990084648844263);
        double latr = lat / 57.29577951308232;
        double theta0 = (0.895168 * latr + 0.0218849 * latr * latr * latr + 0.00806809 * latr * latr * latr * latr * latr) * 57.29577951308232;
        FTheta ft = new FTheta(lat, Projections::FTheta_eck4);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_eck4);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double Y = c2 * R * Math.sin(theta / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_eck4 coordinate function, ", "G_eck4 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FTheta_eck4(double lat, double theta) {
        double cp = 3.5707963267948966;
        return theta / 57.29577951308232 + 0.5 * Math.sin(2.0 * theta / 57.29577951308232) + 2.0 * Math.sin(theta / 57.29577951308232) - 3.5707963267948966 * Math.sin(lat / 57.29577951308232);
    }

    public static double FThetaDer_eck4(double lat, double theta) {
        return (1.0 + Math.cos(2.0 * theta / 57.29577951308232) + 2.0 * Math.cos(theta / 57.29577951308232)) / 57.29577951308232;
    }

    public static double FI_eck4(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eck4 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eck4 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double c2 = 2.0 * Math.sqrt(0.43990084648844263);
        double arg = Yr / (R * c2);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_eck4 coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = Math.asin(arg) * 57.29577951308232;
        double cp = 3.5707963267948966;
        double arg2 = (theta / 57.29577951308232 + 0.5 * Math.sin(2.0 * theta / 57.29577951308232) + 2.0 * Math.sin(theta / 57.29577951308232)) / 3.5707963267948966;
        if (arg2 > 1.00001 || arg2 < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg2) in FI_eck4 coordinate function, ", "abs(arg2) > 1: ", arg2);
        }
        if (arg2 > 1.0) {
            arg2 = 1.0;
        } else if (arg2 < -1.0) {
            arg2 = -1.0;
        }
        double lat = Math.asin(arg2) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_eck4 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_eck4(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eck4 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eck4 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_eck4(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double c2 = 2.0 * Math.sqrt(0.43990084648844263);
        double Xr = X - dx;
        double Yr = Y - dy;
        double arg = Yr / (R * c2);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in GI_eck4 coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = Math.asin(arg) * 57.29577951308232;
        double c1 = 2.0 / Math.sqrt(22.43597501544853);
        double lonr = Xr / (c1 * R * (1.0 + Math.cos(theta / 57.29577951308232))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_eck4 coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_eck5(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = R * lonr / 57.29577951308232 * (1.0 + Math.cos(lat / 57.29577951308232)) / Math.sqrt(5.141592653589793) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_eck5 coordinate function, ", "F_eck5 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_eck5(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = 2.0 * R * lat / 57.29577951308232 / Math.sqrt(5.141592653589793) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_eck5 coordinate function, ", "G_eck5 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_eck5(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eck5 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eck5 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double arg = 0.5 * Yr * Math.sqrt(5.141592653589793) / R;
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_eck5 coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double lat = Math.asin(arg) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_eck6 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_eck5(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eck5 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eck5 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_eck5(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double Xr = X - dx;
        double lonr = Xr * Math.sqrt(5.141592653589793) / (R * (1.0 + Math.cos(lat / 57.29577951308232))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_eck6 coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_eck6(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_eck6);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_eck6);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double X = R * (1.0 + Math.cos(theta / 57.29577951308232)) * lonr / 57.29577951308232 / Math.sqrt(5.141592653589793) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_eck6 coordinate function, ", "F_eck6 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_eck6(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_eck6);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_eck6);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double Y = 2.0 * R * theta / Math.sqrt(5.141592653589793) / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_eck6 coordinate function, ", "G_eck6 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FTheta_eck6(double lat, double theta) {
        return theta / 57.29577951308232 + Math.sin(theta / 57.29577951308232) - 2.5707963267948966 * Math.sin(lat / 57.29577951308232);
    }

    public static double FThetaDer_eck6(double lat, double theta) {
        return (1.0 + Math.cos(theta / 57.29577951308232)) / 57.29577951308232;
    }

    public static double FI_eck6(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eck6 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eck6 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double theta = Yr * Math.sqrt(5.141592653589793) / (2.0 * R) * 57.29577951308232;
        double A = 2.0 * (Math.sin(theta / 57.29577951308232) + theta / 57.29577951308232) / 5.141592653589793;
        if (A > 1.00001 || A < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(A) in FI_eck6 coordinate function, ", "abs(A) > 1: ", A);
        }
        if (A > 1.0) {
            A = 1.0;
        } else if (A < -1.0) {
            A = -1.0;
        }
        double lat = Math.asin(A) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_eck6 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_eck6(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eck6 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eck6 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_eck6(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double Xr = X - dx;
        double Yr = Y - dy;
        double theta = Yr * Math.sqrt(5.141592653589793) / (2.0 * R) * 57.29577951308232;
        double A = Math.cos(0.5 * theta / 57.29577951308232);
        double lonr = Xr * Math.sqrt(5.141592653589793) / (2.0 * R * A * A) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_eck6 coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_eckgr(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double W = 0.25;
        double D = 2.0 / (1.0 + Math.cos(lat / 57.29577951308232) * Math.cos(0.25 * lonr / 57.29577951308232));
        double X = R * Math.sqrt(D) / 0.25 * Math.cos(lat / 57.29577951308232) * Math.sin(0.25 * lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_eckgr coordinate function, ", "F_eckgr > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_eckgr(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double W = 0.25;
        double D = 2.0 / (1.0 + Math.cos(lat / 57.29577951308232) * Math.cos(0.25 * lonr / 57.29577951308232));
        double Y = R * Math.sqrt(D) * Math.sin(lat / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_eckgr coordinate function, ", "G_eckgr > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_eckgr(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eckgr coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eckgr coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double F = 0.25;
        double Yr = Y - dy;
        double Xr = X - dx;
        double A = 4.0 * R * R - Yr * Yr - 0.0625 * Xr * Xr;
        if (A < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(A) in FI_eckgr coordinate function, ", "A < 0: ", A);
        }
        double B = Yr * Math.sqrt(A) / (4.0 * R * R);
        if (Math.abs(B) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(B) in FI_eckgr coordinate function, ", "abs(B) > 1: ", B);
        }
        double lat = Math.asin(B) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_eckgr coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_eckgr(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eckgr coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eckgr coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_eckgr(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double A = Math.sin(lat / 57.29577951308232);
        double B = Math.cos(lat / 57.29577951308232);
        double F = 0.25;
        double Xr = X - dx;
        double Yr = Y - dy;
        double C = 2.0 * R * R * A * A - Yr * Yr;
        double D = Yr * Yr * Yr * Yr * B * B - C * C;
        if (D < -1.0E-5) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in GI_eckgr coordinate function, ", "D < 0: ", D);
        }
        if (D < 0.0) {
            D = 0.0;
        }
        if (Math.abs(lonr = 4.0 * Math.signum(X) * Math.atan2(Math.sqrt(D), C) * 57.29577951308232) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_eckgr coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_eisen(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double S1 = Math.sin(0.5 * lonr / 57.29577951308232);
        double C1 = Math.cos(0.5 * lonr / 57.29577951308232);
        double D = Math.cos(0.5 * lat / 57.29577951308232) + C1 * Math.sqrt(2.0 * Math.cos(lat / 57.29577951308232));
        if (Math.abs(D) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_eisen coordinate function, ", "1 / D, D = 0:", D);
        }
        double TT = Math.sin(0.5 * lat / 57.29577951308232) / D;
        double C = Math.sqrt(2.0 / (1.0 + TT * TT));
        double E = Math.cos(0.5 * lat / 57.29577951308232) + Math.sqrt(0.5 * Math.cos(lat / 57.29577951308232)) * (C1 + S1);
        double F = Math.cos(0.5 * lat / 57.29577951308232) + Math.sqrt(0.5 * Math.cos(lat / 57.29577951308232)) * (C1 - S1);
        if (Math.abs(F) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_eisen coordinate function, ", "1 / E, E = 0:", E);
        }
        double G = E / F;
        if (G < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(G) in F_eisen coordinate function, ", "G < 0: ", G);
        }
        double V = Math.sqrt(G);
        if (Math.abs(V) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_eisen coordinate function, ", "1 / V, V = 0:", V);
        }
        double X = R * (3.0 + Math.sqrt(8.0)) * (-2.0 * Math.log(V) + C * (V - 1.0 / V)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_eisen coordinate function, ", "F_eisen > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_eisen(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double S1 = Math.sin(0.5 * lonr / 57.29577951308232);
        double C1 = Math.cos(0.5 * lonr / 57.29577951308232);
        double D = Math.cos(0.5 * lat / 57.29577951308232) + C1 * Math.sqrt(2.0 * Math.cos(lat / 57.29577951308232));
        if (Math.abs(D) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_eisen coordinate function, ", "1 / D, D = 0:", D);
        }
        double TT = Math.sin(0.5 * lat / 57.29577951308232) / D;
        double C = Math.sqrt(2.0 / (1.0 + TT * TT));
        double E = Math.cos(0.5 * lat / 57.29577951308232) + Math.sqrt(0.5 * Math.cos(lat / 57.29577951308232)) * (C1 + S1);
        double F = Math.cos(0.5 * lat / 57.29577951308232) + Math.sqrt(0.5 * Math.cos(lat / 57.29577951308232)) * (C1 - S1);
        if (Math.abs(F) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_eisen coordinate function, ", "1 / E, E = 0:", E);
        }
        double G = E / F;
        if (G < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(G) in G_eisen coordinate function, ", "G < 0: ", G);
        }
        double V = Math.sqrt(G);
        if (Math.abs(V) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_eisen coordinate function, ", "1 / V, V = 0:", V);
        }
        if (Math.abs(TT) % 90.0 < 1.0E-37 && Math.abs(TT) > 1.0E-37) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate atan(TT) in G_eisen coordinate function, ", "TT = PI: ", TT);
        }
        double Y = R * (3.0 + Math.sqrt(8.0)) * (-2.0 * Math.atan(TT) + C * TT * (V + 1.0 / V)) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_eisen coordinate function, ", "G_eisen > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_eqc(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = R * lonr * Math.cos(lat1 / 57.29577951308232) / 57.29577951308232 + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_eqc coordinate function, ", "F_eqc > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_eqc(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = R * lat / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_eqc coordinate function, ", "G_eqc > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_eqc(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eqc coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = (Y - dy) / R * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_eqc coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_eqc(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eqc coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(lat1) > 89.999999999) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_eqc coordinate function, ", "1.0 / cos(lat1), lat1 = +-90.", lat1);
        }
        double lonr = (X - dx) / (R * Math.cos(lat1 / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_eqc coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_eqdc(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = Math.tan(lat1 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate F_eqdc coordinate function, ", "1 / A, A = 0:", A);
        }
        double rho0 = R / A;
        double rho = rho0 + R * (lat1 - lat) / 57.29577951308232;
        double n = Math.sin(lat1 / 57.29577951308232);
        double X = rho * Math.sin(n * lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_eqdc coordinate function, ", "F_eqdc > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_eqdc(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = Math.tan(lat1 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate G_eqdc coordinate function, ", "1 / A, A = 0:", A);
        }
        double rho0 = R / A;
        double rho = rho0 + R * (lat1 - lat) / 57.29577951308232;
        double n = Math.sin(lat1 / 57.29577951308232);
        double Y = rho0 - rho * Math.cos(n * lonr / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_eqdc coordinate function, ", "G_eqdc > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_eqdc(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eqdc coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eqdc coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double A = Math.tan(lat1 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate FI_eqdc coordinate function, ", "1.0 / A, A = 0:", A);
        }
        double Xr = X - dx;
        double rho0 = R / A;
        double Yr = Y - dy;
        double B = rho0 - Yr;
        double rho = Math.sqrt(Xr * Xr + B * B);
        double lat = lat1 - (rho - rho0) * 57.29577951308232 / R;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_eqdc coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_eqdc(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eqdc coordinate function, ", "X > MAX_FLOAT: ", Y);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eqdc coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double A = Math.tan(lat1 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_eqdc coordinate function, ", "1.0 / A, A = 0:", A);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double rho0 = R / A;
        double B = rho0 - Yr;
        double eps = Math.atan2(Xr, B) * 57.29577951308232;
        double n = Math.sin(lat1 / 57.29577951308232);
        if (Math.abs(n) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_eqdc coordinate function, ", "1.0 / n, n = 0:", n);
        }
        double lonr = eps / n;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_eqdc coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_eqdc2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        if (Math.abs(lat1 - 90.0) < 1.0E-9) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate F_eqdc2 coordinate function, ", "1 / (90 - lat1), lat1 = 90.", lat1);
        }
        double rho = R * (90.0 - lat) / 57.29577951308232;
        double n = Math.cos(lat1 / 57.29577951308232) / (90.0 - lat1);
        double X = rho * Math.sin(n * lonr) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_eqdc2 coordinate function, ", "F_eqdc2 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_eqdc2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        if (Math.abs(lat1 - 90.0) < 1.0E-9) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate G_eqdc2 coordinate function, ", "1 / (90 - lat1), lat1 = 90.", lat1);
        }
        double rho = R * (90.0 - lat) / 57.29577951308232;
        double n = Math.cos(lat1 / 57.29577951308232) / (90.0 - lat1);
        double Y = -rho * Math.cos(n * lonr) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_eqdc2 coordinate function, ", "G_eqdc2 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_eqdc2(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eqdc2 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eqdc2 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double rho = Math.sqrt(Xr * Xr + Yr * Yr);
        double lat = 90.0 - rho / R * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_eqdc2 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_eqdc2(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eqdc2 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eqdc2 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        if (Math.abs(lat1 - 90.0) < 1.0E-9) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_eqdc2 coordinate function, ", "1.0 / (90 - lat1), lat1 = 90.", lat1);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double eps = Math.atan2(Xr, -Yr) * 57.29577951308232;
        double n = Math.cos(lat1 / 57.29577951308232) / (90.0 - lat1) * 57.29577951308232;
        if (Math.abs(n) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_eqdc2 coordinate function, ", "1.0 / n, n = 0:", n);
        }
        double lonr = eps / n;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_eqdc coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_eqdc3(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = Math.cos(lat1 / 57.29577951308232) - Math.cos(lat2 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate F_eqdc3 coordinate function, ", "1 / A, A = 0:", A);
        }
        double n = A / (lat2 - lat1) * 57.29577951308232;
        double rho = R * ((lat2 / 57.29577951308232 * Math.cos(lat1 / 57.29577951308232) - lat1 / 57.29577951308232 * Math.cos(lat2 / 57.29577951308232)) / A - lat / 57.29577951308232);
        double X = rho * Math.sin(n * lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_eqdc3 coordinate function, ", "F_eqdc3 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_eqdc3(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double rho;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = Math.cos(lat1 / 57.29577951308232) - Math.cos(lat2 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate G_eqdc3 coordinate function, ", "1 / A, A = 0:", A);
        }
        double n = A / (lat2 - lat1) * 57.29577951308232;
        double lat0 = 0.5 * (lat1 + lat2);
        double rho0 = R * ((lat2 / 57.29577951308232 * Math.cos(lat1 / 57.29577951308232) - lat1 / 57.29577951308232 * Math.cos(lat2 / 57.29577951308232)) / A - lat0 / 57.29577951308232);
        double Y = rho0 - (rho = R * ((lat2 / 57.29577951308232 * Math.cos(lat1 / 57.29577951308232) - lat1 / 57.29577951308232 * Math.cos(lat2 / 57.29577951308232)) / A - lat / 57.29577951308232)) * Math.cos(n * lonr / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_eqdc3 coordinate function, ", "G_eqdc3 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_eqdc3(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eqdc3 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_eqdc3 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double A = Math.cos(lat1 / 57.29577951308232) - Math.cos(lat2 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate FI_eqdc3 coordinate function, ", "1.0 / A, A = 0:", A);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double lat0 = 0.5 * (lat1 + lat2);
        double rho0 = R * ((lat2 / 57.29577951308232 * Math.cos(lat1 / 57.29577951308232) - lat1 / 57.29577951308232 * Math.cos(lat2 / 57.29577951308232)) / A - lat0 / 57.29577951308232);
        double B = rho0 - Yr;
        double rho = Math.sqrt(Xr * Xr + B * B);
        double lat = lat0 - (rho - rho0) * 57.29577951308232 / R;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_eqdc3 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_eqdc3(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eqdc3 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eqdc3 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        if (Math.abs(lat1 - 90.0) < 1.0E-9) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_eqdc2 coordinate function, ", "1.0 / (90 - lat1), lat1 = 90.", lat1);
        }
        double A = Math.cos(lat1 / 57.29577951308232) - Math.cos(lat2 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_eqdc3 coordinate function, ", "1.0 / A, A = 0:", A);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double lat0 = 0.5 * (lat1 + lat2);
        double rho0 = R * ((lat2 / 57.29577951308232 * Math.cos(lat1 / 57.29577951308232) - lat1 / 57.29577951308232 * Math.cos(lat2 / 57.29577951308232)) / A - lat0 / 57.29577951308232);
        double B = rho0 - Yr;
        double eps = Math.atan2(Xr, B) * 57.29577951308232;
        double n = A / (lat2 - lat1) * 57.29577951308232;
        if (Math.abs(n) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_eqdc3 coordinate function, ", "1.0 / n, n = 0:", n);
        }
        double lonr = eps / n;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_eqdc3 coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_fahey(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = Math.tan(lat / 2.0 / 57.29577951308232);
        double B = 1.0 - Math.pow(A, 2.0);
        if (B < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(B) in F_fahey coordinate function, ", "B < 0: ", B);
        }
        double X = R * lonr / 57.29577951308232 * Math.cos(lat1 / 57.29577951308232) * Math.sqrt(B) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_fahey coordinate function, ", "F_fahey > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_fahey(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = R * (1.0 + Math.cos(lat1 / 57.29577951308232)) * Math.tan(lat / 2.0 / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_fahey coordinate function, ", "G_fahey > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_fahey(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_fahey coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_fahey coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double lat = 2.0 * Math.atan(Yr / (R * (1.0 + Math.cos(lat1 / 57.29577951308232)))) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_fahey coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_fahey(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_fahey coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_fahey coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_fahey(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double Xr = X - dx;
        double A = Math.tan(lat / 2.0 / 57.29577951308232);
        double B = 1.0 - Math.pow(A, 2.0);
        if (B < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(B) in GI_fahey coordinate function, ", "B < 0: ", B);
        }
        double lonr = Xr / (R * Math.cos(lat1 / 57.29577951308232) * Math.sqrt(B)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_eck6 coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_fouc(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double p = Math.sqrt(Math.PI);
        double q = 2.0;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 2.0 / p * R * lonr / 57.29577951308232 * Math.cos(lat / 57.29577951308232) * Math.pow(Math.cos(lat / 2.0 / 57.29577951308232), 2.0) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_fouc coordinate function, ", "F_fouc > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_fouc(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double p = Math.sqrt(Math.PI);
        double q = 2.0;
        double Y = p * R * Math.tan(lat / 2.0 / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_fouc coordinate function, ", "G_fouc > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_fouc(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_fouc coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_fouc coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double p = Math.sqrt(Math.PI);
        double q = 2.0;
        double lat = 2.0 * Math.atan(Yr / (p * R)) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_fouc coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_fouc(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_fouc coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_fouc coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_fouc(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double p = Math.sqrt(Math.PI);
        double q = 2.0;
        double Xr = X - dx;
        double lonr = p * Xr / (2.0 * R * Math.cos(lat / 57.29577951308232) * Math.pow(Math.cos(lat / 2.0 / 57.29577951308232), 2.0)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_fouc coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_fouc_s(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = Math.cos(lat / 57.29577951308232);
        double B = Math.sin(lat1 / 57.29577951308232);
        double C = B + (1.0 - B) * A;
        if (Math.abs(C) < 1.0E-37) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate F_fouc_s coordinate function, ", "1 / C, C = 0:", A);
        }
        double X = R * lonr / 57.29577951308232 * A / C + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_fouc_s coordinate function, ", "F_fouc_s > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_fouc_s(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double A = Math.sin(lat1 / 57.29577951308232);
        double Y = R * (A * lat / 57.29577951308232 + (1.0 - A) * Math.sin(lat / 57.29577951308232)) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_foucs coordinate function, ", "G_foucs > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_fouc_s(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_fouc_s coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_fouc_s coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat0 = 0.0;
        FILat fl = new FILat(X, Y, R, lat1, lat2, lon0, dx, dy, Projections::FILat_fouc_s);
        FILatDer fld = new FILatDer(X, Y, R, lat1, lat2, lon0, dx, dy, Projections::FILatDer_fouc_s);
        double lat = NewtonRaphson.findRoot(fl::function, fld::function, 0.0, 20, 1.0E-5);
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_fouc_s coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_fouc_s(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_fouc_s coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_fouc_s coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_fouc_s(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double Xr = X - dx;
        double n = Math.sin(lat1 / 57.29577951308232);
        double lonr = Xr * (n + (1.0 - n) * Math.cos(lat / 57.29577951308232)) / (R * Math.cos(lat / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_fouc_s coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double FILat_fouc_s(double lat_i, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy) {
        double Yr = Y - dy;
        double n = Math.sin(lat1 / 57.29577951308232);
        double F = (R * (n * lat_i / 57.29577951308232 + (1.0 - n) * Math.sin(lat_i / 57.29577951308232)) - Yr) * 57.29577951308232;
        return F;
    }

    public static double FILatDer_fouc_s(double lat_i, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy) {
        double n = Math.sin(lat1 / 57.29577951308232);
        double dF = R * (n + (1.0 - n) * Math.cos(lat_i / 57.29577951308232));
        return dF;
    }

    public static double F_fourn(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double X = 0.0;
        double lonr = CartTransformation.redLon0(lon, lon0);
        if (Math.abs(lonr) < 1.0E-9 || Math.abs(Math.abs(lat) - 90.0) < 1.0E-9) {
            X = dx;
        } else if (Math.abs(lat) < 1.0E-9) {
            X = R * lonr / 57.29577951308232 + dx;
        } else if (Math.abs(Math.abs(lonr) - 90.0) < 1.0E-9) {
            X = R * lonr / 57.29577951308232 * Math.cos(lat / 57.29577951308232) + dx;
        } else {
            double Y = Projections.G_fourn(lat, lon, R, lat1, lat2, lon0, dx, dy, c);
            double N = 1.0 - 2.0 * Y / (Math.PI * R) * (2.0 * Y / (Math.PI * R));
            if (N < -1.0E-5) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(N) in F_fourn coordinate function, ", "N < 0: ", N);
            }
            if (N < 0.0) {
                N = 0.0;
            }
            X = R * lonr / 57.29577951308232 * Math.sqrt(N) + dx;
        }
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_fourn coordinate function, ", "F_fourn > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_fourn(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = 0.0;
        double lonr = CartTransformation.redLon0(lon, lon0);
        if (Math.abs(lonr) < 1.0E-9 || Math.abs(Math.abs(lat) - 90.0) < 1.0E-9) {
            Y = R * lat / 57.29577951308232 + dy;
        } else if (Math.abs(lat) < 1.0E-9) {
            Y = dy;
        } else if (Math.abs(Math.abs(lonr) - 90.0) < 1.0E-9) {
            Y = R * Math.PI / 2.0 * Math.sin(lat / 57.29577951308232) + dy;
        } else {
            double C = 2.4674011002723395;
            double P = Math.PI * Math.abs(Math.sin(lat / 57.29577951308232));
            double Q = P - 2.0 * Math.abs(lat) / 57.29577951308232;
            if (Math.abs(Q) < 1.0E-37) {
                throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate G_fourn coordinate function, ", "1 / Q, Q = 0.", Q);
            }
            double F = (2.4674011002723395 - lat / 57.29577951308232 * (lat / 57.29577951308232)) / Q;
            double G = 2.0 * lonr / 180.0;
            double L = G * G - 1.0;
            if (Math.abs(L) < 1.0E-37) {
                throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate G_fourn coordinate function, ", "1 / L, L = 0.", L);
            }
            double M = F * F - L * (2.4674011002723395 - F * P - lonr / 57.29577951308232 * (lonr / 57.29577951308232));
            if (M < -1.0E-5) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(M) in G_fourn coordinate function, ", "M < 0: ", M);
            }
            if (M < 0.0) {
                M = 0.0;
            }
            Y = R / L * Math.signum(lat) * (Math.sqrt(M) - F) + dy;
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_fourn coordinate function, ", "G_fourn > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_fourn2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = R / Math.sqrt(Math.PI) * lonr / 57.29577951308232 * Math.cos(lat / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_fourn2 coordinate function, ", "F_fourn2 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_fourn2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = R * Math.sqrt(Math.PI) / 2.0 * Math.sin(lat / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_fourn2 coordinate function, ", "G_fourn2 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_gall(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = R * Math.cos(lat1 / 57.29577951308232) * lonr / 57.29577951308232 + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_gall coordinate function, ", "F_gall > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_gall(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(lat / 2.0) == 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate tan(lat/2) in F_fourn coordinate function, ", "lat/2.0 = +-90: ", lat);
        }
        double Y = R * (1.0 + Math.cos(lat1 / 57.29577951308232)) * Math.tan(lat / 2.0 / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_gall coordinate function, ", "G_gall > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_gall(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_gall coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double lat = 2.0 * Math.atan(Yr / (R * (1.0 + Math.cos(lat1 / 57.29577951308232)))) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_gall coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_gall(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_gall coordinate function, ", "FI_cea > MAX_FLOAT: ", X);
        }
        if (Math.abs(lat1) > 89.999999999) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_gall coordinate function, ", "1.0 / cos(lat1), lat1 = +-90.", lat1);
        }
        double Xr = X - dx;
        double lonr = Xr / (R * Math.cos(lat1 / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_gall coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_gins4(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double c1 = 1.0;
        double c2 = 0.0;
        double c3 = 2.8283;
        double c4 = -1.69845;
        double c5 = 0.754046;
        double c6 = -0.180646;
        double c7 = 1.760031;
        double c8 = -0.389143;
        double c9 = 0.042555;
        double X = Projections.F_gins(lat, lonr, R, 1.0, 0.0, 2.8283, -1.69845, 0.754046, -0.180646, 1.760031, -0.389143, 0.042555, dx);
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_gins4 coordinate function, ", "F_gins8 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_gins4(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double c1 = 1.0;
        double c2 = 0.0;
        double c3 = 2.8283;
        double c4 = -1.69845;
        double c5 = 0.754046;
        double c6 = -0.180646;
        double c7 = 1.760031;
        double c8 = -0.389143;
        double c9 = 0.042555;
        double Y = Projections.G_gins(lat, lonr, R, 1.0, 0.0, 2.8283, -1.69845, 0.754046, -0.180646, 1.760031, -0.389143, 0.042555, dy);
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_gins4 coordinate function, ", "G_gins8 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_gins5(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double c1 = 1.0;
        double c2 = 0.0;
        double c3 = 2.583819;
        double c4 = -0.835827;
        double c5 = 0.170354;
        double c6 = -0.038094;
        double c7 = 1.543313;
        double c8 = -0.411435;
        double c9 = 0.082742;
        double X = Projections.F_gins(lat, lonr, R, 1.0, 0.0, 2.583819, -0.835827, 0.170354, -0.038094, 1.543313, -0.411435, 0.082742, dx);
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_gins5 coordinate function, ", "F_gins8 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_gins5(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double c1 = 1.0;
        double c2 = 0.0;
        double c3 = 2.583819;
        double c4 = -0.835827;
        double c5 = 0.170354;
        double c6 = -0.038094;
        double c7 = 1.543313;
        double c8 = -0.411435;
        double c9 = 0.082742;
        double Y = Projections.G_gins(lat, lonr, R, 1.0, 0.0, 2.583819, -0.835827, 0.170354, -0.038094, 1.543313, -0.411435, 0.082742, dy);
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_gins5 coordinate function, ", "G_gins8 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_gins6(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double c1 = 0.994605;
        double c2 = 0.044707;
        double c3 = 2.603377;
        double c4 = -0.622711;
        double c5 = -0.034239;
        double c6 = 0.0;
        double c7 = 1.341985;
        double c8 = -0.054981;
        double c9 = 0.0;
        double X = Projections.F_gins(lat, lonr, R, 0.994605, 0.044707, 2.603377, -0.622711, -0.034239, 0.0, 1.341985, -0.054981, 0.0, dx);
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_gins6 coordinate function, ", "F_gins8 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_gins6(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double c1 = 0.994605;
        double c2 = 0.044707;
        double c3 = 2.603377;
        double c4 = -0.622711;
        double c5 = -0.034239;
        double c6 = 0.0;
        double c7 = 1.341985;
        double c8 = -0.054981;
        double c9 = 0.0;
        double Y = Projections.G_gins(lat, lonr, R, 0.994605, 0.044707, 2.603377, -0.622711, -0.034239, 0.0, 1.341985, -0.054981, 0.0, dy);
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_gins6 coordinate function, ", "G_gins8 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_gins9(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double c1 = 1.0;
        double c2 = 0.0;
        double c3 = 2.6516;
        double c4 = -0.76534;
        double c5 = 0.19123;
        double c6 = -0.047094;
        double c7 = 1.36289;
        double c8 = -0.13965;
        double c9 = 0.013762;
        double X = Projections.F_gins(lat, lonr, R, 1.0, 0.0, 2.6516, -0.76534, 0.19123, -0.047094, 1.36289, -0.13965, 0.013762, dx);
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_gins9 coordinate function, ", "F_gins8 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_gins9(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double c1 = 1.0;
        double c2 = 0.0;
        double c3 = 2.6516;
        double c4 = -0.76534;
        double c5 = 0.19123;
        double c6 = -0.047094;
        double c7 = 1.36289;
        double c8 = -0.13965;
        double c9 = 0.013762;
        double Y = Projections.G_gins(lat, lonr, R, 1.0, 0.0, 2.6516, -0.76534, 0.19123, -0.047094, 1.36289, -0.13965, 0.013762, dy);
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_gins9 coordinate function, ", "G_gins8 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    private static double F_gins(double lat, double lon, double R, double c1, double c2, double c3, double c4, double c5, double c6, double c7, double c8, double c9, double dx) {
        double X = 0.0;
        double latp2 = lat * lat / 3282.806350011744;
        double latp4 = latp2 * latp2;
        double xa = 0.0;
        double ya = c1 * lat / 57.29577951308232 + c2 * lat / 57.29577951308232 * latp2;
        double xb = c3 + c4 * latp2 + c5 * latp4 + c6 * latp2 * latp4;
        double yb = c7 * lat / 57.29577951308232 + c8 * lat / 57.29577951308232 * latp2 + c9 * lat / 57.29577951308232 * latp4;
        double yba = yb - ya;
        if (Math.abs(yba) < 1.0E-37) {
            X = R * lon / 57.29577951308232 * c3 / Math.PI + dx;
        } else {
            double m = (xb * xb + yba * yba) / (2.0 * yba);
            double xbm = xb / m;
            if (xbm > 1.00001 || xbm < -1.00001) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(xbm) in F_gins coordinate function, ", "abs(xbm) > 1: ", xbm);
            }
            if (xbm > 1.0) {
                xbm = 1.0;
            } else if (xbm < -1.0) {
                xbm = -1.0;
            }
            double alpha = Math.asin(xbm) * lon / 57.29577951308232 / Math.PI;
            X = R * m * Math.sin(alpha) + dx;
        }
        return X;
    }

    private static double G_gins(double lat, double lon, double R, double c1, double c2, double c3, double c4, double c5, double c6, double c7, double c8, double c9, double dy) {
        double Y = 0.0;
        double latp2 = lat * lat / 3282.806350011744;
        double latp4 = latp2 * latp2;
        double xa = 0.0;
        double ya = c1 * lat / 57.29577951308232 + c2 * lat / 57.29577951308232 * latp2;
        double xb = c3 + c4 * latp2 + c5 * latp4 + c6 * latp2 * latp4;
        double yb = c7 * lat / 57.29577951308232 + c8 * lat / 57.29577951308232 * latp2 + c9 * lat / 57.29577951308232 * latp4;
        double yba = yb - ya;
        if (Math.abs(yba) < 1.0E-37) {
            Y = dy;
        } else {
            double m = (xb * xb + yba * yba) / (2.0 * yba);
            double xbm = xb / m;
            if (xbm > 1.00001 || xbm < -1.00001) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(xbm) in G_gins coordinate function, ", "abs(xbm) > 1: ", xbm);
            }
            if (xbm > 1.0) {
                xbm = 1.0;
            } else if (xbm < -1.0) {
                xbm = -1.0;
            }
            double alpha = Math.asin(xbm) * lon / 57.29577951308232 / Math.PI;
            Y = R * (ya + m - m * Math.cos(alpha)) + dy;
        }
        return Y;
    }

    public static double F_gins8(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double c1 = 0.162388;
        double c2 = 0.87;
        double c3 = 9.52426E-4;
        double X = R * lonr / 57.29577951308232 * (1.0 - 0.162388 * (lat / 57.29577951308232) * (lat / 57.29577951308232)) * (0.87 - 9.52426E-4 * Math.pow(lonr / 57.29577951308232, 4.0)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_gins8 coordinate function, ", "F_gins8 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_gins8(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = R * lat / 57.29577951308232 * (1.0 + 0.0 * Math.pow(Math.abs(lat) / 57.29577951308232, 3.0)) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_gins8 coordinate function, ", "G_gins8 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_gins8(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_gins8 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_gins8 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double lat = 0.0;
        if (Math.abs(Yr) > 1.0E-37) {
            double p3;
            double p5;
            double at = 0.08333333333333333;
            double ct = -Yr / R;
            double p1 = Math.pow(Math.sqrt(3.0 * (0.1875 - 0.14814814814814814 * ct * ct * ct)) + 0.75, 0.3333333333333333);
            double p2 = 4.0 * Math.pow(0.6666666666666666, 0.3333333333333333) * ct;
            double p4 = p2 / p1;
            double p6 = p4 + (p5 = p1 / (p3 = Math.pow(2.0, 0.3333333333333333) * Math.pow(3.0, 0.6666666666666666) * 0.08333333333333333));
            double D1 = -p6 - 2.0 / (0.08333333333333333 * Math.sqrt(p6));
            if (D1 > 0.0) {
                double x1 = 0.5 * Math.sqrt(p6) - 0.5 * Math.sqrt(D1);
                double x2 = 0.5 * Math.sqrt(p6) + 0.5 * Math.sqrt(D1);
                lat = (Math.abs(x1) < Math.abs(x2) ? x1 : x2) * 57.29577951308232;
            } else {
                double D2 = -p6 + 2.0 / (0.08333333333333333 * Math.sqrt(p6));
                if (D2 > 0.0) {
                    double x3 = -0.5 * Math.sqrt(p6) - 0.5 * Math.sqrt(D2);
                    double x4 = -0.5 * Math.sqrt(p6) + 0.5 * Math.sqrt(D2);
                    lat = (Math.abs(x3) < Math.abs(x4) ? x3 : x4) * 57.29577951308232;
                }
            }
        }
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_gins8 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_gins8(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_gins8 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_gins8 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_gins8(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double lonr0 = 0.0;
        FILon fl = new FILon(lat, X, R, lat1, lat2, lon0, dx, dy, Projections::FILon_gins8);
        FILonDer fld = new FILonDer(lat, X, R, lat1, lat2, lon0, dx, dy, Projections::FILonDer_gins8);
        double lonr = NewtonRaphson.findRoot(fl::function, fld::function, 0.0, 20, 1.0E-5);
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_gins8 coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double FILon_gins8(double lon_i, double lat, double X, double R, double lat1, double lat2, double lon0, double dx, double dy) {
        double Xr = X - dx;
        double c1 = 0.162388;
        double c2 = 0.87;
        double c3 = 9.52426E-4;
        return R * lon_i / 57.29577951308232 * (1.0 - 0.162388 * lat * lat / 3282.806350011744) * (0.87 - 9.52426E-4 * Math.pow(lon_i / 57.29577951308232, 4.0)) - Xr;
    }

    public static double FILonDer_gins8(double lon_i, double lat, double X, double R, double lat1, double lat2, double lon0, double dx, double dy) {
        double Xr = X - dx;
        double c1 = 0.162388;
        double c2 = 0.87;
        double c3 = 9.52426E-4;
        return R * (1.0 - 0.162388 * lat * lat / 3282.806350011744) * (0.87 - 0.00476213 * Math.pow(lon_i / 57.29577951308232, 4.0)) / 57.29577951308232;
    }

    public static double F_gnom(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double rho = R * Math.tan((90.0 - lat) / 57.29577951308232);
        double X = rho * Math.sin(lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_gnom coordinate function, ", "F_gnom > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_gnom(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double rho = R * Math.tan((90.0 - lat) / 57.29577951308232);
        double Y = -rho * Math.cos(lonr / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_gnom coordinate function, ", "G_gnom > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_gnom(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_gnom coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_gnom coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double dist = Math.sqrt(Xr * Xr + Yr * Yr);
        double lat = 90.0 - Math.atan(dist / (2.0 * R)) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_gnom coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_gnom(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_gnom coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_gnom coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double lonr = Math.atan2(Xr, -Yr) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_gnom coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_goode(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lat_int = 40.733333333333334;
        double X = 0.0;
        X = Math.abs(lat) <= 40.733333333333334 ? Projections.F_sinu(lat, lon, R, lat1, lat2, lon0, dx, dy, c) : Projections.F_moll(lat, lon, R, lat1, lat2, lon0, dx, dy, c);
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_goode coordinate function, ", "F_goode > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_goode(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lat_int = 40.733333333333334;
        double Y = 0.0;
        if (Math.abs(lat) <= 40.733333333333334) {
            Y = Projections.G_sinu(lat, lon, R, lat1, lat2, lon0, dx, dy, c);
        } else {
            double theta0 = lat;
            FTheta ft = new FTheta(lat, Projections::FTheta_moll);
            FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_moll);
            double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
            Y = R * (Math.sqrt(2.0) * Math.sin(theta / 57.29577951308232) - 0.0528 * Math.signum(lat)) + dy;
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_goode coordinate function, ", "G_goode > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_guyou(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 0.0;
        if (Math.abs(Math.abs(lat) - 90.0) < 1.0E-9) {
            X = dx;
        } else {
            double a = (Math.cos(lat / 57.29577951308232) * Math.sin(lonr / 57.29577951308232) - Math.sin(lat / 57.29577951308232)) / Math.sqrt(2.0);
            if (Math.abs(a) > 1.0) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(a) in F_guyou coordinate function, ", "abs(a) > 1: ", a);
            }
            double A = Math.acos(a);
            double b = (Math.cos(lat / 57.29577951308232) * Math.sin(lonr / 57.29577951308232) + Math.sin(lat / 57.29577951308232)) / Math.sqrt(2.0);
            if (Math.abs(b) > 1.0) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(b) in F_guyou coordinate function, ", "abs(b) > 1: ", b);
            }
            double B = Math.acos(b);
            double u = 0.5 * (A + B);
            double n = Math.sqrt(2.0) * Math.cos(u);
            if (n > 1.00001 || n < -1.00001) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(n) in F_guyou coordinate function, ", "abs(n) > 1: ", n);
            }
            if (n > 1.0) {
                n = 1.0;
            } else if (n < -1.0) {
                n = -1.0;
            }
            double N = Math.asin(n);
            double Xe = NumIntegration.getInEllipticIntegral1(Math.sqrt(0.5), N, 1.0E-14);
            X = R * Xe + dx;
        }
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_guyou coordinate function, ", "F_guyou > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_guyou(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double Y = 0.0;
        if (Math.abs(Math.abs(lat) - 90.0) < 1.0E-9) {
            Y = Math.signum(lat) * 1.85407 * R + dy;
        } else {
            double a = (Math.cos(lat / 57.29577951308232) * Math.sin(lonr / 57.29577951308232) - Math.sin(lat / 57.29577951308232)) / Math.sqrt(2.0);
            if (Math.abs(a) > 1.0) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(a) in G_guyou coordinate function, ", "abs(a) > 1: ", a);
            }
            double A = Math.acos(a);
            double b = (Math.cos(lat / 57.29577951308232) * Math.sin(lonr / 57.29577951308232) + Math.sin(lat / 57.29577951308232)) / Math.sqrt(2.0);
            if (Math.abs(b) > 1.0) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(b) in G_guyou coordinate function, ", "abs(b) > 1: ", b);
            }
            double B = Math.acos(b);
            double v = 0.5 * (A - B);
            double m = Math.sqrt(2.0) * Math.sin(v);
            if (m > 1.00001 || m < -1.00001) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(m) in G_guyou coordinate function, ", "abs(m) > 1: ", m);
            }
            if (m > 1.0) {
                m = 1.0;
            } else if (m < -1.0) {
                m = -1.0;
            }
            double M = Math.asin(m);
            double Ye = NumIntegration.getInEllipticIntegral1(Math.sqrt(0.5), M, 1.0E-14);
            Y = R * Ye + dy;
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_guyou coordinate function, ", "G_guyou > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_hammer(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double W = 0.5;
        double D = 2.0 / (1.0 + Math.cos(lat / 57.29577951308232) * Math.cos(0.5 * lonr / 57.29577951308232));
        double X = R * Math.sqrt(D) / 0.5 * Math.cos(lat / 57.29577951308232) * Math.sin(0.5 * lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_hammer coordinate function, ", "F_hammer > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_hammer(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double W = 0.5;
        double D = 2.0 / (1.0 + Math.cos(lat / 57.29577951308232) * Math.cos(0.5 * lonr / 57.29577951308232));
        double Y = R * Math.sqrt(D) * Math.sin(lat / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_hammer coordinate function, ", "G_hammer > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_hammer(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_hammer coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_hammer coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double Xr = X - dx;
        double A = 16.0 * R * R - 4.0 * Yr * Yr - Xr * Xr;
        if (A < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(A) in FI_hammer coordinate function, ", "A < 0: ", A);
        }
        double B = Yr * Math.sqrt(A) / (4.0 * R * R);
        if (Math.abs(B) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(B) in FI_hammer coordinate function, ", "abs(B) > 1: ", B);
        }
        double lat = Math.asin(B) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_hammer coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_hammer(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_hammer coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_hammer coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_hammer(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double A = Math.sin(lat / 57.29577951308232);
        double B = Math.cos(lat / 57.29577951308232);
        double Xr = X - dx;
        double Yr = Y - dy;
        double C = 2.0 * R * R * A * A - Yr * Yr;
        double D = Yr * Yr * Yr * Yr * B * B - C * C;
        if (D < -1.0E-5) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in GI_hammer coordinate function, ", "D < 0: ", D);
        }
        if (D < 0.0) {
            D = 0.0;
        }
        if (Math.abs(lonr = 2.0 * Math.signum(X) * Math.atan2(Math.sqrt(D), C) * 57.29577951308232) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_hammer coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_hataea(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double c1 = 0.85;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double theta0 = 0.5 * lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_hataea);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_hataea);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double X = 0.85 * R * lonr / 57.29577951308232 * Math.cos(theta / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_hataea coordinate function, ", "F_hataea > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_hataea(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = lat < 0.0 ? 1.93052 : 1.56548;
        double theta0 = 0.5 * lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_hataea);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_hataea);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double Y = cy * R * Math.sin(theta / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_hataea coordinate function, ", "G_hataea > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FTheta_hataea(double lat, double theta) {
        double cp = lat < 0.0 ? 2.43763 : 2.67595;
        return 2.0 * theta / 57.29577951308232 + Math.sin(2.0 * theta / 57.29577951308232) - cp * Math.sin(lat / 57.29577951308232);
    }

    public static double FThetaDer_hataea(double lat, double theta) {
        return (2.0 + 2.0 * Math.cos(2.0 * theta / 57.29577951308232)) / 57.29577951308232;
    }

    public static double FI_hataea(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Yr;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_hataea coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_hataea coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double cy = (Yr = Y - dy) < 0.0 ? 1.93052 : 1.56548;
        double arg = Yr / (R * cy);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_hataea coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = Math.asin(arg) * 57.29577951308232;
        double cp = Yr < 0.0 ? 2.43763 : 2.67595;
        double arg2 = (2.0 * theta / 57.29577951308232 + Math.sin(2.0 * theta / 57.29577951308232)) / cp;
        if (arg2 > 1.00001 || arg2 < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg2) in FI_hataea coordinate function, ", "abs(arg2) > 1: ", arg2);
        }
        if (arg2 > 1.0) {
            arg2 = 1.0;
        } else if (arg2 < -1.0) {
            arg2 = -1.0;
        }
        double lat = Math.asin(arg2) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_hataea coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_hataea(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Yr;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_hataea coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_hataea coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_hataea(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double Xr = X - dx;
        double cy = (Yr = Y - dy) < 0.0 ? 1.93052 : 1.56548;
        double arg = Yr / (R * cy);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in GI_hataea coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = Math.asin(arg) * 57.29577951308232;
        double c1 = 0.85;
        double lonr = Xr / (0.85 * R * Math.cos(theta / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_hataea coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_hire(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double h = 2.0 + Math.sqrt(2.0) / 2.0;
        return Projections.F_persf(lat, lon, R, lat1, lat2, lon0, dx, dy, h);
    }

    public static double G_hire(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double h = 2.0 + Math.sqrt(2.0) / 2.0;
        return Projections.G_persf(lat, lon, R, lat1, lat2, lon0, dx, dy, h);
    }

    public static double FI_hire(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double h = 2.0 + Math.sqrt(2.0) / 2.0;
        return Projections.FI_persf(X, Y, R, lat1, lat2, lon0, dx, dy, h);
    }

    public static double GI_hire(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double h = 2.0 + Math.sqrt(2.0) / 2.0;
        return Projections.GI_persf(X, Y, R, lat1, lat2, lon0, dx, dy, h);
    }

    public static double F_jam(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double h = 1.5;
        return Projections.F_persf(lat, lon, R, lat1, lat2, lon0, dx, dy, 1.5);
    }

    public static double G_jam(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double h = 2.5;
        return Projections.G_persf(lat, lon, R, lat1, lat2, lon0, dx, dy, 2.5);
    }

    public static double FI_jam(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double h = 2.0 + Math.sqrt(2.0) / 2.0;
        return Projections.FI_persf(X, Y, R, lat1, lat2, lon0, dx, dy, h);
    }

    public static double GI_jam(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double h = 2.0 + Math.sqrt(2.0) / 2.0;
        return Projections.GI_persf(X, Y, R, lat1, lat2, lon0, dx, dy, h);
    }

    public static double F_kav5(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double p = 1.50488;
        double q = 1.35439;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 0.899998670990378 * R * lonr / 57.29577951308232 * Math.cos(lat / 57.29577951308232) / Math.cos(lat / 1.35439 / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_kav5 coordinate function, ", "F_kav5 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_kav5(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double p = 1.50488;
        double q = 1.35439;
        double Y = 1.50488 * R * Math.sin(lat / 1.35439 / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_kav5 coordinate function, ", "G_kav5 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_kav5(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_kav5 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_kav5 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double p = 1.50488;
        double q = 1.35439;
        double arg = Yr / (1.50488 * R);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in F_kav5 coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double lat = 1.35439 * Math.asin(arg) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_kav5 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_kav5(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_kav5 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_kav5 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_qua_aut(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double p = 1.50488;
        double q = 1.35439;
        double Xr = X - dx;
        double lonr = 1.50488 * Xr / (1.35439 * R * Math.cos(lat / 57.29577951308232) / Math.cos(lat / 1.35439 / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_kav5 coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_kav7(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cx = Math.sqrt(3.0) / 2.0;
        double B = 3.0;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double D = 1.0 - 3.0 * Math.pow(lat / 180.0, 2.0);
        if (Math.abs(D) == 1.0E-37) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(A) in F_kav7 coordinate function, ", "D = 0: ", D);
        }
        double X = cx * R * lonr / 57.29577951308232 * Math.sqrt(D) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_kav7 coordinate function, ", "F_kav7 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_kav7(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = R * lat / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_kav7 coordinate function, ", "G_kav7 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_kav7(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_kav7 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_kav7 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double lat = Yr / R * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_kav7 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_kav7(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_kav7 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_kav7 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_kav7(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double cx = Math.sqrt(3.0) / 2.0;
        double B = 3.0;
        double Xr = X - dx;
        double D = 1.0 - 3.0 * Math.pow(lat / 180.0, 2.0);
        if (D < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in GI_kav7 coordinate function, ", "D < 0: ", D);
        }
        double lonr = Xr / (R * cx * Math.sqrt(D)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_kav7 coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_laea(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double rho = 2.0 * R * Math.sin((90.0 - lat) / 2.0 / 57.29577951308232);
        double X = rho * Math.sin(lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_laea coordinate function, ", "F_laea > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_laea(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double rho = 2.0 * R * Math.sin((90.0 - lat) / 2.0 / 57.29577951308232);
        double Y = -rho * Math.cos(lonr / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_laea coordinate function, ", "G_laea > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_laea(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_laea coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_laea coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double dist = Math.sqrt(Xr * Xr + Yr * Yr);
        double A = dist / (2.0 * R);
        if (Math.abs(A) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(A) in FI_laea coordinate function, ", "abs(A) > 1: ", A);
        }
        double lat = 90.0 - 2.0 * Math.asin(A) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_laea coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_laea(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_laea coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_laea coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double lonr = Math.atan2(Xr, -Yr) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_laea coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_lagrng(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 0.0;
        if (Math.abs(Math.abs(lat) - 90.0) < 1.0E-9) {
            X = dx;
        } else {
            double W = 2.0;
            double A1 = Math.pow((1.0 + Math.sin(lat1 / 57.29577951308232)) / (1.0 - Math.sin(lat1 / 57.29577951308232)), 0.25);
            double A = Math.pow((1.0 + Math.sin(lat / 57.29577951308232)) / (1.0 - Math.sin(lat / 57.29577951308232)), 0.25);
            if (Math.abs(A1) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_lagrng coordinate function, ", "1 / A1, A1 = 0:", A1);
            }
            double V = A / A1;
            double C = 0.5 * (V + 1.0 / V) + Math.cos(lonr / 2.0 / 57.29577951308232);
            if (Math.abs(C) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_lagrng coordinate function, ", "1 / C, C = 0:", C);
            }
            X = 2.0 * R * Math.sin(lonr / 2.0 / 57.29577951308232) / C + dx;
        }
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_lagrng coordinate function, ", "F_larr > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_lagrng(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double Y = 0.0;
        if (Math.abs(Math.abs(lat) - 90.0) < 1.0E-9) {
            Y = 2.0 * R * Math.signum(lat) + dy;
        } else {
            double W = 2.0;
            double A1 = Math.pow((1.0 + Math.sin(lat1 / 57.29577951308232)) / (1.0 - Math.sin(lat1 / 57.29577951308232)), 0.25);
            double A = Math.pow((1.0 + Math.sin(lat / 57.29577951308232)) / (1.0 - Math.sin(lat / 57.29577951308232)), 0.25);
            if (Math.abs(A1) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_lagrng coordinate function, ", "1 / A1, A1 = 0:", A1);
            }
            double V = A / A1;
            double C = 0.5 * (V + 1.0 / V) + Math.cos(lonr / 2.0 / 57.29577951308232);
            if (Math.abs(C) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_lagrng coordinate function, ", "1 / C, C = 0:", C);
            }
            if (Math.abs(V) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_lagrng coordinate function, ", "1 / V, V = 0:", V);
            }
            Y = R * (V - 1.0 / V) / C + dy;
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_lagrng coordinate function, ", "G_lagrng > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_lagrng(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_lagrng coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_lagrng coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double Xr = X - dx;
        double arg = Yr / (R * (1.0 + (Xr * Xr + Yr * Yr) / (4.0 * R * R)));
        if (Math.abs(arg) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate atanh(arg) in FI_lagrng coordinate function, ", "abs(arg) > 1: ", arg);
        }
        double mu = Math.log((1.0 + arg) / (1.0 - arg));
        double C = (1.0 + Math.sin(lat1 / 57.29577951308232)) / (1.0 - Math.sin(lat1 / 57.29577951308232));
        double lat = 2.0 * Math.atan(Math.sqrt(C) * Math.exp(mu)) * 57.29577951308232 - 90.0;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_lagrng coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_lagrng(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_lagrng coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_lagrng coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double lonr = 2.0 * Math.atan2(Xr / R, 1.0 - (Xr * Xr + Yr * Yr) / (4.0 * R * R)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_lagrng coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_larr(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = Math.cos(lat / 57.29577951308232);
        if (A < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(A) in F_larr coordinate function, ", "A < 0: ", A);
        }
        double X = 0.5 * R * lonr / 57.29577951308232 * (1.0 + Math.sqrt(A)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_larr coordinate function, ", "F_larr > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_larr(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = Math.cos(lat / 2.0 / 57.29577951308232) * Math.cos(lonr / 6.0 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate G_larr coordinate function, ", "1 / A, A = 0:", A);
        }
        double Y = R * lat / 57.29577951308232 / A + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_larr coordinate function, ", "G_larr > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_larr(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_larr coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_larr coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat0 = 0.0;
        FILat fl = new FILat(X, Y, R, lat1, lat2, lon0, dx, dy, Projections::FILat_larr);
        FILatDer fld = new FILatDer(X, Y, R, lat1, lat2, lon0, dx, dy, Projections::FILatDer_larr);
        double lat = NewtonRaphson.findRoot(fl::function, fld::function, 0.0, 20, 1.0E-5);
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_larr coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_larr(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_larr coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_larr coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double lat = Projections.FI_larr(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double lonr = 2.0 * Xr / (R * (1.0 + Math.sqrt(Math.cos(lat / 57.29577951308232)))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_larr coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double FILat_larr(double lat_i, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy) {
        double Xr = X - dx;
        double Yr = Y - dy;
        double A = Math.cos(lat_i / 57.29577951308232);
        if (A < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(A) in FI_larr coordinate function, ", "A < 0: ", A);
        }
        double F = (Yr * Math.cos(lat_i / 2.0 / 57.29577951308232) * Math.cos(Xr / (3.0 * R * (1.0 + Math.sqrt(A)))) - R * lat_i / 57.29577951308232) * 57.29577951308232;
        return F;
    }

    public static double FILatDer_larr(double lat_i, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy) {
        double Xr = X - dx;
        double Yr = Y - dy;
        double A = Math.cos(lat_i / 57.29577951308232);
        if (A < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(A) in FI_larr coordinate function, ", "A < 0: ", A);
        }
        double B = 3.0 * R * (1.0 + Math.sqrt(A));
        double C = Xr / B;
        double dF = -Yr / 2.0 * Math.sin(lat_i / 2.0 / 57.29577951308232) * Math.cos(C) - 3.0 * Xr * Yr * Math.cos(lat_i / 2.0 / 57.29577951308232) * Math.sin(C) * Math.sin(lat_i / 57.29577951308232) / (2.0 * R * Math.sqrt(A) * B * B) - R;
        return dF;
    }

    public static double F_lask(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double a10 = 0.975534;
        double a12 = -0.119161;
        double a32 = -0.0143059;
        double a14 = -0.0547009;
        double X = R * (0.975534 * lonr / 57.29577951308232 + -0.119161 * (lonr / 57.29577951308232) * (lat / 57.29577951308232) * (lat / 57.29577951308232) + -0.0143059 * Math.pow(lonr / 57.29577951308232, 3.0) * (lat / 57.29577951308232) * (lat / 57.29577951308232) + -0.0547009 * (lonr / 57.29577951308232) * Math.pow(lat / 57.29577951308232, 4.0)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_lask coordinate function, ", "F_lask > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_lask(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double b01 = 1.00384;
        double b21 = 0.0802894;
        double b03 = 0.0998909;
        double b41 = 1.99025E-4;
        double b23 = -0.02855;
        double b05 = -0.0491032;
        double Y = R * (1.00384 * (lat / 57.29577951308232) + 0.0802894 * (lonr / 57.29577951308232) * (lonr / 57.29577951308232) * (lat / 57.29577951308232) + 0.0998909 * Math.pow(lat / 57.29577951308232, 3.0) + 1.99025E-4 * Math.pow(lonr / 57.29577951308232, 4.0) * (lat / 57.29577951308232) + -0.02855 * (lonr / 57.29577951308232) * (lonr / 57.29577951308232) * Math.pow(lat / 57.29577951308232, 3.0) + -0.0491032 * Math.pow(lat / 57.29577951308232, 5.0)) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_lask coordinate function, ", "G_lask > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_lask(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_lask coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_lask coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double a10 = 0.975534;
        double a12 = -0.119161;
        double b01 = 1.00384;
        double Xr = X - dx;
        double Yr = Y - dy;
        double lat0 = Math.max(Math.min(Yr / (R * 1.00384) * 57.29577951308232, 80.0), -80.0);
        double lonr0 = Math.signum(Xr) * 90.0;
        double[] lat = new double[]{lat0};
        double[] lonr = new double[]{lonr0};
        double fx = Projections.GN(Projections::JI_lask, Projections::FRI_lask, Projections::GRI_lask, X, Y, R, lat1, lat2, lon0, dx, dy, c, 1.0E-4, lat, lonr);
        if (Math.abs(lat[0]) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_lask coordinate function, ", "abs(lat)  > 90.", lat[0]);
        }
        return lat[0];
    }

    public static double GI_lask(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_lask coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_lask coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double a10 = 0.975534;
        double a12 = -0.119161;
        double b01 = 1.00384;
        double Xr = X - dx;
        double Yr = Y - dy;
        double lat0 = Math.max(Math.min(Yr / (R * 1.00384) * 57.29577951308232, 80.0), -80.0);
        double lonr0 = Math.signum(Xr) * 90.0;
        double[] lat = new double[]{lat0};
        double[] lonr = new double[]{lonr0};
        double fx = Projections.GN(Projections::JI_lask, Projections::FRI_lask, Projections::GRI_lask, X, Y, R, lat1, lat2, lon0, dx, dy, c, 1.0E-4, lat, lonr);
        if (Math.abs(lonr[0]) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_lask coordinate function, ", "abs(lonr) > 180.", lonr[0]);
        }
        double lon = CartTransformation.redLon0(lonr[0], -lon0);
        return lon;
    }

    public static void JI_lask(double lat, double lon, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c, double[] aj, double[] bj, double[] cj, double[] dj) {
        double a10 = 0.975534;
        double a12 = -0.119161;
        double a32 = -0.0143059;
        double a14 = -0.0547009;
        double b01 = 1.00384;
        double b21 = 0.0802894;
        double b03 = 0.0998909;
        double b41 = 1.99025E-4;
        double b23 = -0.02855;
        double b05 = -0.0491032;
        aj[0] = R * (-0.238322 * lon * lat / 3282.806350011744 + -0.0286118 * lon * lon * lon * lat / 1.077681753167743E7 + -0.2188036 * lon * lat * lat * lat / 1.077681753167743E7);
        bj[0] = R * (0.975534 + -0.119161 * lat * lat / 3282.806350011744 + -0.0429177 * lon * lon * lat * lat / 1.077681753167743E7 + -0.0547009 * lat * lat * lat * lat / 1.077681753167743E7);
        cj[0] = R * (1.00384 + 0.0802894 * lon * lon / 3282.806350011744 + 0.2996727 * lat * lat / 3282.806350011744 + 1.99025E-4 * lon * lon * lon * lon / 1.077681753167743E7 + -0.08565 * lon * lon * lat * lat / 1.077681753167743E7 + -0.245516 * lat * lat * lat * lat / 1.077681753167743E7);
        dj[0] = R * (0.1605788 * lat * lon / 3282.806350011744 + 7.961E-4 * lon * lon * lon * lat / 1.077681753167743E7 + -0.0571 * lon * lat * lat * lat / 1.077681753167743E7);
    }

    public static double FRI_lask(double lat, double lon, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double a10 = 0.975534;
        double a12 = -0.119161;
        double a32 = -0.0143059;
        double a14 = -0.0547009;
        double Xr = X - dx;
        return R * (0.975534 * lon / 57.29577951308232 + -0.119161 * lon * lat * lat / 188090.94881441945 + -0.0143059 * lon * lon * lon * lat * lat / 6.174661611477101E8 + -0.0547009 * lon * lat * lat * lat * lat / 6.174661611477101E8) - Xr;
    }

    public static double GRI_lask(double lat, double lon, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double b01 = 1.00384;
        double b21 = 0.0802894;
        double b03 = 0.0998909;
        double b41 = 1.99025E-4;
        double b23 = -0.02855;
        double b05 = -0.0491032;
        double Yr = Y - dy;
        return R * (1.00384 * lat / 57.29577951308232 + 0.0802894 * lon * lon * lat / 188090.94881441945 + 0.0998909 * lat * lat * lat / 188090.94881441945 + 1.99025E-4 * lon * lon * lon * lon * lat / 6.174661611477101E8 + -0.02855 * lon * lon * lat * lat * lat / 6.174661611477101E8 + -0.0491032 * lat * lat * lat * lat * lat / 6.174661611477101E8) - Yr;
    }

    public static double F_lcc(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = Math.tan(lat1 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_lcc coordinate function, ", "1.0 / A, A = 0:", A);
        }
        double n = Math.sin(lat1 / 57.29577951308232);
        double rho0 = R / A;
        double B = Math.tan((lat1 / 2.0 + 45.0) / 57.29577951308232);
        double C = Math.tan((lat / 2.0 + 45.0) / 57.29577951308232);
        if (Math.abs(C) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_lcc coordinate function, ", "C > MAX_FLOAT: ", C);
        }
        double D = B / C;
        if (D < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate F_lcc coordinate function, ", "pow(D, n), D < 0.", D);
        }
        double rho = rho0 * Math.pow(D, n);
        double X = rho * Math.sin(n * lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_lcc coordinate function, ", "F_lcc > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_lcc(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = Math.tan(lat1 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_lcc coordinate function, ", "1.0 / A, A = 0:", A);
        }
        double n = Math.sin(lat1 / 57.29577951308232);
        double rho0 = R / A;
        double B = Math.tan((lat1 / 2.0 + 45.0) / 57.29577951308232);
        double C = Math.tan((lat / 2.0 + 45.0) / 57.29577951308232);
        if (Math.abs(C) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_lcc coordinate function, ", "C > MAX_FLOAT: ", C);
        }
        double D = B / C;
        if (D < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate G_lcc coordinate function, ", "pow(D, n), D < 0.", D);
        }
        double rho = rho0 * Math.pow(D, n);
        double Y = rho0 - rho * Math.cos(n * lonr / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_lcc coordinate function, ", "G_lcc > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_lcc(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_lcc coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_lcc coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double A = Math.tan(lat1 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate FI_lcc coordinate function, ", "1.0 / A, A = 0:", A);
        }
        double n = Math.sin(lat1 / 57.29577951308232);
        if (Math.abs(n) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate FI_lcc coordinate function, ", "1.0 / n, n = 0:", n);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double rho0 = R / A;
        double B = rho0 - Yr;
        double rho = Math.sqrt(Xr * Xr + B * B);
        double C = rho / rho0;
        double D = Math.pow(C, 1.0 / n);
        double E = Math.tan((lat1 / 2.0 + 45.0) / 57.29577951308232);
        double lat = 2.0 * Math.atan2(E, D) * 57.29577951308232 - 90.0;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_lcc coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_lcc(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_lcc coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_lcc coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double A = Math.tan(lat1 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_lcc coordinate function, ", "1.0 / A, A = 0:", A);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double rho0 = R / A;
        double B = rho0 - Yr;
        double eps = Math.atan2(Xr, B) * 57.29577951308232;
        double n = Math.sin(lat1 / 57.29577951308232);
        if (Math.abs(n) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_lcc coordinate function, ", "1.0 / n, n = 0:", n);
        }
        double lonr = eps / n;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_lcc coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_leac(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = Math.tan(lat1 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate F_leac coordinate function, ", "1 / A, A = 0:", A);
        }
        double n = Math.sin(lat1 / 57.29577951308232);
        if (Math.abs(n) < 1.0E-37) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate F_leac coordinate function, ", "1 / n, n = 0:", n);
        }
        double rho0 = R / A;
        double rho = Math.sqrt(rho0 * rho0 + 2.0 * R * R / n * (n - Math.sin(lat / 57.29577951308232)));
        double X = rho * Math.sin(n * lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_leac coordinate function, ", "F_leac > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_leac(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = Math.tan(lat1 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate G_leac coordinate function, ", "1 / A, A = 0:", A);
        }
        double n = Math.sin(lat1 / 57.29577951308232);
        if (Math.abs(n) < 1.0E-37) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate G_leac coordinate function, ", "1 / n, n = 0:", n);
        }
        double rho0 = R / A;
        double rho = Math.sqrt(rho0 * rho0 + 2.0 * R * R / n * (n - Math.sin(lat / 57.29577951308232)));
        double Y = rho0 - rho * Math.cos(n * lonr / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_leac coordinate function, ", "G_leac > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_leac(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_leac coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_leac coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double A = Math.tan(lat1 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate FI_leac coordinate function, ", "1.0 / A, A = 0:", A);
        }
        double n = Math.sin(lat1 / 57.29577951308232);
        if (Math.abs(n) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate FI_leac coordinate function, ", "1.0 / n, n = 0:", n);
        }
        double Xr = X - dx;
        double rho0 = R / A;
        double Yr = Y - dy;
        double B = rho0 - Yr;
        double rho = Math.sqrt(Xr * Xr + B * B);
        double C = n - (rho * rho - rho0 * rho0) * n / (2.0 * R * R);
        if (C > 1.00001 || C < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(C) in FI_leac coordinate function, ", "abs(C) > 1: ", C);
        }
        if (C > 1.0) {
            C = 1.0;
        } else if (C < -1.0) {
            C = -1.0;
        }
        double lat = Math.asin(C) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_leac coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_leac(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_leac coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_leac coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double A = Math.tan(lat1 / 57.29577951308232);
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_leac coordinate function, ", "1.0 / A, A = 0:", A);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double rho0 = R / A;
        double B = rho0 - Yr;
        double eps = Math.atan2(Xr, B) * 57.29577951308232;
        double n = Math.sin(lat1 / 57.29577951308232);
        if (Math.abs(n) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_leac coordinate function, ", "1.0 / n, n = 0:", n);
        }
        double lonr = eps / n;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_leac coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_leac2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double n = (1.0 + Math.sin(lat1 / 57.29577951308232)) / 2.0;
        if (Math.abs(n) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_leac2 coordinate function, ", "1.0 / n, n = 0:", n);
        }
        double B = 2.0 / n * (1.0 - Math.sin(lat / 57.29577951308232));
        if (B < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(B) in F_leac2 coordinate function, ", "A < 0: ", B);
        }
        double rho = R * Math.sqrt(B);
        double X = rho * Math.sin(n * lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_leac2 coordinate function, ", "F_leac2 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_leac2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double n = (1.0 + Math.sin(lat1 / 57.29577951308232)) / 2.0;
        if (Math.abs(n) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_leac2 coordinate function, ", "1.0 / n, n = 0:", n);
        }
        double B = 2.0 / n * (1.0 - Math.sin(lat / 57.29577951308232));
        if (B < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(B) in G_leac2 coordinate function, ", "B < 0: ", B);
        }
        double rho = R * Math.sqrt(B);
        double C = 2.0 / n * (1.0 - Math.sin(lat1 / 57.29577951308232));
        if (C < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(C) in G_leac2 coordinate function, ", "C < 0: ", C);
        }
        double rho0 = R * Math.sqrt(C);
        double Y = rho0 - rho * Math.cos(n * lonr / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_leac2 coordinate function, ", "G_leac2 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_leac2(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_leac2 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_leac2 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double n = (1.0 + Math.sin(lat1 / 57.29577951308232)) / 2.0;
        if (Math.abs(n) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate FI_leac2 coordinate function, ", "1.0 / n, n = 0:", n);
        }
        double C = 2.0 / n * (1.0 - Math.sin(lat1 / 57.29577951308232));
        if (C < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(C) in FI_leac2 coordinate function, ", "C < 0: ", C);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double rho0 = R * Math.sqrt(C);
        double B = rho0 - Yr;
        double rho = Math.sqrt(Xr * Xr + B * B);
        double D = 1.0 - n * rho * rho / (2.0 * R * R);
        if (D > 1.00001 || D < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(D) in FI_leac2 coordinate function, ", "abs(D) > 1: ", D);
        }
        if (D > 1.0) {
            D = 1.0;
        } else if (D < -1.0) {
            D = -1.0;
        }
        double lat = Math.asin(D) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_leac coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_leac2(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_leac2 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_leac2 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double n = (1.0 + Math.sin(lat1 / 57.29577951308232)) / 2.0;
        if (Math.abs(n) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_leac2 coordinate function, ", "1.0 / n, n = 0:", n);
        }
        double C = 2.0 / n * (1.0 - Math.sin(lat1 / 57.29577951308232));
        if (C < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(C) in G_leac2 coordinate function, ", "C < 0: ", C);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double rho0 = R * Math.sqrt(C);
        double B = rho0 - Yr;
        double eps = Math.atan2(Xr, B) * 57.29577951308232;
        double lonr = eps / n;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_leac coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_litt(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        if (Math.abs(lat) == 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate tan(lat) in F_litt coordinate function, ", "lat = +-90: ", lat);
        }
        double X = R * Math.sin(lonr / 57.29577951308232) / Math.cos(lat / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_litt coordinate function, ", "F_litt > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_litt(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        if (Math.abs(lat) == 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate tan(lat) in G_litt coordinate function, ", "lat = +-90: ", lat);
        }
        if (lonr > 90.0) {
            lonr = 180.0 - lonr;
        } else if (lonr < -90.0) {
            lonr = -180.0 - lonr;
        }
        double Y = R * Math.tan(lat / 57.29577951308232) * Math.cos(lonr / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_litt coordinate function, ", "G_litt > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_litt(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_litt coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_litt coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double aq = Xr * Xr;
        double bq = R * R + Yr * Yr - Xr * Xr;
        double cq = -Yr * Yr;
        double t = 0.0;
        if (Math.abs(aq) < 1.0E-37) {
            t = -cq / bq;
        } else {
            double discr = bq * bq - 4.0 * aq * cq;
            double t1 = (-bq + Math.sqrt(discr)) / (2.0 * aq);
            double t2 = (-bq - Math.sqrt(discr)) / (2.0 * aq);
            double d = t = t1 >= 0.0 && t1 <= 1.0 ? t1 : t2;
        }
        if (t < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(t) in FI_litt coordinate function, ", "t < 0: ", t);
        }
        double arg = Math.sqrt(t);
        if (arg > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_litt coordinate function, ", "abs(arg) > 1: ", t);
        }
        double lat = Math.signum(Yr) * Math.asin(arg) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_litt coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_litt(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_litt coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_litt coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double lat = Projections.FI_litt(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double lonr = Math.atan(Xr / Yr * Math.sin(lat / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_littcoordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_loxim(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 0.0;
        double dlat = lat - lat1;
        if (Math.abs(dlat) < 1.0E-9) {
            X = R * lonr / 57.29577951308232 * Math.cos(lat1 / 57.29577951308232) + dx;
        } else {
            double A = 0.5 * lat + 45.0;
            double B = 0.5 * lat1 + 45.0;
            X = Math.abs(A) < 1.0E-9 || Math.abs(Math.abs(A) - 90.0) < 1.0E-9 ? dx : R * lonr / 57.29577951308232 * dlat / 57.29577951308232 / (Math.log(Math.tan(A / 57.29577951308232)) - Math.log(Math.tan(B / 57.29577951308232))) + dx;
        }
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_loxim coordinate function, ", "F_loxim > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_loxim(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double Y = R * (lat - lat1) / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_loxim coordinate function, ", "G_loxim > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_loxim(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_loxim coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_loxim coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double lat = lat1 + Yr / R * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_loxim coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_loxim(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_loxim coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_loxim coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lonr = 0.0;
        double lat = Projections.FI_loxim(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double Xr = X - dx;
        double dlat = lat - lat1;
        if (Math.abs(dlat) < 1.0E-9) {
            lonr = Xr / (R * Math.cos(lat1 / 57.29577951308232)) * 57.29577951308232;
        }
        double A = 0.5 * lat + 45.0;
        double B = 0.5 * lat1 + 45.0;
        lonr = Xr * (Math.log(Math.tan(A / 57.29577951308232)) - Math.log(Math.tan(B / 57.29577951308232))) / (R * dlat / 57.29577951308232) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_loxim coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_maurer(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = R * lonr / 57.29577951308232 * (c - 2.0 * lat / 57.29577951308232) / Math.PI + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_maurer coordinate function, ", "F_maurer > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_maurer(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = R * lat / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_maurer coordinate function, ", "G_maurer > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_maurer(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_maurer coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_maurer coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double lat = Yr / R * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_maurer coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_maurer(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_loxim coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_loxim coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double lat = Projections.FI_maurer(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double lonr = Xr * Math.PI / (R * (c - 2.0 * lat / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_maurer coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_mbt_s(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double p = 1.48875;
        double q = 1.36509;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 0.9169370277078085 * R * lonr / 57.29577951308232 * Math.cos(lat / 57.29577951308232) / Math.cos(lat / 1.36509 / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_mbt_s coordinate function, ", "F_mbt_s > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_mbt_s(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double p = 1.48875;
        double q = 1.36509;
        double Y = 1.48875 * R * Math.sin(lat / 1.36509 / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_mbt_s coordinate function, ", "G_mbt_s > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_mbt_s(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_mbt_s coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_mbt_s coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double p = 1.48875;
        double q = 1.36509;
        double arg = Yr / (1.48875 * R);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in F_mbt_s coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double lat = 1.36509 * Math.asin(arg) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_mbt_s coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_mbt_s(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_mbt_s coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_mbt_s coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_qua_aut(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double p = 1.48875;
        double q = 1.36509;
        double Xr = X - dx;
        double lonr = 1.48875 * Xr / (1.36509 * R * Math.cos(lat / 57.29577951308232) / Math.cos(lat / 1.36509 / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_mbt_s coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_mbt_s3(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lat_int = 55.85;
        double X = 0.0;
        X = Math.abs(lat) <= 55.85 ? Projections.F_sinu(lat, lon, R, lat1, lat2, lon0, dx, dy, c) : Projections.F_mbtfps2(lat, lon, R, lat1, lat2, lon0, dx, dy, c);
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_mbt_s3 coordinate function, ", "F_mbt_s3 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_mbt_s3(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lat_int = 55.85;
        double Y = 0.0;
        if (Math.abs(lat) <= 55.85) {
            Y = Projections.G_sinu(lat, lon, R, lat1, lat2, lon0, dx, dy, c);
        } else {
            double theta0 = lat;
            FTheta ft = new FTheta(lat, Projections::FTheta_mbtfps2);
            FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_mbtfps2);
            double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
            Y = R * (Math.sqrt(0.840148730267336) * theta / 57.29577951308232 - 0.069065 * Math.signum(lat)) + dy;
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_mbt_s3 coordinate function, ", "G_mbt_s3 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_mbtfpp(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cx = Math.sqrt(0.8571428571428571) / 3.0;
        double A = 2.0;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_mbtfpp);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_mbtfpp);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double B = Math.cos(theta / 3.0 / 57.29577951308232);
        if (Math.abs(B) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_mbtfpp coordinate function, ", "1.0 / B, B = 0:", B);
        }
        double X = cx * R * lonr / 57.29577951308232 * (1.0 + 2.0 * Math.cos(theta / 57.29577951308232) / B) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_mbtfpp coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_mbtfpp(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = 3.0 * Math.sqrt(0.8571428571428571);
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_mbtfpp);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_mbtfpp);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double Y = cy * R * Math.sin(theta / 3.0 / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_mbtfpp coordinate function, ", "G_mbtfpq > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FTheta_mbtfpp(double lat, double theta) {
        double A = 1.125;
        double B = 0.4375;
        double C = Math.sin(theta / 3.0 / 57.29577951308232);
        return 1.125 * C - C * C * C - 0.4375 * Math.sin(lat / 57.29577951308232);
    }

    public static double FThetaDer_mbtfpp(double lat, double theta) {
        double A = 0.375;
        double B = Math.sin(theta / 3.0 / 57.29577951308232);
        return (0.375 - B * B) * Math.cos(theta / 3.0 / 57.29577951308232) / 57.29577951308232;
    }

    public static double FI_mbtfpp(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_mbtfpp coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_mbtfpp coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = 3.0 * Math.sqrt(0.8571428571428571);
        double arg = Yr / (R * cy);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_mbtfpp coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = 3.0 * Math.asin(arg) * 57.29577951308232;
        double A = 1.125;
        double B = 0.4375;
        double C = Math.sin(theta / 3.0 / 57.29577951308232);
        double arg2 = (1.125 * C - C * C * C) / 0.4375;
        if (arg2 > 1.00001 || arg2 < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg2) in FI_mbtfpp coordinate function, ", "abs(arg2) > 1: ", arg2);
        }
        if (arg2 > 1.0) {
            arg2 = 1.0;
        } else if (arg2 < -1.0) {
            arg2 = -1.0;
        }
        double lat = Math.asin(arg2) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_mbtfpp coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_mbtfpp(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_mbtfpp coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_mbtfpp coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double cx = Math.sqrt(0.8571428571428571) / 3.0;
        double cy = 3.0 * Math.sqrt(0.8571428571428571);
        double A = 2.0;
        double Xr = X - dx;
        double Yr = Y - dy;
        double arg = Yr / (R * cy);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in GI_mbtfpp coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = 3.0 * Math.asin(arg) * 57.29577951308232;
        double B = Math.cos(theta / 3.0 / 57.29577951308232);
        if (Math.abs(B) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_mbtfpp coordinate function, ", "1.0 / B, B = 0:", B);
        }
        double lonr = Xr / (cx * R * (1.0 + 2.0 * Math.cos(theta / 57.29577951308232) / B)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_mbtfpp coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_mbtfpq(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cx = 1.0 / Math.sqrt(3.0 * Math.sqrt(2.0) + 6.0);
        double lonr = CartTransformation.redLon0(lon, lon0);
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_mbtfpq);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_mbtfpq);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double X = cx * R * lonr / 57.29577951308232 * (1.0 + 2.0 * Math.cos(theta / 57.29577951308232) / Math.cos(0.5 * theta / 57.29577951308232)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_mbtfpq coordinate function, ", "F_mbtfpq > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_mbtfpq(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = 2.0 * Math.sqrt(3.0) / Math.sqrt(2.0 + Math.sqrt(2.0));
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_mbtfpq);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_mbtfpq);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double Y = cy * R * Math.sin(theta / 2.0 / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_mbtfpq coordinate function, ", "G_mbtfpq > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FTheta_mbtfpq(double lat, double theta) {
        double A = 1.0 + Math.sqrt(2.0) / 2.0;
        return Math.sin(theta / 2.0 / 57.29577951308232) + Math.sin(theta / 57.29577951308232) - A * Math.sin(lat / 57.29577951308232);
    }

    public static double FThetaDer_mbtfpq(double lat, double theta) {
        return (0.5 * Math.cos(theta / 2.0 / 57.29577951308232) + Math.cos(theta / 57.29577951308232)) / 57.29577951308232;
    }

    public static double FI_mbtfpq(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_mbtfpq coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_mbtfpq coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = 2.0 * Math.sqrt(3.0) / Math.sqrt(2.0 + Math.sqrt(2.0));
        double arg = Yr / (R * cy);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_mbtfpq coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = 2.0 * Math.asin(arg) * 57.29577951308232;
        double A = 1.0 + Math.sqrt(2.0) / 2.0;
        double arg2 = (Math.sin(theta / 2.0 / 57.29577951308232) + Math.sin(theta / 57.29577951308232)) / A;
        if (arg2 > 1.00001 || arg2 < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg2) in FI_mbtfpq coordinate function, ", "abs(arg2) > 1: ", arg2);
        }
        if (arg2 > 1.0) {
            arg2 = 1.0;
        } else if (arg2 < -1.0) {
            arg2 = -1.0;
        }
        double lat = Math.asin(arg2) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_mbtfpq coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_mbtfpq(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_mbtfpq coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_mbtfpq coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double cx = 1.0 / Math.sqrt(3.0 * Math.sqrt(2.0) + 6.0);
        double cy = 2.0 * Math.sqrt(3.0) / Math.sqrt(2.0 + Math.sqrt(2.0));
        double Xr = X - dx;
        double Yr = Y - dy;
        double arg = Yr / (R * cy);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in GI_mbtfpq coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = 2.0 * Math.asin(arg) * 57.29577951308232;
        if (Math.abs(theta) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_mbtfpq coordinate function, ", "1.0 / theta, theta = 0:", theta);
        }
        double lonr = Xr / (cx * R * (1.0 + 2.0 * Math.cos(theta / 57.29577951308232) / Math.cos(0.5 * theta / 57.29577951308232))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_mbtfpq coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_mbtfps(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cx = 0.22248;
        double D = 1.36509;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_mbtfps);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_mbtfps);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double X = 0.22248 * R * lonr / 57.29577951308232 * (1.0 + 3.0 * Math.cos(theta / 57.29577951308232) / Math.cos(theta / 1.36509 / 57.29577951308232)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_mbtfps coordinate function, ", "F_mbtfps > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_mbtfps(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = 1.44492;
        double D = 1.36509;
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_mbtfps);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_mbtfps);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double Y = 1.44492 * R * Math.sin(theta / 1.36509 / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_mbtfs coordinate function, ", "G_mbtfps > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FTheta_mbtfps(double lat, double theta) {
        double B = 0.45503;
        double C = 1.41546;
        double D = 1.36509;
        return 0.45503 * Math.sin(theta / 1.36509 / 57.29577951308232) + Math.sin(theta / 57.29577951308232) - 1.41546 * Math.sin(lat / 57.29577951308232);
    }

    public static double FThetaDer_mbtfps(double lat, double theta) {
        double B = 0.45503;
        double D = 1.36509;
        return (0.33333333333333337 * Math.cos(theta / 1.36509 / 57.29577951308232) + Math.cos(theta / 57.29577951308232)) / 57.29577951308232;
    }

    public static double FI_mbtfps(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_mbtfps coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_mbtfps coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = 1.44492;
        double D = 1.36509;
        double arg = Yr / (R * 1.44492);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_mbtfps coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = 1.36509 * Math.asin(arg) * 57.29577951308232;
        double B = 0.45503;
        double C = 1.41546;
        double arg2 = (0.45503 * Math.sin(theta / 1.36509 / 57.29577951308232) + Math.sin(theta / 57.29577951308232)) / 1.41546;
        if (arg2 > 1.00001 || arg2 < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg2) in FI_mbtfps coordinate function, ", "abs(arg2) > 1: ", arg2);
        }
        if (arg2 > 1.0) {
            arg2 = 1.0;
        } else if (arg2 < -1.0) {
            arg2 = -1.0;
        }
        double lat = Math.asin(arg2) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_mbtfps coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_mbtfps(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_mbtfps coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_mbtfps coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double cx = 0.22248;
        double cy = 1.44492;
        double D = 1.36509;
        double Xr = X - dx;
        double Yr = Y - dy;
        double arg = Yr / (R * 1.44492);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in GI_mbtfps coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = 1.36509 * Math.asin(arg) * 57.29577951308232;
        if (Math.abs(theta) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_mbtfps coordinate function, ", "1.0 / theta, theta = 0:", theta);
        }
        double lonr = Xr / (0.22248 * R * (1.0 + 3.0 * Math.cos(theta / 57.29577951308232) / Math.cos(theta / 1.36509 / 57.29577951308232))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_mbtfps coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_mbtfps2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_mbtfps2);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_mbtfps2);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double X = R * Math.sqrt(0.840148730267336) * (0.5 + Math.cos(theta / 57.29577951308232)) * lonr / 57.29577951308232 / 1.5 + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_mbtfps coordinate function, ", "F_mbtfps > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_mbtfps2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_mbtfps2);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_mbtfps2);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double Y = R * Math.sqrt(0.840148730267336) * theta / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_mbtfs coordinate function, ", "G_mbtfps > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FTheta_mbtfps2(double lat, double theta) {
        return theta / 2.0 / 57.29577951308232 + Math.sin(theta / 57.29577951308232) - 1.7853981633974483 * Math.sin(lat / 57.29577951308232);
    }

    public static double FThetaDer_mbtfps2(double lat, double theta) {
        return (0.5 + Math.cos(theta / 57.29577951308232)) / 57.29577951308232;
    }

    public static double F_merc(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = R * lonr * Math.cos(lat1 / 57.29577951308232) / 57.29577951308232 + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_merc coordinate function, ", "F_merc > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_merc(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double A = Math.tan((lat / 2.0 + 45.0) / 57.29577951308232);
        if (Math.abs(lat) == 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate tan(lat) in G_merc coordinate function, ", "lat = +-90: ", lat);
        }
        if (A <= 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate log(A) in G_merc coordinate function, ", "A <= 0: ", A);
        }
        double Y = R * Math.log(A) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_merc coordinate function, ", "G_merc > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_merc(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_merc coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = 90.0 - 2.0 * Math.atan(Math.exp(-(Y - dy) / R)) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_merc coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_merc(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_merc coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(lat1) > 89.999999999) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_merc coordinate function, ", "1.0 / cos(lat1), lat1 = +-90.", lat1);
        }
        double lonr = (X - dx) / (R * Math.cos(lat1 / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_merc coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_mill(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = R * lonr * Math.cos(lat1 / 57.29577951308232) / 57.29577951308232 + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_mill coordinate function, ", "F_mill > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_mill(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double A = Math.tan((0.4 * lat + 45.0) / 57.29577951308232);
        if (A <= 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate log(A) in G_mill coordinate function, ", "A <= 0: ", A);
        }
        double Y = R * Math.log(A) / 0.8 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_mill coordinate function, ", "G_mill > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_mill(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_mill coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = 2.5 * (Math.atan(Math.exp(0.8 * (Y - dy) / R)) - 0.7853981633974483) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_mill coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_mill(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_mill coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(lat1) > 89.999999999) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_mill coordinate function, ", "1.0 / cos(lat1), lat1 = +-90.", lat1);
        }
        double lonr = (X - dx) / (R * Math.cos(lat1 / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_mill coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_moll(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double r = Math.sqrt(2.0);
        double c1 = 2.0 * r / Math.PI;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_moll);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_moll);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double X = c1 * R * lonr / 57.29577951308232 * Math.cos(theta / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_moll coordinate function, ", "F_moll > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_moll(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double c2 = Math.sqrt(2.0);
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_moll);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_moll);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double Y = c2 * R * Math.sin(theta / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_moll coordinate function, ", "G_moll > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FTheta_moll(double lat, double theta) {
        double cp = Math.PI;
        return 2.0 * theta / 57.29577951308232 + Math.sin(2.0 * theta / 57.29577951308232) - Math.PI * Math.sin(lat / 57.29577951308232);
    }

    public static double FThetaDer_moll(double lat, double theta) {
        return (2.0 + 2.0 * Math.cos(2.0 * theta / 57.29577951308232)) / 57.29577951308232;
    }

    public static double FI_moll(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_moll coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_moll coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double c2 = Math.sqrt(2.0);
        double arg = Yr / (R * c2);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_moll coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double cp = Math.PI;
        double theta = Math.asin(arg) * 57.29577951308232;
        double arg2 = (2.0 * theta / 57.29577951308232 + Math.sin(2.0 * theta / 57.29577951308232)) / Math.PI;
        if (arg2 > 1.00001 || arg2 < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg2) in FI_moll coordinate function, ", "abs(arg2) > 1: ", arg2);
        }
        if (arg2 > 1.0) {
            arg2 = 1.0;
        } else if (arg2 < -1.0) {
            arg2 = -1.0;
        }
        double lat = Math.asin(arg2) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_moll coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_moll(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_moll coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_moll coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_moll(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double Xr = X - dx;
        double Yr = Y - dy;
        double arg = Yr / (R * Math.sqrt(2.0));
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_moll coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = Math.asin(arg) * 57.29577951308232;
        double r = Math.sqrt(2.0);
        double c1 = 2.0 * r / Math.PI;
        double lonr = Xr / (c1 * R * Math.cos(theta / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_moll coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_nell(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_nell);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_nell);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double X = R * 0.5 * lonr / 57.29577951308232 * (1.0 + Math.cos(theta / 57.29577951308232)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_nell coordinate function, ", "F_nell > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_nell(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_nell);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_nell);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double Y = R * theta / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_nell coordinate function, ", "G_nell > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FTheta_nell(double lat, double theta) {
        return theta / 57.29577951308232 + Math.sin(theta / 57.29577951308232) - 2.0 * Math.sin(lat / 57.29577951308232);
    }

    public static double FThetaDer_nell(double lat, double theta) {
        return (1.0 + Math.cos(theta / 57.29577951308232)) / 57.29577951308232;
    }

    public static double FI_nell(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_nell coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_nell coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double theta = Yr / R * 57.29577951308232;
        double arg = 0.5 * (theta / 57.29577951308232 + Math.sin(theta / 57.29577951308232));
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_nell coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double lat = Math.asin(arg) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_nell coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_nell(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_nell coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_nell coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double theta = Yr / R * 57.29577951308232;
        double lonr = 2.0 * Xr / (R * (1.0 + Math.cos(theta / 57.29577951308232))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_nell coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_nell_h(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 0.5 * R * lonr / 57.29577951308232 * (1.0 + Math.cos(lat / 57.29577951308232)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_nell_h coordinate function, ", "F_nell_h > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_nell_h(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = 2.0 * R * (lat / 57.29577951308232 - Math.tan(lat / 2.0 / 57.29577951308232)) + dy;
        if (Math.abs(Math.abs(lat) - 180.0) < 1.0E-9) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate tan(lat) in F_nell_h coordinate function, ", "lat = +-180: ", lat);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_nell_h coordinate function, ", "G_nell_h > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_nell_h(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_nell_h coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_nell_h coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        FILat fl = new FILat(X, Y, R, lat1, lat2, lon0, dx, dy, Projections::FILat_nell_h);
        FILatDer fld = new FILatDer(X, Y, R, lat1, lat2, lon0, dx, dy, Projections::FILatDer_nell_h);
        double lat = NewtonRaphson.findRoot(fl::function, fld::function, lat1, 20, 1.0E-5);
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_nell_h coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_nell_h(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_nell_h coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_nell_h coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double lat = Projections.FI_nell_h(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double lonr = 2.0 * Xr / (R * (1.0 + Math.cos(lat / 57.29577951308232))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_nell_h coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double FILat_nell_h(double lat_i, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy) {
        double Yr = Y - dy;
        return lat_i / 57.29577951308232 - Math.tan(0.5 * lat_i / 57.29577951308232) - Yr / (2.0 * R);
    }

    public static double FILatDer_nell_h(double lat_i, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy) {
        return (1.0 - 1.0 / (1.0 + Math.cos(lat_i / 57.29577951308232))) / 57.29577951308232;
    }

    public static double F_nicol(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 0.0;
        if (Math.abs(lonr) < 1.0E-9 || Math.abs(Math.abs(lat) - 90.0) < 1.0E-9) {
            X = dx;
        } else if (Math.abs(lat) < 1.0E-9) {
            X = R * lonr / 57.29577951308232 + dx;
        } else if (Math.abs(Math.abs(lonr) - 90.0) < 1.0E-9) {
            X = R * lonr / 57.29577951308232 * Math.cos(lat / 57.29577951308232) + dx;
        } else {
            double p = (1.0 - 4.0 * lonr * lonr / 32400.0) / (4.0 * lonr / Math.PI / 57.29577951308232);
            double r = 2.0 * (Math.sin(lat / 57.29577951308232) - 2.0 * lat / Math.PI / 57.29577951308232);
            if (Math.abs(r) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_nicol coordinate function, ", "1.0 / r, r = 0:", r);
            }
            double q = (1.0 - 4.0 * lat * lat / 32400.0) / r;
            double at = p * p + q * q;
            double bt = 2.0 * p * q * (q - Math.sin(lat / 57.29577951308232));
            double ct = q * q * (Math.sin(lat / 57.29577951308232) * Math.sin(lat / 57.29577951308232) - 1.0);
            double D = bt * bt - 4.0 * at * ct;
            double x = lonr < 0.0 ? (-bt - Math.sqrt(D)) / (2.0 * at) : (-bt + Math.sqrt(D)) / (2.0 * at);
            X = R * Math.PI / 2.0 * x + dx;
        }
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_nicol coordinate function, ", "F_nicol > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_nicol(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double Y = 0.0;
        if (Math.abs(lonr) < 1.0E-9 || Math.abs(Math.abs(lat) - 90.0) < 1.0E-9) {
            Y = R * lat / 57.29577951308232 + dy;
        } else if (Math.abs(lat) < 1.0E-9) {
            Y = dy;
        } else if (Math.abs(Math.abs(lonr) - 90.0) < 1.0E-9) {
            Y = R * Math.PI / 2.0 * Math.sin(lat / 57.29577951308232) + dy;
        } else {
            double p = (1.0 - 4.0 * lonr * lonr / 32400.0) / (4.0 * lonr / Math.PI / 57.29577951308232);
            double r = 2.0 * (Math.sin(lat / 57.29577951308232) - 2.0 * lat / Math.PI / 57.29577951308232);
            if (Math.abs(r) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_nicol coordinate function, ", "1.0 / r, r = 0:", r);
            }
            double q = (1.0 - 4.0 * lat * lat / 32400.0) / r;
            double X = Projections.F_nicol(lat, lon, R, lat1, lat2, lon0, dx, dy, c);
            Y = R * Math.PI / 2.0 * Math.sin(lat / 57.29577951308232) - p / q * X + dy;
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_nicol coordinate function, ", "G_nicol > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_nicol(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_nicol coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_nicol coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        if (Math.abs(Xr) < 1.0E-37) {
            return Yr / R * 57.29577951308232;
        }
        if (Math.abs(Yr) < 1.0E-37) {
            return 0.0;
        }
        double lat0 = 0.0;
        double x = 2.0 * Xr / (Math.PI * R);
        double y = 2.0 * Yr / (Math.PI * R);
        FILat fl = new FILat(x, y, R, lat1, lat2, lon0, dx, dy, Projections::FILat_nicol);
        FILatDer fld = new FILatDer(x, y, R, lat1, lat2, lon0, dx, dy, Projections::FILatDer_nicol);
        double lat = NewtonRaphson.findRoot(fl::function, fld::function, 0.0, 20, 1.0E-5);
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_nicol coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_nicol(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_nicol coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_nicol coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        if (Math.abs(Xr) < 1.0E-37) {
            return 0.0;
        }
        if (Math.abs(Yr) < 1.0E-37) {
            return Xr / R * 57.29577951308232;
        }
        double x = 2.0 * Xr / (Math.PI * R);
        double y = 2.0 * Yr / (Math.PI * R);
        double at = 4.0 * x;
        double bt = Math.PI * 2 * (1.0 - x * x - y * y);
        double ct = -9.869604401089358 * x;
        double D = bt * bt - 4.0 * at * ct;
        double lonr = (x > 0.0 ? (-bt + Math.sqrt(D)) / (2.0 * at) : (-bt + Math.sqrt(D)) / (2.0 * at)) * 57.29577951308232;
        if (lonr > 180.00001 || lonr < -180.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_nicol coordinate function, ", "abs(lonr)  > 90.", lonr);
        }
        if (lonr > 180.0) {
            lonr = 180.0;
        } else if (lonr < -180.0) {
            lonr = -180.0;
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double FILat_nicol(double lat_i, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy) {
        double F = ((X * X + Y * Y) * (Math.PI * Math.sin(lat_i / 57.29577951308232) - 2.0 * lat_i / 57.29577951308232) * Math.PI + 4.0 * lat_i * lat_i / 3282.806350011744 * (Y - Math.sin(lat_i / 57.29577951308232)) + Math.PI * 2 * lat_i / 57.29577951308232 - Math.PI * Math.PI * Y) * 57.29577951308232;
        return F;
    }

    public static double FILatDer_nicol(double lat_i, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy) {
        double dF = Math.PI * 2 + 8.0 * lat_i / 57.29577951308232 * (Y - Math.sin(lat_i / 57.29577951308232)) - 4.0 * lat_i * lat_i / 3282.806350011744 * Math.cos(lat_i / 57.29577951308232) + Math.PI * (X * X + Y * Y) * (Math.PI * Math.cos(lat_i / 57.29577951308232) - 2.0);
        return dF;
    }

    public static double F_ortel(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 0.0;
        X = Math.abs(lonr) < 90.0 ? Projections.F_api(lat, lon, R, lat1, lat2, lon0, dx, dy, c) : R * Math.signum(lonr) * (Math.sqrt(2.4674011002723395 - lat * lat / 3282.806350011744) + Math.abs(lonr / 57.29577951308232) - 1.5707963267948966) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_ortel coordinate function, ", "F_ortel > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_ortel(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = R * lat / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_ortho coordinate function, ", "G_ortho > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_ortho(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double rho = R * Math.cos(lat / 57.29577951308232);
        double X = rho * Math.sin(lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_ortho coordinate function, ", "F_ortho > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_ortho(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double rho = R * Math.cos(lat / 57.29577951308232);
        double Y = -rho * Math.cos(lonr / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_ortho coordinate function, ", "G_ortho > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_ortho(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_ortho coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_ortho coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double dist = Math.sqrt(Xr * Xr + Yr * Yr);
        double A = dist / (2.0 * R);
        if (Math.abs(A) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(A) in FI_ortho coordinate function, ", "abs(A) > 1: ", A);
        }
        double lat = 90.0 - Math.asin(A) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_ortho coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_ortho(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_ortho coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_ortho coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        if (Math.abs(lat1) > 89.999999999) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_ortho coordinate function, ", "1.0 / cos(lat1), lat1 = +-90.", lat1);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double lonr = Math.atan2(Xr, -Yr) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_ortho coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_parab(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = Math.sqrt(0.954929658551372) * R * lonr / 57.29577951308232 * (2.0 * Math.cos(2.0 * lat / 3.0 / 57.29577951308232) - 1.0) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_parab coordinate function, ", "F_parab > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_parab(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = Math.sqrt(Math.PI * 3) * R * Math.sin(lat / 3.0 / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_parab coordinate function, ", "G_parab > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_peiq(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double a = Math.cos(lat / 57.29577951308232) * (Math.cos(lonr / 57.29577951308232) - Math.sin(lonr / 57.29577951308232)) / Math.sqrt(2.0);
        if (Math.abs(a) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(a) in F_peiq coordinate function, ", "abs(a) > 1: ", a);
        }
        double A = Math.acos(a);
        double b = Math.cos(lat / 57.29577951308232) * (Math.sin(lonr / 57.29577951308232) + Math.cos(lonr / 57.29577951308232)) / Math.sqrt(2.0);
        if (Math.abs(b) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(b) in F_peiq coordinate function, ", "abs(b) > 1: ", b);
        }
        double B = Math.acos(b);
        double v = 0.5 * (A - B);
        double m = Math.sqrt(2.0) * Math.sin(v);
        if (m > 1.00001 || m < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(m) in F_peiq coordinate function, ", "abs(m) > 1: ", m);
        }
        if (m > 1.0) {
            m = 1.0;
        } else if (m < -1.0) {
            m = -1.0;
        }
        double M = Math.asin(m);
        double u = 0.5 * (A + B);
        double n = Math.sqrt(2.0) * Math.cos(u);
        if (n > 1.00001 || n < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(n) in F_peiq coordinate function, ", "abs(n) > 1: ", n);
        }
        if (n > 1.0) {
            n = 1.0;
        } else if (n < -1.0) {
            n = -1.0;
        }
        double N = Math.asin(n);
        double Xe = NumIntegration.getInEllipticIntegral1(Math.sqrt(0.5), M, 1.0E-14);
        double Ye = NumIntegration.getInEllipticIntegral1(Math.sqrt(0.5), N, 1.0E-14);
        double X = R * 0.5 * (Ye - Xe) / Math.sqrt(2.0) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_peiq coordinate function, ", "F_peiq > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_peiq(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double a = Math.cos(lat / 57.29577951308232) * (Math.cos(lonr / 57.29577951308232) - Math.sin(lonr / 57.29577951308232)) / Math.sqrt(2.0);
        if (Math.abs(a) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(a) in G_peiq coordinate function, ", "abs(a) > 1: ", a);
        }
        double A = Math.acos(a);
        double b = Math.cos(lat / 57.29577951308232) * (Math.sin(lonr / 57.29577951308232) + Math.cos(lonr / 57.29577951308232)) / Math.sqrt(2.0);
        if (Math.abs(b) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate acos(b) in G_peiq coordinate function, ", "abs(b) > 1: ", b);
        }
        double B = Math.acos(b);
        double v = 0.5 * (A - B);
        double m = Math.sqrt(2.0) * Math.sin(v);
        if (m > 1.00001 || m < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(m) in G_peiq coordinate function, ", "abs(m) > 1: ", m);
        }
        if (m > 1.0) {
            m = 1.0;
        } else if (m < -1.0) {
            m = -1.0;
        }
        double M = Math.asin(m);
        double u = 0.5 * (A + B);
        double n = Math.sqrt(2.0) * Math.cos(u);
        if (n > 1.00001 || n < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(n) in G_peiq coordinate function, ", "abs(n) > 1: ", n);
        }
        if (n > 1.0) {
            n = 1.0;
        } else if (n < -1.0) {
            n = -1.0;
        }
        double N = Math.asin(n);
        double Xe = NumIntegration.getInEllipticIntegral1(Math.sqrt(0.5), M, 1.0E-14);
        double Ye = NumIntegration.getInEllipticIntegral1(Math.sqrt(0.5), N, 1.0E-14);
        double Y = R * 0.5 * (Ye + Xe) / Math.sqrt(2.0) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_peiq coordinate function, ", "G_peiq > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_pers(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double h = Math.sqrt(5.0);
        double A = 1.0 - 1.0 / h * (1.0 - Math.sin(lat / 57.29577951308232));
        double rho = R * Math.cos(lat / 57.29577951308232) / A;
        double X = rho * Math.sin(lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_pers coordinate function, ", "F_pers > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_pers(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double h = Math.sqrt(5.0);
        double A = 1.0 - 1.0 / h * (1.0 - Math.sin(lat / 57.29577951308232));
        double rho = R * Math.cos(lat / 57.29577951308232) / A;
        double Y = -rho * Math.cos(lonr / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_pers coordinate function, ", "G_pers > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_pers(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_pers coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_pers coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double dist = Math.sqrt(Xr * Xr + Yr * Yr);
        double h = Math.sqrt(5.0);
        double A = dist * dist / (h * h) + R * R;
        double B = 2.0 * dist * dist / h - 2.0 * dist * dist / (h * h);
        double C = dist * dist - 2.0 * dist * dist / h + dist * dist / (h * h) - R * R;
        double D = B * B - 4.0 * A * C;
        double arg = 0.0;
        if (D < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in FI_pers coordinate function, ", "D < 0: ", D);
        }
        arg = D == 0.0 ? -B / (2.0 * A) : (-B + Math.sqrt(D)) / (2.0 * A);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_pers coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double lat = Math.asin(arg) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_stere coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_pers(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_pers coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_pers coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double lonr = Math.atan2(Xr, -Yr) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_stere coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_persf(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        if (Math.abs(c) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_persf coordinate function, ", "1.0 / c, c = 0:", c);
        }
        double A = 1.0 - 1.0 / c * (1.0 - Math.sin(lat / 57.29577951308232));
        if (Math.abs(A) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_persf coordinate function, ", "1.0 / A, A = 0:", A);
        }
        double rho = R * Math.cos(lat / 57.29577951308232) / A;
        double X = rho * Math.sin(lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_persf coordinate function, ", "F_persf > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_persf(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        if (Math.abs(c) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_persf coordinate function, ", "1.0 / c, c = 0:", c);
        }
        double A = 1.0 - 1.0 / c * (1.0 - Math.sin(lat / 57.29577951308232));
        double rho = R * Math.cos(lat / 57.29577951308232) / A;
        double Y = -rho * Math.cos(lonr / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_persf coordinate function, ", "G_persf > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_persf(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_persf coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluateFI_persf coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double dist = Math.sqrt(Xr * Xr + Yr * Yr);
        double A = dist * dist / (c * c) + R * R;
        double B = 2.0 * dist * dist / c - 2.0 * dist * dist / (c * c);
        double C = dist * dist - 2.0 * dist * dist / c + dist * dist / (c * c) - R * R;
        double D = B * B - 4.0 * A * C;
        double arg = 0.0;
        if (D < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in FI_persf coordinate function, ", "D < 0: ", D);
        }
        arg = D == 0.0 ? -B / (2.0 * A) : (-B + Math.sqrt(D)) / (2.0 * A);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_persf coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double lat = Math.asin(arg) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_persf coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_persf(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_persf coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_persf coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double lonr = Math.atan2(Xr, -Yr) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_persf coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_persn(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = 1.0 + 1.0 / c * (1.0 + Math.sin(lat / 57.29577951308232));
        double rho = R * Math.cos(lat / 57.29577951308232) / A;
        double X = rho * Math.sin(lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_persn coordinate function, ", "F_persn > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_persn(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = 1.0 + 1.0 / c * (1.0 + Math.sin(lat / 57.29577951308232));
        double rho = R * Math.cos(lat / 57.29577951308232) / A;
        double Y = -rho * Math.cos(lonr / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_persn coordinate function, ", "G_persn > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_persn(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_persn coordinate function, ", "FI_persn > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_persn coordinate function, ", "GI_persn > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double dist = Math.sqrt(Xr * Xr + Yr * Yr);
        double A = dist * dist / (c * c) + R * R;
        double B = 2.0 * dist * dist / c + 2.0 * dist * dist / (c * c);
        double C = dist * dist + 2.0 * dist * dist / c + dist * dist / (c * c) - R * R;
        double D = B * B - 4.0 * A * C;
        double arg = 0.0;
        if (D < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in FI_persn coordinate function, ", "D < 0: ", D);
        }
        arg = D == 0.0 ? -B / (2.0 * A) : (-B + Math.sqrt(D)) / (2.0 * A);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_persn coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double lat = Math.asin(arg) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_persn coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_persn(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_persn coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_persn coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double lonr = Math.atan2(Xr, -Yr) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_persn coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_poly(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 0.0;
        if (Math.abs(lat) < 1.0E-9) {
            X = R * lonr / 57.29577951308232 + dx;
        } else {
            double delta = lonr / 57.29577951308232 * Math.sin(lat / 57.29577951308232);
            if (Math.abs(lat) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_poly coordinate function, ", "1.0 / lat, lat = 0:", lat);
            }
            double rho = R * 1.0 / Math.tan(lat / 57.29577951308232);
            X = rho * Math.sin(delta) + dx;
        }
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_poly coordinate function, ", "F_poly > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_poly(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double Y = 0.0;
        if (Math.abs(lat) < 1.0E-9) {
            Y = -R * lat1 / 57.29577951308232 + dy;
        } else {
            double delta = lonr / 57.29577951308232 * Math.sin(lat / 57.29577951308232);
            if (Math.abs(lat) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_poly coordinate function, ", "1.0 / lat, lat = 0:", lat);
            }
            double rho = R * 1.0 / Math.tan(lat / 57.29577951308232);
            double S = R * lat / 57.29577951308232 - R * lat1 / 57.29577951308232;
            Y = S + rho * (1.0 - Math.cos(delta)) + dy;
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_poly coordinate function, ", "G_poly > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_poly(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double ct;
        double DGG;
        double at;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_poly coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_poly coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double lat_i = 0.0;
        double dlat = 0.0 - lat1;
        double A = Xr * Xr + R * R * dlat * dlat / 57.29577951308232 + Yr * Yr - 2.0 * R * dlat / 57.29577951308232 * Yr;
        double B = R * R * dlat / 57.29577951308232 - R * Yr;
        double C = Math.sin(0.0);
        double G = A * C * C + B * Math.sin(0.0);
        double d2 = Xr * Xr + Yr * Yr;
        double D = d2 + R * R * dlat / 57.29577951308232 * dlat / 57.29577951308232 + R * R - 2.0 * R * Yr * dlat / 57.29577951308232;
        double E = 2.0 * R * R * dlat / 57.29577951308232 - 2.0 * R * Yr;
        double F = Math.cos(0.0);
        double dG = D * Math.sin(0.0) + E * F * F;
        double bt = dG;
        double disc = bt * bt - 4.0 * (at = 0.5 * (DGG = 2.0 * Math.cos(0.0) * D + 2.0 * F * F * R * R)) * (ct = G);
        if (disc < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(disc) in FI_poly coordinate function, ", "disc < 0: ", disc);
        }
        double x1 = (-bt + Math.sqrt(disc)) / (2.0 * at);
        double x2 = (-bt - Math.sqrt(disc)) / (2.0 * at);
        double lat0 = (Math.abs(x1) > Math.abs(x2) ? x1 : x2) * 57.29577951308232;
        FILat fl = new FILat(X, Y, R, lat1, lat2, lon0, dx, dy, Projections::FILat_poly);
        FILatDer fld = new FILatDer(X, Y, R, lat1, lat2, lon0, dx, dy, Projections::FILatDer_poly);
        double lat = NewtonRaphson.findRoot(fl::function, fld::function, lat0, 20, 1.0E-5);
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_poly coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_poly(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_poly coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_poly coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_poly(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double Xr = X - dx;
        double Yr = Y - dy;
        double lonr = 0.0;
        if (Math.abs(lat) < 1.0E-9) {
            lonr = Xr / R * 57.29577951308232;
        } else {
            double S = R * lat / 57.29577951308232 - R * lat1 / 57.29577951308232;
            double rho = R / Math.tan(lat / 57.29577951308232);
            double delta = Math.atan2(Math.signum(lat) * Xr, Math.signum(lat) * (S + rho - Yr)) * 57.29577951308232;
            lonr = delta / Math.sin(lat / 57.29577951308232);
        }
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_poly coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double FILat_poly(double lat_i, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy) {
        double Xr = X - dx;
        double Yr = Y - dy;
        double S = R * (lat_i - lat1) / 57.29577951308232;
        double rho = R / Math.tan(lat_i / 57.29577951308232);
        double A = S + rho - Yr;
        double F = (Xr * Xr + A * A - rho * rho) * 57.29577951308232;
        return F;
    }

    public static double FILatDer_poly(double lat_i, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy) {
        double Xr = X - dx;
        double Yr = Y - dy;
        double S = R * (lat_i - lat1) / 57.29577951308232;
        double rho = R / Math.tan(lat_i / 57.29577951308232);
        double dF = 2.0 * rho * (R - S / Math.tan(lat_i / 57.29577951308232) + Yr / Math.tan(lat_i / 57.29577951308232));
        return dF;
    }

    public static double F_putp1(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cx = 0.94745;
        double B = 3.0;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double D = 1.0 - 3.0 * Math.pow(lat / 180.0, 2.0);
        if (D < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in F_putp1 coordinate function, ", "D < 0: ", D);
        }
        double X = 0.94745 * R * lonr / 57.29577951308232 * Math.sqrt(D) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_putp1 coordinate function, ", "F_putp1 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_putp1(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = 0.94745;
        double Y = 0.94745 * R * lat / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_putp1 coordinate function, ", "G_putp1 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_putp1(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_putp1 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_putp1 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = 0.94745;
        double lat = Yr / (R * 0.94745) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_putp2 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_putp1(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_putp1 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_putp1 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_putp1(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double cx = 0.94745;
        double B = 3.0;
        double Xr = X - dx;
        double D = 1.0 - 3.0 * Math.pow(lat / 180.0, 2.0);
        if (D < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in GI_putp1 coordinate function, ", "D < 0: ", D);
        }
        double lonr = Xr / (R * 0.94745 * Math.sqrt(D)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_putp1 coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_putp2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double c1 = 1.8949;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double latr = lat / 57.29577951308232;
        double theta0 = (0.615709 * latr + 0.00909953 * latr * latr * latr + 0.0046292 * latr * latr * latr * latr * latr) * 57.29577951308232;
        FTheta ft = new FTheta(lat, Projections::FTheta_putp2);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_putp2);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double X = 1.8949 * R * lonr / 57.29577951308232 * (Math.cos(theta / 57.29577951308232) - 0.5) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_putp2 coordinate function, ", "F_putp2 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_putp2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double c2 = 1.71848;
        double latr = lat / 57.29577951308232;
        double theta0 = (0.615709 * latr + 0.00909953 * latr * latr * latr + 0.0046292 * latr * latr * latr * latr * latr) * 57.29577951308232;
        FTheta ft = new FTheta(lat, Projections::FTheta_putp2);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_putp2);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double Y = 1.71848 * R * Math.sin(theta / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_putp2 coordinate function, ", "G_putp2 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FTheta_putp2(double lat, double theta) {
        double cp = (Math.PI * 4 - 3.0 * Math.sqrt(3.0)) / 6.0;
        return 2.0 * theta / 57.29577951308232 + Math.sin(2.0 * theta / 57.29577951308232) - 2.0 * Math.sin(theta / 57.29577951308232) - cp * Math.sin(lat / 57.29577951308232);
    }

    public static double FThetaDer_putp2(double lat, double theta) {
        return (2.0 + 2.0 * Math.cos(2.0 * theta / 57.29577951308232) - 2.0 * Math.cos(theta / 57.29577951308232)) / 57.29577951308232;
    }

    public static double FI_putp2(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_putp2 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_putp2 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double c2 = 1.71848;
        double arg = Yr / (R * 1.71848);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_putp2 coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = Math.asin(arg) * 57.29577951308232;
        double cp = (Math.PI * 4 - 3.0 * Math.sqrt(3.0)) / 6.0;
        double arg2 = (2.0 * theta / 57.29577951308232 + Math.sin(2.0 * theta / 57.29577951308232) - 2.0 * Math.sin(theta / 57.29577951308232)) / cp;
        if (arg2 > 1.00001 || arg2 < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg2) in FI_putp2 coordinate function, ", "abs(arg2) > 1: ", arg2);
        }
        if (arg2 > 1.0) {
            arg2 = 1.0;
        } else if (arg2 < -1.0) {
            arg2 = -1.0;
        }
        double lat = Math.asin(arg2) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_putp2 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_putp2(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_putp2 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_putp2 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_putp2(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double c2 = 1.71848;
        double Xr = X - dx;
        double Yr = Y - dy;
        double arg = Yr / (R * 1.71848);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in GI_putp2 coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = Math.asin(arg) * 57.29577951308232;
        double c1 = 1.8949;
        double lonr = Xr / (1.8949 * R * (Math.cos(theta / 57.29577951308232) - 0.5)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_putp2 coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_putp3(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cx = Math.sqrt(0.6366197723675814);
        double A = 4.0;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = cx * R * lonr / 57.29577951308232 * (1.0 - 4.0 * Math.pow(lat / 180.0, 2.0)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_putp3 coordinate function, ", "F_putp3 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_putp3(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = Math.sqrt(0.6366197723675814);
        double Y = cy * R * lat / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_putp3 coordinate function, ", "G_putp3 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_putp3(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_putp3 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_putp3 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = Math.sqrt(0.6366197723675814);
        double lat = Yr / (R * cy) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_putp3 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_putp3(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_putp3 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_putp3 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_putp3(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double cx = Math.sqrt(0.6366197723675814);
        double A = 4.0;
        double Xr = X - dx;
        double lonr = Xr / (R * cx * (1.0 - 4.0 * Math.pow(lat / 180.0, 2.0))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_putp3 coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_putp3p(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cx = Math.sqrt(0.6366197723675814);
        double A = 2.0;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = cx * R * lonr / 57.29577951308232 * (1.0 - 2.0 * Math.pow(lat / 180.0, 2.0)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_putp3p coordinate function, ", "F_putp3p > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_putp3p(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = Math.sqrt(0.6366197723675814) * R * lat / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_putp3p coordinate function, ", "G_putp3p > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_putp3p(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_putp3p coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_putp3p coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = Math.sqrt(0.6366197723675814);
        double lat = Yr / (R * cy) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_putp3p coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_putp3p(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_putp3p coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_putp3p coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_putp3(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double cx = Math.sqrt(0.6366197723675814);
        double A = 2.0;
        double Xr = X - dx;
        double lonr = Xr / (R * cx * (1.0 - 2.0 * Math.pow(lat / 180.0, 2.0))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_putp3p coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_putp4p(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cx = 2.0 * Math.sqrt(0.1909859317102744);
        double A = 5.0 * Math.sqrt(2.0) / 8.0;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double arg = A * Math.sin(lat / 57.29577951308232);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in F_putp4p coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = Math.asin(arg) * 57.29577951308232;
        double B = Math.cos(theta / 3.0 / 57.29577951308232);
        if (Math.abs(B) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_putp4p coordinate function, ", "1.0 / B, B = 0:", B);
        }
        double X = cx * R * lonr / 57.29577951308232 * Math.cos(theta / 57.29577951308232) / B + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_putp4p coordinate function, ", "F_putp4p > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_putp4p(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = 2.0 * Math.sqrt(3.7699111843077517);
        double A = 5.0 * Math.sqrt(2.0) / 8.0;
        double arg = A * Math.sin(lat / 57.29577951308232);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in G_putp4p coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = Math.asin(arg) * 57.29577951308232;
        double Y = cy * R * Math.sin(theta / 3.0 / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_putp4p coordinate function, ", "G_putp4p > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_putp4p(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_putp4p coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_putp4p coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = 2.0 * Math.sqrt(3.7699111843077517);
        double arg = Yr / (R * cy);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_putp4p coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = 3.0 * Math.asin(arg) * 57.29577951308232;
        double A = 5.0 * Math.sqrt(2.0) / 8.0;
        double arg2 = Math.sin(theta / 57.29577951308232) / A;
        if (arg2 > 1.00001 || arg2 < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg2) in FI_putp4p coordinate function, ", "abs(arg2) > 1: ", arg2);
        }
        if (arg2 > 1.0) {
            arg2 = 1.0;
        } else if (arg2 < -1.0) {
            arg2 = -1.0;
        }
        double lat = Math.asin(arg2) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_putp4p coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_putp4p(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_putp4p coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_putp4p coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double cx = 2.0 * Math.sqrt(0.1909859317102744);
        double cy = 2.0 * Math.sqrt(3.7699111843077517);
        double arg = Yr / (R * cy);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_putp4p coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = 3.0 * Math.asin(arg) * 57.29577951308232;
        double B = Math.cos(theta / 3.0 / 57.29577951308232);
        if (Math.abs(B) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_putp4p coordinate function, ", "1.0 / B, B = 0:", B);
        }
        double lonr = Xr * B / (R * cx * Math.cos(theta / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_putp4p coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_putp5(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cx = 1.01346;
        double A = 2.0;
        double B = 1.0;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 1.01346 * R * lonr / 57.29577951308232 * (2.0 - Math.sqrt(1.0 + 12.0 * Math.pow(lat / 180.0, 2.0))) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_putp5 coordinate function, ", "F_putp5 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_putp5(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = 1.01346;
        double Y = 1.01346 * R * lat / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_putp5 coordinate function, ", "G_putp5 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_putp5(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_putp5 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_putp5 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = 1.01346;
        double lat = Yr / (R * 1.01346) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_putp5 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_putp5(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_putp5 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_putp5 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_putp5(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double cx = 1.01346;
        double A = 2.0;
        double B = 1.0;
        double Xr = X - dx;
        double lonr = Xr / (R * 1.01346 * (2.0 - Math.sqrt(1.0 + 12.0 * Math.pow(lat / 180.0, 2.0)))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_putp5 coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_putp5p(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cx = 1.01346;
        double A = 1.5;
        double B = 0.5;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 1.01346 * R * lonr / 57.29577951308232 * (1.5 - Math.sqrt(0.5 + 12.0 * Math.pow(lat / 180.0, 2.0))) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_putp5p coordinate function, ", "F_putp5p > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_putp5p(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = 1.01346;
        double Y = 1.01346 * R * lat / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_putp5p coordinate function, ", "G_putp5p > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_putp5p(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_putp5p coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_putp5p coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = 1.01346;
        double lat = Yr / (R * 1.01346) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_putp5p coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_putp5p(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_putp5p coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_putp5p coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_putp5p(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double cx = 1.01346;
        double A = 1.5;
        double B = 0.5;
        double Xr = X - dx;
        double lonr = Xr / (R * 1.01346 * (1.5 - Math.sqrt(0.5 + 12.0 * Math.pow(lat / 180.0, 2.0)))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_putp5p coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_putp6(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cx = 1.01346;
        double D = 2.0;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_putp6);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_putp6);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double X = 1.01346 * R * lonr / 57.29577951308232 * (2.0 - Math.sqrt(1.0 + theta / 57.29577951308232 * theta / 57.29577951308232)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_putp6 coordinate function, ", "F_putp6 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_putp6(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = 0.9191;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_putp6);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_putp6);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double Y = 0.9191 * R * theta / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_putp6 coordinate function, ", "G_putp6 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FTheta_putp6(double lat, double theta) {
        double A = 4.0;
        double B = 2.14714;
        double r = Math.sqrt(1.0 + theta / 57.29577951308232 * theta / 57.29577951308232);
        return (4.0 - r) * theta / 57.29577951308232 - Math.log(theta / 57.29577951308232 + r) - 2.14714 * Math.sin(lat / 57.29577951308232);
    }

    public static double FThetaDer_putp6(double lat, double theta) {
        double A = 4.0;
        return (4.0 - 2.0 * Math.sqrt(1.0 + theta / 57.29577951308232 * theta / 57.29577951308232)) / 57.29577951308232;
    }

    public static double FI_putp6(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_putp6 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_putp6 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = 0.9191;
        double theta = Yr / (R * 0.9191) * 57.29577951308232;
        double A = 4.0;
        double B = 2.14714;
        double r = Math.sqrt(1.0 + theta / 57.29577951308232 * theta / 57.29577951308232);
        double arg = ((4.0 - r) * theta / 57.29577951308232 - Math.log(theta / 57.29577951308232 + r)) / 2.14714;
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg6) in FI_putp6 coordinate function, ", "abs(arg6) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double lat = Math.asin(arg) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_putp6 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_putp6(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_putp6 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_putp6 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double cx = 1.01346;
        double cy = 0.9191;
        double D = 2.0;
        double Xr = X - dx;
        double Yr = Y - dy;
        double theta = Yr / (R * 0.9191) * 57.29577951308232;
        double lonr = Xr / (1.01346 * R * (2.0 - Math.sqrt(1.0 + theta / 57.29577951308232 * theta / 57.29577951308232))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_putp6 coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_putp6p(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cx = 0.44329;
        double D = 3.0;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_putp6p);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_putp6p);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double X = 0.44329 * R * lonr / 57.29577951308232 * (3.0 - Math.sqrt(1.0 + theta / 57.29577951308232 * theta / 57.29577951308232)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_putp6p coordinate function, ", "F_putp6p > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_putp6p(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = 0.80404;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double theta0 = lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_putp6p);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_putp6p);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double Y = 0.80404 * R * theta / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_putp6p coordinate function, ", "G_putp6p > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FTheta_putp6p(double lat, double theta) {
        double A = 6.0;
        double B = 5.61125;
        double r = Math.sqrt(1.0 + theta / 57.29577951308232 * theta / 57.29577951308232);
        return (6.0 - r) * theta / 57.29577951308232 - Math.log(theta / 57.29577951308232 + r) - 5.61125 * Math.sin(lat / 57.29577951308232);
    }

    public static double FThetaDer_putp6p(double lat, double theta) {
        double A = 6.0;
        return (6.0 - 2.0 * Math.sqrt(1.0 + theta / 57.29577951308232 * theta / 57.29577951308232)) / 57.29577951308232;
    }

    public static double FI_putp6p(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_putp6p coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_putp6p coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = 0.80404;
        double theta = Yr / (R * 0.80404) * 57.29577951308232;
        double A = 6.0;
        double B = 5.61125;
        double r = Math.sqrt(1.0 + theta / 57.29577951308232 * theta / 57.29577951308232);
        double arg = ((6.0 - r) * theta / 57.29577951308232 - Math.log(theta / 57.29577951308232 + r)) / 5.61125;
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_putp6p coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double lat = Math.asin(arg) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_putp6p coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_putp6p(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_putp6p coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_putp6p coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double cx = 0.44329;
        double cy = 0.80404;
        double D = 3.0;
        double Xr = X - dx;
        double Yr = Y - dy;
        double theta = Yr / (R * 0.80404) * 57.29577951308232;
        double lonr = Xr / (0.44329 * R * (3.0 - Math.sqrt(1.0 + theta / 57.29577951308232 * theta / 57.29577951308232))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_putp6p coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_qua_aut(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double q = 2.0;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = R * lonr / 57.29577951308232 * Math.cos(lat / 57.29577951308232) / Math.cos(lat / 2.0 / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_qua_aut coordinate function, ", "F_qua_aut > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_qua_aut(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double p = 2.0;
        double q = 2.0;
        double Y = 2.0 * R * Math.sin(lat / 2.0 / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_qua_aut coordinate function, ", "G_qua_aut > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_qua_aut(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_qua_aut coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_qua_aut coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double p = 2.0;
        double q = 2.0;
        double arg = Yr / (2.0 * R);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in F_qua_aut coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double lat = 2.0 * Math.asin(arg) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_qua_aut coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_qua_aut(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_qua_aut coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_qua_aut coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_qua_aut(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double q = 2.0;
        double Xr = X - dx;
        double lonr = Xr / (R * Math.cos(lat / 57.29577951308232) / Math.cos(lat / 2.0 / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_qua_aut coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_rpoly(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 0.0;
        double A = 0.0;
        A = Math.abs(lat1) < 1.0E-9 ? 0.5 * lonr / 57.29577951308232 : Math.tan(0.5 * lonr / 57.29577951308232 * Math.sin(lat1 / 57.29577951308232)) / Math.sin(lat1 / 57.29577951308232);
        if (Math.abs(lat) < 1.0E-9) {
            X = 2.0 * R * A + dx;
        } else {
            double delta = 2.0 * Math.atan(A * Math.sin(lat / 57.29577951308232));
            if (Math.abs(Math.abs(lat) - 90.0) < 1.0E-9) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate tan(lat) in F_rpoly coordinate function, ", "lat = +-90: ", lat);
            }
            double rho = R / Math.tan(lat / 57.29577951308232);
            X = rho * Math.sin(delta) + dx;
        }
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_rpoly coordinate function, ", "F_rpoly > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_rpoly(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double Y = 0.0;
        double A = 0.0;
        A = Math.abs(lat1) < 1.0E-9 ? 0.5 * lonr / 57.29577951308232 : Math.tan(0.5 * lonr / 57.29577951308232 * Math.sin(lat1 / 57.29577951308232)) / Math.sin(lat1 / 57.29577951308232);
        if (Math.abs(lat) < 1.0E-9) {
            Y = -R * lat1 / 57.29577951308232 + dy;
        } else {
            double delta = 2.0 * Math.atan(A * Math.sin(lat / 57.29577951308232));
            if (Math.abs(Math.abs(lat) - 90.0) < 1.0E-9) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate tan(lat) in G_rpoly coordinate function, ", "lat = +-90: ", lat);
            }
            Y = R * (lat / 57.29577951308232 - lat1 / 57.29577951308232 + 1.0 / Math.tan(lat / 57.29577951308232) * (1.0 - Math.cos(Math.E))) + dy;
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_rpoly coordinate function, ", "G_rpoly > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_rpoly(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_rpoly coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_rpoly coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        if (Math.abs(lat1) > 89.999999999) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_rpoly coordinate function, ", "1.0 / cos(lat1), lat1 = +-90.", lat1);
        }
        double lat = Projections.FI_poly(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_rpoly coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_rpoly(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_rpoly coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_rpoly coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        if (Math.abs(lat1) > 89.999999999) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_rpoly coordinate function, ", "1.0 / cos(lat1), lat1 = +-90.", lat1);
        }
        double lat = Projections.FI_poly(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double Xr = X - dx;
        double Yr = Y - dy;
        double A = 0.0;
        if (Math.abs(lat) < 1.0E-9) {
            A = Xr / (2.0 * R);
        } else {
            double S = R * lat / 57.29577951308232 - R * lat1 / 57.29577951308232;
            double rho = R / Math.tan(lat / 57.29577951308232);
            double delta = Math.atan2(Math.signum(lat) * Xr, Math.signum(lat) * (S + rho - Yr)) * 57.29577951308232;
            A = Math.tan(0.5 * delta / 57.29577951308232) / Math.sin(lat / 57.29577951308232);
        }
        double lonr = 0.0;
        if (Math.abs(lat1) < 1.0E-9) {
            lonr = 2.0 * A * 57.29577951308232;
        } else {
            double C = Math.sin(lat1 / 57.29577951308232);
            lonr = 2.0 / C * Math.atan(C * A) * 57.29577951308232;
        }
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_rpoly coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_sinu(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = R * lonr * Math.cos(lat / 57.29577951308232) / 57.29577951308232 + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_sinu coordinate function, ", "F_sinu > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_sinu(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = R * lat / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_sinu coordinate function, ", "G_psinu > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_sinu(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_sinu coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = (Y - dy) / R * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_sinu coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_sinu(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_sinu coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_sinu coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        if (Math.abs(lat1) > 89.999999999) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_sinu coordinate function, ", "1.0 / cos(lat1), lat1 = +-90.", lat1);
        }
        double lat = Projections.FI_sinu(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double lonr = (X - dx) / (R * Math.cos(lat / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_sinu coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_solo(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = (90.0 - lat) / 4.0;
        if (Math.abs(Math.abs(A) - 90.0) < 1.0E-9) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate tan(lat) in F_solo coordinate function, ", "lat = +-90: ", lat);
        }
        double rho = 4.0 * R * Math.tan(A / 57.29577951308232);
        double X = rho * Math.sin(lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_solo coordinate function, ", "F_solo > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_solo(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = (90.0 - lat) / 4.0;
        if (Math.abs(Math.abs(A) - 90.0) < 1.0E-9) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate tan(lat) in G_solo coordinate function, ", "lat = +-90: ", lat);
        }
        double rho = 4.0 * R * Math.tan(A / 57.29577951308232);
        double Y = -rho * Math.cos(lonr / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_solo coordinate function, ", "G_solo > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_solo(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_solo coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_solo coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double dist = Math.sqrt(Xr * Xr + Yr * Yr);
        double lat = 90.0 - 4.0 * Math.atan(dist / (4.0 * R)) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_solo coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_solo(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_solo coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_solo coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double lonr = Math.atan2(Xr, -Yr) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_solo coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_stere(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = (90.0 - lat) / 2.0;
        if (Math.abs(A - 90.0) < 1.0E-9) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate tan(lat) in F_stere coordinate function, ", "lat = +-90: ", lat);
        }
        double rho = 2.0 * R * Math.tan(A / 57.29577951308232);
        double X = rho * Math.sin(lonr / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_stere coordinate function, ", "F_stere > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_stere(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = (90.0 - lat) / 2.0;
        if (Math.abs(A - 90.0) < 1.0E-9) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate tan(lat) in G_stere coordinate function, ", "lat = +-90: ", lat);
        }
        double rho = 2.0 * R * Math.tan(A / 57.29577951308232);
        double Y = -rho * Math.cos(lonr / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_stere coordinate function, ", "G_stere > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_stere(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_stere coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_stere coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double dist = Math.sqrt(Xr * Xr + Yr * Yr);
        double lat = 90.0 - 2.0 * Math.atan(dist / (2.0 * R)) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_stere coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_stere(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_stere coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_stere coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double lonr = Math.atan2(Xr, -Yr) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_stere coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_twi(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double h = 2.4;
        return Projections.F_persf(lat, lon, R, lat1, lat2, lon0, dx, dy, 2.4);
    }

    public static double G_twi(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double h = 2.4;
        return Projections.G_persf(lat, lon, R, lat1, lat2, lon0, dx, dy, 2.4);
    }

    public static double FI_twi(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double h = 2.4;
        return Projections.FI_persf(X, Y, R, lat1, lat2, lon0, dx, dy, 2.4);
    }

    public static double GI_twi(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double h = 2.4;
        return Projections.GI_persf(X, Y, R, lat1, lat2, lon0, dx, dy, 2.4);
    }

    public static double F_urm5(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double theta;
        double m = 2.0 * Math.pow(3.0, 0.25) / 3.0;
        double n = 0.8;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = m * R * lonr / 57.29577951308232 * Math.cos((theta = Math.asin(0.8 * Math.sin(lat / 57.29577951308232)) * 57.29577951308232) / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_urm5 coordinate function, ", "F_urm5 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_urm5(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double m = 2.0 * Math.pow(3.0, 0.25) / 3.0;
        double n = 0.8;
        double q = 0.414524;
        double theta = Math.asin(0.8 * Math.sin(lat / 57.29577951308232)) * 57.29577951308232;
        double Y = R * theta / 57.29577951308232 * (1.0 + 0.13817466666666667 * theta * theta / 3282.806350011744) / (m * 0.8) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_urm5 coordinate function, ", "G_urm5 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_urm5(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double t;
        double u;
        double r;
        double s;
        double theta;
        double arg2;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_urm5 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_urm5 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double m = 2.0 * Math.pow(3.0, 0.25) / 3.0;
        double n = 0.8;
        double q = 0.414524;
        double Yr = Y - dy;
        double ct = -Yr / R;
        double at = 0.414524 / (3.0 * m * 0.8);
        double g = ct / at;
        double bt = 1.0 / (m * 0.8);
        double f = bt / at;
        double h = g * g / 4.0 + f * f * f / 27.0;
        if (h < -1.0E-5) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(h) in FI_urm5 coordinate function, ", "h < 0: ", h);
        }
        if (h < 0.0) {
            h = 0.0;
        }
        if ((arg2 = 1.25 * Math.sin((theta = ((s = Math.cbrt(r = -g / 2.0 + Math.sqrt(h))) + (u = Math.cbrt(t = -g / 2.0 - Math.sqrt(h)))) * 57.29577951308232) / 57.29577951308232)) > 1.00001 || arg2 < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg2) in FI_urm5 coordinate function, ", "abs(arg2) > 1: ", arg2);
        }
        if (arg2 > 1.0) {
            arg2 = 1.0;
        } else if (arg2 < -1.0) {
            arg2 = -1.0;
        }
        double lat = Math.asin(arg2) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_urm5 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_urm5(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double t;
        double u;
        double r;
        double s;
        double theta;
        double lonr;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_urm5 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_urm5 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double m = 2.0 * Math.pow(3.0, 0.25) / 3.0;
        double n = 0.8;
        double q = 0.414524;
        double ct = -Yr / R;
        double at = 0.414524 / (3.0 * m * 0.8);
        double g = ct / at;
        double bt = 1.0 / (m * 0.8);
        double f = bt / at;
        double h = g * g / 4.0 + f * f * f / 27.0;
        if (h < -1.0E-5) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(h) in GI_urm5 coordinate function, ", "h < 0: ", h);
        }
        if (h < 0.0) {
            h = 0.0;
        }
        if (Math.abs(lonr = Xr / (m * R * Math.cos((theta = ((s = Math.cbrt(r = -g / 2.0 + Math.sqrt(h))) + (u = Math.cbrt(t = -g / 2.0 - Math.sqrt(h)))) * 57.29577951308232) / 57.29577951308232)) * 57.29577951308232) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_putp6p coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_vandg(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 0.0;
        double B = Math.abs(2.0 * lat / 180.0);
        double C = Math.sqrt(1.0 - B * B);
        if (Math.abs(lat) < 1.0E-9) {
            X = R * lonr / 57.29577951308232 + dx;
        } else if (Math.abs(lonr) < 1.0E-9 || Math.abs(B - 1.0) < 1.0E-9) {
            X = dx;
        } else {
            if (Math.abs(lonr) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_vandg coordinate function, ", "1.0 / lonr, lonr = 0:", lonr);
            }
            double A = 0.5 * Math.abs(180.0 / lonr - lonr / 180.0);
            double D = A * A;
            double E = B + C - 1.0;
            if (Math.abs(E) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_vandg coordinate function, ", "1 / E, E = 0:", E);
            }
            double G = C / E;
            if (Math.abs(B) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_vandg coordinate function, ", "1.0 / B, B = 0:", B);
            }
            double P = G * (2.0 / B - 1.0);
            double Q = D + G;
            double TT = G - P * P;
            double S = P * P + D;
            double U = A * A * TT * TT - S * (G * G - P * P);
            if (U < -1.0E-5) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(m) in F_vandg coordinate function, ", "U < 0: ", U);
            }
            if (U < 0.0) {
                U = 0.0;
            }
            if (Math.abs(S) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_vandg coordinate function, ", "1 / S, S = 0:", S);
            }
            X = R * Math.PI * Math.signum(lonr) * (A * TT + Math.sqrt(U)) / S + dx;
        }
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_vandg coordinate function, ", "F_vandg > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_vandg(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double Y = 0.0;
        double B = Math.abs(2.0 * lat / 180.0);
        double C = Math.sqrt(1.0 - B * B);
        if (Math.abs(lat) < 1.0E-9) {
            Y = dy;
        } else if (Math.abs(lonr) < 1.0E-9) {
            Y = R * Math.signum(lat) * Math.PI * B / (1.0 + C) + dy;
        } else if (Math.abs(B - 1.0) < 1.0E-9) {
            Y = R * Math.signum(lat) * Math.PI + dy;
        } else {
            if (Math.abs(lonr) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_vandg coordinate function, ", "1.0 / lonr, lonr = 0:", lonr);
            }
            double A = 0.5 * Math.abs(180.0 / lonr - lonr / 180.0);
            double D = A * A;
            double E = B + C - 1.0;
            if (Math.abs(E) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_vandg coordinate function, ", "1 / E, E = 0:", E);
            }
            double G = C / E;
            if (Math.abs(B) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_vandg coordinate function, ", "1.0 / B, B = 0:", B);
            }
            double P = G * (2.0 / B - 1.0);
            double S = P * P + D;
            double Q = D + G;
            double V = (A * A + 1.0) * S - Q * Q;
            if (V < -1.0E-5) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(m) in G_vandg coordinate function, ", "V < 0: ", V);
            }
            if (V < 0.0) {
                V = 0.0;
            }
            if (Math.abs(S) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_vandg coordinate function, ", "1 / S, S = 0:", S);
            }
            Y = R * Math.PI * Math.signum(lat) * (P * Q - A * Math.sqrt(V)) / S + dy;
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_vandg coordinate function, ", "G_vandg > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_vandg(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_vandg coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_vandg coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        if (Math.abs(Xr) < 1.0E-37) {
            double t = Math.PI * 2 * R * Yr / (Math.PI * Math.PI * R * R + Yr * Yr);
            return t * Math.PI / 2.0 * 57.29577951308232;
        }
        if (Math.abs(Yr) < 1.0E-37) {
            return 0.0;
        }
        double x = Math.abs(Xr) / (R * Math.PI);
        double y = Math.abs(Yr) / (R * Math.PI);
        double at = x * x * x * x + 2.0 * x * x * y * (1.0 + y) + (1.0 + y) * (1.0 + y) * (1.0 + y * y);
        double bt = -2.0 * (x * x * (y - 1.0) + y * (1.0 + y) * (1.0 + y));
        double ct = -4.0 * y * (1.0 + x * x + y * y);
        double dt = 8.0 * y * y;
        double A = bt / at;
        double B = ct / at;
        double C = dt / at;
        double Q_ = (3.0 * B - A * A) / 9.0;
        double R_ = (9.0 * A * B - 27.0 * C - 2.0 * A * A * A) / 54.0;
        double theta = Math.acos(R_ / Math.sqrt(-Q_ * Q_ * Q_));
        double t = 2.0 * Math.sqrt(-Q_) * Math.cos((theta + Math.PI * 4) / 3.0) - A / 3.0;
        double lat = Math.signum(Y) * Math.PI / 2.0 * t * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_vandg coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_vandg(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_vandg coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_vandg coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        if (Math.abs(Xr) < 1.0E-37) {
            return 0.0;
        }
        if (Math.abs(Yr) < 1.0E-37) {
            return Xr / R * 57.29577951308232;
        }
        double x = Math.abs(Xr) / (R * Math.PI);
        double y = Math.abs(Yr) / (R * Math.PI);
        double at = x;
        double bt = 1.0 - x * x - y * y;
        double ct = -x;
        double D = bt * bt - 4.0 * at * ct;
        double s = (-bt + Math.sqrt(D)) / (2.0 * at);
        double lonr = Math.signum(Xr) * s * Math.PI * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_vandg coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_vandg2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 0.0;
        double B = Math.abs(2.0 * lat / 180.0);
        double C = Math.sqrt(1.0 - B * B);
        if (Math.abs(lat) < 1.0E-9) {
            X = R * lonr / 57.29577951308232 + dx;
        } else if (Math.abs(lonr) < 1.0E-9 || Math.abs(B - 1.0) < 1.0E-9) {
            X = dx;
        } else {
            if (Math.abs(lonr) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_vandg2 coordinate function, ", "1.0 / lonr, lonr = 0:", lonr);
            }
            double A = 0.5 * Math.abs(180.0 / lonr - lonr / 180.0);
            double D = 1.0 + A * A * B * B;
            if (Math.abs(D) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_vandg2 coordinate function, ", "1 / D, D = 0:", D);
            }
            double X1 = (C * Math.sqrt(1.0 + A * A) - A * C * C) / D;
            X = R * Math.PI * Math.signum(lonr) * X1 + dx;
        }
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_vandg2 coordinate function, ", "F_vandg2 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_vandg2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double Y = 0.0;
        double B = Math.abs(2.0 * lat / 180.0);
        double C = Math.sqrt(1.0 - B * B);
        if (Math.abs(lat) < 1.0E-9) {
            Y = dy;
        } else if (Math.abs(lonr) < 1.0E-9) {
            Y = R * Math.signum(lat) * Math.PI * B / (1.0 + C) + dy;
        } else if (Math.abs(B - 1.0) < 1.0E-9) {
            Y = R * Math.signum(lat) * Math.PI + dy;
        } else {
            if (Math.abs(lonr) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_vandg2 coordinate function, ", "1.0 / lonr, lonr = 0:", lonr);
            }
            double A = 0.5 * Math.abs(180.0 / lonr - lonr / 180.0);
            double D = 1.0 + A * A * B * B;
            if (Math.abs(D) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_vandg2 coordinate function, ", "1 / D, D = 0:", D);
            }
            double X1 = (C * Math.sqrt(1.0 + A * A) - A * C * C) / D;
            double E = 1.0 - X1 * X1 - 2.0 * A * X1;
            if (E < -1.0E-5) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(E) in G_vandg2 coordinate function, ", "E < 0: ", E);
            }
            if (E < 0.0) {
                E = 0.0;
            }
            Y = R * Math.PI * Math.signum(lat) * Math.sqrt(E) + dy;
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_vandg2 coordinate function, ", "G_vandg2 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_vandg2(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_vandg2 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_vandg2 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        if (Math.abs(Xr) < 1.0E-37) {
            double t = Math.PI * 2 * R * Yr / (Math.PI * Math.PI * R * R + Yr * Yr);
            return t * Math.PI / 2.0 * 57.29577951308232;
        }
        if (Math.abs(Yr) < 1.0E-37) {
            return 0.0;
        }
        double y = Yr / (R * Math.PI);
        double x = Xr / (R * Math.PI);
        double t = 2.0 * y / (1.0 + x * x + y * y);
        double lat = 1.5707963267948966 * t * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_vandg2 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_vandg2(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        return Projections.GI_vandg(X, Y, R, lat1, lat2, lon0, dx, dy, c);
    }

    public static double F_vandg3(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 0.0;
        double B = Math.abs(2.0 * lat / 180.0);
        double C = Math.sqrt(1.0 - B * B);
        if (Math.abs(lat) < 1.0E-9) {
            X = R * lonr / 57.29577951308232 + dx;
        } else if (Math.abs(lonr) < 1.0E-9 || Math.abs(B - 1.0) < 1.0E-9) {
            X = dx;
        } else {
            double Y1;
            if (Math.abs(lonr) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_vandg3 coordinate function, ", "1.0 / lonr, lonr = 0:", lonr);
            }
            double A = 0.5 * Math.abs(180.0 / lonr - lonr / 180.0);
            double D = 1.0 + A * A - (Y1 = B / (1.0 + C)) * Y1;
            if (D < -1.0E-5) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in F_vandg3 coordinate function, ", "D < 0: ", D);
            }
            if (D < 0.0) {
                D = 0.0;
            }
            X = R * Math.PI * Math.signum(lonr) * (Math.sqrt(D) - A) + dx;
        }
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_vandg3 coordinate function, ", "F_vandg3 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_vandg3(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double Y = 0.0;
        double B = Math.abs(2.0 * lat / 180.0);
        double C = Math.sqrt(1.0 - B * B);
        if (Math.abs(lat) < 1.0E-9) {
            Y = dy;
        } else if (Math.abs(lonr) < 1.0E-9) {
            Y = R * Math.signum(lat) * Math.PI * B / (1.0 + C) + dy;
        } else if (Math.abs(B - 1.0) < 1.0E-9) {
            Y = R * Math.signum(lat) * Math.PI + dy;
        } else {
            double Y1 = B / (1.0 + C);
            Y = R * Math.PI * Math.signum(lat) * Y1 + dy;
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_vandg3 coordinate function, ", "G_vandg3 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_vandg3(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_vandg2 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_vandg2 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        if (Math.abs(Xr) < 1.0E-37) {
            double t = Math.PI * 2 * R * Yr / (Math.PI * Math.PI * R * R + Yr * Yr);
            return t * Math.PI / 2.0 * 57.29577951308232;
        }
        if (Math.abs(Yr) < 1.0E-37) {
            return 0.0;
        }
        double x = Xr / (R * Math.PI);
        double y = Yr / (R * Math.PI);
        double t = 2.0 * y / (1.0 + y * y);
        double lat = 1.5707963267948966 * t * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_vandg2 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_vandg3(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        return Projections.GI_vandg(X, Y, R, lat1, lat2, lon0, dx, dy, c);
    }

    public static double F_vandg4(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 0.0;
        double B = Math.abs(2.0 * lat / 180.0);
        if (Math.abs(lat) < 1.0E-9) {
            X = R * lonr / 57.29577951308232 + dx;
        } else if (Math.abs(lonr) < 1.0E-9 || Math.abs(B - 1.0) < 1.0E-9) {
            X = dx;
        } else {
            double G;
            double F2;
            double D;
            double F1;
            double F;
            double B1 = B * B * (B - 1.0);
            if (Math.abs(B1) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_vandg4 coordinate function, ", "1.0 / B1, B1 = 0:", B1);
            }
            double C = 0.5 * (B * (8.0 - B * (2.0 + B * B)) - 5.0) / B1;
            if (Math.abs(lonr) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_vandg4 coordinate function, ", "1.0 / lonr, lonr = 0:", lonr);
            }
            double C1 = 90.0 / lonr + lonr / 90.0;
            double C2 = C1 * C1 - 4.0;
            if (C2 < -1.0E-5) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(m) in F_vandg4 coordinate function, ", "C2 < 0: ", C2);
            }
            if (C2 < 0.0) {
                C2 = 0.0;
            }
            if ((F = (F1 = (B + C) * (B + C)) * (B * B + C * C * (D = Math.signum(Math.abs(lonr) - 90.0) * Math.sqrt(C2)) * D - 1.0) + (1.0 - B * B) * (B * B * ((F2 = (B + 3.0 * C) * (B + 3.0 * C)) + 4.0 * C * C) + 12.0 * B * C * C * C + 4.0 * C * C * C * C)) < -1.0E-5) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(m) in F_vandg4 coordinate function, ", "F < 0: ", F);
            }
            if (F < 0.0) {
                F = 0.0;
            }
            if (Math.abs(G = 4.0 * F1 + D * D) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_vandg4 coordinate function, ", "1 / G, G = 0:", G);
            }
            double X1 = (D * (F1 + C * C - 1.0) + 2.0 * Math.sqrt(F)) / G;
            X = R * Math.PI * 0.5 * Math.signum(lonr) * X1 + dx;
        }
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_vandg4 coordinate function, ", "F_vandg4 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_vandg4(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double Y = 0.0;
        double B = Math.abs(2.0 * lat / 180.0);
        if (Math.abs(lat) < 1.0E-9) {
            Y = dy;
        } else if (Math.abs(lonr) < 1.0E-9 || Math.abs(B - 1.0) < 1.0E-9) {
            Y = R * lat / 57.29577951308232 + dy;
        } else {
            double G;
            double F2;
            double D;
            double F1;
            double F;
            double B1 = B * B * (B - 1.0);
            if (Math.abs(B1) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_vandg4 coordinate function, ", "1.0 / B1, B1 = 0:", B1);
            }
            double C = 0.5 * (B * (8.0 - B * (2.0 + B * B)) - 5.0) / B1;
            if (Math.abs(lonr) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_vandg4 coordinate function, ", "1.0 / lonr, lonr = 0:", lonr);
            }
            double C1 = 90.0 / lonr + lonr / 90.0;
            double C2 = C1 * C1 - 4.0;
            if (C2 < -1.0E-5) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(m) in F_vandg4 coordinate function, ", "C2 < 0: ", C2);
            }
            if (C2 < 0.0) {
                C2 = 0.0;
            }
            if ((F = (F1 = (B + C) * (B + C)) * (B * B + C * C * (D = Math.signum(Math.abs(lonr) - 90.0) * Math.sqrt(C2)) * D - 1.0) + (1.0 - B * B) * (B * B * ((F2 = (B + 3.0 * C) * (B + 3.0 * C)) + 4.0 * C * C) + 12.0 * B * C * C * C + 4.0 * C * C * C * C)) < -1.0E-5) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(m) in G_vandg4 coordinate function, ", "F < 0: ", F);
            }
            if (F < 0.0) {
                F = 0.0;
            }
            if (Math.abs(G = 4.0 * F1 + D * D) < 1.0E-37) {
                throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_vandg4 coordinate function, ", "1 / G, G = 0:", G);
            }
            double X1 = (D * (F1 + C * C - 1.0) + 2.0 * Math.sqrt(F)) / G;
            double H = 1.0 + D * Math.abs(X1) - X1 * X1;
            if (H < -1.0E-5) {
                throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(H) in G_vandg4 coordinate function, ", "H < 0: ", H);
            }
            if (H < 0.0) {
                H = 0.0;
            }
            Y = R * Math.PI * 0.5 * Math.signum(lat) * Math.sqrt(H) + dy;
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_vandg4 coordinate function, ", "G_vandg4 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_vandg4(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_vandg4 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_vandg4 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        if (Math.abs(Xr) < 1.0E-37) {
            return Yr / R * 57.29577951308232;
        }
        if (Math.abs(Yr) < 1.0E-37) {
            return 0.0;
        }
        double x = Math.abs(Xr) / (0.5 * R * Math.PI);
        double y = Math.abs(Yr) / (0.5 * R * Math.PI);
        double at = 1.0 + y;
        double bt = -(x * x - 3.0 + y + y * y);
        double ct = -(5.0 + 3.0 * y);
        double dt = 5.0 * y;
        double A = bt / at;
        double B = ct / at;
        double C = dt / at;
        double Q_ = (3.0 * B - A * A) / 9.0;
        double R_ = (9.0 * A * B - 27.0 * C - 2.0 * A * A * A) / 54.0;
        double theta = Math.acos(R_ / Math.sqrt(-Q_ * Q_ * Q_));
        double t = 2.0 * Math.sqrt(-Q_) * Math.cos((theta + Math.PI * 4) / 3.0) - A / 3.0;
        double lat = Math.signum(Y) * Math.PI / 2.0 * t * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_vandg4 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_vandg4(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_vandg4 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_vandg4 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        if (Math.abs(Xr) < 1.0E-37) {
            return 0.0;
        }
        if (Math.abs(Yr) < 1.0E-37) {
            return Xr / R * 57.29577951308232;
        }
        double x = Math.abs(Xr) / (0.5 * R * Math.PI);
        double y = Math.abs(Yr) / (0.5 * R * Math.PI);
        double at = x;
        double bt = 1.0 - x * x - y * y;
        double ct = -x;
        double D = bt * bt - 4.0 * at * ct;
        double s = (-bt + Math.sqrt(D)) / (2.0 * at);
        double lonr = Math.signum(Xr) * s * Math.PI / 2.0 * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_vandg4 coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_wag1(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double M = 2.0 * Math.sqrt(Math.sqrt(3.0)) / 3.0;
        double N = 0.5 * Math.sqrt(3.0);
        double A = N * Math.sin(lat / 57.29577951308232);
        if (Math.abs(A) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(A) in F_wag1 coordinate function, ", "abs(A) > 1: ", A);
        }
        double theta = Math.asin(A) * 57.29577951308232;
        double X = R * M * lonr / 57.29577951308232 * Math.cos(theta / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_wag1 coordinate function, ", "F_wag1 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_wag1(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double M = 2.0 * Math.sqrt(Math.sqrt(3.0)) / 3.0;
        double N = 0.5 * Math.sqrt(3.0);
        double A = N * Math.sin(lat / 57.29577951308232);
        if (Math.abs(A) > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(A) in G_wag1 coordinate function, ", "abs(A) > 1: ", A);
        }
        double theta = Math.asin(A) * 57.29577951308232;
        double Y = R * 3.0 * theta / 57.29577951308232 * M * N / 2.0 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_wag1 coordinate function, ", "G_wag1 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_wag2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double c1 = 0.88022;
        double c2 = 0.8855;
        double c3 = 0.92483;
        double theta = Math.asin(0.88022 * Math.sin(0.8855 * lat / 57.29577951308232)) * 57.29577951308232;
        double X = 0.92483 * R * lonr / 57.29577951308232 * Math.cos(theta / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_wag2 coordinate function, ", "F_wag2 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_wag2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double c1 = 0.88022;
        double c2 = 0.8855;
        double c4 = 1.38725;
        double theta = Math.asin(0.88022 * Math.sin(0.8855 * lat / 57.29577951308232)) * 57.29577951308232;
        double Y = 1.38725 * R * theta / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_wag2 coordinate function, ", "G_wag2 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_wag2(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_wag2 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_wag2 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double lat = Yr / R * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_wag2 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_wag2(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_wag2 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_wag2 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_wag2(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double Xr = X - dx;
        double c1 = 0.88022;
        double c2 = 0.8855;
        double c3 = 0.92483;
        double arg = 0.88022 * Math.sin(0.8855 * lat / 57.29577951308232);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in GI_wag2 coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = Math.asin(arg) * 57.29577951308232;
        double lonr = Xr / (R * 0.92483 * Math.cos(theta / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_eck5 coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_wag3(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double A = lat1 / 57.29577951308232;
        double B = Math.cos(2.0 * A / 3.0);
        if (Math.abs(B) < 1.0E-37) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate F_wag3 coordinate function, ", "1 / A, A = 0:", A);
        }
        double X = R * lonr / 57.29577951308232 * (Math.cos(A) / B) * Math.cos(2.0 * lat / 3.0 / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_wag3 coordinate function, ", "F_wag3 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_wag3(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = R * lat / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_wag3 coordinate function, ", "G_wag3 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_wag3(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_wag3 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_wag3 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double lat = Yr / R * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_wag3 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_wag3(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_wag3 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_wag3 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double A = lat1 / 57.29577951308232;
        double B = Math.cos(2.0 * A / 3.0);
        double lat = Projections.FI_wag3(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double Xr = X - dx;
        double lonr = Xr / (R * Math.cos(A) / B * Math.cos(2.0 * lat / 3.0 / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_eck5 coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_wag4(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double r = Math.sqrt(Math.PI * 2 * Math.sin(1.0471975511965976) / (2.0943951023931953 + Math.sin(2.0943951023931953)));
        double c1 = 2.0 * r / Math.PI;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double theta0 = 0.5 * lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_wag4);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_wag4);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double X = c1 * R * lonr / 57.29577951308232 * Math.cos(theta / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_wag4 coordinate function, ", "F_wag4 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_wag4(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double r = Math.sqrt(Math.PI * 2 * Math.sin(1.0471975511965976) / (2.0943951023931953 + Math.sin(2.0943951023931953)));
        double c2 = 2.0 * r / Math.sqrt(3.0);
        double theta0 = 0.5 * lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_wag4);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_wag4);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double Y = c2 * R * Math.sin(theta / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_wag4 coordinate function, ", "G_wag4 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FTheta_wag4(double lat, double theta) {
        double cp = 2.0943951023931953 + Math.sqrt(3.0) / 2.0;
        return 2.0 * theta / 57.29577951308232 + Math.sin(2.0 * theta / 57.29577951308232) - cp * Math.sin(lat / 57.29577951308232);
    }

    public static double FThetaDer_wag4(double lat, double theta) {
        return (2.0 + 2.0 * Math.cos(2.0 * theta / 57.29577951308232)) / 57.29577951308232;
    }

    public static double FI_wag4(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_wag4 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_wag4 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double r = Math.sqrt(Math.PI * 2 * Math.sin(1.0471975511965976) / (2.0943951023931953 + Math.sin(2.0943951023931953)));
        double c2 = r * 2.0 / Math.sqrt(3.0);
        double arg = Yr / (R * c2);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_wag4 coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double cp = 2.0943951023931953 + Math.sqrt(1.5);
        double theta = Math.asin(arg) * 57.29577951308232;
        double arg2 = (2.0 * theta / 57.29577951308232 + Math.sin(2.0 * theta / 57.29577951308232)) / cp;
        if (arg2 > 1.00001 || arg2 < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg2) in FI_wag4 coordinate function, ", "abs(arg2) > 1: ", arg2);
        }
        if (arg2 > 1.0) {
            arg2 = 1.0;
        } else if (arg2 < -1.0) {
            arg2 = -1.0;
        }
        double lat = Math.asin(arg2) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_wag4 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_wag4(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_moll coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_moll coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_wag4(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double r = Math.sqrt(Math.PI * 2 * Math.sin(1.0471975511965976) / (2.0943951023931953 + Math.sin(2.0943951023931953)));
        double c2 = r * 2.0 / Math.sqrt(3.0);
        double Xr = X - dx;
        double Yr = Y - dy;
        double arg = Yr / (R * c2);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_wag4 coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = Math.asin(arg) * 57.29577951308232;
        double c1 = 2.0 * r / Math.PI;
        double lonr = Xr / (c1 * R * Math.cos(theta / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_moll coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_wag6(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cx = 1.8949;
        double A = -0.5;
        double B = 3.0;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double D = 1.0 - 3.0 * Math.pow(lat / 180.0, 2.0);
        if (D < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in F_wag6 coordinate function, ", "D < 0: ", D);
        }
        double X = 1.8949 * R * lonr / 57.29577951308232 * (-0.5 + Math.sqrt(D)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_wag6 coordinate function, ", "F_wag6 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_wag6(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = 0.94745;
        double Y = 0.94745 * R * lat / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_wag6 coordinate function, ", "G_wag6 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_wag6(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_wag6 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_wag6 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = 0.94745;
        double lat = Yr / (R * 0.94745) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_putp2 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_wag6(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_wag6 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_wag6 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_wag6(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double cx = 1.8949;
        double A = -0.5;
        double B = 3.0;
        double Xr = X - dx;
        double D = 1.0 - 3.0 * Math.pow(lat / 180.0, 2.0);
        if (D < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(D) in GI_wag6 coordinate function, ", "D < 0: ", D);
        }
        double lonr = Xr / (R * 1.8949 * (-0.5 + Math.sqrt(D))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_wag6 coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_wag7(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double cx = 2.66723;
        double ct = Math.sin(1.1344640137963142);
        double sin_th = ct * Math.sin(lat / 57.29577951308232);
        double sin2_th = sin_th * sin_th;
        if (sin2_th > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(sin2_th) in F_wag7 coordinate function, ", "sin2_th < 0: ", sin2_th);
        }
        double cos_th = Math.sqrt(1.0 - sin2_th);
        double cos2_al = 0.5 * (1.0 + cos_th * Math.cos(lonr / 3.0 / 57.29577951308232));
        if (Math.abs(cos2_al) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_wag7 coordinate function, ", "1.0 / cos2_al, cos2_al = 0:", cos2_al);
        }
        double cos_al = Math.sqrt(cos2_al);
        double X = 2.66723 * R * cos_th / cos_al * Math.sin(lonr / 3.0 / 57.29577951308232) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_wag7 coordinate function, ", "F_wag7 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_wag7(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double cy = 1.24104;
        double ct = Math.sin(1.1344640137963142);
        double sin_th = ct * Math.sin(lat / 57.29577951308232);
        double sin2_th = sin_th * sin_th;
        if (sin2_th > 1.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(sin2_th) in G_wag7 coordinate function, ", "sin2_th < 0: ", sin2_th);
        }
        double cos_th = Math.sqrt(1.0 - sin2_th);
        double cos2_al = 0.5 * (1.0 + cos_th * Math.cos(lonr / 3.0 / 57.29577951308232));
        if (Math.abs(cos2_al) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate G_wag7 coordinate function, ", "1.0 / cos2_al, cos2_al = 0:", cos2_al);
        }
        double cos_al = Math.sqrt(cos2_al);
        double Y = 1.24104 * R * sin_th / cos_al + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_wag7 coordinate function, ", "G_wag7 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_wag7(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_wag7 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_wag7 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double cx = 2.66723;
        double cy = 1.24104;
        double ct = Math.sin(1.1344640137963142);
        double Yr = Y - dy;
        double Xr = X - dx;
        double A = 4.0 * R * R * 2.66723 * 2.66723 * 1.24104 * 1.24104 * Yr * Yr - 7.1141158729 * Yr * Yr * Yr * Yr - Xr * Xr * Yr * Yr * 1.24104 * 1.24104;
        if (A < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(A) in F_wag7 coordinate function, ", "A < 0: ", A);
        }
        double sin_th = Math.sqrt(A) / (2.0 * R * R * 2.66723 * 1.24104 * 1.24104);
        double sin_lat = sin_th / ct;
        if (sin_lat > 1.00001 || sin_lat < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(sin_lat) in FI_wag7 coordinate function, ", "abs(sin_lat) > 1: ", sin_lat);
        }
        if (sin_lat > 1.0) {
            sin_lat = 1.0;
        } else if (sin_lat < -1.0) {
            sin_lat = -1.0;
        }
        double lat = Math.signum(Yr) * Math.asin(sin_lat) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_larr coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_wag7(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_wag7 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_wag7 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double cx = 2.66723;
        double cy = 1.24104;
        double ct = Math.sin(1.1344640137963142);
        double Yr = Y - dy;
        double Xr = X - dx;
        double A = 4.0 * R * R * 2.66723 * 2.66723 * 1.24104 * 1.24104 * Yr * Yr - 7.1141158729 * Yr * Yr * Yr * Yr - Xr * Xr * Yr * Yr * 1.24104 * 1.24104;
        if (A < 0.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate sqrt(A) in F_wag7 coordinate function, ", "A < 0: ", A);
        }
        double sin_th = Math.sqrt(A) / (2.0 * R * R * 2.66723 * 1.24104 * 1.24104);
        if (sin_th > 1.00001 || sin_th < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(sin_th) in GI_wag7 coordinate function, ", "abs(sin_th) > 1: ", sin_th);
        }
        if (sin_th > 1.0) {
            sin_th = 1.0;
        } else if (sin_th < -1.0) {
            sin_th = -1.0;
        }
        double theta = Math.signum(Yr) * Math.asin(sin_th);
        double lonr = Math.atan2(Xr * Yr * 1.24104 * Math.sin(theta), 2.66723 * (2.0 * R * R * 1.24104 * 1.24104 * Math.sin(theta) * Math.sin(theta) - Yr * Yr)) * 3.0 * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_larr coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_wer(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 0.0;
        X = Math.abs(90.0 - lat) < 1.0E-9 ? dx : R * (90.0 - lat) / 57.29577951308232 * Math.sin(lonr * Math.cos(lat / 57.29577951308232) / (90.0 - lat)) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_wer coordinate function, ", "F_wer > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_wer(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double Y = 0.0;
        Y = Math.abs(90.0 - lat) < 1.0E-9 ? dy : R * (lat - 90.0) / 57.29577951308232 * Math.cos(lonr * Math.cos(lat / 57.29577951308232) / (90.0 - lat)) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_wer coordinate function, ", "G_wer > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_wer(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_wer coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_weren coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double rho = Math.sqrt(Xr * Xr + Yr * Yr);
        double lat = 90.0 - rho / R * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_wer coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_wer(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_wer coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_wer coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double rho = Math.sqrt(Xr * Xr + Yr * Yr);
        double lat = 90.0 - rho / R * 57.29577951308232;
        double lonr = (90.0 - lat) / Math.cos(lat / 57.29577951308232) * Math.atan2(Xr, -Yr);
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_wer coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_weren(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double A = 5.0 * Math.sqrt(2.0) / 8.0;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double arg = A * Math.sin(lat / 57.29577951308232);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in F_weren coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = Math.asin(arg) * 57.29577951308232;
        double B = Math.cos(theta / 3.0 / 57.29577951308232);
        if (Math.abs(B) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate F_weren coordinate function, ", "1.0 / B, B = 0:", B);
        }
        double X = R * lonr / 57.29577951308232 * Math.cos(theta / 57.29577951308232) / B + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_weren coordinate function, ", "F_weren > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_weren(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = Math.PI * Math.sqrt(2.0);
        double A = 5.0 * Math.sqrt(2.0) / 8.0;
        double arg = A * Math.sin(lat / 57.29577951308232);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in G_weren coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = Math.asin(arg) * 57.29577951308232;
        double Y = cy * R * Math.sin(theta / 3.0 / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_weren coordinate function, ", "G_weren > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_weren(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_weren coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_weren coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = Math.PI * Math.sqrt(2.0);
        double arg = Yr / (R * cy);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_weren coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = 3.0 * Math.asin(arg) * 57.29577951308232;
        double A = 5.0 * Math.sqrt(2.0) / 8.0;
        double arg2 = Math.sin(theta / 57.29577951308232) / A;
        if (arg2 > 1.00001 || arg2 < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg2) in FI_weren coordinate function, ", "abs(arg2) > 1: ", arg2);
        }
        if (arg2 > 1.0) {
            arg2 = 1.0;
        } else if (arg2 < -1.0) {
            arg2 = -1.0;
        }
        double lat = Math.asin(arg2) * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_weren coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_weren(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_weren coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_weren coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double cy = Math.PI * Math.sqrt(2.0);
        double arg = Yr / (R * cy);
        if (arg > 1.00001 || arg < -1.00001) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate asin(arg) in FI_weren coordinate function, ", "abs(arg) > 1: ", arg);
        }
        if (arg > 1.0) {
            arg = 1.0;
        } else if (arg < -1.0) {
            arg = -1.0;
        }
        double theta = 3.0 * Math.asin(arg) * 57.29577951308232;
        double B = Math.cos(theta / 3.0 / 57.29577951308232);
        if (Math.abs(B) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_weren coordinate function, ", "1.0 / B, B = 0:", B);
        }
        double lonr = Xr * B / (R * Math.cos(theta / 57.29577951308232)) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_weren coordinate function, ", "abs(lonr) > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_wiech(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = R * (Math.sin(lonr / 57.29577951308232) * Math.cos(lat / 57.29577951308232) - Math.cos(lonr / 57.29577951308232) * (1.0 - Math.sin(lat / 57.29577951308232))) + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_wiech coordinate function, ", "F_wiech > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_wiech(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double Y = -R * (Math.cos(lonr / 57.29577951308232) * Math.cos(lat / 57.29577951308232) + Math.sin(lonr / 57.29577951308232) * (1.0 - Math.sin(lat / 57.29577951308232))) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_wiech coordinate function, ", "G_wiech > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double F_wink1(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double lonr = CartTransformation.redLon0(lon, lon0);
        double X = 0.5 * R * lonr * (Math.cos(lat1 / 57.29577951308232) + Math.cos(lat / 57.29577951308232)) / 57.29577951308232 + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_wink1 coordinate function, ", "F_wink1 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_wink1(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y = R * lat / 57.29577951308232 + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_wink1 coordinate function, ", "G_wink1 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_wink1(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_wink1 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_wink1 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double lat = Yr / R * 57.29577951308232;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_wink1 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_wink1(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eck5 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_eck5 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double lat = Projections.FI_wink1(X, Y, R, lat1, lat2, lon0, dx, dy, c);
        double Xr = X - dx;
        double lonr = 2.0 * Xr / (R * (Math.cos(lat1 / 57.29577951308232) + Math.cos(lat / 57.29577951308232))) * 57.29577951308232;
        if (Math.abs(lonr) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_eck5 coordinate function, ", "abs(lonr)  > 180.", lonr);
        }
        double lon = CartTransformation.redLon0(lonr, -lon0);
        return lon;
    }

    public static double F_wink2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cx = 0.5;
        double lonr = CartTransformation.redLon0(lon, lon0);
        double theta0 = 0.9 * lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_wink2);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_wink2);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double E = Math.cos(lat1 / 57.29577951308232) + Math.cos(theta / 57.29577951308232);
        double X = 0.5 * R * lonr / 57.29577951308232 * E + dx;
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_wink2 coordinate function, ", "F_wink2 > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_wink2(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double cy = 0.7853981633974483;
        double D = 0.6366197723675814;
        double theta0 = 0.9 * lat;
        FTheta ft = new FTheta(lat, Projections::FTheta_wink2);
        FThetaDer ftd = new FThetaDer(lat, Projections::FThetaDer_wink2);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double Y = 0.7853981633974483 * R * (Math.sin(theta / 57.29577951308232) + 0.6366197723675814 * lat / 57.29577951308232) + dy;
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_wink2 coordinate function, ", "G_wink2 > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FTheta_wink2(double lat, double theta) {
        return 2.0 * theta / 57.29577951308232 + Math.sin(2.0 * theta / 57.29577951308232) - Math.PI * Math.sin(lat / 57.29577951308232);
    }

    public static double FThetaDer_wink2(double lat, double theta) {
        return (2.0 + 2.0 * Math.cos(2.0 * theta / 57.29577951308232)) / 57.29577951308232;
    }

    public static double FI_wink2(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_wink2 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_wink2 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Yr = Y - dy;
        double cy = 0.7853981633974483;
        double D = 0.6366197723675814;
        double arg = Yr / (0.7853981633974483 * R);
        double theta0 = -Projections.FITheta_wink2(arg, 0.0) / Projections.FIThetaDer_wink2(arg, 0.0);
        if (Math.abs(theta0) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_wink2 coordinate function, ", "abs(theta0)  > 90.", theta0);
        }
        FTheta ft = new FTheta(arg, Projections::FITheta_wink2);
        FThetaDer ftd = new FThetaDer(arg, Projections::FIThetaDer_wink2);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double lat = (arg * 57.29577951308232 - Math.sin(theta / 57.29577951308232) * 57.29577951308232) / 0.6366197723675814;
        if (Double.isNaN(lat)) {
            System.out.println("Error");
        }
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_boggs coordinate function, ", "abs(lat)  > 90.", lat);
        }
        return lat;
    }

    public static double GI_wink2(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_wink2 coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_wink2 coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double Xr = X - dx;
        double Yr = Y - dy;
        double cx = 0.5;
        double cy = 0.7853981633974483;
        double D = 0.6366197723675814;
        double arg = Yr / (0.7853981633974483 * R);
        double theta0 = -Projections.FITheta_wink2(arg, 0.0) / Projections.FIThetaDer_wink2(arg, 0.0);
        if (Math.abs(theta0) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_wink2 coordinate function, ", "abs(theta0)  > 90.", theta0);
        }
        FTheta ft = new FTheta(arg, Projections::FITheta_wink2);
        FThetaDer ftd = new FThetaDer(arg, Projections::FIThetaDer_wink2);
        double theta = NewtonRaphson.findRoot(ft::function, ftd::function, theta0, 20, 1.0E-5);
        double lat = (arg * 57.29577951308232 - Math.sin(theta / 57.29577951308232) * 57.29577951308232) / 0.6366197723675814;
        if (Math.abs(lat) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_wink2 coordinate function, ", "abs(lat)  > 90.", lat);
        }
        double E = Math.cos(lat1 / 57.29577951308232) + Math.cos(theta / 57.29577951308232);
        if (Math.abs(E) < 1.0E-37) {
            throw new MathZeroDevisionException("MathZeroDevisionException: can not evaluate GI_wink2 coordinate function, ", "1.0 / E, E = 0:", E);
        }
        double lonr = Xr / (R * 0.5 * E) * 57.29577951308232;
        double lon = CartTransformation.redLon0(lonr, -lon0);
        if (Math.abs(lon) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_wink2 coordinate function, ", "abs(lon)  > 180.", lon);
        }
        return lon;
    }

    public static double FITheta_wink2(double arg, double theta) {
        if (Math.abs(theta) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FITheta_wink2 coordinate function, ", "abs(theta0)  > 90.", theta);
        }
        double D = 0.6366197723675814;
        return 0.6366197723675814 * Math.asin(0.3183098861837907 * (2.0 * theta / 57.29577951308232 + Math.sin(2.0 * theta / 57.29577951308232))) + Math.sin(theta / 57.29577951308232) - arg;
    }

    public static double FIThetaDer_wink2(double lat, double theta) {
        if (Math.abs(theta) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FIThetaDer_wink2 coordinate function, ", "abs(theta0)  > 90.", theta);
        }
        double D = 0.6366197723675814;
        double A = 0.3183098861837907 * (2.0 * theta / 57.29577951308232 + Math.sin(2.0 * theta / 57.29577951308232));
        double B = 1.0 - A * A;
        if (Math.abs(B) < 1.0E-37) {
            throw new MathZeroDevisionException("MathDivisonByZeroException: can not evaluate FI_wink2 coordinate function, ", "1 / B, B = 0:", B);
        }
        if (B < 0.0) {
            B = 0.0;
        }
        return (0.40528473456935116 * (1.0 + Math.cos(2.0 * theta / 57.29577951308232)) / Math.sqrt(B) + Math.cos(theta / 57.29577951308232)) / 57.29577951308232;
    }

    public static double F_wintri(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double X2;
        double X1 = Projections.F_aitoff(lat, lon, R, lat1, lat2, lon0, dx, dy, c);
        double X = 0.5 * (X1 + (X2 = Projections.F_eqc(lat, lon, R, lat1, lat2, lon0, dx, dy, c)));
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_wintri coordinate function, ", "F_wintri > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_wintri(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y2;
        double Y1 = Projections.G_aitoff(lat, lon, R, lat1, lat2, lon0, dx, dy, c);
        double Y = 0.5 * (Y1 + (Y2 = Projections.G_eqc(lat, lon, R, lat1, lat2, lon0, dx, dy, c)));
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_wintri coordinate function, ", "G_wintri > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double FI_wintri(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_wintri coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate FI_wintri coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double[] lat = new double[]{Projections.FI_aitoff(X, Y, R, lat1, lat2, lon0, dx, dy, c)};
        double[] lonr = new double[]{Projections.GI_aitoff(X, Y, R, lat1, lat2, lon0, dx, dy, c)};
        double fx = Projections.GN(Projections::JI_wintri, Projections::FRI_wintri, Projections::GRI_wintri, X, Y, R, lat1, lat2, lon0, dx, dy, c, 1.0E-4, lat, lonr);
        if (Math.abs(lat[0]) > 90.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate FI_wintri coordinate function, ", "abs(lat)  > 90.", lat[0]);
        }
        return lat[0];
    }

    public static double GI_wintri(double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_wintri coordinate function, ", "X > MAX_FLOAT: ", X);
        }
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate GI_wintri coordinate function, ", "Y > MAX_FLOAT: ", Y);
        }
        double[] lat = new double[]{Projections.FI_aitoff(X, Y, R, lat1, lat2, lon0, dx, dy, c)};
        double[] lonr = new double[]{Projections.GI_aitoff(X, Y, R, lat1, lat2, lon0, dx, dy, c)};
        double fx = Projections.GN(Projections::JI_wintri, Projections::FRI_wintri, Projections::GRI_wintri, X, Y, R, lat1, lat2, lon0, dx, dy, c, 1.0E-4, lat, lonr);
        if (Math.abs(lonr[0]) > 180.0) {
            throw new MathInvalidArgumentException("MathInvalidArgumentException: can not evaluate GI_wintri coordinate function, ", "abs(lonr) > 180.", lonr[0]);
        }
        double lon = CartTransformation.redLon0(lonr[0], -lon0);
        return lon;
    }

    public static void JI_wintri(double lat, double lon, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c, double[] aj, double[] bj, double[] cj, double[] dj) {
        double Yr = Y - dy;
        aj[0] = 2.0 * Math.sin(0.5 * lon / 57.29577951308232) * (2.0 * Yr - R * lat / 57.29577951308232 + R * Math.sin(2.0 * lat / 57.29577951308232) / 2.0) / (Math.sin(lat / 57.29577951308232) * Math.sin(lat / 57.29577951308232));
        bj[0] = -R * Math.cos(lat1 / 57.29577951308232) - Math.cos(0.5 * lon / 57.29577951308232) / Math.tan(lat / 57.29577951308232) * (2.0 * Yr - R * lat / 57.29577951308232);
        double p1 = Math.cos(lat / 57.29577951308232) * Math.cos(0.5 * lon / 57.29577951308232);
        double p2 = Math.acos(p1);
        double p3 = 1.0 - p1 * p1;
        double p4 = Math.cos(0.5 * lon / 57.29577951308232) * Math.sin(lat / 57.29577951308232) * Math.sin(lat / 57.29577951308232);
        cj[0] = -R - R * p2 * Math.cos(lat / 57.29577951308232) / Math.sqrt(p3) - R * p4 / p3 + R * p4 * p1 * p2 / Math.pow(p3, 1.5);
        dj[0] = -R * Math.sin(0.5 * lon / 57.29577951308232) * Math.sin(2.0 * lat / 57.29577951308232) / (4.0 * p3) + R * Math.sin(lon / 57.29577951308232) * p2 * Math.cos(lat / 57.29577951308232) * Math.cos(lat / 57.29577951308232) * Math.sin(lat / 57.29577951308232) / (4.0 * Math.pow(p3, 1.5));
    }

    public static double FRI_wintri(double lat, double lon, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Xr = X - dx;
        double Yr = Y - dy;
        return 2.0 * Xr - R * lon / 57.29577951308232 * Math.cos(lat1 / 57.29577951308232) - 2.0 / Math.tan(lat / 57.29577951308232) * Math.sin(lon / 2.0 / 57.29577951308232) * (2.0 * Yr - R * lat / 57.29577951308232);
    }

    public static double GRI_wintri(double lat, double lon, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Yr = Y - dy;
        double p1 = Math.cos(lat / 57.29577951308232) * Math.cos(0.5 * lon / 57.29577951308232);
        double p2 = Math.acos(p1);
        double p3 = 1.0 - p1 * p1;
        return 2.0 * Yr - R * lat / 57.29577951308232 - R * p2 * Math.sin(lat / 57.29577951308232) / Math.sqrt(p3);
    }

    public static double F_wintri_bopc(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double X2;
        double X1 = Projections.F_aitoff(lat, lon, R, lat1, lat2, lon0, dx, dy, c);
        double X = 0.5 * (X1 + (X2 = Projections.F_cea(lat, lon, R, lat1, lat2, lon0, dx, dy, c)));
        if (Math.abs(X) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate F_wintri coordinate function, ", "F_wintri > MAX_FLOAT: ", X);
        }
        return X;
    }

    public static double G_wintri_bopc(double lat, double lon, double R, double lat1, double lat2, double lon0, double dx, double dy, double c) {
        double Y2;
        double Y1 = Projections.G_aitoff(lat, lon, R, lat1, lat2, lon0, dx, dy, c);
        double Y = 0.5 * (Y1 + (Y2 = Projections.G_cea(lat, lon, R, lat1, lat2, lon0, dx, dy, c)));
        if (Math.abs(Y) > 1.0E37) {
            throw new MathOverflowException("MathOverflowException: can not evaluate G_wintri coordinate function, ", "G_wintri > MAX_FLOAT: ", Y);
        }
        return Y;
    }

    public static double GN(ICoordFunctionProjJI function_ji, ICoordFunctionProjRI function_fri, ICoordFunctionProjRI function_gri, double X, double Y, double R, double lat1, double lat2, double lon0, double dx, double dy, double c, double eps, double[] lat, double[] lon) {
        int MAX_ITER = 5;
        double fx = 0.0;
        for (int iterations = 0; iterations < 5; ++iterations) {
            double B;
            double[] aj = new double[]{0.0};
            double[] bj = new double[]{0.0};
            double[] cj = new double[]{0.0};
            double[] dj = new double[]{0.0};
            function_ji.f(lat[0], lon[0], X, Y, R, lat1, lat2, lon0, dx, dy, c, aj, bj, cj, dj);
            double A = aj[0] * aj[0] + cj[0] * cj[0];
            double C = B = aj[0] * bj[0] + cj[0] * dj[0];
            double D = bj[0] * bj[0] + dj[0] * dj[0];
            double deter = A * D - B * C;
            double AI = D / deter;
            double BI = -B / deter;
            double CI = -C / deter;
            double DI = A / deter;
            double rlat = function_fri.f(lat[0], lon[0], X, Y, R, lat1, lat2, lon0, dx, dy, c);
            double rlon = function_gri.f(lat[0], lon[0], X, Y, R, lat1, lat2, lon0, dx, dy, c);
            fx = rlat * rlat + rlon * rlon;
            double glat = aj[0] * rlat + cj[0] * rlon;
            double glon = bj[0] * rlat + dj[0] * rlon;
            double dlat = -(AI * glat + BI * glon);
            double dlon = -(CI * glat + DI * glon);
            lat[0] = lat[0] + dlat * 57.29577951308232;
            lon[0] = lon[0] + dlon * 57.29577951308232;
            if (Math.abs(dlat) < eps && Math.abs(dlon) < eps) break;
        }
        return fx;
    }
}

