/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;

public class Coordinate
implements ICoordinate,
Serializable {
    private static final long serialVersionUID = 1L;
    private double x;
    private double y;

    public Coordinate(double lat, double lon) {
        this.setLat(lat);
        this.setLon(lon);
    }

    @Override
    public double getLat() {
        return this.y;
    }

    @Override
    public void setLat(double lat) {
        this.y = lat;
    }

    @Override
    public double getLon() {
        return this.x;
    }

    @Override
    public void setLon(double lon) {
        this.x = lon;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.x);
        out.writeObject(this.y);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.x = (Double)in.readObject();
        this.y = (Double)in.readObject();
    }

    public String toString() {
        return "Coordinate[" + this.y + ", " + this.x + "]";
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        Coordinate that = (Coordinate)o;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0;
    }
}

