/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.MapObjectImpl;
import org.openstreetmap.gui.jmapviewer.Style;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;

public class MapRectangleImpl
extends MapObjectImpl
implements MapRectangle {
    private final Coordinate topLeft;
    private final Coordinate bottomRight;

    public MapRectangleImpl(Coordinate topLeft, Coordinate bottomRight) {
        this(null, null, topLeft, bottomRight);
    }

    public MapRectangleImpl(String name, Coordinate topLeft, Coordinate bottomRight) {
        this(null, name, topLeft, bottomRight);
    }

    public MapRectangleImpl(Layer layer, Coordinate topLeft, Coordinate bottomRight) {
        this(layer, null, topLeft, bottomRight);
    }

    public MapRectangleImpl(Layer layer, String name, Coordinate topLeft, Coordinate bottomRight) {
        this(layer, name, topLeft, bottomRight, MapRectangleImpl.getDefaultStyle());
    }

    public MapRectangleImpl(Layer layer, String name, Coordinate topLeft, Coordinate bottomRight, Style style) {
        super(layer, name, style);
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
    }

    @Override
    public Coordinate getTopLeft() {
        return this.topLeft;
    }

    @Override
    public Coordinate getBottomRight() {
        return this.bottomRight;
    }

    @Override
    public void paint(Graphics g, Point topLeft, Point bottomRight) {
        Color oldColor = g.getColor();
        g.setColor(this.getColor());
        Stroke oldStroke = null;
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            oldStroke = g2.getStroke();
            g2.setStroke(this.getStroke());
        }
        g.drawRect(topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
        g.setColor(oldColor);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(oldStroke);
        }
        int width = bottomRight.x - topLeft.x;
        int height = bottomRight.y - topLeft.y;
        Point p = new Point(topLeft.x + width / 2, topLeft.y + height / 2);
        if (this.getLayer() == null || this.getLayer().isVisibleTexts().booleanValue()) {
            this.paintText(g, p);
        }
    }

    public static Style getDefaultStyle() {
        return new Style(Color.BLUE, null, new BasicStroke(2.0f), MapRectangleImpl.getDefaultFont());
    }

    public String toString() {
        return "MapRectangle from " + String.valueOf(this.getTopLeft()) + " to " + String.valueOf(this.getBottomRight());
    }
}

